/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.editors.serviceeditor.constraint.gui;

import com.ericsson.charging.common.dataitem.DataItemAdapter;
import com.ericsson.ere.constraint.contract.ConstrainableProfileContract;
import com.ericsson.ere.constraint.contract.ConstraintSpecification;
import com.ericsson.ere.constraint.entity.Constrainable;
import com.ericsson.ere.constraint.entity.Constraint;
import com.ericsson.ere.constraint.entity.ConstraintContext;
import com.ericsson.ere.constraint.entity.ConstraintContextItemType;
import com.ericsson.ere.constraint.entity.ConstraintTarget;
import com.ericsson.ere.constraint.entity.ConstraintTargetType;
import com.ericsson.ere.gui.editors.serviceeditor.constraint.gui.ConstraintSpecificationLabeler;
import com.ericsson.ere.gui.editors.serviceeditor.constraint.gui.ConstraintSpecificationNode;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.vareditor.VarTableModel;
import ericsson.vareditor.variable.TypedDropDownVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class ConstraintAddEditDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final String CONSTRAINABLE_LABEL = "";
    private static final String ACTION_LABEL = "";
    private static final String TARGET_TYPE_LABEL = "";
    private static final String CONTEXT_GROUP_LABEL = "Applies when";
    private static final String TARGET_GROUP_LABEL = "What to constrain";
    private static final String COMMON_GROUP_LABEL = "Plugin to constrain";
    private static final String RESULTING_CONSTRAINT_LABEL = "Resulting constraint:";
    private static final String CONSTRAINABLE_KEY = "Constrainable";
    private static final String TARGET_TYPE_KEY = "TargetType";
    private static final String ACTION_KEY = "TargetAction";
    private static final int GAP_BETWEEN_LABEL_AND_EDITOR = 6;
    private static final int GAP_BELOW_EDITOR = 18;
    private static final int HORIZONTAL_MARGIN = 6;
    private static final int VERTICAL_MARGIN = 6;
    private static final int EDITOR_INDENT = 18;
    private static final int GAP_BETWEEN_GROUPS = 6;
    private ClassRepository myRepository;
    private VarTableModel myVarTableModel = new VarTableModel();
    private Map<String, VariableChangeAction> myChangeActions = new HashMap<String, VariableChangeAction>();
    private ConstraintSpecification myTargetConstraintSpecification = null;
    private ConstraintTarget myTarget = null;
    private Constrainable myConstrainable = null;
    private Constraint.Action myAction = Constraint.Action.INCLUDE;
    private Map<TypedDropDownVariable<ConstraintTarget>, ConstraintSpecificationNode> myContextMap = new HashMap<TypedDropDownVariable<ConstraintTarget>, ConstraintSpecificationNode>();
    private Constraint myConstraintObject;
    private JTextArea myResultingConstraint;
    private DialogEventHandler myEventHandler = new DialogEventHandler();
    private ConstraintDialogDataSource myDataSource;

    public ConstraintAddEditDialog(Window owner, ClassRepository classRep, ConstraintDialogDataSource dataSource) throws ClassNotFoundException {
        this(owner, classRep, dataSource, null);
    }

    public ConstraintAddEditDialog(Window owner, ClassRepository classRep, ConstraintDialogDataSource dataSource, Constraint constraintToEdit) throws ClassNotFoundException {
        super(owner, ConstraintAddEditDialog.getTitleFor(constraintToEdit), Dialog.ModalityType.APPLICATION_MODAL);
        this.setName("ConstraintAddEditDialog");
        if (dataSource == null) {
            throw new IllegalArgumentException("Data source must not be null.");
        }
        this.myDataSource = dataSource;
        this.myRepository = classRep;
        this.myConstraintObject = constraintToEdit;
        this.configureWindowClosing();
        this.setupComponents();
        this.myConstraintObject = null;
        this.pack();
        this.setLocationRelativeTo(owner);
        this.validate();
    }

    private void configureWindowClosing() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ConstraintAddEditDialog.this.cancelDialog();
            }
        });
    }

    void confirmDialog() {
        if (this.isDialogValid()) {
            this.myConstraintObject = this.createConstraintObject();
            this.dispose();
        }
    }

    void cancelDialog() {
        this.myConstraintObject = null;
        this.dispose();
    }

    private static String getTitleFor(Constraint constraintToEdit) {
        if (constraintToEdit != null) {
            return "Edit constraint " + constraintToEdit;
        }
        return "Create a new constraint";
    }

    private void setupComponents() throws ClassNotFoundException {
        JLabel result = new JLabel(RESULTING_CONSTRAINT_LABEL);
        this.myResultingConstraint = new JTextArea(1, 40);
        this.myResultingConstraint.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.myResultingConstraint.setEditable(false);
        this.myResultingConstraint.setFont(result.getFont());
        this.myResultingConstraint.setLineWrap(true);
        JButton okButton = new JButton("OK");
        okButton.setActionCommand("OK");
        okButton.setName("ConstraintAddEditDialog.JButton.OK");
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setActionCommand("CANCEL");
        cancelButton.setName("ConstraintAddEditDialog.JButton.Cancel");
        okButton.addActionListener(this.myEventHandler);
        cancelButton.addActionListener(this.myEventHandler);
        TypedDropDownVariable<Constrainable> constrainableVar = this.createConstrainableVariable();
        constrainableVar.getEditor().setName("ConstraintAddEditDialog.JComboBox.Constrainable");
        this.myVarTableModel.addRow(constrainableVar);
        this.tieChange(constrainableVar, new VariableChangeAction<TypedDropDownVariable<Constrainable>>(){

            @Override
            public void onChange(TypedDropDownVariable<Constrainable> variable) {
                Constrainable item = variable.getSelectedItem();
                if (item != null) {
                    ConstraintAddEditDialog.this.configureDialogForConstrainable(item);
                    ConstraintAddEditDialog.this.pack();
                }
            }
        });
        ConstraintDialogPanel table = new ConstraintDialogPanel();
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        container.add((Component)table, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(6, 6, 0, 6), 0, 0));
        container.add((Component)result, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(6, 6, 0, 0), 0, 0));
        container.add((Component)this.myResultingConstraint, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(6, 24, 0, 6), 0, 0));
        JPanel buttonPanel = new JPanel(new FlowLayout(4, 6, 6));
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        container.add((Component)buttonPanel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 14, 1, new Insets(6, 6, 6, 0), 0, 0));
    }

    private TypedDropDownVariable<Constrainable> createConstrainableVariable() throws ClassNotFoundException {
        Constrainable selected;
        Collection<Constrainable> constrainables = this.myDataSource.getConstrainables(this.myRepository);
        Constrainable[] constrainablesArray = constrainables.toArray(new Constrainable[constrainables.size()]);
        Constrainable constrainable = selected = this.myConstraintObject != null ? this.myConstraintObject.getConstrainable() : null;
        if (selected == null) {
            selected = ConstraintAddEditDialog.firstElementOrNull(constrainablesArray);
        }
        TypedDropDownVariable<Constrainable> constrainableVar = new TypedDropDownVariable<Constrainable>("", constrainablesArray, selected, new ConstrainableIDLabeler());
        constrainableVar.setKey(CONSTRAINABLE_KEY);
        return constrainableVar;
    }

    private void configureDialogForConstrainable(Constrainable constrainable) {
        this.myConstrainable = constrainable;
        this.retainVariablesByKeyFromModel(CONSTRAINABLE_KEY);
        TypedDropDownVariable<ConstraintSpecification> targetTypeVar = this.createTargetTypeVariable();
        this.myVarTableModel.addRow(targetTypeVar);
        targetTypeVar.getEditor().setName("ConstraintAddEditDialog.JComboBox.TargetType");
        this.tieChange(targetTypeVar, new VariableChangeAction<TypedDropDownVariable<ConstraintSpecification>>(){

            @Override
            public void onChange(TypedDropDownVariable<ConstraintSpecification> variable) {
                ConstraintSpecification spec = variable.getSelectedItem();
                if (spec != null) {
                    ConstraintAddEditDialog.this.configureDialogWithActionForTargetType(spec);
                }
            }
        });
    }

    private TypedDropDownVariable<ConstraintTarget> variableByTreeNode(ConstraintSpecificationNode node) {
        for (Map.Entry<TypedDropDownVariable<ConstraintTarget>, ConstraintSpecificationNode> entry : this.myContextMap.entrySet()) {
            if (entry.getValue() != node) continue;
            return entry.getKey();
        }
        return null;
    }

    private void configureDialogWithActionForTargetType(final ConstraintSpecification currentSpec) {
        this.retainVariablesByKeyFromModel(CONSTRAINABLE_KEY, TARGET_TYPE_KEY);
        Constraint.Action[] actions = this.createAvailableActionArray(currentSpec);
        Constraint.Action selectedAction = this.myConstraintObject != null ? this.myConstraintObject.getAction() : Constraint.Action.EXCLUDE;
        TypedDropDownVariable<Constraint.Action> actionVar = new TypedDropDownVariable<Constraint.Action>("", actions, selectedAction, new ActionLabeler());
        actionVar.setKey(ACTION_KEY);
        actionVar.getEditor().setName("ConstraintAddEditDialog.JComboBox.Action");
        this.myVarTableModel.addRow(actionVar);
        this.tieChange(actionVar, new VariableChangeAction<TypedDropDownVariable<Constraint.Action>>(){

            @Override
            public void onChange(TypedDropDownVariable<Constraint.Action> variable) {
                ConstraintAddEditDialog.this.myAction = variable.getSelectedItem();
                ConstraintAddEditDialog.this.configureDialogWithContextForTargetType(currentSpec);
            }
        });
    }

    private Constraint.Action[] createAvailableActionArray(ConstraintSpecification currentCS) {
        ArrayList<Constraint.Action> actionList = new ArrayList<Constraint.Action>();
        actionList.add(Constraint.Action.EXCLUDE);
        actionList.add(Constraint.Action.INCLUDE);
        if (currentCS != null && currentCS.supportsAdditionalAction(Constraint.Action.SELECT)) {
            actionList.add(Constraint.Action.SELECT);
        }
        return actionList.toArray(new Constraint.Action[actionList.size()]);
    }

    private void configureDialogWithContextForTargetType(ConstraintSpecification target) {
        this.myTargetConstraintSpecification = target;
        this.retainVariablesByKeyFromModel(CONSTRAINABLE_KEY, TARGET_TYPE_KEY, ACTION_KEY);
        this.myContextMap.clear();
        ConstrainableProfileContract contract = this.getContractForCurrentConstrainable();
        Set<ConstraintSpecification> specifications = contract.supportedConstraintSpecifications();
        ConstraintSpecificationNode tree = ConstraintSpecificationNode.createContextItemTypeTree(specifications);
        List<ConstraintSpecificationNode> branchRoots = ConstraintSpecificationNode.findBranchesContaining(tree, target);
        for (ConstraintSpecificationNode child : branchRoots) {
            ConstraintSpecification spec = child.getSpecification();
            assert (spec.getContextItemTypes().isEmpty());
            ConstraintContext context = spec.representsAnyContext() ? ConstraintContext.ANY_CONTEXT : ConstraintContext.EMPTY_CONTEXT;
            Collection<ConstraintTarget> targets = this.getTargets(contract, spec.getTargetType(), context);
            TypedDropDownVariable<ConstraintTarget> ddVar = this.createContextVariable(targets, child);
            this.myVarTableModel.addRow(ddVar);
            this.tieChange(ddVar, new ContextSelectAction(contract));
        }
    }

    private void retainVariablesByKeyFromModel(String ... keys) {
        boolean variableListChanged = VarListUtil.retainVariablesByKey(this.myVarTableModel.getData(), keys);
        if (variableListChanged) {
            this.myVarTableModel.fireTableDataChanged();
        }
    }

    private Collection<ConstraintTarget> getTargets(ConstrainableProfileContract contract, ConstraintTargetType targetType, ConstraintContext context) {
        if (targetType == ConstraintTargetType.FIELD) {
            return contract.getConstraintFields(context);
        }
        return contract.getConstraintTargets(targetType, context);
    }

    private void configureNextLevelContext(ConstrainableProfileContract contract, ConstraintSpecificationNode node) {
        ConstraintContext context = this.buildContextFromNode(node);
        for (ConstraintSpecificationNode child : node.getChildren()) {
            ConstraintSpecification spec = child.getSpecification();
            Collection<ConstraintTarget> targets = this.getTargets(contract, spec.getTargetType(), context);
            TypedDropDownVariable<ConstraintTarget> existing = this.variableByTreeNode(child);
            TypedDropDownVariable<ConstraintTarget> ddVar = this.createContextVariable(targets, child);
            if (existing != null) {
                List<Variable> vars = this.myVarTableModel.getData();
                int row = vars.indexOf(existing);
                vars.set(row, ddVar);
                this.myContextMap.remove(existing);
                this.myVarTableModel.fireTableRowsUpdated(row, row);
            } else {
                this.myVarTableModel.addRow(ddVar);
            }
            this.tieChange(ddVar, new ContextSelectAction(contract));
        }
    }

    private TypedDropDownVariable<ConstraintTarget> createContextVariable(Collection<ConstraintTarget> targetCollection, ConstraintSpecificationNode node) {
        ConstraintSpecification spec = node.getSpecification();
        boolean isTarget = spec.equals(this.myTargetConstraintSpecification);
        ConstraintTarget[] targets = this.createTargetArray(targetCollection, spec);
        ConstraintTarget selected = this.extractSelectedTarget(spec, targets, isTarget);
        String contextSpec = ConstraintSpecificationLabeler.describeConstraintSpecification(spec, false);
        String label = contextSpec + " is";
        TypedDropDownVariable<ConstraintTarget> ddVar = new TypedDropDownVariable<ConstraintTarget>(label, targets, selected, new ConstraintTargetLabeler(isTarget));
        String editorName = "ConstraintAddEditDialog.JComboBox.";
        editorName = editorName + (isTarget ? "TargetValue" : contextSpec + ".ContextValue");
        ddVar.getEditor().setName(editorName);
        this.myContextMap.put(ddVar, node);
        return ddVar;
    }

    protected ConstraintTarget[] createTargetArray(Collection<ConstraintTarget> targetCollection, ConstraintSpecification spec) {
        ArrayList<ConstraintTarget> targets = new ArrayList<ConstraintTarget>(targetCollection);
        if (this.myAction != Constraint.Action.SELECT) {
            targets.add(0, ConstraintTarget.createTargetForAll(spec.getTargetType()));
        }
        return targets.toArray(new ConstraintTarget[targets.size()]);
    }

    private ConstraintTarget extractSelectedTarget(ConstraintSpecification spec, ConstraintTarget[] targets, boolean isTarget) {
        ConstraintTarget selected;
        ConstraintTarget constraintTarget = selected = targets.length > 0 ? targets[0] : null;
        if (this.myConstraintObject != null) {
            if (isTarget) {
                selected = this.myConstraintObject.getTarget();
            } else {
                ConstraintContextItemType itemType = ConstraintSpecificationNode.targetTypeToItem(spec.getTargetType());
                assert (itemType != null) : "Expected target type with corresponding item type at this point: " + (Object)((Object)spec.getTargetType());
                String value = this.myConstraintObject.getContext().itemForType(itemType).getValue();
                selected = ConstraintTarget.createTarget(spec.getTargetType(), value);
            }
        } else if (targets.length > 1 && targets[0].isAll()) {
            selected = targets[1];
        }
        return selected;
    }

    String describeConstraintTarget(ConstraintTarget constraintTarget, boolean isTarget) {
        if (constraintTarget.isAll()) {
            String allAny = isTarget ? "ALL" : "ANY";
            StringBuilder b = new StringBuilder(allAny);
            b.append(" ");
            b.append(constraintTarget.getTargetType().getName().toUpperCase());
            if (isTarget) {
                b.append("S");
            }
            return b.toString();
        }
        return constraintTarget.getTargetValue();
    }

    private ConstraintContext buildContextFromNode(ConstraintSpecificationNode node) {
        TypedDropDownVariable<ConstraintTarget> var;
        ConstraintContext.Builder builder = new ConstraintContext.Builder();
        for (ConstraintSpecificationNode parent = node; parent != null && parent.getSpecification() != null && (var = this.variableByTreeNode(parent)) != null; parent = parent.getParent()) {
            ConstraintContextItemType itemType = ConstraintSpecificationNode.targetTypeToItem(parent.getSpecification().getTargetType());
            assert (itemType != null) : "Expected target type with corresponding item type at this point: " + (Object)((Object)parent.getSpecification().getTargetType());
            ConstraintTarget selected = var.getSelectedItem();
            builder.addContext(itemType, selected.getTargetValue());
        }
        return builder.build();
    }

    private ConstrainableProfileContract getContractForCurrentConstrainable() {
        return this.myDataSource.getContractForConstrainable(this.myRepository, this.myConstrainable);
    }

    private TypedDropDownVariable<ConstraintSpecification> createTargetTypeVariable() {
        ConstrainableProfileContract contract = this.getContractForCurrentConstrainable();
        Set<ConstraintSpecification> supported = contract.supportedConstraintSpecifications();
        ConstraintSpecification[] choiceValues = new ConstraintSpecification[supported.size()];
        ConstraintSpecification selected = null;
        int i = 0;
        for (ConstraintSpecification spec : supported) {
            choiceValues[i++] = spec;
            if (this.myConstraintObject == null || !spec.isSpecificationOf(this.myConstraintObject)) continue;
            selected = spec;
        }
        if (selected == null) {
            selected = this.myConstraintObject != null ? ConstraintSpecification.constraintSpecificationFromConstraint(this.myConstraintObject) : ConstraintAddEditDialog.firstElementOrNull(choiceValues);
        }
        TypedDropDownVariable<ConstraintSpecification> targetTypeVar = new TypedDropDownVariable<ConstraintSpecification>("", choiceValues, selected, new ConstraintSpecificationLabeler(true));
        targetTypeVar.setKey(TARGET_TYPE_KEY);
        return targetTypeVar;
    }

    private static <T> T firstElementOrNull(T[] array) {
        return array.length > 0 ? (T)array[0] : null;
    }

    boolean isDialogValid() {
        boolean valid = true;
        for (Variable var : this.myVarTableModel.getData()) {
            if (var.isValueValid()) continue;
            valid = false;
            break;
        }
        return valid;
    }

    private <T extends Variable> void tieChange(T variable, VariableChangeAction<T> action) {
        if (!this.myChangeActions.containsKey(variable)) {
            variable.setDataItem(this.myEventHandler);
            this.myChangeActions.put(variable.getKey(), action);
        }
        action.onChange(variable);
    }

    private Constraint createConstraintObject() {
        Constraint c = null;
        ConstraintContext context = this.buildCurrentContext();
        if (context != null && this.myTarget != null && this.myConstrainable != null) {
            Constraint.ConstraintBuilder builder = new Constraint.ConstraintBuilder(this.myTarget, this.myConstrainable);
            builder.withContext(context);
            switch (this.myAction) {
                case SELECT: {
                    builder.setSelect();
                    break;
                }
                case EXCLUDE: {
                    builder.setExclude();
                    break;
                }
                case INCLUDE: {
                    builder.setInclude();
                    break;
                }
            }
            c = builder.build();
        }
        return c;
    }

    private ConstraintContext buildCurrentContext() {
        ConstraintContext cc = null;
        Variable targetVar = this.getTargetVariable();
        if (targetVar != null) {
            ConstraintSpecificationNode node = this.myContextMap.get(targetVar);
            cc = node.getSpecification().representsAnyContext() ? ConstraintContext.ANY_CONTEXT : this.buildContextFromNode(this.myContextMap.get(targetVar).getParent());
        }
        return cc;
    }

    private Variable getTargetVariable() {
        Variable targetVar = null;
        for (Map.Entry<TypedDropDownVariable<ConstraintTarget>, ConstraintSpecificationNode> entry : this.myContextMap.entrySet()) {
            ConstraintSpecification spec = entry.getValue().getSpecification();
            if (!spec.equals(this.myTargetConstraintSpecification)) continue;
            targetVar = entry.getKey();
            break;
        }
        return targetVar;
    }

    public Constraint getConstraintObject() {
        return this.myConstraintObject;
    }

    private void updateResultingConstraint() {
        Constraint c = this.createConstraintObject();
        this.myResultingConstraint.setText(c != null ? c.describe(Locale.getDefault()) : "");
        this.pack();
    }

    public void showMe() {
        this.setLocationRelativeTo(GuiServiceCenter.getInstance().getMainWindow());
        this.setVisible(true);
    }

    private class ActionLabeler
    implements TypedDropDownVariable.ItemLabeler<Constraint.Action> {
        private ActionLabeler() {
        }

        @Override
        public String getDisplayStringFor(Constraint.Action item, int index) {
            return item.getDescription();
        }
    }

    private class ConstraintTargetLabeler
    implements TypedDropDownVariable.ItemLabeler<ConstraintTarget> {
        private boolean myIsTarget;

        ConstraintTargetLabeler(boolean isTarget) {
            this.myIsTarget = isTarget;
        }

        @Override
        public String getDisplayStringFor(ConstraintTarget object, int index) {
            return ConstraintAddEditDialog.this.describeConstraintTarget(object, this.myIsTarget);
        }
    }

    private class ConstrainableIDLabeler
    implements TypedDropDownVariable.ItemLabeler<Constrainable> {
        private ConstrainableIDLabeler() {
        }

        @Override
        public String getDisplayStringFor(Constrainable object, int index) {
            String label;
            Constrainable.ConstrainableType type = object.getType();
            if (object.isGeneral()) {
                label = object.toString().toUpperCase();
            } else if (type == Constrainable.ConstrainableType.CONDITION) {
                String alias = this.getConditionAliasOrName(object.getName());
                label = String.format("%s (condition)", alias);
            } else if (type == Constrainable.ConstrainableType.MODIFIER) {
                String alias = ConstraintAddEditDialog.this.myRepository.getModifierAliasOrName(object.getName());
                label = String.format("%s (modifier)", alias);
            } else if (type == Constrainable.ConstrainableType.NODE) {
                label = String.format("%s (node)", object.getName());
            } else if (type == Constrainable.ConstrainableType.TARIFF_STRUCTURE) {
                label = String.format("%s (tariff structure)", object.getName());
            } else {
                throw new AssertionError((Object)("Unhandled constrainable type: " + (Object)((Object)type)));
            }
            return label;
        }

        private String getConditionAliasOrName(String conditionName) {
            boolean isBase;
            String alias = ConstraintAddEditDialog.this.myRepository.getBaseConditionAliasOrName(conditionName);
            boolean bl = isBase = alias != null;
            if (!isBase) {
                alias = ConstraintAddEditDialog.this.myRepository.getConditionAliasOrName(conditionName);
            }
            return alias;
        }
    }

    public static interface ConstraintDialogDataSource {
        public Collection<Constrainable> getConstrainables(ClassRepository var1) throws ClassNotFoundException;

        public ConstrainableProfileContract getContractForConstrainable(ClassRepository var1, Constrainable var2);
    }

    private class ContextSelectAction
    implements VariableChangeAction<TypedDropDownVariable<ConstraintTarget>> {
        private ConstrainableProfileContract myContract;

        ContextSelectAction(ConstrainableProfileContract contract) {
            this.myContract = contract;
        }

        @Override
        public void onChange(TypedDropDownVariable<ConstraintTarget> variable) {
            ConstraintSpecificationNode node = (ConstraintSpecificationNode)ConstraintAddEditDialog.this.myContextMap.get(variable);
            boolean isTarget = node.getSpecification().equals(ConstraintAddEditDialog.this.myTargetConstraintSpecification);
            if (!isTarget) {
                ConstraintAddEditDialog.this.configureNextLevelContext(this.myContract, node);
            } else {
                ConstraintAddEditDialog.this.myTarget = variable.getSelectedItem();
                ConstraintAddEditDialog.this.updateResultingConstraint();
            }
        }
    }

    private class ContextVariableComparator
    implements Comparator<Variable> {
        private ContextVariableComparator() {
        }

        @Override
        public int compare(Variable o1, Variable o2) {
            ConstraintSpecificationNode n1 = (ConstraintSpecificationNode)ConstraintAddEditDialog.this.myContextMap.get(o1);
            ConstraintSpecificationNode n2 = (ConstraintSpecificationNode)ConstraintAddEditDialog.this.myContextMap.get(o2);
            if (n1 == null || n2 == null) {
                return 0;
            }
            return n1.getSpecification().getContextItemTypes().size() - n2.getSpecification().getContextItemTypes().size();
        }
    }

    private class ConstraintDialogPanel
    extends JPanel
    implements TableModelListener {
        private ConstraintDialogPanel() {
            this.setLayout(new BoxLayout(this, 3));
            this.init();
        }

        private void init() {
            ConstraintAddEditDialog.this.myVarTableModel.addTableModelListener(this);
            this.updateTable();
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            this.updateTable();
        }

        private void updateTable() {
            this.removeAll();
            this.add(this.createCommonPanel());
            this.add(Box.createRigidArea(new Dimension(0, 6)));
            this.add(this.createTargetPanel());
            this.add(Box.createRigidArea(new Dimension(0, 6)));
            List<Variable> contextVars = this.getContextVariables();
            if (contextVars.size() > 0) {
                this.add(this.createVariablePanel(ConstraintAddEditDialog.CONTEXT_GROUP_LABEL, contextVars));
            }
            this.revalidate();
            this.repaint();
        }

        private JPanel createCommonPanel() {
            Variable constrainableVar = VarListUtil.getVariableForKey(ConstraintAddEditDialog.this.myVarTableModel.getData(), ConstraintAddEditDialog.CONSTRAINABLE_KEY);
            JPanel panel = this.createVariablePanel(ConstraintAddEditDialog.COMMON_GROUP_LABEL, Collections.singletonList(constrainableVar));
            return panel;
        }

        private JPanel createTargetPanel() {
            JPanel panel = this.createVariablePanel(ConstraintAddEditDialog.TARGET_GROUP_LABEL, Collections.emptyList());
            List<Variable> modelVars = ConstraintAddEditDialog.this.myVarTableModel.getData();
            Variable targetVar = VarListUtil.getVariableForKey(modelVars, ConstraintAddEditDialog.TARGET_TYPE_KEY);
            Variable actionVar = VarListUtil.getVariableForKey(modelVars, ConstraintAddEditDialog.ACTION_KEY);
            Variable targetItemVar = ConstraintAddEditDialog.this.getTargetVariable();
            this.addVariable(panel, targetVar, false);
            Box row = Box.createHorizontalBox();
            row.add(Box.createHorizontalStrut(18));
            if (actionVar != null) {
                row.add(actionVar.getEditor());
            }
            if (targetItemVar != null) {
                row.add(Box.createHorizontalStrut(6));
                row.add(targetItemVar.getEditor());
            }
            panel.add(row);
            panel.add(Box.createVerticalStrut(6));
            return panel;
        }

        private JPanel createVariablePanel(String title, List<Variable> variables) {
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 3));
            panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(title), BorderFactory.createEmptyBorder(0, 6, 0, 6)));
            this.addVariables(panel, variables);
            return panel;
        }

        private void addVariables(Container container, List<Variable> vars) {
            for (int i = 0; i < vars.size(); ++i) {
                Variable var = vars.get(i);
                boolean isLast = i == vars.size() - 1;
                this.addVariable(container, var, isLast);
            }
        }

        private void addVariable(Container container, Variable var, boolean isLast) {
            if (var == null) {
                return;
            }
            this.addLabel(container, var);
            this.addEditor(container, var, isLast);
        }

        private void addEditor(Container container, Variable var, boolean isLast) {
            Box editorRow = Box.createHorizontalBox();
            editorRow.add(Box.createHorizontalStrut(18));
            editorRow.add(var.getEditor());
            Dimension dim = new Dimension(0, isLast ? 6 : 18);
            container.add(editorRow);
            container.add(Box.createRigidArea(dim));
        }

        private void addLabel(Container container, Variable var) {
            String label = var.getLabel();
            if (label.length() > 0) {
                Box labelRow = Box.createHorizontalBox();
                labelRow.add(new JLabel(label));
                labelRow.add(Box.createHorizontalGlue());
                container.add(labelRow);
                container.add(Box.createRigidArea(new Dimension(0, 6)));
            }
        }

        private List<Variable> getContextVariables() {
            ArrayList<Variable> vars = new ArrayList<Variable>(ConstraintAddEditDialog.this.myContextMap.keySet());
            vars.remove(ConstraintAddEditDialog.this.getTargetVariable());
            Collections.sort(vars, new ContextVariableComparator());
            return vars;
        }
    }

    private class DialogEventHandler
    extends DataItemAdapter
    implements ActionListener {
        private DialogEventHandler() {
        }

        @Override
        public void setDataItem(Object reference, Object object) {
            VariableChangeAction a = (VariableChangeAction)ConstraintAddEditDialog.this.myChangeActions.get(reference.toString());
            if (a != null) {
                a.onChange((Variable)object);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String ac = e.getActionCommand();
            if ("OK".equals(ac)) {
                ConstraintAddEditDialog.this.confirmDialog();
            } else if ("CANCEL".equals(ac)) {
                ConstraintAddEditDialog.this.cancelDialog();
            }
        }
    }

    static interface VariableChangeAction<T extends Variable> {
        public void onChange(T var1);
    }
}

