/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.editors.serviceeditor.constraint.gui;

import com.ericsson.ere.constraint.contract.ConstraintSpecification;
import com.ericsson.ere.constraint.entity.ConstraintContextItemType;
import ericsson.ere.util.StringUtil;
import ericsson.vareditor.variable.TypedDropDownVariable;
import java.util.ArrayList;
import java.util.Set;

public class ConstraintSpecificationLabeler
implements TypedDropDownVariable.ItemLabeler<ConstraintSpecification> {
    private boolean myFull;

    public ConstraintSpecificationLabeler(boolean full) {
        this.myFull = full;
    }

    @Override
    public String getDisplayStringFor(ConstraintSpecification object, int index) {
        return ConstraintSpecificationLabeler.describeConstraintSpecification(object, this.myFull);
    }

    static String describeConstraintSpecification(ConstraintSpecification spec, boolean includeContext) {
        String s;
        String tt = StringUtil.toInitialCapitalCase(spec.getTargetType().toString());
        if (includeContext) {
            String contextDesc = spec.representsAnyContext() ? "everywhere" : ConstraintSpecificationLabeler.describeContextItemTypes(spec.getContextItemTypes());
            s = String.format("%s %s", tt, contextDesc);
        } else {
            s = tt;
        }
        return s;
    }

    private static String describeContextItemTypes(Set<ConstraintContextItemType> contextItemTypes) {
        String s;
        if (contextItemTypes.isEmpty()) {
            s = "";
        } else {
            StringBuilder builder = new StringBuilder("when");
            ArrayList<ConstraintContextItemType> types = new ArrayList<ConstraintContextItemType>(contextItemTypes);
            for (int i = 0; i < types.size(); ++i) {
                builder.append(" " + ConstraintSpecificationLabeler.describeContextItemType((ConstraintContextItemType)((Object)types.get(i))));
                if (i >= types.size() - 1) continue;
                builder.append(" and");
            }
            if (types.size() > 1) {
                builder.append(" are");
            } else {
                builder.append(" is");
            }
            builder.append(" selected");
            s = builder.toString();
        }
        return s;
    }

    private static String describeContextItemType(ConstraintContextItemType itemType) {
        switch (itemType) {
            case FIELD: {
                return "a field";
            }
            case CONDITION: {
                return "a condition";
            }
            case MODIFIER: {
                return "a modifier";
            }
            case OPERATION: {
                return "an operation";
            }
        }
        throw new AssertionError((Object)("Unknown item type: " + (Object)((Object)itemType)));
    }
}

