/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts;

import com.ericsson.ere.gui.editors.serviceeditor.ServiceEditorTreeTransferHandler;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.FieldsDefinitionTreeModel;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.AbstractTreeNode;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.ContextFieldsGroupNode;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.FieldGroupNode;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.FieldNode;
import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.HierarchicalFieldNode;
import ericsson.ere.gui.util.GuiUtil;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.tree.TreePath;

public class FieldsDefinitionTree
extends JTree {
    public FieldsDefinitionTree(FieldsDefinitionTreeModel model) {
        super(model);
        this.setName("ServiceEditor.JTree.FieldsDefinitionTree");
        this.enableDragging();
        GuiUtil.disableRootCollapse(this);
        GuiUtil.enableSelectionOnRightClick(this);
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    private void enableDragging() {
        this.setDragEnabled(true);
        this.setTransferHandler(new CopyOnlyTransferHandler());
    }

    private class CopyOnlyTransferHandler
    extends ServiceEditorTreeTransferHandler {
        private CopyOnlyTransferHandler() {
        }

        @Override
        public int getSourceActions(JComponent c) {
            TreePath path = ((JTree)c).getSelectionPath();
            AbstractTreeNode node = path != null ? (AbstractTreeNode)path.getLastPathComponent() : null;
            boolean allowDrag = (this.isContextField(node) || this.isComplexContextGroup(node)) && !this.isFieldInComplexContextGroup(node);
            return allowDrag ? 1 : 0;
        }

        private boolean isContextField(AbstractTreeNode node) {
            return (node instanceof FieldNode || node instanceof HierarchicalFieldNode) && node.isContextField() && node.getParent() instanceof ContextFieldsGroupNode;
        }

        private boolean isComplexContextGroup(AbstractTreeNode node) {
            return node instanceof FieldGroupNode && ((FieldGroupNode)node).isComplexGroup() && node.isContextField();
        }

        private boolean isFieldInComplexContextGroup(AbstractTreeNode node) {
            return this.isContextField(node) && this.isComplexContextGroup((AbstractTreeNode)node.getParent());
        }

        @Override
        protected boolean importDropData(TransferHandler.TransferSupport support) {
            return false;
        }

        @Override
        protected boolean canDrop(TransferHandler.TransferSupport support) {
            return false;
        }
    }
}

