/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.multiupdate;

import com.ericsson.ere.selectiontree.mdu.MDUTreeElement;
import com.ericsson.ere.selectiontree.mdu.filter.BooleanSelectionTreeElementFilter;
import com.ericsson.ere.selectiontree.mdu.filter.ExtendedSelectionTreeElementFilter;
import com.ericsson.ere.selectiontree.mdu.filter.PathBasedElementFilter;
import com.ericsson.ere.selectiontree.mdu.filter.SelectionTreeElementFilter;
import com.ericsson.ere.selectiontree.mdu.filter.TagBasedElementFilter;
import com.ericsson.ere.util.BooleanPredicate;
import com.ericsson.ere.util.CollectionUtils;
import com.ericsson.ere.util.Transformer;
import ericsson.ere.interfaces.DAGUtil;
import ericsson.ere.interfaces.TariffStructureNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum MultiDataUpdateFindCriteria {
    TAG_BASED{

        @Override
        public String toString() {
            return "Tag(s)";
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected SelectionTreeElementFilter createPredicateFromString(String criteria) {
            TagBasedElementFilter filter = null;
            String criteriaWithoutEscapedAsterisks = criteria.replace("\\*", "");
            if (!criteriaWithoutEscapedAsterisks.contains("*")) return new TagBasedElementFilter(this.removeEscapeChars(criteria));
            if (!this.hasAllowedIndexForWildCard(criteriaWithoutEscapedAsterisks)) throw new IllegalArgumentException("Predicate has a faulty format.");
            String tagToMatch = this.createTagString(criteria);
            if (criteria.length() == 1) {
                return new TagBasedElementFilter("", TagBasedElementFilter.MatchOperation.Contains, false);
            }
            if (this.isContainString(criteriaWithoutEscapedAsterisks)) {
                return new TagBasedElementFilter(tagToMatch, TagBasedElementFilter.MatchOperation.Contains, false);
            }
            if (this.shouldMatchEndOfString(criteriaWithoutEscapedAsterisks)) {
                return new TagBasedElementFilter(tagToMatch, TagBasedElementFilter.MatchOperation.EndsWith, false);
            }
            if (!this.shouldMatchStartOfString(criteriaWithoutEscapedAsterisks)) throw new IllegalArgumentException("Predicate has a faulty format.");
            return new TagBasedElementFilter(tagToMatch, TagBasedElementFilter.MatchOperation.StartsWith, false);
        }

        private boolean isContainString(String criteria) {
            return this.shouldMatchStartOfString(criteria) && this.shouldMatchEndOfString(criteria);
        }

        private boolean shouldMatchStartOfString(String criteria) {
            return criteria.endsWith("*") && !criteria.endsWith("\\*");
        }

        private boolean shouldMatchEndOfString(String criteria) {
            return criteria.startsWith("*");
        }

        private String createTagString(String criteria) {
            String matchString = "";
            if (criteria.length() == 1) {
                matchString = criteria;
            } else if (this.isContainString(criteria)) {
                matchString = criteria.substring(1, criteria.lastIndexOf(42));
            } else if (this.shouldMatchStartOfString(criteria)) {
                matchString = criteria.substring(0, criteria.length() - 1);
            } else if (this.shouldMatchEndOfString(criteria)) {
                matchString = criteria.substring(1, criteria.length());
            } else {
                throw new IllegalArgumentException("Unknown format of filter criteria string");
            }
            return this.removeEscapeChars(matchString);
        }

        private boolean containsEscapedWildCard(String criteria) {
            return criteria.indexOf("\\*") != -1;
        }

        private String removeEscapeChars(String tag) {
            return tag.replaceAll("\\\\\\*", "*");
        }

        private boolean hasAllowedIndexForWildCard(String tag) {
            boolean result = true;
            int indexForWildCard = tag.indexOf("*", 1);
            if (indexForWildCard != -1 && indexForWildCard != tag.length() - 1) {
                result = this.containsEscapedWildCard(tag);
            }
            return result;
        }

        @Override
        protected List<String> parseCriterionString(String criterias) {
            ArrayList<String> criteria = new ArrayList<String>();
            Pattern regexp = Pattern.compile("[^\\s\"]+|\"[^\"]*\"");
            Matcher matcher = regexp.matcher(criterias);
            while (matcher.find()) {
                criteria.add(matcher.group().replace('\"', ' ').trim());
            }
            return criteria;
        }

        @Override
        protected String getUniqueness(TariffStructureNode node) {
            return ((MDUTreeElement)((Object)node)).getProductTag();
        }
    }
    ,
    PATH_BASED{

        @Override
        public String toString() {
            return "Path(s)";
        }

        @Override
        protected SelectionTreeElementFilter createPredicateFromString(String criteria) {
            return new PathBasedElementFilter(criteria, false);
        }

        @Override
        protected List<String> parseCriterionString(String criterias) {
            ArrayList<String> criteria = new ArrayList<String>();
            String[] split = criterias.split(" ");
            StringBuilder builder = null;
            for (String curr : split) {
                if (builder != null) {
                    if (curr.startsWith("/") || curr.startsWith("\"")) {
                        criteria.add(this.extractStringAndTrimEnding(builder));
                        builder = new StringBuilder(this.trimBeginning(curr));
                        continue;
                    }
                    builder.append(" ").append(curr);
                    continue;
                }
                builder = new StringBuilder(this.trimBeginning(curr));
            }
            String lastCriterion = this.extractStringAndTrimEnding(builder);
            if (!lastCriterion.isEmpty()) {
                criteria.add(lastCriterion);
            }
            return criteria;
        }

        private String trimBeginning(String string) {
            return (string.startsWith("\"") ? string.substring(1) : string).trim();
        }

        private String extractStringAndTrimEnding(StringBuilder builder) {
            String string;
            if (builder != null) {
                string = builder.toString();
                if (string.endsWith("\"")) {
                    string = string.substring(0, string.length() - 1);
                }
            } else {
                string = "";
            }
            return string.trim();
        }

        @Override
        protected String getUniqueness(TariffStructureNode node) {
            return DAGUtil.getTreePathToString(DAGUtil.getPathToRoot(node));
        }
    };

    private static final String SINGLE_QUOTE = "'";

    public abstract String toString();

    protected abstract SelectionTreeElementFilter createPredicateFromString(String var1);

    protected abstract String getUniqueness(TariffStructureNode var1);

    protected abstract List<String> parseCriterionString(String var1);

    public BooleanSelectionTreeElementFilter createBooleanPredicateFromString(String criterionString) {
        ArrayList<SelectionTreeElementFilter> predicateList = new ArrayList<SelectionTreeElementFilter>();
        List<String> criterias = this.parseCriterionString(criterionString);
        for (String criteria : criterias) {
            predicateList.add(this.createPredicateFromString(criteria));
        }
        return new BooleanSelectionTreeElementFilter(BooleanPredicate.Operation.OR, predicateList, MultiDataUpdateFindCriteria.createDisplayString(criterias));
    }

    private static String createDisplayString(List<String> criterias) {
        StringBuilder builder = new StringBuilder();
        for (String criterion : criterias) {
            builder.append(SINGLE_QUOTE).append(criterion).append(SINGLE_QUOTE).append(" ");
        }
        return builder.toString().trim();
    }

    public final List<SelectionTreeElementFilter> extractUniqueFiltersFromCompound(List<TariffStructureNode> elements) {
        Map<String, List<TariffStructureNode>> map = CollectionUtils.bucket(elements, new Transformer<TariffStructureNode, String>(){

            @Override
            public String transform(TariffStructureNode input) {
                return MultiDataUpdateFindCriteria.this.getUniqueness(input);
            }
        });
        ArrayList<SelectionTreeElementFilter> filters = new ArrayList<SelectionTreeElementFilter>(map.size());
        for (Map.Entry<String, List<TariffStructureNode>> entry : map.entrySet()) {
            String uid = entry.getKey();
            if (uid == null) continue;
            filters.add(new CriteriaBasedElementFilter(entry.getValue(), uid));
        }
        return filters;
    }

    public class CriteriaBasedElementFilter
    implements ExtendedSelectionTreeElementFilter {
        private List<TariffStructureNode> myElements;
        private String myDisplayString;

        CriteriaBasedElementFilter(List<TariffStructureNode> elements, String dispString) {
            this.myElements = elements;
            this.myDisplayString = dispString;
        }

        public MultiDataUpdateFindCriteria getCriteriaType() {
            return MultiDataUpdateFindCriteria.this;
        }

        @Override
        public Collection<TariffStructureNode> filter(Collection<TariffStructureNode> input) {
            return Collections.unmodifiableCollection(this.myElements);
        }

        @Override
        public String getDisplayString() {
            return this.myDisplayString;
        }

        @Override
        public boolean test(TariffStructureNode object) {
            boolean found = false;
            for (TariffStructureNode tn : this.myElements) {
                if (tn != object) continue;
                found = true;
                break;
            }
            return found;
        }
    }
}

