/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.multiupdate;

import com.ericsson.ere.dataset.jump.SelectionTreeDestination;
import com.ericsson.ere.gui.appaction.ApplicationAction;
import com.ericsson.ere.gui.appaction.ApplicationActionStateHandler;
import com.ericsson.ere.gui.multiupdate.MultiDataUpdateFindPanel;
import com.ericsson.ere.gui.multiupdate.MultiDataUpdateInfoPanel;
import com.ericsson.ere.gui.multiupdate.MultiDataUpdateModificationPanel;
import com.ericsson.ere.gui.multiupdate.presenter.MultiDataUpdateFindPresenter;
import com.ericsson.ere.gui.multiupdate.presenter.MultiDataUpdateModificationPresenter;
import com.ericsson.ere.proxy.RatingPeriodProxy;
import com.ericsson.ere.selectiontree.SelectionTreeBuilder;
import com.ericsson.ere.selectiontree.mdu.MDUTreeElementFactory;
import com.ericsson.ere.swing.EDT;
import com.ericsson.ere.swing.EventSource;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.RmaFrameInterface;
import ericsson.ere.gui.RmaFrameSupport;
import ericsson.ere.gui.help.HelpSystem;
import ericsson.ere.gui.ratingrules.RatingRuleFrameJumper;
import ericsson.ere.gui.util.DialogFactory;
import ericsson.ere.gui.util.ProgressDialog;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.management.ContextAwareServiceContainer;
import ericsson.ere.management.Service;
import ericsson.ere.progress.NullProgressIndicator;
import ericsson.ere.progress.ProgressIndicator;
import ericsson.ere.ratingrules.RatingBuilderErrorHandler;
import ericsson.ere.xml.XMLUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.concurrent.Callable;
import org.w3c.dom.Element;

public class MultiDataUpdateFrame
extends RmaFrameSupport
implements RmaFrameInterface,
ApplicationActionStateHandler {
    public static final String EXTRACT_PANEL_IDENTIFIER = "MultiDataUpdateExtractPanel";
    public static final String MODIFICATION_PANEL_IDENTIFIER = "MultiDataUpdateModificationPanel";
    private ContextAwareServiceContainer myServiceContainer;
    private EventSource myExportDataToFileEvent;
    private EventSource myImportDataFromFileEvent;
    private MultiDataUpdateModificationPresenter myModificationPresenter;

    public MultiDataUpdateFrame(RatingPeriodProxy ratingPeriodProxy, ContextAwareServiceContainer serviceContainer, TariffStructureNode structureRoot) {
        this.setTitle("Multi Data Update for " + ratingPeriodProxy.getDefaultWindowTitle());
        this.setResizable(true);
        this.myServiceContainer = serviceContainer;
        this.init(ratingPeriodProxy, structureRoot);
        HelpSystem.getInstance().enableHelpKey(this, this.getClass().toString());
    }

    public static MultiDataUpdateFrame createSafelyForProxy(final RatingPeriodProxy ratingPeriodProxy, final ContextAwareServiceContainer serviceContainer, ProgressIndicator progress) throws Exception {
        ProgressIndicator pi = progress != null ? progress : new NullProgressIndicator();
        ProgressIndicator[] indicators = pi.splitProgress(2);
        final TariffStructureNode structure = MultiDataUpdateFrame.fetchAndBuildStructure(serviceContainer, ratingPeriodProxy, indicators[0]);
        MultiDataUpdateFrame frame = MultiDataUpdateFrame.createGUI(new Callable<MultiDataUpdateFrame>(){

            @Override
            public MultiDataUpdateFrame call() throws Exception {
                MultiDataUpdateFrame.setJumperSupport(serviceContainer.getService(), ratingPeriodProxy);
                MultiDataUpdateFrame rrf = new MultiDataUpdateFrame(ratingPeriodProxy, serviceContainer, structure);
                return rrf;
            }
        }, indicators[1]);
        return frame;
    }

    private static TariffStructureNode fetchAndBuildStructure(ContextAwareServiceContainer serviceContainer, RatingPeriodProxy ratingPeriodProxy, ProgressIndicator progress) throws Exception {
        ProgressIndicator[] indicators = progress.splitProgress(2);
        indicators[0].setInfo("Fetching rating period " + ratingPeriodProxy.getName() + " from the server...");
        indicators[0].progressStart();
        Element xmlRoot = ratingPeriodProxy.getRatingPeriodRuleTree();
        xmlRoot = MultiDataUpdateFrame.getTariffStructureElement(xmlRoot);
        indicators[0].progressFinished();
        indicators[1].setInfo("Building the selection tree...");
        indicators[1].progressStart();
        MDUTreeElementFactory mduFactory = new MDUTreeElementFactory(serviceContainer.getClassRepository(), ratingPeriodProxy.getRatingPlanName());
        RatingBuilderErrorHandler handler = new RatingBuilderErrorHandler();
        SelectionTreeBuilder builder = new SelectionTreeBuilder(mduFactory, handler);
        TariffStructureNode root = builder.build(xmlRoot);
        indicators[1].progressFinished();
        return root;
    }

    private static Element getTariffStructureElement(Element e) {
        Element ret = e;
        if (!"TariffStructure".equals(ret.getNodeName()) && (ret = XMLUtil.getFirstElementNamed("TariffStructure", ret)).getParentNode() != null) {
            ret.getParentNode().removeChild(ret);
        }
        return ret;
    }

    private static void setJumperSupport(Service service, RatingPeriodProxy proxy) {
        SelectionTreeDestination ownDestination = new SelectionTreeDestination(proxy.getRatingPlanName(), service.getId(), proxy.getServiceProviderName());
        service.setJumperSupport(new RatingRuleFrameJumper(proxy.getRatingManagerProxy(), ownDestination));
    }

    private static MultiDataUpdateFrame createGUI(Callable<MultiDataUpdateFrame> callable, ProgressIndicator progress) throws Exception {
        progress.progressStart();
        progress.setInfo("Creating editor...");
        MultiDataUpdateFrame frame = EDT.runAndWait(callable);
        progress.progressFinished();
        return frame;
    }

    private void init(RatingPeriodProxy proxy, TariffStructureNode structureRoot) {
        this.setFrameIcon(RmaDefs.getImageIcon("table_new.png"));
        this.setDefaultCloseOperation(2);
        this.setClosable(true);
        this.setMaximizable(true);
        MultiDataUpdateModificationPanel modPanel = new MultiDataUpdateModificationPanel();
        MultiDataUpdateFindPanel findPanel = new MultiDataUpdateFindPanel();
        MultiDataUpdateInfoPanel infoPanel = new MultiDataUpdateInfoPanel();
        infoPanel.setPreferredSize(new Dimension(300, 80));
        infoPanel.setMinimumSize(new Dimension(300, 80));
        this.initActionsForExternalTriggering(modPanel);
        this.myModificationPresenter = new MultiDataUpdateModificationPresenter(modPanel, infoPanel, findPanel, structureRoot, proxy, this.myServiceContainer);
        new MultiDataUpdateFindPresenter(infoPanel);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new GridBagLayout());
        contentPane.add((Component)infoPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        contentPane.add((Component)findPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 11, 2, new Insets(10, 5, 0, 5), 0, 0));
        contentPane.add((Component)modPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 5, 5, 5), 0, 0));
        this.setWindowPosition();
    }

    private void initActionsForExternalTriggering(MultiDataUpdateModificationPanel modPanel) {
        this.myExportDataToFileEvent = modPanel.exportDataToFileEvent();
        this.myImportDataFromFileEvent = modPanel.importDataFromFileEvent();
    }

    protected void setWindowPosition() {
        if (!GuiServiceCenter.getInstance().setWindowPosition(this)) {
            this.setSize(new Dimension(650, 500));
            this.setPreferredSize(new Dimension(600, 500));
            this.setMinimumSize(new Dimension(600, 500));
        }
    }

    @Override
    public void export(ProgressIndicator progress) {
        this.myExportDataToFileEvent.fire(this);
    }

    @Override
    public String getContentDescription() {
        return "Multi Data Update configuration";
    }

    @Override
    public void importFile() {
        this.myImportDataFromFileEvent.fire(this);
    }

    @Override
    public boolean save(ProgressIndicator progress) {
        return this.myModificationPresenter.doSave(progress);
    }

    @Override
    public boolean isApplicationActionSupported(ApplicationAction action) {
        switch (action) {
            case SAVE: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isOkToDiscardChanges() {
        boolean canDiscard = true;
        if (this.myModificationPresenter.viewHasUnsavedChanges()) {
            canDiscard = false;
            int result = DialogFactory.getQuestionDialogWithCancel(this, "Configuration has unsaved changes", "Save Changes ?\n" + this.getTitle());
            if (result == 0) {
                ProgressDialog progressDialog = new ProgressDialog("Multi Data Update", "Saving configuration changes.");
                canDiscard = this.myModificationPresenter.doSave(progressDialog.getProgressIndicator());
            } else if (result == 1) {
                canDiscard = true;
            }
        }
        return canDiscard;
    }
}

