/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.multiupdate;

import com.ericsson.ere.datatype.EREDate;
import com.ericsson.ere.datatype.ERETime;
import com.ericsson.ere.datatype.ERETimeFactory;
import com.ericsson.ere.gui.multiupdate.MultiDataUpdateTableModel;
import com.ericsson.ere.gui.multiupdate.Status;
import com.ericsson.ere.gui.multiupdate.StatusHandler;
import com.ericsson.ere.gui.util.ExceptionUtil;
import com.ericsson.ere.io.CSVUtil;
import com.ericsson.ere.io.IOCloser;
import com.ericsson.ere.selectiontree.mdu.MDUException;
import com.ericsson.ere.selectiontree.mdu.filter.PathBasedElementFilter;
import com.ericsson.ere.selectiontree.mdu.filter.SelectionTreeElementFilter;
import com.ericsson.ere.selectiontree.mdu.filter.TagBasedElementFilter;
import ericsson.ere.datatype.BcdString;
import ericsson.ere.datatype.DataType;
import ericsson.ere.datatype.Time;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.management.DateUtil;
import ericsson.vareditor.variable.UIntegerVariable;
import ericsson.vareditor.variable.ULongVariable;
import ericsson.vareditor.variable.UShortVariable;
import ericsson.vareditor.variable.Variable;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class MultiDataUpdateModelIOHandler {
    private static final int EXCEL_MAX_NUMBER_OF_NUMBERS_BEFORE_DATA_LOSS = 15;
    private static final char LIST_SEPARATOR = CSVUtil.getSystemSpecificListSeparator();
    private static final Logger logger = RmaDefs.loggerMultiDataUpdate;

    public static Status copyFromModel(MultiDataUpdateTableModel model, String pluginName) {
        Status status = null;
        StringWriter sw = new StringWriter();
        BufferedWriter bw = new BufferedWriter(sw);
        StatusHandler handler = new StatusHandler();
        try {
            MultiDataUpdateModelIOHandler.writeModelDataToWriter(model, pluginName, bw, '\t', handler);
            if (handler.getStatusCount() > 0) {
                MultiDataUpdateModelIOHandler.logEvent(handler.getTitle() + "\n" + handler.getMessage(), null);
                status = new Status("Data copied to clipboard with exceptions", "Some row(s) represent multiple tree elements. In this case only the value from the first element was copied.", Status.SEVERITY.WARNING);
            }
            StringSelection ss = new StringSelection(sw.toString());
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, ss);
        }
        catch (Exception e) {
            long logEntry = MultiDataUpdateModelIOHandler.logEvent("Failed to copy model data to clipboard", e);
            status = new Status("Failed to copy model data to clipboard", "An unexpected error occured. See log entry " + logEntry + " for more information.", Status.SEVERITY.ERROR);
        }
        return status;
    }

    public static Status pasteIntoModel(Map<String, MultiDataUpdateTableModel> models, String pluginName) {
        Status status = null;
        try {
            String transferData = (String)Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null).getTransferData(DataFlavor.stringFlavor);
            StringReader sr = new StringReader(transferData);
            BufferedReader br = new BufferedReader(sr);
            MultiDataUpdateDataHolder dataHolder = MultiDataUpdateModelIOHandler.readMDUDataFromReader(br, '\t');
            MultiDataUpdateTableModel model = MultiDataUpdateModelIOHandler.findMatchingModel(models, pluginName, dataHolder.getPluginName());
            StatusHandler handler = new StatusHandler();
            dataHolder.updateDataWithModelSpecificConfiguration(model, handler);
            if (handler.getStatusCount() > 0) {
                long logEntry = MultiDataUpdateModelIOHandler.logEvent("There were problems when pasting:\n" + handler.getMessage(), null);
                status = new Status("Data pasted with exceptions", "All paste contents did not match data in current view. See log entry " + logEntry + " for more information.", Status.SEVERITY.WARNING);
            }
            MultiDataUpdateModelIOHandler.updateModelWithDataFromDataHolder(model, dataHolder);
        }
        catch (IllegalArgumentException e) {
            long logEntry = MultiDataUpdateModelIOHandler.logEvent("Failed to paste data from clipboard", e);
            status = new Status("Failed to paste data from clipboard", "An unexpected error occured. See log entry " + logEntry + " for more information.", Status.SEVERITY.ERROR);
        }
        catch (MDUException e) {
            MultiDataUpdateModelIOHandler.logEvent("Failed to paste data from clipboard", e);
            status = new Status("Failed to paste data from clipboard", e.getMessage(), Status.SEVERITY.ERROR);
        }
        catch (Exception e) {
            MultiDataUpdateModelIOHandler.logEvent("Failed to paste data from clipboard", e);
            status = new Status("Failed to paste data from clipboard", "Please consult the user guide for information on pasting data in table.", Status.SEVERITY.ERROR);
        }
        return status;
    }

    public static List<SelectionTreeElementFilter> importFiltersFromFile(File file) {
        MultiDataUpdateDataHolder dataHolder = null;
        try {
            dataHolder = MultiDataUpdateModelIOHandler.populateDataHolderFromFile(file);
        }
        catch (MDUException mdue) {
            MultiDataUpdateModelIOHandler.logEvent("Failed to extract filters from file " + file.getName(), mdue);
        }
        catch (FileNotFoundException e) {
            MultiDataUpdateModelIOHandler.logEvent("File not found", e);
        }
        return dataHolder != null ? dataHolder.getFilters() : new ArrayList<SelectionTreeElementFilter>();
    }

    public static Status importFromFileToModel(File file, Map<String, MultiDataUpdateTableModel> models, String pluginName) {
        Status status = new Status("Data imported successfully", file.getName() + " was imported into the active table.", Status.SEVERITY.INFO);
        try {
            MultiDataUpdateDataHolder dataHolder = MultiDataUpdateModelIOHandler.populateDataHolderFromFile(file);
            if (dataHolder != null) {
                MultiDataUpdateTableModel matchingModel = MultiDataUpdateModelIOHandler.findMatchingModel(models, pluginName, dataHolder.getPluginName());
                StatusHandler handler = new StatusHandler();
                dataHolder.updateDataWithModelSpecificConfiguration(matchingModel, handler);
                if (handler.getStatusCount() > 0) {
                    long logEntry = MultiDataUpdateModelIOHandler.logEvent("There were problems when pasting:\n" + handler.getMessage(), null);
                    status = new Status("Data imported with exceptions", "All import contents did not match data in current view. See log entry " + logEntry + " for more information.", Status.SEVERITY.WARNING);
                }
                MultiDataUpdateModelIOHandler.updateModelWithDataFromDataHolder(matchingModel, dataHolder);
            }
        }
        catch (MDUException mdue) {
            long logEntry = MultiDataUpdateModelIOHandler.logEvent("Import failed", mdue);
            status = new Status("Import failed", "Import contents did not match data in current view. See log entry " + logEntry + " for more information.", Status.SEVERITY.ERROR);
        }
        catch (FileNotFoundException e) {
            MultiDataUpdateModelIOHandler.logEvent("File not found", e);
            status = new Status("Import failed", "The file was not found.", Status.SEVERITY.ERROR);
        }
        catch (IllegalArgumentException iau) {
            long logEntry = MultiDataUpdateModelIOHandler.logEvent("File " + file.getAbsolutePath() + " corrupt", iau);
            status = new Status("Import failed", "The file " + file.getName() + " appears to be corrupt and cannot be imported. See log entry " + logEntry + " for more information.", Status.SEVERITY.ERROR);
        }
        return status;
    }

    public static Status exportFromModelToFile(MultiDataUpdateTableModel model, String pluginName, File file) {
        Status status = null;
        try {
            FileWriter fw = new FileWriter(file);
            BufferedWriter bw = new BufferedWriter(fw);
            StatusHandler handler = new StatusHandler();
            MultiDataUpdateModelIOHandler.writeModelDataToWriter(model, pluginName, bw, LIST_SEPARATOR, handler);
            status = handler.getStatusCount() == 0 ? new Status("Data exported successfully", "Active table was exported to " + file.getName(), Status.SEVERITY.INFO) : new Status("Data exported with exceptions", "Active table was exported to " + file.getName() + ". \nSome row(s) represent multiple tree elements. In this case only the value from the first element was exported.", Status.SEVERITY.WARNING);
        }
        catch (IOException e1) {
            long logEntry = MultiDataUpdateModelIOHandler.logEvent("Export to " + file.getName() + " failed", e1);
            status = new Status("Export to file failed", "An unexpected error occured. See log entry " + logEntry + " for more information.", Status.SEVERITY.ERROR);
        }
        catch (Exception e) {
            long logEntry = MultiDataUpdateModelIOHandler.logEvent("Export to " + file.getName() + " failed", e);
            status = new Status("Export to file failed", "An unexpected error occured. See log entry " + logEntry + " for more information.", Status.SEVERITY.ERROR);
        }
        return status;
    }

    private static MultiDataUpdateDataHolder populateDataHolderFromFile(File file) throws FileNotFoundException {
        MultiDataUpdateDataHolder dataHolder = null;
        if (file != null) {
            FileReader fr = new FileReader(file);
            BufferedReader br = new BufferedReader(fr);
            dataHolder = MultiDataUpdateModelIOHandler.readMDUDataFromReader(br, LIST_SEPARATOR);
        }
        return dataHolder;
    }

    private static MultiDataUpdateDataHolder readMDUDataFromReader(BufferedReader dataReader, char listSeparator) {
        List<String> columnHeaders;
        ArrayList<FilterValuePair> pairList = new ArrayList<FilterValuePair>();
        String pluginName = "";
        boolean filterAsPath = false;
        try {
            String line;
            pluginName = MultiDataUpdateModelIOHandler.extractpluginName(dataReader.readLine(), listSeparator);
            columnHeaders = MultiDataUpdateModelIOHandler.extractColumnHeaders(dataReader.readLine(), Character.toString(listSeparator));
            int columnCountReference = columnHeaders.size();
            filterAsPath = MultiDataUpdateModelIOHandler.extractFilterTypeAsPath(columnHeaders.get(0));
            while ((line = dataReader.readLine()) != null) {
                String lastPartOfLine = line.substring(line.contains(Character.toString(listSeparator)) ? line.lastIndexOf(listSeparator) : 0);
                if (MultiDataUpdateModelIOHandler.stringContainsUnevenNumberOfDoubleQuotes(lastPartOfLine)) {
                    String lineToAppend;
                    boolean done = false;
                    while ((lineToAppend = dataReader.readLine()) != null && ((done = MultiDataUpdateModelIOHandler.stringContainsUnevenNumberOfDoubleQuotes(lineToAppend)) || !lineToAppend.contains("\""))) {
                        line = line + "\n" + lineToAppend;
                        if (!done) continue;
                    }
                }
                List<String> rowStrings = null;
                rowStrings = CSVUtil.splitCSVLine(line, listSeparator);
                if (MultiDataUpdateModelIOHandler.rowIsValid(rowStrings, columnCountReference)) {
                    String pathOrTag = rowStrings.get(0);
                    SelectionTreeElementFilter filter = filterAsPath ? new PathBasedElementFilter(pathOrTag, false, false) : new TagBasedElementFilter(pathOrTag);
                    Map<String, String> valueMap = MultiDataUpdateModelIOHandler.extractValueMap(columnHeaders, rowStrings);
                    pairList.add(new FilterValuePair(pathOrTag, valueMap, filter));
                    continue;
                }
                throw new MDUException("Encountered invalid row: " + line);
            }
        }
        catch (IOException e) {
            throw new MDUException("Error when reading from resource.", e);
        }
        catch (IndexOutOfBoundsException e) {
            throw new MDUException("Error when reading from resource", e);
        }
        catch (IllegalArgumentException e) {
            throw new MDUException("Error when reading from resource", e);
        }
        finally {
            IOCloser.closeIgnoringException(dataReader);
        }
        if (pairList.size() < 1) {
            throw new MDUException("Resource contained no values that matched the viewed table.");
        }
        List<String> parameterList = columnHeaders.subList(1, columnHeaders.size());
        return new MultiDataUpdateDataHolder(pluginName, parameterList, pairList);
    }

    private static boolean stringContainsUnevenNumberOfDoubleQuotes(String lastPartOfLine) {
        return lastPartOfLine.split("\"", -1).length - 1 == 1;
    }

    private static String extractpluginName(String nameString, char listSeparator) {
        if (nameString == null) {
            throw new MDUException("The resource appears to be empty.");
        }
        return nameString.endsWith(Character.toString(listSeparator)) ? MultiDataUpdateModelIOHandler.extractpluginName(nameString.substring(0, nameString.length() - 1), listSeparator) : nameString;
    }

    private static boolean rowIsValid(List<String> rowStrings, int columnCountReference) {
        int columnCount = rowStrings.size();
        if (columnCount == columnCountReference) {
            return true;
        }
        if (columnCount == columnCountReference + 1) {
            return rowStrings.get(columnCount - 1).isEmpty();
        }
        return false;
    }

    private static Map<String, String> extractValueMap(List<String> keyList, List<String> valueList) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 1; i < keyList.size(); ++i) {
            String key = keyList.get(i);
            String value = valueList.get(i);
            map.put(key, value);
        }
        return map;
    }

    private static boolean extractFilterTypeAsPath(String typeString) {
        if ("Path".equals(typeString)) {
            return true;
        }
        if ("Tag".equals(typeString)) {
            return false;
        }
        throw new MDUException("Unknown identifier in header: " + typeString);
    }

    private static List<String> extractColumnHeaders(String headerString, String separator) {
        ArrayList<String> headers = new ArrayList<String>();
        if (headerString != null) {
            String[] columnTokens = headerString.split(separator);
            for (int i = 0; i < columnTokens.length; ++i) {
                headers.add(columnTokens[i]);
            }
        } else {
            throw new MDUException("Missing column declaration.");
        }
        if (headers.size() < 2) {
            throw new MDUException("Header row contained too few values.");
        }
        return headers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeModelDataToWriter(MultiDataUpdateTableModel model, String pluginName, BufferedWriter bw, char separator, StatusHandler handler) throws Exception {
        try {
            bw.write(pluginName);
            bw.newLine();
            int columnCount = model.getColumnCount();
            for (int column = 0; column < columnCount; ++column) {
                if (column != 0 && column % 2 != 1) continue;
                String columnName = model.getColumnName(column);
                if (column != 0) {
                    columnName = columnName.substring(0, columnName.length() - 6);
                }
                bw.write(String.format("%s%c", columnName, Character.valueOf(separator)));
            }
            bw.newLine();
            Variable[] columnVariables = new Variable[columnCount];
            for (int row = 0; row < model.getRowCount(); ++row) {
                for (int col = 0; col < columnCount; ++col) {
                    String stringOfObject;
                    Object value = model.getValueAt(row, col);
                    if (col == 0) {
                        assert (value instanceof SelectionTreeElementFilter) : "Broken model...";
                        bw.write(String.format("%s%c", CSVUtil.escapeStringForCSV(((SelectionTreeElementFilter)value).getDisplayString(), separator, false), Character.valueOf(separator)));
                        continue;
                    }
                    if (col % 2 != 1) continue;
                    if (value instanceof Collection) {
                        String parameter = model.getColumnName(col);
                        handler.add(new Status("Problem when writing value", "Parameter '" + parameter + "' has multiple values. Only first value included.", Status.SEVERITY.WARNING));
                    }
                    if (value == null || value instanceof Collection && ((Collection)value).isEmpty()) {
                        stringOfObject = "";
                    } else {
                        boolean forceText = false;
                        Object singleValue = value instanceof Collection ? ((Collection)value).iterator().next() : value;
                        Class<?> columnClass = model.getColumnClass(col);
                        if (MultiDataUpdateModelIOHandler.isForcedEscapingCandidateClass(columnClass)) {
                            if (columnVariables[col] == null) {
                                columnVariables[col] = model.createVariableForCell(row, col, singleValue);
                            }
                            if ((stringOfObject = MultiDataUpdateModelIOHandler.getCorrectUnsignedValue(columnVariables[col], singleValue)) == null) {
                                stringOfObject = model.getValueStringForCell(row, col, singleValue);
                            }
                            if (stringOfObject.length() > 15 || MultiDataUpdateModelIOHandler.isForcedEscapingClass(columnClass)) {
                                forceText = true;
                            }
                        } else {
                            stringOfObject = model.getValueStringForCell(row, col, singleValue);
                        }
                        stringOfObject = MultiDataUpdateModelIOHandler.formatValueString(stringOfObject, columnClass, separator, forceText);
                    }
                    bw.write(String.format("%s%c", stringOfObject, Character.valueOf(separator)));
                }
                bw.newLine();
            }
        }
        finally {
            bw.close();
        }
    }

    private static String getCorrectUnsignedValue(Variable columnVariable, Object singleValue) throws Exception {
        String stringOfObject = null;
        if (columnVariable instanceof ULongVariable) {
            stringOfObject = DataType.ULongParser((Long)singleValue);
        } else if (columnVariable instanceof UIntegerVariable) {
            stringOfObject = DataType.UIntegerParser((Integer)singleValue);
        } else if (columnVariable instanceof UShortVariable) {
            stringOfObject = DataType.UShortParser((Short)singleValue);
        }
        return stringOfObject;
    }

    private static boolean isForcedEscapingCandidateClass(Class<?> c) {
        return DataType.fromClass(c) != null && DataType.fromClass(c).isNumeric() || MultiDataUpdateModelIOHandler.isForcedEscapingClass(c);
    }

    private static boolean isForcedEscapingClass(Class<?> c) {
        return c == BcdString.class || c == String.class || Date.class.isAssignableFrom(c) || EREDate.class.isAssignableFrom(c) || Time.class.isAssignableFrom(c) || ERETime.class.isAssignableFrom(c);
    }

    private static void updateModelWithDataFromDataHolder(MultiDataUpdateTableModel matchingModel, MultiDataUpdateDataHolder dataHolder) {
        Map<Integer, Map<Integer, Object>> values = dataHolder.getValues();
        for (Map.Entry<Integer, Map<Integer, Object>> rowEntry : values.entrySet()) {
            int rowIndex = rowEntry.getKey();
            if (rowIndex < 0) continue;
            for (Map.Entry<Integer, Object> columnEntry : rowEntry.getValue().entrySet()) {
                int columnIndex = columnEntry.getKey();
                matchingModel.setValueAt(columnEntry.getValue(), rowIndex, columnIndex);
            }
        }
    }

    private static String formatValueString(String stringToFormat, Class<?> classOfStringValue, char separator, boolean forceText) {
        String ret = stringToFormat;
        if (ERETime.class.isAssignableFrom(classOfStringValue)) {
            ret = DateUtil.convertISOStringToDateTimeString(stringToFormat);
        } else if (Date.class.isAssignableFrom(classOfStringValue) || EREDate.class.isAssignableFrom(classOfStringValue)) {
            ret = DateUtil.convertISOStringToDateString(stringToFormat);
        }
        ret = CSVUtil.escapeStringForCSV(ret, separator, forceText);
        return ret;
    }

    private static MultiDataUpdateTableModel findMatchingModel(Map<String, MultiDataUpdateTableModel> usedModels, String key, String pluginNameImportedData) {
        MultiDataUpdateTableModel model = null;
        if (key.equals(pluginNameImportedData)) {
            for (Map.Entry<String, MultiDataUpdateTableModel> entry : usedModels.entrySet()) {
                if (!entry.getKey().equals(pluginNameImportedData)) continue;
                model = entry.getValue();
                break;
            }
        }
        return model;
    }

    private static long logEvent(String message, Exception exception) {
        if (exception != null) {
            return ExceptionUtil.handleException(exception, "multidataupdate", 1, message, false);
        }
        LogRecord logRecord = new LogRecord(Level.WARNING, message);
        logRecord.setLoggerName(logger.getName());
        logger.log(logRecord);
        return logRecord.getSequenceNumber();
    }

    private static class FilterValuePair {
        private final String myIdentifier;
        private final Map<String, String> myStringMap;
        private final SelectionTreeElementFilter myFilter;
        private int myRowIndex = -1;
        private Map<Integer, Object> myValueMap = null;

        private FilterValuePair(String id, Map<String, String> map, SelectionTreeElementFilter filter) {
            this.myIdentifier = id;
            this.myStringMap = Collections.unmodifiableMap(map);
            this.myFilter = filter;
        }
    }

    public static class MultiDataUpdateDataHolder {
        private final List<FilterValuePair> myData;
        private final String myPluginName;
        private final List<String> myParameterList;
        private boolean isInSyncWithModel = false;

        private MultiDataUpdateDataHolder(String pluginName, List<String> parameterList, List<FilterValuePair> data) {
            this.myParameterList = parameterList;
            this.myData = data;
            this.myPluginName = pluginName;
        }

        public List<SelectionTreeElementFilter> getFilters() {
            ArrayList<SelectionTreeElementFilter> filterList = new ArrayList<SelectionTreeElementFilter>();
            for (FilterValuePair pair : this.myData) {
                SelectionTreeElementFilter filter = pair.myFilter;
                if (filter == null) continue;
                filterList.add(filter);
            }
            return filterList;
        }

        public String getPluginName() {
            return this.myPluginName;
        }

        public Map<Integer, Map<Integer, Object>> getValues() {
            assert (this.isInSyncWithModel) : "Data holder has not been syncronized with the model";
            HashMap<Integer, Map<Integer, Object>> valueMap = new HashMap<Integer, Map<Integer, Object>>();
            for (FilterValuePair pair : this.myData) {
                valueMap.put(pair.myRowIndex, pair.myValueMap);
            }
            return valueMap;
        }

        public void updateDataWithModelSpecificConfiguration(MultiDataUpdateTableModel model, StatusHandler handler) {
            Map<String, Integer> parameterIndexMap = null;
            if (model != null && model.getWritableColumnCount() == this.myParameterList.size()) {
                parameterIndexMap = this.createParameterIndexMap(model);
            }
            if (parameterIndexMap != null) {
                this.populateDataWithValues(parameterIndexMap, model, handler);
            }
            if (!this.isInSyncWithModel) {
                throw new MDUException("Resource contents did not match viewed table.");
            }
        }

        private void populateDataWithValues(Map<String, Integer> parameterIndexMap, MultiDataUpdateTableModel model, StatusHandler handler) {
            for (FilterValuePair pair : this.myData) {
                HashMap<Integer, Object> valueMap = new HashMap<Integer, Object>();
                int rowIndex = model.getRowByIdentifier(pair.myIdentifier);
                if (rowIndex >= 0) {
                    pair.myRowIndex = rowIndex;
                    for (Map.Entry entry : pair.myStringMap.entrySet()) {
                        int columnIndex = parameterIndexMap.get(entry.getKey());
                        if (model.isCellEditable(rowIndex, columnIndex)) {
                            try {
                                String value = (String)entry.getValue();
                                Class<?> c = model.getColumnClass(columnIndex);
                                if (ERETime.class.isAssignableFrom(c)) {
                                    value = ERETimeFactory.parseTimeString(value).toString();
                                } else if (Date.class.isAssignableFrom(c) || EREDate.class.isAssignableFrom(c)) {
                                    value = DateUtil.convertDateStringToISOString(value);
                                } else if (Time.class.isAssignableFrom(c)) {
                                    value = DateUtil.convertDateTimeStringToISOString(value);
                                }
                                valueMap.put(columnIndex, model.parseStringToObjectForCell(rowIndex, columnIndex, value));
                                continue;
                            }
                            catch (Exception e) {
                                throw new MDUException("Row with identifier '" + pair.myIdentifier + "' contained a value that could not be parsed: '" + (String)entry.getValue() + "'", e);
                            }
                        }
                        handler.add(new Status("Column not editable:", "Row with identifier '" + pair.myIdentifier + "' and column '" + (String)entry.getKey() + "' can not be updated in current view.", Status.SEVERITY.INFO));
                    }
                } else {
                    handler.add(new Status("Row missing:", "Row with identifier '" + pair.myIdentifier + "' does not exist in current view.", Status.SEVERITY.INFO));
                    continue;
                }
                pair.myValueMap = valueMap;
            }
            this.isInSyncWithModel = true;
        }

        private Map<String, Integer> createParameterIndexMap(MultiDataUpdateTableModel model) {
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            for (String parameter : this.myParameterList) {
                int columnIndex = model.getWritableColumnByName(parameter);
                if (columnIndex < 0) {
                    return null;
                }
                map.put(parameter, columnIndex);
            }
            return map;
        }
    }
}

