/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.multiupdate;

import com.ericsson.charging.common.RMAStatusInterface;
import com.ericsson.ere.gui.multiupdate.MultiDataUpdateCellEditor;
import com.ericsson.ere.gui.multiupdate.MultiDataUpdateCellRenderer;
import com.ericsson.ere.gui.multiupdate.MultiDataUpdateTableModel;
import com.ericsson.ere.swing.TableRowResizer;
import ericsson.vareditor.variable.MultilineStringVariable;
import ericsson.vareditor.variable.Variable;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class MultiDataUpdateTable
extends JTable {
    public MultiDataUpdateTable(TableModel tableModel) {
        super(tableModel);
        this.initSpecificProperties();
        new TableRowResizer(this, 20, Integer.MAX_VALUE);
        this.configureRightMouseMenu();
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column != 0 && column % 2 == 0;
    }

    private void configureRightMouseMenu() {
        this.addMouseListener(new RightClickListener());
    }

    private void initSpecificProperties() {
        this.setAutoResizeMode(0);
        this.setCellSelectionEnabled(true);
        this.setSelectionMode(0);
        this.getTableHeader().setReorderingAllowed(false);
        this.setRowHeight(30);
        Color defaultGray = new Color(238, 238, 238);
        this.setBackground(defaultGray);
        TableColumnModel colModel = this.getColumnModel();
        colModel.getColumn(0).setCellRenderer(MultiDataUpdateCellRenderer.createRendererForHeaderColumn());
        colModel.getColumn(0).setPreferredWidth(150);
        boolean needExtraRowHeight = false;
        for (int i = 1; i < this.getColumnCount(); ++i) {
            if (!needExtraRowHeight) {
                Variable var = this.getVariableForColumn(i);
                needExtraRowHeight |= this.needsExtraRowHeight(var);
            }
            boolean isOld = i % 2 == 1;
            TableCellRenderer renderer = isOld ? MultiDataUpdateCellRenderer.createRendererForOldValueColumn() : MultiDataUpdateCellRenderer.createRendererForNewValueColumn();
            TableColumn col = colModel.getColumn(i);
            col.setCellRenderer(renderer);
            if (this.shouldHaveCellEditor(i)) {
                col.setCellEditor(new MultiDataUpdateCellEditor(new RMAStatusInterface()));
            }
            int width = Math.max(this.getWidthForColumn(i), 100);
            col.setPreferredWidth(width);
        }
        if (needExtraRowHeight) {
            this.setRowHeight((int)((double)this.getRowHeight() * 1.6));
        }
    }

    private boolean needsExtraRowHeight(Variable var) {
        return var instanceof MultilineStringVariable;
    }

    private Variable getVariableForColumn(int col) {
        Variable var;
        try {
            var = ((MultiDataUpdateTableModel)this.getModel()).createVariableForCell(0, col, null);
        }
        catch (Exception e) {
            var = null;
        }
        return var;
    }

    private int getWidthForColumn(int column) {
        int width = column == 0 ? 150 : (column % 2 == 0 ? 130 : 80);
        return width;
    }

    private boolean shouldHaveCellEditor(int column) {
        return column > 0 && column % 2 == 0;
    }

    private static class ResetToOldAction
    extends AbstractAction {
        private MultiDataUpdateTableModel myModel;
        private int myRow;
        private int myCol;

        ResetToOldAction(MultiDataUpdateTableModel model, int row, int col) {
            super("Reset to old value");
            this.myModel = model;
            this.myRow = row;
            this.myCol = col;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.myModel.resetToOldValue(this.myRow, this.myCol);
        }
    }

    private static class RightClickListener
    extends MouseAdapter {
        RightClickListener() {
        }

        private JPopupMenu createPopupMenu(MultiDataUpdateTableModel model, int row, int col) {
            JPopupMenu menu = new JPopupMenu();
            menu.add(new ResetToOldAction(model, row, col));
            return menu;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.maybeShowPopup(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.maybeShowPopup(e);
            }
        }

        private void maybeShowPopup(MouseEvent e) {
            if (!e.isPopupTrigger()) {
                return;
            }
            JTable table = (JTable)e.getSource();
            if (!table.isEnabled() || table.isEditing()) {
                return;
            }
            Point p = e.getPoint();
            int row = table.convertRowIndexToModel(table.rowAtPoint(p));
            int col = table.convertColumnIndexToModel(table.columnAtPoint(p));
            MultiDataUpdateTableModel model = (MultiDataUpdateTableModel)table.getModel();
            if (row >= 0 && col >= 0 && table.isCellEditable(row, col) && model.isModifiedAt(row, col)) {
                JPopupMenu menu = this.createPopupMenu(model, row, col);
                menu.show(table, p.x, p.y);
            }
        }
    }
}

