/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.multiupdate;

import com.ericsson.ere.gui.multiupdate.Status;
import java.util.ArrayList;
import java.util.List;

public class StatusHandler {
    private List<Status> myStatusList = new ArrayList<Status>();

    public void add(Status status) {
        if (status != null) {
            this.myStatusList.add(status);
        }
    }

    public String getTitle() {
        String title = "";
        if (this.myStatusList.size() == 1) {
            title = this.myStatusList.get(0).getTitle();
        } else if (this.myStatusList.size() > 1) {
            title = "There are multiple information rows:";
        }
        return title;
    }

    public String getMessage() {
        String message = "";
        if (this.myStatusList.size() == 1) {
            message = this.myStatusList.get(0).getMessage();
        } else if (this.myStatusList.size() > 1) {
            StringBuilder messageBuilder = new StringBuilder();
            for (Status status : this.myStatusList) {
                messageBuilder.append(" - ").append((Object)status.getSeverity()).append(" ").append(status.getMessage()).append("\n");
            }
            message = messageBuilder.substring(0, messageBuilder.length() - 1);
        }
        return message;
    }

    public Status.SEVERITY getSeverity() {
        return this.extractHighetsSeverity();
    }

    public Status generateCompoundStatus() {
        return new Status(this.getTitle(), this.getMessage(), this.getSeverity());
    }

    public int getStatusCount() {
        return this.myStatusList.size();
    }

    private Status.SEVERITY extractHighetsSeverity() {
        Status.SEVERITY severity = null;
        for (Status status : this.myStatusList) {
            Status.SEVERITY currentSeverity = status.getSeverity();
            if (severity != null && currentSeverity.compareTo(severity) <= 0) continue;
            severity = currentSeverity;
        }
        return severity;
    }
}

