/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.navigator;

import com.ericsson.ere.defs.SettingsRepository;
import com.ericsson.ere.gui.navigator.interfaces.NavigatorConfigurationHandler;
import com.ericsson.ere.gui.navigator.interfaces.NavigatorConfigurationHandlerProvider;
import com.ericsson.ere.gui.navigator.interfaces.NavigatorNodeConfiguration;
import com.ericsson.ere.gui.navigator.sdp.SDPNavigatorConfigLoader;
import com.ericsson.ere.gui.util.ExceptionUtil;
import com.ericsson.ere.proxy.EreProxy;
import com.ericsson.ere.proxy.EreProxyManager;
import com.ericsson.ere.proxy.ProgressWrapper;
import com.ericsson.ere.proxy.exception.ProxyInstantiationException;
import ericsson.ere.gui.Config;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.ratingrules.nodes.DOMUtil;
import ericsson.ere.gui.util.DialogFactory;
import ericsson.ere.integration.connector.ConnectorFactory;
import ericsson.ere.integration.connector.EreCommunicationException;
import ericsson.ere.integration.connector.EreConnector;
import ericsson.ere.integration.settingsmap.propertyio.XMLOutput;
import ericsson.ere.progress.ProgressIndicator;
import ericsson.ere.xml.DomWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class NavigatorConfigLoader {
    public static final SettingsRepository.Setting<Boolean> NAV_CONFIG_DISABLE_INTERNAL_ERE = SettingsRepository.Setting.create("disable.internal.ere", false);
    public static final String TAG_NODELIST = "NodeList";
    public static final String TAG_ERENODE = "EreNode";
    public static final String TAG_NAME = "Name";
    protected static NavigatorConfigLoader instance = new NavigatorConfigLoader();
    private List<Config.UserInfo> myKnownUserInfos = new ArrayList<Config.UserInfo>();
    private Vector<Element> myUnknownEreNodes = new Vector();

    @Deprecated
    public NavigatorConfigLoader() {
    }

    public void loadManagerFromXML(ProgressIndicator progress) throws Exception {
        Config.getInstance().reloadNodeConfig();
        this.loadExternalConfiguration();
        Vector<Node> nodes = new Vector<Node>();
        if (Config.getInstance().getConfigFor(TAG_NODELIST) != null) {
            nodes.addAll(Config.getInstance().getConfigFor(TAG_NODELIST));
        }
        ProgressIndicator[] aprogress = new ProgressIndicator[nodes.size()];
        if (progress != null) {
            aprogress = progress.splitProgress(nodes.size());
            progress.setInfo("Loading Navigator config...");
        }
        EreProxyManager ereProxyManager = EreProxyManager.getInstance();
        this.myUnknownEreNodes.clear();
        boolean disableInternalEre = Config.settings().getValue(NAV_CONFIG_DISABLE_INTERNAL_ERE);
        for (int i = 0; nodes != null && i < nodes.size(); ++i) {
            ProgressWrapper progressW;
            block11: {
                ereProxyManager.setProgressIndicator(aprogress[i]);
                progressW = new ProgressWrapper(aprogress[i]);
                progressW.progressStart();
                if (nodes.get(i) instanceof Element) {
                    Element ereConfigElement = (Element)nodes.get(i);
                    try {
                        if (NavigatorConfigLoader.isInternalEreConfigElement(ereConfigElement)) {
                            if (ereProxyManager.getInternalEreProxy() == null && !disableInternalEre) {
                                this.startInternalEre(ereConfigElement);
                            }
                            break block11;
                        }
                        if (NavigatorConfigLoader.isEreConfigElement(ereConfigElement)) {
                            ereProxyManager.instantiateRemoteEre(ereConfigElement);
                            break block11;
                        }
                        throw new InstantiationException("Unrecognized ERE node element.");
                    }
                    catch (InstantiationException ie) {
                        this.myUnknownEreNodes.add(ereConfigElement);
                        ExceptionUtil.handleException(ie, "navigator", 1, "Failed to create ERE node.", false);
                    }
                    catch (EreCommunicationException ce) {
                        ExceptionUtil.handleException(ce, "navigator", 1, "Navigator failed to communicate with ERE", false);
                    }
                }
            }
            progressW.progressFinished();
        }
        if (ereProxyManager.getInternalEreProxy() == null && !disableInternalEre) {
            this.startInternalEre(null);
        }
        GuiServiceCenter.getInstance().getNavigatorTreeModel().setProxyManager(ereProxyManager);
    }

    private void loadExternalConfiguration() {
        ArrayList<NavigatorNodeConfiguration> configs = new ArrayList<NavigatorNodeConfiguration>();
        for (NavigatorConfigurationHandler configHandler : this.getConfigHandlers()) {
            configs.addAll(configHandler.getNavigatorConfiguration());
        }
        if (!configs.isEmpty()) {
            try {
                Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
                Element rootElement = document.createElement("RmaConfig");
                Element nodeListElement = document.createElement(TAG_NODELIST);
                rootElement.appendChild(nodeListElement);
                for (NavigatorNodeConfiguration config : configs) {
                    config.appendXML(nodeListElement);
                }
                Config.getInstance().loadConfig(rootElement);
            }
            catch (ParserConfigurationException e) {
                ExceptionUtil.handleException(e, "navigator", 1, "Failed to load external Navigator configuration.", false);
            }
        }
    }

    private List<NavigatorConfigurationHandler> getConfigHandlers() {
        ArrayList<NavigatorConfigurationHandler> configHandlers = new ArrayList<NavigatorConfigurationHandler>();
        String[] types = ConnectorFactory.getInstance().getTypes();
        if (types != null) {
            for (String type : types) {
                try {
                    EreConnector connector = ConnectorFactory.getInstance().createTemporaryConnector(type);
                    if (connector instanceof NavigatorConfigurationHandlerProvider) {
                        NavigatorConfigurationHandler configHandler = ((NavigatorConfigurationHandlerProvider)((Object)connector)).getNavigatorConfigurationHandler();
                        if (configHandler == null) continue;
                        configHandlers.add(configHandler);
                        continue;
                    }
                    if (!"SDP".equals(type)) continue;
                    configHandlers.add(new SDPNavigatorConfigLoader());
                }
                catch (InstantiationException e) {
                    ExceptionUtil.handleException(e, "navigator", 1, "Failed to create connector(" + type + ") when trying to acquire a NavigatorConfigurationHandler.", false);
                }
            }
        }
        return configHandlers;
    }

    private void startInternalEre(Element config) throws InstantiationException, EreCommunicationException {
        try {
            if (config != null) {
                EreProxyManager.getInstance().instantiateInternalEre(config);
            } else {
                EreProxyManager.getInstance().instantiateInternalEre();
            }
        }
        catch (ProxyInstantiationException e) {
            DialogFactory.getErrorDialog("Internal ERE could not be started", "The internal ERE could NOT be started:\n" + e.getCause().getMessage());
        }
    }

    private static boolean isInternalEreConfigElement(Element root) {
        return root.getNodeName().equals(TAG_ERENODE) && root.getAttribute("type").equals("Internal ERE");
    }

    private static boolean isEreConfigElement(Element root) {
        return root.getNodeName().equals(TAG_ERENODE);
    }

    @Deprecated
    public synchronized List<Config.UserInfo> getKnownUserInfos() {
        return this.myKnownUserInfos;
    }

    @Deprecated
    public synchronized void addKnownUserInfo(Config.UserInfo newUserInfo) {
        boolean exists = false;
        for (Config.UserInfo ui : this.myKnownUserInfos) {
            if (!ui.myUsername.equals(newUserInfo.myUsername) || !ui.myPassword.equals(newUserInfo.myPassword)) continue;
            exists = true;
        }
        if (!exists) {
            this.myKnownUserInfos.add(newUserInfo);
        }
    }

    public void saveNodeConfiguration(DefaultMutableTreeNode root) {
        ArrayList<EreProxy> ereProxyList = new ArrayList<EreProxy>(EreProxyManager.getInstance().getRemoteEreList());
        ereProxyList.add(EreProxyManager.getInstance().getInternalEreProxy());
        ereProxyList.removeAll(this.saveExternalConfiguration(ereProxyList));
        try {
            Document cfgDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element rootElement = cfgDoc.createElement(TAG_NODELIST);
            for (EreProxy ereProxy : ereProxyList) {
                Element ereElement = cfgDoc.createElement(TAG_ERENODE);
                ereElement.setAttribute("type", ereProxy.getType());
                XMLOutput.appendToElement(ereProxy.getSettingsMap(), ereElement);
                rootElement.appendChild(ereElement);
            }
            for (Node node : this.myUnknownEreNodes) {
                DOMUtil.adoptNode(cfgDoc, node);
                rootElement.appendChild(node);
            }
            Config.getInstance().saveConfig("NodeConfiguration.xml", DomWriter.elementToStringIndent(rootElement));
            GuiServiceCenter.getInstance().setNodeConfigModified(false);
        }
        catch (Exception e) {
            DialogFactory.getErrorDialog("Saving Node Config", "Failed to save node configuration:\n" + e.getMessage());
        }
    }

    private List<EreProxy> saveExternalConfiguration(List<EreProxy> ereProxyList) {
        ArrayList<EreProxy> unSaved = new ArrayList<EreProxy>(ereProxyList);
        ArrayList<EreProxy> saved = new ArrayList<EreProxy>();
        for (NavigatorConfigurationHandler configHandler : this.getConfigHandlers()) {
            List<EreProxy> saveProxyList;
            if (configHandler.saveNavigatorConfiguration(saveProxyList = this.getHandledProxies(configHandler, unSaved))) {
                saved.addAll(saveProxyList);
                unSaved.removeAll(saveProxyList);
                continue;
            }
            Logger.getLogger("rma").warning("Node configuration was not saved: " + this.getProxyInformation(saveProxyList));
        }
        return saved;
    }

    private String getProxyInformation(List<EreProxy> proxyList) {
        StringBuilder proxyInformation = new StringBuilder();
        boolean first = true;
        for (EreProxy proxy : proxyList) {
            if (first) {
                first = false;
            } else {
                proxyInformation.append(", ");
            }
            proxyInformation.append(proxy.getName());
        }
        return proxyInformation.toString();
    }

    private List<EreProxy> getHandledProxies(NavigatorConfigurationHandler configHandler, List<EreProxy> ereProxyList) {
        ArrayList<EreProxy> proxies = new ArrayList<EreProxy>();
        for (EreProxy ereProxy : ereProxyList) {
            if (!configHandler.handles(ereProxy)) continue;
            proxies.add(ereProxy);
        }
        return proxies;
    }

    public static NavigatorConfigLoader getInstance() {
        return instance;
    }

    @Deprecated
    public static void setInstance(NavigatorConfigLoader newInstance) {
        instance = newInstance;
    }
}

