/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.navigator;

import com.ericsson.ere.util.IterableEnumeration;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

class NavigatorTreeCascadeHandler
extends KeyAdapter
implements TreeExpansionListener {
    private boolean myCascadeExpand = false;

    NavigatorTreeCascadeHandler() {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.isControlDown()) {
            this.myCascadeExpand = true;
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (!e.isControlDown()) {
            this.myCascadeExpand = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void treeCollapsed(TreeExpansionEvent event) {
        JTree source = (JTree)event.getSource();
        if (this.myCascadeExpand) {
            source.removeTreeExpansionListener(this);
            try {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)event.getPath().getLastPathComponent();
                this.collapseAllNodesBelow(source, node);
            }
            finally {
                source.addTreeExpansionListener(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void treeExpanded(TreeExpansionEvent event) {
        JTree source = (JTree)event.getSource();
        if (this.myCascadeExpand) {
            source.removeTreeExpansionListener(this);
            try {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)event.getPath().getLastPathComponent();
                this.expandAllNodesBelow(source, node);
            }
            finally {
                source.addTreeExpansionListener(this);
            }
        }
    }

    private void expandAllNodesBelow(JTree tree, DefaultMutableTreeNode node) {
        tree.expandPath(new TreePath(node.getPath()));
        for (DefaultMutableTreeNode tNode : IterableEnumeration.makeIterable(NavigatorTreeCascadeHandler.children(node))) {
            this.expandAllNodesBelow(tree, tNode);
        }
    }

    private void collapseAllNodesBelow(JTree tree, DefaultMutableTreeNode node) {
        for (DefaultMutableTreeNode tNode : IterableEnumeration.makeIterable(NavigatorTreeCascadeHandler.children(node))) {
            this.collapseAllNodesBelow(tree, tNode);
        }
        tree.collapsePath(new TreePath(node.getPath()));
    }

    private static Enumeration<DefaultMutableTreeNode> children(TreeNode tn) {
        return tn.children();
    }
}

