/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.navigator.actions;

import com.ericsson.ere.gui.navigator.NavigatorTree;
import com.ericsson.ere.gui.navigator.nodes.RatingPeriodNode;
import com.ericsson.ere.proxy.ActiveSavedRatingPeriodProxy;
import com.ericsson.ere.proxy.event.ProxyStructureEvent;
import com.ericsson.ere.proxy.event.ProxyStructureListener;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.util.DialogFactory;
import ericsson.ere.gui.util.ProgressDialog;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.SwingWorker;
import javax.swing.tree.DefaultMutableTreeNode;

public class ActivateAction
extends AbstractAction {
    NavigatorTree myTreeOwner = null;

    public ActivateAction(NavigatorTree owner) {
        super("on this ERE");
        this.myTreeOwner = owner;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DefaultMutableTreeNode node = this.myTreeOwner.getSelectedNode();
        if (node instanceof RatingPeriodNode) {
            RatingPeriodNode navNode = (RatingPeriodNode)node;
            final ActiveSavedRatingPeriodProxy ratingPeriodProxy = (ActiveSavedRatingPeriodProxy)navNode.getProxy();
            if (DialogFactory.getQuestionDialog(GuiServiceCenter.getInstance().getMainWindow(), "Confirm activation", "Do you really want to activate '" + navNode.toString() + "'?")) {
                ActivationListener listener = new ActivationListener(ratingPeriodProxy);
                ratingPeriodProxy.getEreProxy().addProxyStructureEventListener(listener);
                SwingWorker<Object, Object> activateTask = new SwingWorker<Object, Object>(){

                    @Override
                    protected Object doInBackground() throws Exception {
                        ratingPeriodProxy.activateRatingPeriod();
                        return null;
                    }
                };
                activateTask.execute();
                listener.startProgressTimer();
            }
        }
    }

    private class ActivationListener
    implements ProxyStructureListener {
        private ActiveSavedRatingPeriodProxy myProxy;
        private ProgressDialog myProgressDialog;

        ActivationListener(ActiveSavedRatingPeriodProxy ratingPeriodProxy) {
            this.myProxy = ratingPeriodProxy;
            this.myProgressDialog = new ProgressDialog("Activating", "Activating rating period...", false);
            this.myProgressDialog.setIndeterminate(true);
            this.myProgressDialog.setStringPainted(false);
        }

        void startProgressTimer() {
            DialogFactory.showProgressDialogWithDelay(GuiServiceCenter.getInstance().getMainWindow(), this.myProgressDialog, 1500);
        }

        @Override
        public void proxyStructureChanged(ProxyStructureEvent e) {
            this.myProxy.getEreProxy().removeProxyStructureEventListener(this);
            this.myProgressDialog.setVisible(false);
            this.myProgressDialog.dispose();
        }
    }
}

