/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.navigator.nodeimport.panels;

import com.ericsson.charging.common.dataitem.DataItemAdapter;
import com.ericsson.ere.gui.navigator.nodeimport.ImportWizardModel;
import com.ericsson.ere.gui.wizard.panels.AbstractWizardPanel;
import com.ericsson.ere.gui.wizard.panels.WizardStateView;
import ericsson.vareditor.VarTable2;
import ericsson.vareditor.VarTableModel;
import ericsson.vareditor.variable.DateAndTimeVariable;
import ericsson.vareditor.variable.StringVariable;
import ericsson.vareditor.variable.Variable;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.JLabel;

public class MigrateFilePanel
extends AbstractWizardPanel
implements WizardStateView {
    private static final long serialVersionUID = 1L;
    private Variable myServiceProviderVar = null;
    private Variable myServiceVar = null;
    private Variable myRatingPlanVar = null;
    private Variable myRatingPeriodNameVar = null;
    private Variable myStartdateVar = null;
    private JLabel myMessageLabel = null;
    private ImportWizardModel myModel;

    public MigrateFilePanel(ImportWizardModel model) {
        this.myModel = model;
        this.initialize();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(10, 12, 0, 11);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        VarTable2 table = new VarTable2();
        VarTableModel model = new VarTableModel();
        ArrayList<Variable> vars = this.initializeVariables();
        model.setData(vars);
        table.setTableModel(model);
        this.setLayout(new GridBagLayout());
        this.add((Component)table, gridBagConstraints);
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.anchor = 26;
        gridBagConstraints1.gridx = 0;
        this.myMessageLabel = new JLabel(" ");
        this.myMessageLabel.setName("MigrateFilePanel.JLabel.messageLabel");
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.insets = new Insets(10, 5, 10, 5);
        this.add((Component)this.myMessageLabel, gridBagConstraints1);
    }

    private ArrayList<Variable> initializeVariables() {
        VariableHandler variableHandler = new VariableHandler();
        this.myServiceProviderVar = new StringVariable("Service Provider");
        this.myServiceProviderVar.setDataItem(variableHandler);
        this.myServiceVar = new StringVariable("Service");
        this.myServiceVar.setDataItem(variableHandler);
        this.myRatingPlanVar = new StringVariable("Rating Plan");
        this.myRatingPlanVar.setDataItem(variableHandler);
        this.myRatingPeriodNameVar = new StringVariable("Name");
        this.myRatingPeriodNameVar.setDataItem(variableHandler);
        this.myStartdateVar = new DateAndTimeVariable("Start Date", DateAndTimeVariable.Content.DATE_TIME, "99990101T000000000");
        this.myStartdateVar.setDataItem(variableHandler);
        ArrayList<Variable> vars = new ArrayList<Variable>();
        vars.add(this.myServiceProviderVar);
        vars.add(this.myServiceVar);
        vars.add(this.myRatingPlanVar);
        vars.add(this.myRatingPeriodNameVar);
        vars.add(this.myStartdateVar);
        return vars;
    }

    @Override
    public String getPanelIdentifier() {
        return "MigrateFile";
    }

    @Override
    public String getPanelDescription() {
        return "Fill in the required information to complete migration";
    }

    public void clearAllVariables() {
        this.myServiceProviderVar.setValue("");
        this.myServiceVar.setValue("");
        this.myRatingPeriodNameVar.setValue("");
        this.myRatingPlanVar.setValue("");
    }

    @Override
    public void wizardCanceled() {
    }

    public String getServiceProvider() {
        return this.myServiceProviderVar.getValueString();
    }

    public void setServiceProviderNameAndEnabling(String name, boolean isEnabled) {
        this.myServiceProviderVar.setValue(name);
        this.myServiceProviderVar.setEnabled(isEnabled);
    }

    public String getService() {
        return this.myServiceVar.getValueString();
    }

    public void setServiceNameAndEnabling(String name, boolean isEnabled) {
        this.myServiceVar.setValue(name);
        this.myServiceVar.setEnabled(isEnabled);
    }

    public void setServiceEnabledAndAllowEditing(boolean isEnabled, boolean isAllowEdit) {
        this.myServiceVar.setAllowEdit(isAllowEdit);
        this.myServiceVar.setEnabled(isEnabled);
    }

    public String getRatingPlan() {
        return this.myRatingPlanVar.getValueString();
    }

    public void setRatingPlanNameAndEnabling(String name, boolean isEnabled) {
        this.myRatingPlanVar.setValue(name);
        this.myRatingPlanVar.setEnabled(isEnabled);
    }

    public String getRatingPeriodName() {
        return this.myRatingPeriodNameVar.getValueString();
    }

    public void setRatingPeriodNameAndEnabling(String name, boolean isEnabled) {
        this.myRatingPeriodNameVar.setValue(name);
        this.myRatingPeriodNameVar.setEnabled(isEnabled);
    }

    public void setEnablingForAllInputVariables(boolean isEnabled) {
        this.myServiceVar.setEnabled(isEnabled);
        this.myServiceProviderVar.setEnabled(isEnabled);
        this.myRatingPeriodNameVar.setEnabled(isEnabled);
        this.myRatingPlanVar.setEnabled(isEnabled);
        this.myStartdateVar.setEnabled(isEnabled);
    }

    public boolean isStartdateValid() {
        return this.myStartdateVar.isValueValid();
    }

    public String getStartdate() {
        return this.myStartdateVar.getValueString();
    }

    public void setStartdateAndEnabling(String date, boolean isEnabled) {
        this.myRatingPlanVar.setValue(date);
        this.myRatingPlanVar.setEnabled(isEnabled);
    }

    public void setStatusMessage(String text) {
        this.myMessageLabel.setText(text);
    }

    private class VariableHandler
    extends DataItemAdapter {
        private VariableHandler() {
        }

        @Override
        public void setDataItem(Object reference, Object object) {
            MigrateFilePanel.this.myModel.wizardDataChanged();
        }
    }
}

