/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.navigator.nodes;

import com.ericsson.ere.gui.editors.interfaces.NavigatorNodePropertiesInterface;
import com.ericsson.ere.gui.editors.interfaces.ProxySettingsEditorInterface;
import com.ericsson.ere.gui.editors.propertyeditor.DefaultNavigatorNodeEditor;
import com.ericsson.ere.gui.navigator.NavigatorConfigLoader;
import com.ericsson.ere.gui.navigator.NavigatorTree;
import com.ericsson.ere.gui.navigator.nodes.AbstractNavigatorNode;
import com.ericsson.ere.gui.navigator.nodes.NavigatorNodeInterface;
import com.ericsson.ere.gui.util.ExceptionUtil;
import com.ericsson.ere.proxy.AbstractEreProxy;
import com.ericsson.ere.proxy.EreProxyManager;
import com.ericsson.ere.proxy.InternalEreProxy;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.propertieseditor.EditablePropertiesInterface;
import ericsson.ere.gui.util.ProgressDialog;
import ericsson.ere.integration.connector.EreCommunicationException;
import ericsson.ere.progress.ProgressIndicator;
import ericsson.ere.progress.SynchronizedEDTProgressVisualizer;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultMutableTreeNode;

public class InternalEreNode
extends AbstractNavigatorNode
implements EditablePropertiesInterface,
NavigatorNodeInterface,
Comparable<Object> {
    private static final long serialVersionUID = -3279496270081660342L;
    private static final String ICON_IMAGE_AVAILABLE = "navigator_ere_local.png";
    private static final String ICON_IMAGE_UNAVAILABLE = "navigator_ere_local_stopped.png";
    private static final String ICON_IMAGE_UNKNOWN = "NodeStatusUnknown.gif";
    public static final String NAME = "Internal Ere";
    private static final Color CONNECTION_FAILED = Color.GRAY;
    public static final String INTERNAL_TYPE = "Internal ERE";
    private InternalEreProxy myInternalEreProxy = null;

    public InternalEreNode(InternalEreProxy internalEreProxy) {
        this.myInternalEreProxy = internalEreProxy;
    }

    @Override
    public String toString() {
        return "Internal Ere (" + this.myInternalEreProxy.getType() + ")";
    }

    public boolean isEnabled() {
        return this.myInternalEreProxy.isEnabled();
    }

    public NavigatorNodePropertiesInterface getPropertyModel() {
        return null;
    }

    @Override
    public void cancel() {
    }

    @Override
    public String getTitle() {
        return this.toString();
    }

    @Override
    public void performNodeAction() {
        this.fetchRatingManager();
    }

    public void fetchRatingManager() {
        final ProgressDialog myDialog = new ProgressDialog("Fetching Rating Manager", "Fetching Rating Manager");
        Thread work = new Thread(new Runnable(){

            @Override
            public void run() {
                InternalEreNode.this.myInternalEreProxy.clearAbortRefresh();
                myDialog.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        InternalEreNode.this.myInternalEreProxy.abortRefresh();
                    }
                });
                ProgressIndicator indicator = SynchronizedEDTProgressVisualizer.createThreadSafeProgressIndicator(myDialog, 1000);
                indicator.setInfo("Removing old");
                indicator.progressStart();
                EreProxyManager.getInstance().setProgressIndicator(indicator);
                if (InternalEreNode.this.getNodeState() == 1) {
                    myDialog.dispose();
                    return;
                }
                try {
                    InternalEreNode.this.myInternalEreProxy.refreshRatingManagerDocument();
                    InternalEreNode.this.myInternalEreProxy.getRatingManagerProxy();
                }
                catch (EreCommunicationException e) {
                    ExceptionUtil.handleException(e, "navigator", 2, "Failed to connect to internal ERE", true);
                }
                indicator.progressFinished();
                myDialog.dispose();
            }
        });
        work.start();
        myDialog.setVisible(true);
    }

    @Override
    public void saveNode() {
        NavigatorConfigLoader.getInstance().saveNodeConfiguration((DefaultMutableTreeNode)this.getRoot());
    }

    @Override
    public ImageIcon getNodeIcon(boolean expanded) {
        switch (this.getNodeState()) {
            case 0: {
                return RmaDefs.getImageIcon(ICON_IMAGE_UNKNOWN);
            }
            case 1: 
            case 2: {
                return RmaDefs.getImageIcon(ICON_IMAGE_UNAVAILABLE);
            }
        }
        return RmaDefs.getImageIcon(ICON_IMAGE_AVAILABLE);
    }

    @Override
    public Color getNodeColor() {
        if (this.getNodeState() == 2 || this.getNodeState() == 1) {
            return CONNECTION_FAILED;
        }
        return null;
    }

    public int getNodeState() {
        return this.myInternalEreProxy.getConnectionState();
    }

    @Override
    public String getNodeToolTip() {
        String myTooltip = "Node status: unknown";
        switch (this.myInternalEreProxy.getConnectionState()) {
            case 4: {
                myTooltip = "Node status: connected";
                break;
            }
            case 1: {
                myTooltip = "Node status: disabled";
            }
        }
        return myTooltip;
    }

    public String getConnectorType() {
        return this.myInternalEreProxy.getType();
    }

    @Override
    public int compareTo(Object o) {
        return -1;
    }

    public boolean isConnected() {
        return this.getNodeState() == 4;
    }

    @Override
    public void setNavigatorTree(NavigatorTree owner) {
    }

    @Override
    public ProxySettingsEditorInterface getNavigatorNodeEditor() {
        return new DefaultNavigatorNodeEditor();
    }

    @Override
    public void setNavigatorNodeEditorClass(Class<?> navigatorNodeEditor) {
    }

    @Override
    public boolean isMenuOn() {
        return true;
    }

    @Override
    public AbstractEreProxy getProxy() {
        return this.myInternalEreProxy;
    }
}

