/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.navigator.popupmenus;

import com.ericsson.ere.gui.navigator.NavigatorTree;
import com.ericsson.ere.gui.navigator.NavigatorTreeUtil;
import com.ericsson.ere.gui.navigator.nodes.ServiceListNode;
import com.ericsson.ere.gui.navigator.nodes.ServiceNode;
import com.ericsson.ere.gui.navigator.popupmenus.AbstractNavigatorPopupMenu;
import com.ericsson.ere.proxy.EreProxyManager;
import javax.swing.tree.DefaultMutableTreeNode;

public class ServicePopupMenu
extends AbstractNavigatorPopupMenu {
    static String LBL_NEW_SERVICE = "Add Service";
    static String LBL_EDIT_SERVICE_DEFINITION = "Edit Service Definition";

    public ServicePopupMenu(NavigatorTree owner) {
        super(owner);
    }

    protected void menuForServiceListNode() {
        this.removeAll();
        this.addNewServiceMenu();
        this.addSeparator();
        this.addImportMenu();
        this.addExportMenu();
        this.addSeparator();
        this.addPropertiesMenu();
    }

    protected void menuForServiceNode() {
        this.removeAll();
        this.addNewServiceMenu();
        this.addSeparator();
        this.addDeleteServiceMenuIfAllowed();
        this.addEditMenu(LBL_EDIT_SERVICE_DEFINITION);
        this.addSeparator();
        this.addImportMenu();
        this.addExportMenu();
        this.addDistributeMenu();
        this.addSeparator();
        this.addPropertiesMenu();
    }

    @Override
    public void enablePopupMenu() {
        DefaultMutableTreeNode tmpTreeNode = this.myOwner.getSelectedNode();
        if (tmpTreeNode == null) {
            this.removeAll();
            return;
        }
        if (tmpTreeNode instanceof ServiceListNode) {
            this.menuForServiceListNode();
        }
        if (tmpTreeNode instanceof ServiceNode) {
            this.menuForServiceNode();
        }
    }

    @Override
    public void enableActions() {
        this.myOwner.disableAllActions();
        DefaultMutableTreeNode tmpTreeNode = this.myOwner.getSelectedNode();
        if (tmpTreeNode == null) {
            return;
        }
        if (tmpTreeNode instanceof ServiceListNode) {
            NavigatorTree.newServiceAction.setEnabled(true);
            NavigatorTree.exportAction.setEnabled(true);
            NavigatorTree.importAction.setEnabled(true);
        }
        if (tmpTreeNode instanceof ServiceNode) {
            NavigatorTree.newServiceAction.setEnabled(true);
            NavigatorTree.deleteAction.setEnabled(true);
            NavigatorTree.editAction.setEnabled(true);
            NavigatorTree.exportAction.setEnabled(true);
            NavigatorTree.importAction.setEnabled(true);
            NavigatorTree.propertiesAction.setEnabled(true);
            NavigatorTree.distributedSaveAction.setEnabled(true);
            NavigatorTree.distributedDeleteAction.setEnabled(true);
        }
        int ereCount = 0;
        if (EreProxyManager.getInstance().getInternalEreProxy() != null) {
            ++ereCount;
        }
        if ((ereCount += EreProxyManager.getInstance().getRemoteEreList().size()) <= 1) {
            NavigatorTree.distributedDeleteAction.setEnabled(false);
            NavigatorTree.distributedSaveAction.setEnabled(false);
        }
    }

    private void addDeleteServiceMenuIfAllowed() {
        if (NavigatorTreeUtil.nodeIsDeletable(this.myOwner.getSelectedNode())) {
            this.addDeleteMenu(true);
            this.addSeparator();
        }
    }
}

