/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.ratingrules;

import com.ericsson.ere.gui.navigator.nodeimport.ImportUtil;
import com.ericsson.ere.gui.ratingrules.SelectionTree;
import com.ericsson.ere.gui.ratingrules.SelectionTreeUtil;
import com.ericsson.ere.gui.ratingrules.VersionHandler;
import com.ericsson.ere.gui.undoredo.CreateNodeEdit;
import com.ericsson.ere.gui.undoredo.UndoableTree;
import com.ericsson.ere.gui.util.ExceptionUtil;
import com.ericsson.ere.gui.util.Version;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.PluginName;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.ratingrules.nodes.TSCondition;
import ericsson.ere.gui.ratingrules.nodes.TSElement;
import ericsson.ere.gui.ratingrules.nodes.TSLink;
import ericsson.ere.gui.ratingrules.nodes.TSModifier;
import ericsson.ere.gui.ratingrules.nodes.TSNode;
import ericsson.ere.gui.ratingrules.nodes.TSTariffStructure;
import ericsson.ere.gui.ratingrules.nodes.TariffDAGModel;
import ericsson.ere.integration.management.ratingperiod.action.RatingPeriodAction;
import ericsson.ere.integration.settingsmap.SettingsMap;
import ericsson.ere.interfaces.DAGNode;
import ericsson.ere.interfaces.DAGUtil;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.ratingrules.RatingRuleBuilder;
import ericsson.ere.xml.XMLUtil;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.w3c.dom.Element;

public final class SelectionTreeImpl
implements SelectionTree,
PropertyChangeListener,
VersionHandler {
    private JTree myTree;
    private boolean myIsModified = false;
    private SettingsMap mySettings;
    private ClassRepository myRepository;
    private TreeChangeListener myTreeChangeListener = new TreeChangeListener();
    private PropertyChangeSupport myPropChangeSupport = new PropertyChangeSupport(this);

    public SelectionTreeImpl(SettingsMap settings, ClassRepository classRep) {
        this.mySettings = settings;
        this.myRepository = classRep;
    }

    @Override
    public void setTree(JTree tree) {
        if (this.myTree == tree) {
            return;
        }
        if (this.myTree != null) {
            throw new IllegalStateException("Tree component already set for this selection tree.");
        }
        this.myTree = tree;
        TreeModel model = this.myTree.getModel();
        if (model instanceof TariffDAGModel) {
            model.addTreeModelListener(this.myTreeChangeListener);
        }
        this.myTree.addPropertyChangeListener(this);
    }

    @Override
    public void addElement(int type, boolean asChild) {
        this.privAddElement(type, asChild);
    }

    @Override
    public String getSetting(String name) {
        if (this.mySettings == null) {
            return null;
        }
        return this.mySettings.getParameterAsString(name);
    }

    @Override
    public TSTariffStructure getTreeRoot() {
        assert (this.myTree != null) : "Tree component not set.";
        return (TSTariffStructure)this.myTree.getModel().getRoot();
    }

    @Override
    public JTree getTreeComponent() {
        assert (this.myTree != null) : "Tree component not set.";
        return this.myTree;
    }

    @Override
    public UndoableTree getUndoableTree() {
        assert (this.myTree != null) : "Tree component not set.";
        UndoableTree ut = null;
        if (this.myTree instanceof UndoableTree) {
            ut = (UndoableTree)((Object)this.myTree);
        }
        return ut;
    }

    @Override
    public boolean isModified() {
        return this.myIsModified;
    }

    @Override
    public boolean isTreeValid() {
        return this.getTreeRoot().isNodeValid();
    }

    @Override
    public void resetModified() {
        boolean wasModified = this.myIsModified;
        this.myIsModified = false;
        if (wasModified) {
            this.myPropChangeSupport.firePropertyChange("modified", wasModified, false);
        }
    }

    @Override
    public Version getVersion() {
        return this.getTreeRoot().getVersion();
    }

    @Override
    public void setVersion(Version version) {
        Version oldVersion = this.getVersion();
        try {
            TSTariffStructure root = this.getTreeRoot();
            root.setVersion(version);
        }
        catch (RuntimeException e) {
            this.setVersion(oldVersion);
        }
    }

    private void privAddElement(int type, boolean asChild) {
        assert (this.myTree != null) : "Tree component not set.";
        TreePath path = this.myTree.getSelectionPath();
        if (path == null) {
            return;
        }
        Object[] selectionPath = path.getPath();
        TariffDAGModel model = (TariffDAGModel)this.myTree.getModel();
        ClassRepository classRep = this.myRepository;
        TSElement element = null;
        switch (type) {
            case 1: {
                element = new TSNode(classRep);
                break;
            }
            case 2: {
                element = new TSCondition(classRep);
                break;
            }
            case 3: {
                element = new TSModifier(classRep);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unrecognized element type: " + type));
            }
        }
        String defaultName = this.getDefaultName(type, classRep);
        if (defaultName == null) {
            Component component = this.getOwnerFrame();
            if (type == 2) {
                JOptionPane.showMessageDialog(component, "There are no conditions available", "Error", 0);
            } else if (type == 3) {
                JOptionPane.showMessageDialog(component, "There are no modifiers available", "Error", 0);
            }
        } else {
            try {
                element.init(defaultName);
                element.setTreeModel(model);
                if (asChild) {
                    model.addTariffStrucureNodeAsChild(selectionPath, element);
                } else {
                    model.addTariffStrucureNodeAsSibling(selectionPath, element);
                }
                Object[] newPath = SelectionTreeUtil.findClosestMatchingPath(element, this.getTreeRoot(), selectionPath);
                int index = model.getIndexOfChild(newPath[newPath.length - 2], element);
                UndoableTree ut = this.getUndoableTree();
                if (ut != null) {
                    ut.getUndoManager().addEdit(new CreateNodeEdit(this.getUndoableTree(), newPath, index));
                }
                if (newPath != null && newPath.length > 0) {
                    SelectionTreeUtil.selectAndMakeVisible(this.getTreeComponent(), new TreePath(newPath));
                } else {
                    RmaDefs.loggerRatingPeriod.info("Strange: null/empty path, for node: " + element + " old path: " + selectionPath);
                }
            }
            catch (Exception x) {
                ExceptionUtil.handleException(x, "ratingperiod", 1, "Failed to add node.", true);
            }
        }
    }

    private String getDefaultName(int type, ClassRepository classRep) {
        String ret;
        switch (type) {
            case 1: {
                ret = "A new Node";
                break;
            }
            case 2: {
                List<PluginName> definedConditionList = classRep.getDefinedConditionList();
                String string = ret = definedConditionList.isEmpty() ? null : definedConditionList.get(0).getName();
                if (classRep.getConditionAliasOrName("FieldSelection") == null) break;
                ret = "FieldSelection";
                break;
            }
            case 3: {
                List<PluginName> modifierList = classRep.getModifierList();
                ret = modifierList.isEmpty() ? null : modifierList.get(0).getName();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unhandled element type.");
            }
        }
        return ret;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.myTree && "model".equals(evt.getPropertyName())) {
            TreeModel oldModel = (TreeModel)evt.getOldValue();
            TreeModel newModel = (TreeModel)evt.getNewValue();
            oldModel.removeTreeModelListener(this.myTreeChangeListener);
            if (newModel instanceof TariffDAGModel) {
                newModel.addTreeModelListener(this.myTreeChangeListener);
            }
            this.myIsModified = true;
        }
    }

    @Override
    public TSTariffStructure buildCopy(RatingRuleBuilder builder) {
        TSTariffStructure copy = null;
        try {
            copy = this.getTreeRoot().buildCopy(builder);
        }
        catch (Exception ex) {
            ExceptionUtil.handleException(ex, "ratingRuleFrame", 1, "RMA failed to build xml configuration when saving.", false);
        }
        return copy;
    }

    @Override
    public Element getUpdatedXMLConfiguration() {
        return (Element)this.getTreeRoot().getUpdatedXMLConfiguration();
    }

    @Override
    public Element getUpdatedXMLConfigurationClone() {
        return (Element)this.getTreeRoot().getUpdatedXMLConfigurationClone();
    }

    @Override
    public void updateVersion(Element xml, long currentVersion) {
        TSTariffStructure rootNode = this.getTreeRoot();
        Element versionElement = XMLUtil.getNamedElement("Version", xml.getChildNodes());
        if (versionElement != null) {
            long version = currentVersion >= 0L ? currentVersion : rootNode.getVersion().getVersion();
            long newVersion = version + 1L;
            RatingPeriodAction.updateVersion(versionElement, Calendar.getInstance(), String.valueOf(newVersion));
            rootNode.updateLastModifiedDate();
            rootNode.getVersion().setVersion(newVersion);
        } else {
            ImportUtil.addVersionElement(xml);
        }
    }

    @Override
    public VersionHandler getVersionHandler() {
        return this;
    }

    @Override
    public boolean validateLinkTargets() {
        HashMap<DAGNode, DAGNode> linkMap = new HashMap<DAGNode, DAGNode>();
        DAGUtil.getLinksToTargets(this.getTreeRoot(), linkMap);
        LinkedHashSet<DAGNode> linkSet = new LinkedHashSet<DAGNode>();
        linkSet.addAll(linkMap.values());
        Iterator linkIterator = linkSet.iterator();
        HashSet<TariffStructureNode> processedNodes = new HashSet<TariffStructureNode>();
        while (linkIterator.hasNext()) {
            DAGNode currentNode = (DAGNode)linkIterator.next();
            int[] foundIndex = new int[1];
            TreePath path = DAGUtil.getPathToRoot(currentNode);
            if (TSLink.checkDuplicatesInPath(path.getPath(), 0, foundIndex, processedNodes) == null && SelectionTreeUtil.checkNodeId(path)) continue;
            SelectionTreeUtil.selectAndMakeVisible(this.getTreeComponent(), path);
            return false;
        }
        return true;
    }

    @Override
    public Component getOwnerFrame() {
        JTree tree = this.getTreeComponent();
        return SwingUtilities.getAncestorOfClass(RootPaneContainer.class, tree);
    }

    @Override
    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.myPropChangeSupport;
    }

    private class TreeChangeListener
    implements TreeModelListener {
        private TreeChangeListener() {
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            SelectionTreeImpl.this.myIsModified = true;
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
            SelectionTreeImpl.this.myIsModified = true;
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
            SelectionTreeImpl.this.myIsModified = true;
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
            SelectionTreeImpl.this.myIsModified = true;
        }
    }
}

