/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.ratingrules;

import com.ericsson.ere.functioncontrol.FunctionContext;
import com.ericsson.ere.functioncontrol.FunctionManager;
import com.ericsson.ere.functioncontrol.FunctionManagerImpl;
import com.ericsson.ere.functioncontrol.FunctionState;
import com.ericsson.ere.functioncontrol.FunctionToken;
import com.ericsson.ere.gui.diff.DiffToolPanel;
import com.ericsson.ere.gui.editors.interfaces.NewProxyEditorInterface;
import com.ericsson.ere.gui.editors.interfaces.SaveAsProxyEditorInterface;
import com.ericsson.ere.gui.navigator.distribute.DistributedSaveRatingPeriodToAssociatedERETask;
import com.ericsson.ere.gui.navigator.distribute.DistributionWizardOptions;
import com.ericsson.ere.gui.navigator.distribute.EREDistributorDialog;
import com.ericsson.ere.gui.navigator.nodeimport.ImportUtil;
import com.ericsson.ere.gui.navigator.nodes.RatingPeriodNode;
import com.ericsson.ere.gui.ratingrules.SaveEvent;
import com.ericsson.ere.gui.ratingrules.SaveListener;
import com.ericsson.ere.gui.ratingrules.SelectionTree;
import com.ericsson.ere.gui.ratingrules.SelectionTreeSaveHandler;
import com.ericsson.ere.gui.ratingrules.VersionHandler;
import com.ericsson.ere.gui.util.ExceptionUtil;
import com.ericsson.ere.gui.util.SystemPropertyUtil;
import com.ericsson.ere.gui.util.Version;
import com.ericsson.ere.gui.wizard.WizardDialog;
import com.ericsson.ere.gui.wizard.WizardFactory;
import com.ericsson.ere.gui.wizard.WizardOptions;
import com.ericsson.ere.gui.wizard.WizardView;
import com.ericsson.ere.proxy.RatingPeriodProxy;
import com.ericsson.ere.swing.EDT;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.RmaFrameSupport;
import ericsson.ere.gui.ratingrules.DiffStrategy;
import ericsson.ere.gui.ratingrules.LightweightJTreeNodeFactory;
import ericsson.ere.gui.ratingrules.RatingJTreeErrorHandler;
import ericsson.ere.gui.ratingrules.nodes.TSTariffStructure;
import ericsson.ere.gui.util.DefaultDialogFactory;
import ericsson.ere.gui.util.DialogFactoryInterface;
import ericsson.ere.gui.util.FrameOpener;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.ere.gui.util.ProgressDialog;
import ericsson.ere.gui.util.SwingWorker;
import ericsson.ere.integration.connector.EreCommunicationException;
import ericsson.ere.interfaces.RatingRuleBuilderErrorHandler;
import ericsson.ere.management.ContextAwareServiceContainer;
import ericsson.ere.progress.ProgressIndicator;
import ericsson.ere.ratingrules.RatingBuilderErrorHandler;
import ericsson.ere.ratingrules.RatingRuleBuilder;
import ericsson.ere.ratingrules.SyntaxCheckingRatingFactory;
import ericsson.ere.xml.DomWriter;
import ericsson.ere.xml.XMLUtil;
import java.awt.Component;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class SelectionTreeSaveHandlerImpl
implements SelectionTreeSaveHandler {
    private final SelectionTree myTree;
    private final String myFileName;
    private final RatingPeriodProxyWrapper myProxy;
    private final ContextAwareServiceContainer myServiceContainer;
    private Set<SaveListener> mySaveListeners = new HashSet<SaveListener>();
    private boolean myUseDialogForDiff;
    private DialogFactoryInterface myDialogFactory = new DefaultDialogFactory();

    private SelectionTreeSaveHandlerImpl(SelectionTree tree, ContextAwareServiceContainer serviceContainer, String fileName) {
        this.myTree = tree;
        this.myFileName = fileName;
        this.myServiceContainer = serviceContainer;
        this.myProxy = null;
    }

    private SelectionTreeSaveHandlerImpl(SelectionTree tree, ContextAwareServiceContainer serviceContainer, RatingPeriodProxyWrapper proxy) {
        this.myTree = tree;
        this.myProxy = proxy;
        this.myServiceContainer = serviceContainer;
        this.myFileName = null;
    }

    public static SelectionTreeSaveHandlerImpl createForFile(SelectionTree tree, ContextAwareServiceContainer serviceContainer, String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("Null filename not permitted.");
        }
        return new SelectionTreeSaveHandlerImpl(tree, serviceContainer, fileName);
    }

    public static SelectionTreeSaveHandlerImpl createForProxy(SelectionTree tree, ContextAwareServiceContainer serviceContainer, RatingPeriodProxyWrapper proxy) {
        if (proxy == null) {
            throw new IllegalArgumentException("Null proxy not permitted.");
        }
        return new SelectionTreeSaveHandlerImpl(tree, serviceContainer, proxy);
    }

    public DialogFactoryInterface setDialogFactory(DialogFactoryInterface factory) {
        if (factory == null) {
            throw new IllegalArgumentException("Null dialog factory is not allowed.");
        }
        DialogFactoryInterface old = this.myDialogFactory;
        this.myDialogFactory = factory;
        return old;
    }

    public void useDialogForDifferenceDetectionTool() {
        this.myUseDialogForDiff = true;
    }

    @Override
    public void addSaveListener(SaveListener listener) {
        this.mySaveListeners.add(listener);
    }

    @Override
    public void removeSaveListener(SaveListener listener) {
        this.mySaveListeners.remove(listener);
    }

    protected final void fireBeforeSave(SaveEvent evt) {
        for (SaveListener l : this.mySaveListeners) {
            l.beforeSave(evt);
        }
    }

    protected final void fireHasSaved(SaveEvent evt) {
        for (SaveListener l : this.mySaveListeners) {
            l.hasSaved(evt);
        }
    }

    @Override
    public void saveToMultipleEREs() {
        block2: {
            try {
                DistributionWizardOptions wizardOptions = new DistributionWizardOptions();
                wizardOptions.wizardTitle = "ERE Distribution wizard";
                Element elem = this.myTree.getUpdatedXMLConfigurationClone();
                EREDistributorDialog analyzePanel = new EREDistributorDialog(this.myProxy.getProxy(), elem, DistributedSaveRatingPeriodToAssociatedERETask.class, EREDistributorDialog.DistributionMode.ANALYZE, wizardOptions);
                EREDistributorDialog performPanel = new EREDistributorDialog(this.myProxy.getProxy(), elem, DistributedSaveRatingPeriodToAssociatedERETask.class, EREDistributorDialog.DistributionMode.PERFORM, wizardOptions);
                wizardOptions.wizardPanels.add(analyzePanel);
                wizardOptions.wizardPanels.add(performPanel);
                WizardDialog tDialog = new WizardDialog(GuiServiceCenter.getInstance().getMainWindow(), (WizardOptions)wizardOptions);
                tDialog.setSize(500, 700);
                tDialog.setVisible(true);
                this.myTree.resetModified();
            }
            catch (Exception e) {
                Component frame = this.getFrame();
                if (frame == null) break block2;
                this.myDialogFactory.getErrorDialog(frame, "RMA", "There was an error trying to save the Selection Tree!\nReason:" + e.getMessage());
            }
        }
    }

    private boolean isTreeValidWithDialog() {
        boolean valid = this.myTree.isTreeValid();
        if (!valid) {
            Component frame = this.getFrame();
            if (frame != null) {
                this.myDialogFactory.getInformationDialog(frame, "Save not allowed", "Save not allowed due to invalid value/s in tree structure.\nUpdate structure with valid value/s before saving.");
            }
            return false;
        }
        return valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SelectionTreeSaveHandler.SaveResult save(ProgressIndicator progress) {
        SelectionTreeSaveHandler.SaveResult result;
        ProgressIndicator pi = progress;
        if (pi == null) {
            pi = new ProgressDialog("", "").getProgressIndicator();
        }
        if (!this.checkTreeValidity()) {
            return SelectionTreeSaveHandler.SaveResult.NOT_STARTED;
        }
        if (this.isBeforeSaveVetoed(SaveEvent.SaveKind.Save)) {
            return this.saveAs(pi, false);
        }
        Component frame = this.getFrame();
        try {
            if (frame != null) {
                GuiUtil.setBusyCursor(frame);
            }
            ProgressIndicator[] saveProgress = pi.splitProgress(2);
            Element domRoot = this.getXmlWithConsistencyCheck(saveProgress[0], false);
            if (this.myProxy != null) {
                SelectionTreeSaveHandler.SaveResult hasSaved;
                Element xmlElement = domRoot;
                DiffStrategy showDiff = DiffStrategy.CONFLICT_DETECTION;
                if (this.useSaveConfirmation()) {
                    showDiff = DiffStrategy.SAVE_CONFIRMATION;
                }
                if ((hasSaved = this.saveViaProxy(this.myProxy.getProxy(), xmlElement, saveProgress[1], showDiff, false)) == SelectionTreeSaveHandler.SaveResult.SUCCESS) {
                    this.myTree.resetModified();
                    this.fireHasSaved(new SaveEvent(this, SaveEvent.SaveKind.Save, this.myProxy.getProxy()));
                }
                result = hasSaved;
            } else {
                this.saveTariffToFile(new File(this.myFileName), saveProgress[1], domRoot);
                this.myTree.resetModified();
                result = SelectionTreeSaveHandler.SaveResult.SUCCESS;
            }
        }
        catch (IOException e) {
            String dest = this.myProxy != null ? "connector" : "file " + new File(this.myFileName).getPath();
            long logNumber = ExceptionUtil.handleException(e, "ratingperiod", 2, "I/O error when saving.", false);
            if (frame != null) {
                String msgFormat = "Failed to save to %s. See log entry %d for more details.\n\nReason:\n\n%s";
                String msg = String.format("Failed to save to %s. See log entry %d for more details.\n\nReason:\n\n%s", dest, logNumber, e.getMessage());
                this.myDialogFactory.getErrorDialog(frame, "Save failed", msg);
            }
            result = SelectionTreeSaveHandler.SaveResult.FAILURE;
        }
        catch (Exception e) {
            long logNumber = ExceptionUtil.handleException(e, "ratingperiod", 2, "Error when saving.", false);
            if (frame != null) {
                String msgFormat = "Failed to save. See log entry %d for more details.\n\nReason:\n\n%s";
                String errReason = e instanceof NullPointerException ? "Rating tree is missing on server" : e.getMessage();
                String msg = String.format("Failed to save. See log entry %d for more details.\n\nReason:\n\n%s", logNumber, errReason);
                this.myDialogFactory.getErrorDialog(frame, "Save failed", msg);
            }
            result = SelectionTreeSaveHandler.SaveResult.FAILURE;
        }
        finally {
            if (frame != null) {
                GuiUtil.setDefaultCursor(frame);
            }
        }
        return result;
    }

    @Override
    public boolean saveAs(ProgressIndicator progress) {
        return this.saveAs(progress, true) == SelectionTreeSaveHandler.SaveResult.SUCCESS;
    }

    private SelectionTreeSaveHandler.SaveResult saveAs(ProgressIndicator progress, boolean checkValidity) {
        SelectionTreeSaveHandler.SaveResult result;
        ProgressIndicator pi = progress;
        if (pi == null) {
            pi = new ProgressDialog("", "").getProgressIndicator();
        }
        if (checkValidity && !this.checkTreeValidity()) {
            return SelectionTreeSaveHandler.SaveResult.NOT_STARTED;
        }
        if (this.isBeforeSaveVetoed(SaveEvent.SaveKind.SaveAs)) {
            return SelectionTreeSaveHandler.SaveResult.NOT_STARTED;
        }
        Component frame = this.getFrame();
        try {
            Class<?> editorClass = this.getSaveAsEditorClass();
            boolean hasSaveAsEditor = editorClass != null;
            ProgressIndicator[] saveAsProgress = pi.splitProgress(hasSaveAsEditor || this.myProxy == null ? 2 : 1);
            Element xml = this.getXmlWithConsistencyCheck(saveAsProgress[0], true);
            if (this.myProxy != null) {
                RatingPeriodProxy newRatingPeriodProxy = hasSaveAsEditor ? this.saveAsUsingSaveAsEditor(editorClass, saveAsProgress[1], xml) : this.saveAsUsingCreateEditor(xml);
                this.fireHasSaved(new SaveEvent(this, SaveEvent.SaveKind.SaveAs, newRatingPeriodProxy));
                result = newRatingPeriodProxy != null ? SelectionTreeSaveHandler.SaveResult.SUCCESS : SelectionTreeSaveHandler.SaveResult.NOT_STARTED;
            } else {
                JFileChooser chooser = GuiServiceCenter.getInstance().getFileChooser();
                int save = chooser.showSaveDialog(frame);
                if (save == 0) {
                    File newFile = chooser.getSelectedFile();
                    this.saveTariffToFile(newFile, saveAsProgress[1], xml);
                    result = SelectionTreeSaveHandler.SaveResult.SUCCESS;
                } else {
                    result = SelectionTreeSaveHandler.SaveResult.NOT_STARTED;
                }
            }
        }
        catch (Exception e) {
            RmaDefs.loggerRatingPeriod.warning("Error when saving: " + e.getMessage());
            if (frame != null) {
                String msg = "Failed to save.\nDetails: " + e.getMessage();
                this.myDialogFactory.getErrorDialog(frame, "Save as failed", msg);
            }
            result = SelectionTreeSaveHandler.SaveResult.FAILURE;
        }
        return result;
    }

    private Class<?> getSaveAsEditorClass() {
        Class<?> editorClass = this.myProxy == null ? null : this.myProxy.getProxy().getSaveAsProxyEditorClass();
        return editorClass;
    }

    private RatingPeriodProxy saveAsUsingSaveAsEditor(Class<?> editorClass, ProgressIndicator progress, Element xml) throws InstantiationException, IllegalAccessException, Exception {
        final SaveAsProxyEditorInterface editor = (SaveAsProxyEditorInterface)editorClass.newInstance();
        RatingPeriodProxy newRatingPeriodProxy = EDT.runAndWait(new EDT.ValueRunnable<RatingPeriodProxy>(){

            @Override
            public RatingPeriodProxy run() {
                editor.performNew(SelectionTreeSaveHandlerImpl.this.myProxy.getProxy().getParentRatingPlanProxy());
                return editor.getCreatedProxy();
            }
        });
        if (newRatingPeriodProxy != null) {
            xml.setAttribute("Name", newRatingPeriodProxy.getName());
            this.addVersionTagIfNoneExists(xml);
            this.replaceVersionTagForElement(xml);
            DiffStrategy openDiffTool = editor.requiresOverwriting() ? DiffStrategy.OVERWRITE_PROTECTION : DiffStrategy.NEVER_OPEN;
            this.saveViaProxy(newRatingPeriodProxy, xml, progress, openDiffTool, true);
        }
        return newRatingPeriodProxy;
    }

    private void addVersionTagIfNoneExists(Element xml) {
        Element versionElement = XMLUtil.getFirstElementNamed("Version", xml);
        if (versionElement == null) {
            ImportUtil.addVersionElement(xml);
        }
    }

    private void replaceVersionTagForElement(Element xml) {
        Element versionElement = XMLUtil.getFirstElementNamed("Version", xml);
        if (versionElement != null) {
            Version version = new Version((Version.VersionUpdateListener)null);
            Element newVersionElement = null;
            try {
                newVersionElement = version.getVersionElement();
            }
            catch (Exception ex) {
                throw new AssertionError((Object)"This indicates an error in the Version class");
            }
            newVersionElement = (Element)xml.getOwnerDocument().importNode(newVersionElement, false);
            xml.replaceChild(newVersionElement, versionElement);
        }
    }

    private RatingPeriodProxy saveAsUsingCreateEditor(Element xml) throws InstantiationException, IllegalAccessException, EreCommunicationException {
        final RatingPeriodProxy periodProxy = this.myProxy.getProxy();
        final NewProxyEditorInterface editor = (NewProxyEditorInterface)periodProxy.getCreateProxyEditorClass(RatingPeriodProxy.class).newInstance();
        RatingPeriodProxy newRatingPeriodProxy = EDT.runAndWait(new EDT.ValueRunnable<RatingPeriodProxy>(){

            @Override
            public RatingPeriodProxy run() {
                editor.performNew(periodProxy.getParentRatingPlanProxy());
                return (RatingPeriodProxy)editor.getCreatedProxy();
            }
        });
        if (newRatingPeriodProxy != null) {
            xml.setAttribute("Name", newRatingPeriodProxy.getName());
            this.replaceVersionTagForElement(xml);
            newRatingPeriodProxy.updateRatingPeriodRuleTree(xml);
        }
        return newRatingPeriodProxy;
    }

    private Element getXmlWithConsistencyCheck(ProgressIndicator progress, boolean clone) throws Exception {
        ProgressIndicator[] pi = progress.splitProgress(2);
        pi[0].setInfo("Updating tree XML - this may take some time");
        pi[0].progressStart();
        Element domRoot = clone ? this.myTree.getUpdatedXMLConfigurationClone() : this.myTree.getUpdatedXMLConfiguration();
        pi[0].progressFinished();
        pi[1].setInfo("Checking consistency");
        pi[1].progressStart();
        this.checkTariffConsistency(domRoot, pi[1]);
        pi[1].progressFinished();
        return domRoot;
    }

    private boolean isBeforeSaveVetoed(SaveEvent.SaveKind kind) {
        if (this.myProxy == null) {
            return false;
        }
        SaveEvent event = new SaveEvent(this, kind, this.myProxy.getProxy());
        this.fireBeforeSave(event);
        return event.isVetoed();
    }

    private boolean checkTreeValidity() {
        return this.isTreeValidWithDialog() && this.validateLinkTargetsWithDialog();
    }

    @Override
    public void export(ProgressIndicator pi) {
        boolean doExport = true;
        if (this.myProxy == null) {
            doExport = false;
            this.saveAs(pi, true);
        } else if (this.myTree.isModified()) {
            int result = this.myDialogFactory.getQuestionDialogWithCancel(this.getFrame(), "Selection Tree is not saved", "The Selection Tree has been modified and is not saved. If you export without\nsaving the exported Selection Tree will be the last saved version.\nDo you want to save the Selection Tree before exporting?");
            if (result == 0) {
                final ProgressDialog progressDialog = new ProgressDialog("RMA", "Saving Selection Tree");
                SwingWorker worker = new SwingWorker(){

                    @Override
                    public Object construct() {
                        ProgressIndicator progress = progressDialog.getProgressIndicator();
                        return SelectionTreeSaveHandlerImpl.this.save(progress);
                    }

                    @Override
                    public void finished() {
                        progressDialog.dispose();
                    }
                };
                worker.start();
                progressDialog.setVisible(true);
            } else if (result == -1 || result == 2) {
                doExport = false;
            }
        }
        if (doExport) {
            RatingPeriodNode node = new RatingPeriodNode(this.myProxy.getProxy());
            WizardView view = WizardFactory.createNavigatorExportWizard(GuiServiceCenter.getInstance().getMainWindow(), node);
            view.run();
        }
    }

    private Element getRemoteTreeElement(RatingPeriodProxy remoteProxy) throws EreCommunicationException {
        Element remoteTree = remoteProxy.getRatingPeriodRuleTree();
        if (remoteTree != null && !"TariffStructure".equals(remoteTree.getNodeName())) {
            remoteTree = XMLUtil.getNamedElement("TariffStructure", remoteTree.getElementsByTagName("TariffStructure"));
        }
        return remoteTree;
    }

    private SelectionTreeSaveHandler.SaveResult saveViaProxy(RatingPeriodProxy remoteProxy, Element xml, ProgressIndicator progressIndicator, DiffStrategy diffStrategy, boolean isSaveAs) throws Exception {
        SelectionTreeSaveHandler.SaveResult result;
        long remoteVersionNumber = -1L;
        boolean checkDiff = diffStrategy != DiffStrategy.NEVER_OPEN;
        boolean needsSave = true;
        ProgressIndicator[] progress = progressIndicator.splitProgress(checkDiff ? 3 : 2);
        int pidx = 0;
        if (checkDiff) {
            progress[pidx].progressStart();
            progress[pidx].setInfo("Comparing with remote version");
            Object[] ret = this.checkDiffOnSave(diffStrategy, remoteProxy, progress[pidx]);
            needsSave = (Boolean)ret[0];
            remoteVersionNumber = (Long)ret[1];
            progress[pidx].progressFinished();
            ++pidx;
        }
        if (needsSave) {
            try {
                if (!isSaveAs) {
                    progress[pidx].progressStart();
                    progress[pidx].setInfo("Updating version");
                    VersionHandler handler = this.myTree.getVersionHandler();
                    handler.updateVersion(xml, remoteVersionNumber);
                    progress[pidx].progressFinished();
                    ++pidx;
                }
                progress[pidx].setInfo("Saving - This may take some time");
                progress[pidx].progressStart();
                remoteProxy.updateRatingPeriodRuleTree(xml);
                progress[pidx].progressFinished();
                result = SelectionTreeSaveHandler.SaveResult.SUCCESS;
            }
            catch (EreCommunicationException e) {
                ExceptionUtil.handleException(e, "ratingRuleFrame", 2, "Failed to save the Selection Tree to the server.", true);
                result = SelectionTreeSaveHandler.SaveResult.FAILURE;
            }
            catch (Exception e) {
                ExceptionUtil.handleException(e, "ratingRuleFrame", 2, "Failed to update the version when saving the Selection Tree.", true);
                result = SelectionTreeSaveHandler.SaveResult.FAILURE;
            }
        } else {
            result = SelectionTreeSaveHandler.SaveResult.DIFF_SAVE;
        }
        return result;
    }

    private Object[] checkDiffOnSave(DiffStrategy diffStrategy, RatingPeriodProxy remoteProxy, ProgressIndicator progress) throws Exception {
        boolean needsSave = false;
        LightweightJTreeNodeFactory nodeFactory = new LightweightJTreeNodeFactory(this.myServiceContainer.getService().getId(), this.myServiceContainer.getClassRepository());
        RatingJTreeErrorHandler errorHandler = new RatingJTreeErrorHandler();
        RatingRuleBuilder builder = new RatingRuleBuilder(nodeFactory, (RatingRuleBuilderErrorHandler)errorHandler);
        long remoteVersionNumber = remoteProxy.getRemoteVersion();
        Element remoteTree = null;
        if (remoteVersionNumber == -1L) {
            remoteTree = this.getRemoteTreeElement(remoteProxy);
            if (remoteTree == null) {
                return new Object[]{true, remoteVersionNumber};
            }
            Element remoteVersionElement = XMLUtil.getNamedElement("Version", remoteTree.getChildNodes());
            if (remoteVersionElement != null) {
                Version remoteVersion = Version.create(remoteVersionElement, null);
                remoteVersionNumber = remoteVersion.getVersion();
            }
        }
        if (remoteVersionNumber != -1L) {
            Version localVersion = this.myTree.getVersion();
            if (localVersion != null) {
                if (diffStrategy == DiffStrategy.OVERWRITE_PROTECTION) {
                    this.informShowDifferences();
                    this.fetchRemoteTreeAndShowDiffTool(remoteProxy, remoteTree, progress, builder, this.myTree.buildCopy(builder), 2);
                } else if (remoteVersionNumber >= localVersion.getVersion() + 1L) {
                    int result = this.askCompareOrOverwrite();
                    if (result == 0) {
                        this.fetchRemoteTreeAndShowDiffTool(remoteProxy, remoteTree, progress, builder, this.myTree.buildCopy(builder), 2);
                    } else if (result == 1) {
                        needsSave = true;
                    }
                } else if (diffStrategy == DiffStrategy.SAVE_CONFIRMATION) {
                    this.informConfirmNecessary();
                    this.fetchRemoteTreeAndShowDiffTool(remoteProxy, remoteTree, progress, builder, this.myTree.buildCopy(builder), 3);
                } else {
                    needsSave = true;
                }
            }
        } else if (diffStrategy == DiffStrategy.SAVE_CONFIRMATION) {
            this.informConfirmNecessary();
            this.fetchRemoteTreeAndShowDiffTool(remoteProxy, remoteTree, progress, builder, this.myTree.buildCopy(builder), 3);
        } else {
            needsSave = true;
        }
        return new Object[]{needsSave, remoteVersionNumber};
    }

    private void fetchRemoteTreeAndShowDiffTool(RatingPeriodProxy remoteProxy, Element remoteTreeElement, ProgressIndicator progress, RatingRuleBuilder builder, TSTariffStructure localTree, int diffAction) {
        try {
            Element remoteTree = remoteTreeElement == null ? this.getRemoteTreeElement(remoteProxy) : remoteTreeElement;
            this.showDiffTool(remoteProxy, progress, builder, remoteTree, localTree, diffAction);
        }
        catch (Exception ex) {
            ExceptionUtil.handleException(ex, "ratingRuleFrame", 1, "RMA failed to compare local and remote versions when saving!", false);
        }
    }

    private void informConfirmNecessary() {
        this.myDialogFactory.getInformationDialog(this.getFrame(), "RMA", "RMA requires confirmation of your changes before saving.");
    }

    private int askCompareOrOverwrite() {
        String[] options = new String[]{"Compare the two versions", "Overwrite the other version", "Cancel"};
        return this.myDialogFactory.showCustomOptionDialog(GuiServiceCenter.getInstance().getMainWindow(), "Possible conflict found", "A later tree version than the one you are trying to save was found.\nWould you like to compare that version with your changes before saving?\n\nNOTE: If you go ahead with the save without looking at the differences, the changes found in the other version will be lost!", options, 1, 3);
    }

    private void informShowDifferences() {
        this.myDialogFactory.getInformationDialog(GuiServiceCenter.getInstance().getMainWindow(), "RMA", "You are about to overwrite an existing period.\nThe diff tool will now show the differences between your selection tree and the one you are trying to overwrite.");
    }

    private void showDiffTool(final RatingPeriodProxy remoteProxy, ProgressIndicator progress, RatingRuleBuilder builder, Element remoteTree, final TSTariffStructure localTree, final int diffToolAction) throws Exception {
        ProgressIndicator[] progresses = progress.splitProgress(3);
        progresses[0].setInfo("Building remote selection tree...");
        progresses[0].progressStart();
        final TSTariffStructure remoteRoot = (TSTariffStructure)builder.build((Node)remoteTree, progress);
        progresses[0].progressFinished();
        progresses[1].setInfo("Creating the Difference Detection tool GUI...");
        progresses[1].progressStart();
        DiffToolPanel diffTool = EDT.runAndWait(new Callable<DiffToolPanel>(){

            @Override
            public DiffToolPanel call() throws Exception {
                return new DiffToolPanel(SelectionTreeSaveHandlerImpl.this.myTree, remoteProxy, SelectionTreeSaveHandlerImpl.this.myServiceContainer, localTree, remoteRoot, diffToolAction);
            }
        });
        progresses[1].progressFinished();
        progresses[2].setInfo("Starting the Difference Detection tool...");
        progresses[2].progressStart();
        if (this.myUseDialogForDiff) {
            JDialog dlg = diffTool.getDialog();
            dlg.setVisible(true);
        } else {
            RmaFrameSupport frame = diffTool.getInternalFrame();
            new FrameOpener(frame).open();
        }
        progresses[2].progressFinished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveTariffToFile(File dest, ProgressIndicator progress, Node domRoot) throws Exception {
        progress.progressStart();
        progress.setInfo("Saving");
        if (dest.exists() && !dest.canWrite()) {
            throw new IOException("Cannot write to file " + dest.getPath());
        }
        try (PrintWriter out = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(dest), "UTF-8")), false);){
            DomWriter.nodeToWriter(domRoot, out, true, true);
        }
        progress.progressFinished();
    }

    private boolean useSaveConfirmation() {
        String saveConfirmationProperty = SystemPropertyUtil.getPropertyWithOptionalJnlpPrefix("saveConfirmation");
        return saveConfirmationProperty != null && Boolean.valueOf(saveConfirmationProperty) != false;
    }

    private boolean validateLinkTargetsWithDialog() {
        Component frame;
        boolean b = this.myTree.validateLinkTargets();
        if (!b && (frame = this.getFrame()) != null) {
            this.myDialogFactory.getErrorDialog(frame, "Tree cannot not be saved", "There are invalid links in the tree. The tree cannot be saved in this state.\nPossible reasons are: Ambiguous paths to link targets or invalid node Id in link target path.");
        }
        return b;
    }

    private void checkTariffConsistency(Node root, ProgressIndicator progress) throws Exception {
        String ratingPlanId = this.myProxy == null ? "TempPlan" : this.myProxy.getProxy().getRatingPlanName();
        SyntaxCheckingRatingFactory nodeFactory = new SyntaxCheckingRatingFactory(this.myServiceContainer.getClassRepository(), ratingPlanId);
        RatingBuilderErrorHandler errorHandler = new RatingBuilderErrorHandler();
        RatingRuleBuilder builder = new RatingRuleBuilder(nodeFactory, (RatingRuleBuilderErrorHandler)errorHandler);
        builder.buildFromElement((Element)root, progress);
    }

    @Override
    public boolean isSaveAllowed() {
        FunctionContext ctx;
        if (this.myProxy == null) {
            return true;
        }
        FunctionManager mgr = FunctionManagerImpl.getInstance();
        FunctionState state = mgr.getStateForFunction(FunctionToken.SAVE_SELECTION_TREE, ctx = FunctionContext.build().withProxy(this.myProxy.getProxy()).get());
        return state.getState() == FunctionState.State.ON;
    }

    private Component getFrame() {
        return this.myTree.getOwnerFrame();
    }

    public static interface RatingPeriodProxyWrapper {
        public RatingPeriodProxy getProxy();
    }
}

