/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.search;

import com.ericsson.ere.gui.search.AbstractViewPanel;
import com.ericsson.ere.gui.search.view.BranchSearchFilterSelectionView;
import com.ericsson.ere.swing.EventSource;
import com.ericsson.ere.swing.WeightedSingleLineLayoutManager;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.util.FileFilterImpl;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class BranchSearchFilterSelectionPanel
extends AbstractViewPanel
implements BranchSearchFilterSelectionView {
    private static final String ADD_NEW_ICON = "cube_blue_add_16.png";
    private static final String DELETE_ICON = "cube_blue_delete_16.png";
    private static final String EDIT_ICON = "cube_blue_preferences.png";
    private static final String EXPORT_ICON = "export1_16.png";
    private static final String IMPORT_ICON = "import1_16.png";
    private static final String FILE_EXTENSION = "bsx";
    private static final String SELECT_ICON = "arrow_right_green_16.png";
    private static final String DESELECT_ICON = "arrow_left_green_16.png";
    private static final String MAIN_FILTER_EMPTY_LIST_TOOLTIP = "Manage filters using buttons below";
    private static final String MAIN_FILTER_LIST_TOOLTIP = "Double-click on a filter to start editing it";
    private static final String NEW_FILTER_TOOLTIP = "Create a new filter";
    private static final String DELETE_FILTERS_TOOLTIP = "Delete selected filters";
    private static final String EXPORT_FILTERS_TOOLTIP = "Export selected filters to file";
    private static final String IMPORT_FILTERS_TOOLTIP = "Import filters from file";
    private static final String EDIT_FILTER_TOOLTIP = "Edit selected filter";
    private static final String EXCLUDE_FILTER_LIST_TITLE = "Exclude list";
    private static final String INCLUDE_FILTER_LIST_TITLE = "Include list";
    private static final String MAIN_FILTER_LIST_TITLE = "All filters";
    private EventSource mySelectIncludeEvent = new EventSource();
    private EventSource myDeselectIncludeEvent = new EventSource();
    private EventSource mySelectExcludeEvent = new EventSource();
    private EventSource myDeselectExcludeEvent = new EventSource();
    private EventSource myExportFiltersEvent = new EventSource();
    private EventSource myImportFiltersEvent = new EventSource();
    private EventSource myDeleteFiltersEvent = new EventSource();
    private EventSource myNewFilterEvent = new EventSource();
    private EventSource myEditFilterEvent = new EventSource();
    private JList myMainFilterList;
    private JList myIncludedFilterList;
    private JList myExcludedFilterList;
    private JFileChooser myImportExportChooser = null;
    private List<ListDataListener> myIncludeExcludeListeners = new ArrayList<ListDataListener>();

    public BranchSearchFilterSelectionPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new WeightedSingleLineLayoutManager(new int[]{50, 0, 50}, WeightedSingleLineLayoutManager.Orientation.Horizontal, 10));
        this.myMainFilterList = this.createList("BranchSearchFilterSelectionPanel.JList.AllFilters");
        this.myIncludedFilterList = this.createList("BranchSearchFilterSelectionPanel.JList.IncludeFilters");
        this.myExcludedFilterList = this.createList("BranchSearchFilterSelectionPanel.JList.ExcludeFilters");
        this.myMainFilterList.addMouseListener(new MainFilterListHandler());
        this.updateMainFilterListToolTip();
        this.add(this.createListView(this.myMainFilterList, MAIN_FILTER_LIST_TITLE, this.createFilterToolbar()));
        this.add(this.createButtonPanel());
        this.add(this.createIncludeExcludeListPanel());
    }

    private JPanel createIncludeExcludeListPanel() {
        JPanel p = new JPanel(new GridLayout(2, 1, 0, 10));
        p.add(this.createListView(this.myIncludedFilterList, INCLUDE_FILTER_LIST_TITLE, null));
        p.add(this.createListView(this.myExcludedFilterList, EXCLUDE_FILTER_LIST_TITLE, null));
        return p;
    }

    private JPanel createButtonPanel() {
        ImageIcon selectIcon = RmaDefs.getImageIcon(SELECT_ICON);
        ImageIcon deselectIcon = RmaDefs.getImageIcon(DESELECT_ICON);
        JButton selectIncludeButton = this.mySelectIncludeEvent.createButton("", selectIcon);
        JButton deselectIncludeButton = this.myDeselectIncludeEvent.createButton("", deselectIcon);
        JButton selectExcludeButton = this.mySelectExcludeEvent.createButton("", selectIcon);
        JButton deselectExcludeButton = this.myDeselectExcludeEvent.createButton("", deselectIcon);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.createVerticalButtonPanel(selectIncludeButton, deselectIncludeButton), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.5, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.createVerticalButtonPanel(selectExcludeButton, deselectExcludeButton), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.5, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        selectIncludeButton.setName("BranchSearchFilterSelectionPanel.JButton.SelectIncludeFilter");
        deselectIncludeButton.setName("BranchSearchFilterSelectionPanel.JButton.DeselectIncludeFilter");
        selectExcludeButton.setName("BranchSearchFilterSelectionPanel.JButton.SelectExcludeFilter");
        deselectExcludeButton.setName("BranchSearchFilterSelectionPanel.JButton.DeselectExcludeFilter");
        return panel;
    }

    private JList createList(String name) {
        JList list = new JList();
        list.setSelectionMode(2);
        list.setName(name);
        return list;
    }

    private JComponent createFilterToolbar() {
        JPanel toolbar = new JPanel(new GridLayout(1, 5, 5, 0));
        toolbar.add(this.namedButton(this.myNewFilterEvent.createButton("", RmaDefs.getImageIcon(ADD_NEW_ICON), NEW_FILTER_TOOLTIP), "BranchSearchFilterSelectionPanel.JButton.AddFilter"));
        toolbar.add(this.namedButton(this.myEditFilterEvent.createButton("", RmaDefs.getImageIcon(EDIT_ICON), EDIT_FILTER_TOOLTIP), "BranchSearchFilterSelectionPanel.JButton.EditFilter"));
        toolbar.add(this.namedButton(this.myDeleteFiltersEvent.createButton("", RmaDefs.getImageIcon(DELETE_ICON), DELETE_FILTERS_TOOLTIP), "BranchSearchFilterSelectionPanel.JButton.DeleteFilter"));
        toolbar.add(this.namedButton(this.myImportFiltersEvent.createButton("", RmaDefs.getImageIcon(IMPORT_ICON), IMPORT_FILTERS_TOOLTIP), "BranchSearchFilterSelectionPanel.JButton.ImportFilters"));
        toolbar.add(this.namedButton(this.myExportFiltersEvent.createButton("", RmaDefs.getImageIcon(EXPORT_ICON), EXPORT_FILTERS_TOOLTIP), "BranchSearchFilterSelectionPanel.JButton.ExportFilters"));
        JPanel holder = new JPanel(new GridBagLayout());
        holder.add((Component)toolbar, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        return holder;
    }

    private JButton namedButton(JButton btn, String name) {
        btn.setName(name);
        return btn;
    }

    private JComponent createListView(JList list, String title, JComponent extra) {
        JPanel p = new JPanel(new GridBagLayout());
        Insets FIRST = new Insets(0, 0, 5, 0);
        Insets NOT_LAST = new Insets(0, 0, 10, 0);
        Insets LAST = new Insets(0, 0, 0, 0);
        p.add((Component)new JLabel(title), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, FIRST, 0, 0));
        p.add((Component)new JScrollPane(list, 20, 31), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, extra != null ? NOT_LAST : LAST, 0, 0));
        if (extra != null) {
            p.add((Component)extra, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 2, LAST, 0, 0));
        }
        return p;
    }

    private JComponent createVerticalButtonPanel(JComponent ... buttons) {
        JToolBar toolbar = new JToolBar(1);
        toolbar.setFloatable(false);
        toolbar.setOpaque(false);
        toolbar.setBorder(BorderFactory.createEmptyBorder());
        toolbar.setBorderPainted(false);
        for (JComponent c : buttons) {
            toolbar.add(c);
        }
        return toolbar;
    }

    @Override
    public Object[] getSelectedExcludeFilters() {
        return this.myExcludedFilterList.getSelectedValues();
    }

    @Override
    public Object[] getSelectedIncludeFilters() {
        return this.myIncludedFilterList.getSelectedValues();
    }

    @Override
    public Object[] getSelectedMainFilters() {
        return this.myMainFilterList.getSelectedValues();
    }

    @Override
    public EventSource deselectExcludeEvent() {
        return this.myDeselectExcludeEvent;
    }

    @Override
    public EventSource deselectIncludeEvent() {
        return this.myDeselectIncludeEvent;
    }

    @Override
    public EventSource selectExcludeEvent() {
        return this.mySelectExcludeEvent;
    }

    @Override
    public EventSource selectIncludeEvent() {
        return this.mySelectIncludeEvent;
    }

    @Override
    public EventSource exportFiltersEvent() {
        return this.myExportFiltersEvent;
    }

    @Override
    public EventSource importFiltersEvent() {
        return this.myImportFiltersEvent;
    }

    @Override
    public EventSource deleteFiltersEvent() {
        return this.myDeleteFiltersEvent;
    }

    @Override
    public File getExportFile() {
        String path;
        int dot;
        File f = this.getFileFromFileChooser("Export filters", true);
        if (f != null && !f.exists() && (dot = (path = f.getPath()).lastIndexOf(46)) < 0) {
            path = path + ".bsx";
            f = new File(path);
        }
        return f;
    }

    @Override
    public File getImportFile() {
        return this.getFileFromFileChooser("Import filters", false);
    }

    private File getFileFromFileChooser(String title, boolean isExport) {
        this.ensureFileChooserIsCreated();
        this.myImportExportChooser.setDialogTitle(title);
        int result = isExport ? this.myImportExportChooser.showSaveDialog(this) : this.myImportExportChooser.showOpenDialog(this);
        File file = result == 0 ? this.myImportExportChooser.getSelectedFile() : null;
        return file;
    }

    private void ensureFileChooserIsCreated() {
        if (this.myImportExportChooser == null) {
            this.myImportExportChooser = new JFileChooser();
            this.myImportExportChooser.addChoosableFileFilter(new FileFilterImpl(FILE_EXTENSION, "Branch Search Filter Files"));
            this.myImportExportChooser.setCurrentDirectory(new File(System.getProperty("user.home")));
            this.myImportExportChooser.setMultiSelectionEnabled(false);
        }
    }

    @Override
    public void setExcludeFilterModel(ListModel model) {
        this.myExcludedFilterList.setModel(model);
        model.addListDataListener(new SubListHandler(this.myExcludedFilterList));
    }

    @Override
    public void setIncludeFilterModel(ListModel model) {
        this.myIncludedFilterList.setModel(model);
        model.addListDataListener(new SubListHandler(this.myIncludedFilterList));
    }

    void addIncludeExcludeFilterModelListener(ListDataListener listener) {
        this.myIncludeExcludeListeners.add(listener);
    }

    private void updateMainFilterListToolTip() {
        ListModel model = this.myMainFilterList.getModel();
        if (model != null && model.getSize() > 0) {
            this.myMainFilterList.setToolTipText(MAIN_FILTER_LIST_TOOLTIP);
        } else {
            this.myMainFilterList.setToolTipText(MAIN_FILTER_EMPTY_LIST_TOOLTIP);
        }
    }

    @Override
    public void setMainFilterModel(ListModel model) {
        this.myMainFilterList.setModel(model);
        this.updateMainFilterListToolTip();
        model.addListDataListener(new MainFilterListHandler());
    }

    @Override
    public EventSource newFilterEvent() {
        return this.myNewFilterEvent;
    }

    @Override
    public EventSource startEditFilterEvent() {
        return this.myEditFilterEvent;
    }

    void setSelectedMainIndex(int index) {
        if (index < 0) {
            this.myMainFilterList.clearSelection();
        } else {
            this.myMainFilterList.setSelectedIndex(index);
        }
    }

    private class SubListHandler
    implements ListDataListener {
        private final int SAME_ADD_EVENT_THRESHOLD_MS = 5;
        private long myLastAddTime = -1L;
        private JList myList;

        SubListHandler(JList list) {
            this.myList = list;
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            for (int i = BranchSearchFilterSelectionPanel.this.myIncludeExcludeListeners.size() - 1; i >= 0; --i) {
                ((ListDataListener)BranchSearchFilterSelectionPanel.this.myIncludeExcludeListeners.get(i)).contentsChanged(e);
            }
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            for (int i = BranchSearchFilterSelectionPanel.this.myIncludeExcludeListeners.size() - 1; i >= 0; --i) {
                ((ListDataListener)BranchSearchFilterSelectionPanel.this.myIncludeExcludeListeners.get(i)).intervalAdded(e);
            }
            this.selectAddedEntries(e);
        }

        private void selectAddedEntries(ListDataEvent e) {
            long now = System.currentTimeMillis();
            if (this.myLastAddTime != -1L && now - this.myLastAddTime <= 5L) {
                this.myList.addSelectionInterval(e.getIndex0(), e.getIndex1());
            } else {
                this.myList.setSelectionInterval(e.getIndex0(), e.getIndex1());
            }
            this.myLastAddTime = now;
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            for (int i = BranchSearchFilterSelectionPanel.this.myIncludeExcludeListeners.size() - 1; i >= 0; --i) {
                ((ListDataListener)BranchSearchFilterSelectionPanel.this.myIncludeExcludeListeners.get(i)).intervalRemoved(e);
            }
        }
    }

    private class MainFilterListHandler
    extends MouseAdapter
    implements ListDataListener {
        private int myFirstClickIndex = -1;

        private MainFilterListHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e)) {
                switch (e.getClickCount()) {
                    case 1: {
                        this.myFirstClickIndex = this.getClickedItemIndex(e);
                        break;
                    }
                    case 2: {
                        int i2 = this.getClickedItemIndex(e);
                        if (this.myFirstClickIndex == i2 && i2 >= 0) {
                            BranchSearchFilterSelectionPanel.this.myEditFilterEvent.fire(BranchSearchFilterSelectionPanel.this.myMainFilterList);
                        }
                        this.myFirstClickIndex = -1;
                    }
                }
            }
        }

        private int getClickedItemIndex(MouseEvent e) {
            Rectangle rect;
            Point p = e.getPoint();
            int index = BranchSearchFilterSelectionPanel.this.myMainFilterList.locationToIndex(p);
            if (index >= 0 && !(rect = BranchSearchFilterSelectionPanel.this.myMainFilterList.getCellBounds(index, index)).contains(p)) {
                index = -1;
            }
            return index;
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            BranchSearchFilterSelectionPanel.this.setSelectedMainIndex(e.getIndex0());
            BranchSearchFilterSelectionPanel.this.updateMainFilterListToolTip();
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            BranchSearchFilterSelectionPanel.this.setSelectedMainIndex(e.getIndex0());
            BranchSearchFilterSelectionPanel.this.updateMainFilterListToolTip();
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            int index = e.getIndex0() - 1;
            if (index < 0 && BranchSearchFilterSelectionPanel.this.myMainFilterList.getModel().getSize() >= 0) {
                index = 0;
            }
            BranchSearchFilterSelectionPanel.this.setSelectedMainIndex(index);
            BranchSearchFilterSelectionPanel.this.updateMainFilterListToolTip();
        }
    }
}

