/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.search;

import com.ericsson.ere.gui.search.BranchSearchTableModel;
import com.ericsson.ere.selectiontree.search.Branch;
import com.ericsson.ere.selectiontree.search.BranchScoreComparator;
import com.ericsson.ere.selectiontree.search.BranchSearchUtil;
import com.ericsson.ere.util.ChainedComparator;
import ericsson.ere.interfaces.TariffStructureNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.table.AbstractTableModel;

public class BranchSearchTableModelImpl
extends AbstractTableModel
implements BranchSearchTableModel {
    public static final Object ELEMENT_CHILD_LEVEL = BranchSearchUtil.EXPANDED_CHILD_LEVEL;
    private static final boolean DEBUG = false;
    private List<Branch> myBranchData;
    private List<Branch> myVisibleData;
    private boolean myRootShownAsTopNode = true;
    private Set<Integer> myVisibleElementTypes;
    private Comparator<Branch> myCachedComparator = null;

    public BranchSearchTableModelImpl(List<Branch> branches) {
        this.myBranchData = new ArrayList<Branch>(branches);
        this.myVisibleData = this.populateVisibleBranches(branches);
        this.myVisibleElementTypes = BranchSearchTableModelImpl.createInitialElementTypeSet();
        ChainedComparator<Branch> comparator = ChainedComparator.chain(BranchScoreComparator.createDescending());
        this.sortBranches(comparator);
    }

    private static Set<Integer> createInitialElementTypeSet() {
        HashSet<Integer> set = new HashSet<Integer>();
        set.add(1);
        set.add(2);
        set.add(3);
        set.add(0);
        return set;
    }

    private List<Branch> populateVisibleBranches(List<Branch> branchList) {
        ArrayList<Branch> resultingView = new ArrayList<Branch>();
        for (Branch branch : branchList) {
            resultingView.add(new BranchView(branch, branch.getBranchElements()));
        }
        return resultingView;
    }

    @Override
    public int getColumnCount() {
        return this.myVisibleData.size();
    }

    @Override
    public int getRowCount() {
        return this.getNumberOfElementsInLongestBranch(this.myVisibleData);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Branch branch = this.myVisibleData.get(columnIndex);
        TariffStructureNode[] elements = branch.getBranchElements();
        Object dataToShow = elements.length > rowIndex ? (this.myRootShownAsTopNode ? elements[rowIndex] : elements[elements.length - rowIndex - 1]) : "";
        return dataToShow;
    }

    @Override
    public String getColumnName(int column) {
        return Integer.toString(column + 1);
    }

    @Override
    public void hideElementsOfType(int elementType) {
        assert (elementType == 2 || elementType == 1);
        if (this.myVisibleElementTypes.contains(elementType)) {
            this.myVisibleElementTypes.remove(elementType);
            this.updateVisibleData();
        }
    }

    @Override
    public void showElementsOfType(int elementType) {
        assert (elementType == 2 || elementType == 1);
        if (!this.myVisibleElementTypes.contains(elementType)) {
            this.myVisibleElementTypes.add(elementType);
            this.updateVisibleData();
        }
    }

    @Override
    public void reverseOrderOfElements(boolean rootFirst) {
        if (rootFirst != this.myRootShownAsTopNode) {
            this.myRootShownAsTopNode = rootFirst;
            this.fireTableDataChanged();
        }
    }

    private void updateVisibleData() {
        this.myVisibleData.clear();
        for (Branch b : this.myBranchData) {
            ArrayList<TariffStructureNode> tempList = new ArrayList<TariffStructureNode>();
            TariffStructureNode[] elements = b.getBranchElements();
            for (int i = 0; i < elements.length; ++i) {
                if (!this.myVisibleElementTypes.contains(elements[i].getNodeType())) continue;
                tempList.add(elements[i]);
            }
            BranchView v = new BranchView(b, tempList.toArray(new TariffStructureNode[tempList.size()]));
            this.myVisibleData.add(v);
        }
        if (this.myCachedComparator != null) {
            this.sortBranches(this.myCachedComparator);
        }
        this.fireTableDataChanged();
    }

    private int getNumberOfElementsInLongestBranch(List<Branch> branches) {
        if (branches.size() == 0) {
            return 0;
        }
        int max = branches.get(0).getBranchElements().length;
        for (int i = 1; i < branches.size(); ++i) {
            max = Math.max(max, branches.get(i).getBranchElements().length);
        }
        return max;
    }

    @Override
    public void sortBranches(Comparator<Branch> comparator) {
        this.myCachedComparator = comparator;
        Collections.sort(this.myVisibleData, comparator);
        this.fireTableStructureChanged();
    }

    @Override
    public List<Branch> getBranchData() {
        return Collections.unmodifiableList(this.myBranchData);
    }

    private static class BranchView
    extends Branch {
        private TariffStructureNode[] myBranchElements;

        public BranchView(Branch b, TariffStructureNode[] elements) {
            super(b.getPath());
            this.myBranchElements = BranchSearchUtil.expandCompoundElements(elements);
            this.transferScoreFrom(b);
        }

        private void transferScoreFrom(Branch b) {
            if (b.hasScore()) {
                this.setScore(b.getScore());
            }
        }

        @Override
        public TariffStructureNode[] getBranchElements() {
            return this.myBranchElements;
        }
    }
}

