/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.search.presenter;

import com.ericsson.ere.gui.search.BranchSearchTableModel;
import com.ericsson.ere.gui.search.view.BranchSearchResultView;
import com.ericsson.ere.selectiontree.search.Branch;
import com.ericsson.ere.selectiontree.search.BranchLengthComparator;
import com.ericsson.ere.selectiontree.search.BranchLocationComparator;
import com.ericsson.ere.selectiontree.search.BranchScoreComparator;
import com.ericsson.ere.selectiontree.search.BranchSearchGUIUtil;
import com.ericsson.ere.selectiontree.search.SettingsBasedBranchComparator;
import com.ericsson.ere.util.ChainedComparator;
import com.ericsson.ere.util.Predicate;
import ericsson.ere.interfaces.TariffStructureNode;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;

public class BranchSearchResultPresenter {
    private BranchSearchTableModel myModel;
    private BranchSearchResultView myView;
    private TreeModel myTreeModelToSupervise;
    private Map<Integer, Map<String, Set<String>>> myParametersMap;

    public BranchSearchResultPresenter(BranchSearchResultView view, BranchSearchTableModel model, TreeModel treeModelToSupervise) {
        this.myView = view;
        this.myModel = model;
        this.myView.setBranchViewModel(model);
        this.myTreeModelToSupervise = treeModelToSupervise;
        this.subscribeToViewEvents();
    }

    private void subscribeToViewEvents() {
        this.myView.toggleConditionsEvent().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BranchSearchResultPresenter.this.toggleConditions(BranchSearchResultPresenter.this.myView.shouldShowConditions());
            }
        });
        this.myView.toggleNodesEvent().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BranchSearchResultPresenter.this.toggleNodes(BranchSearchResultPresenter.this.myView.shouldShowNodes());
            }
        });
        this.myView.toggleVerticalOrderEvent().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BranchSearchResultPresenter.this.toggleReverseModeAction(BranchSearchResultPresenter.this.myView.shouldShowRootOnTop());
            }
        });
        this.myView.sortEvent().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BranchSearchResultPresenter.this.sortBranchesAction();
            }
        });
        this.myTreeModelToSupervise.addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                BranchSearchResultPresenter.this.setTreeChangedInfo();
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
                BranchSearchResultPresenter.this.setTreeChangedInfo();
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
                BranchSearchResultPresenter.this.setTreeChangedInfo();
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                BranchSearchResultPresenter.this.setTreeChangedInfo();
            }
        });
    }

    public static Collection<Comparator<Branch>> createDefaultComparators() {
        ArrayList<Comparator<Branch>> list = new ArrayList<Comparator<Branch>>();
        list.add(BranchScoreComparator.createDescending());
        list.add(new BranchLocationComparator());
        list.add(BranchLengthComparator.constructLongestFirstComparator());
        list.add(BranchLengthComparator.constructShortestFirstComparator());
        list.add(BranchSearchResultPresenter.createDummySettingsBasedComparator());
        return list;
    }

    private static Comparator<Branch> createDummySettingsBasedComparator() {
        Predicate<TariffStructureNode> matcher = new Predicate<TariffStructureNode>(){

            @Override
            public boolean test(TariffStructureNode element) {
                return true;
            }
        };
        return new SettingsBasedBranchComparator(matcher, "");
    }

    void toggleReverseModeAction(boolean rootAsTopNode) {
        this.myModel.reverseOrderOfElements(rootAsTopNode);
    }

    void toggleConditions(boolean showConditions) {
        this.toggleElements(showConditions, 2);
    }

    void toggleNodes(boolean showNodes) {
        this.toggleElements(showNodes, 1);
    }

    private void toggleElements(boolean show, int type) {
        if (show) {
            this.myModel.showElementsOfType(type);
        } else {
            this.myModel.hideElementsOfType(type);
        }
    }

    void sortBranchesAction() {
        if (this.myModel.getRowCount() == 0) {
            return;
        }
        Map<Integer, Map<String, Set<String>>> parametersMap = this.findParametersForElementTypes();
        this.myView.setSettingsBasedSortParameters(parametersMap);
        Comparator<Branch>[] comparators = this.myView.getSelectedComparators();
        ChainedComparator<Branch> comp = ChainedComparator.chain(comparators);
        StringBuilder b = new StringBuilder("Table sorted based on ");
        for (int i = 0; i < comparators.length; ++i) {
            if (i > 0) {
                b.append(" and ");
            }
            b.append("'").append(comparators[i]).append("'");
        }
        this.myView.setSortingInformation(b.toString());
        this.myModel.sortBranches(comp);
    }

    private Map<Integer, Map<String, Set<String>>> findParametersForElementTypes() {
        if (this.myParametersMap == null) {
            try {
                this.myParametersMap = BranchSearchGUIUtil.getElementParameterData(this.myModel.getBranchData());
            }
            catch (Exception ex) {
                this.myParametersMap = Collections.emptyMap();
            }
        }
        return this.myParametersMap;
    }

    void setTreeChangedInfo() {
        this.myView.showInformation("The selection tree has changed. Refresh the search to reflect the new changes.");
    }

    public static enum SortingPriority {
        FIRST,
        SECOND,
        THIRD;


        public String toString() {
            return this.name().toLowerCase();
        }

        public static SortingPriority fromIndex(int index) {
            SortingPriority[] values = SortingPriority.values();
            return values[index];
        }
    }
}

