/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.simulator;

import com.ericsson.ere.dataset.DataSetArrayHelper;
import com.ericsson.ere.dataset.DefaultDataDescriber;
import com.ericsson.ere.datatype.ValueResolver;
import ericsson.ere.defs.ClassRepository;
import ericsson.vareditor.variable.ArrayModel;
import ericsson.vareditor.variable.array.ObjectArrayDescription;
import ericsson.vareditor.variable.array.ObjectArrayModel;
import ericsson.vareditor.variable.array.ObjectMapModel;
import java.util.Map;

public class SimulationDataDescriber
extends DefaultDataDescriber {
    public SimulationDataDescriber() {
    }

    public SimulationDataDescriber(ClassRepository repository) {
        super(repository);
    }

    @Override
    protected boolean includeArrayIndices() {
        return false;
    }

    @Override
    protected String describeObject(Object object, DataSetArrayHelper.ObjectConverter<String> keyConverter, DataSetArrayHelper.ObjectConverter<String> valueConverter, boolean treatMapAsArray) {
        String s = object instanceof ArrayModel ? this.describeArrayModel((ArrayModel)object, keyConverter, valueConverter) : (object instanceof ObjectArrayModel ? this.describeObjectArrayModel((ObjectArrayModel)object, treatMapAsArray) : super.describeObject(object, keyConverter, valueConverter, treatMapAsArray));
        return s;
    }

    private String describeArrayModel(ArrayModel model, DataSetArrayHelper.ObjectConverter<String> keyConverter, DataSetArrayHelper.ObjectConverter<String> valueConverter) {
        String s;
        short dimensions = model.getNumberOfDimensions();
        if (model.possibleToConvertToOneDimensionalArray()) {
            s = this.describeObject(model.toOneDimensionalArray(), valueConverter, true);
        } else if (dimensions == 2) {
            Map<Object, Object> map = model.toMap();
            s = DataSetArrayHelper.convertMapToString(map, keyConverter, valueConverter, false);
        } else {
            throw new AssertionError((Object)("Cannot handle " + dimensions + " dimensions in an ArrayModel."));
        }
        return s;
    }

    private String describeObjectArrayModel(ObjectArrayModel model, boolean treatMapAsArray) {
        boolean isMap = model instanceof ObjectMapModel;
        StringBuilder b = new StringBuilder(isMap ? "{" : "[");
        int rc = model.getRowCount();
        ObjectArrayDescription dataDescription = model.getDataDescription();
        for (int i = 0; i < rc; ++i) {
            if (i > 0) {
                b.append(", ");
            }
            b.append("(");
            Object[] values = model.getValueArray(i);
            for (int j = 0; j < values.length; ++j) {
                if (j > 0) {
                    b.append(", ");
                }
                ValueResolver resolver = dataDescription.getValueResolver(j);
                ValueResolverBasedObjectConverter converter = new ValueResolverBasedObjectConverter(resolver);
                String valueDesc = super.describeObject(values[j], converter, treatMapAsArray);
                b.append(valueDesc);
            }
            b.append(")");
        }
        b.append(isMap ? "}" : "]");
        return b.toString();
    }

    private static class ValueResolverBasedObjectConverter
    implements DataSetArrayHelper.ObjectConverter<String> {
        private ValueResolver myResolver;

        ValueResolverBasedObjectConverter(ValueResolver resolver) {
            this.myResolver = resolver;
        }

        @Override
        public String convert(Object value) {
            return this.myResolver.makeDisplayString(value);
        }
    }
}

