/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.simulator;

import com.ericsson.ere.gui.simulator.SimulationDataTableModel;
import java.util.EventObject;

public class SimulationExecutionEvent
extends EventObject {
    protected SimulationExecutionEvent(Object source) {
        super(source);
    }

    public static class SimulationFailedEvent
    extends SimulationExecutionEvent {
        private Throwable myError;

        public SimulationFailedEvent(Object source, Throwable t) {
            super(source);
            this.myError = t;
        }

        public Throwable getError() {
            return this.myError;
        }
    }

    public static class SimulationFinishedEvent
    extends SimulationExecutionEvent {
        private SimulationDataTableModel.SimulationStatus[] myStatuses;

        public SimulationFinishedEvent(Object source, SimulationDataTableModel.SimulationStatus[] statuses) {
            super(source);
            this.myStatuses = statuses;
        }

        public int getCaseCount() {
            return this.myStatuses.length;
        }

        public boolean didCaseExecuteSuccessfully(int i) {
            SimulationDataTableModel.SimulationStatus ss = this.myStatuses[i];
            return ss != SimulationDataTableModel.SimulationStatus.STATUS_FAILED && ss != SimulationDataTableModel.SimulationStatus.STATUS_ERRONEOUS;
        }
    }

    public static class SimulationStartingEvent
    extends SimulationExecutionEvent {
        private boolean myCanceled;
        private int myCaseCount;

        public SimulationStartingEvent(Object source, int caseCount) {
            super(source);
            this.myCaseCount = caseCount;
        }

        public void cancel() {
            this.myCanceled = true;
        }

        public boolean isCanceled() {
            return this.myCanceled;
        }

        public int getCaseCount() {
            return this.myCaseCount;
        }
    }
}

