/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.simulator;

import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.DataSetValueNotFoundException;
import com.ericsson.ere.dataset.jump.JumperSupport;
import com.ericsson.ere.executor.DefaultTreeExecutor;
import com.ericsson.ere.executor.TreeExecutor;
import com.ericsson.ere.executor.TreeExecutorHelper;
import com.ericsson.ere.functioncontrol.FunctionContext;
import com.ericsson.ere.functioncontrol.FunctionController;
import com.ericsson.ere.functioncontrol.FunctionManager;
import com.ericsson.ere.functioncontrol.FunctionManagerImpl;
import com.ericsson.ere.functioncontrol.FunctionState;
import com.ericsson.ere.functioncontrol.FunctionToken;
import com.ericsson.ere.gui.simulator.AbstractGroupedSimulationDataPanel;
import com.ericsson.ere.gui.simulator.SimulationCaseSelectedFields;
import com.ericsson.ere.gui.simulator.SimulationDataPanel;
import com.ericsson.ere.gui.simulator.SimulationDataPanelChangeListener;
import com.ericsson.ere.gui.simulator.SimulationDataTable;
import com.ericsson.ere.gui.simulator.SimulationDataTableModel;
import com.ericsson.ere.gui.simulator.SimulationErrorException;
import com.ericsson.ere.gui.simulator.SimulationExecutionEvent;
import com.ericsson.ere.gui.simulator.SimulationExecutionListener;
import com.ericsson.ere.gui.simulator.SimulationFactory;
import com.ericsson.ere.gui.simulator.SimulationField;
import com.ericsson.ere.gui.simulator.SimulatorPanel;
import com.ericsson.ere.gui.simulator.SimulatorTreeOwner;
import com.ericsson.ere.gui.simulator.input.FileSimulationSource;
import com.ericsson.ere.gui.simulator.input.SimulationDataSource;
import com.ericsson.ere.gui.simulator.input.db.DatabaseSimulationSource;
import com.ericsson.ere.gui.simulator.search.SQLSimulationTool;
import com.ericsson.ere.gui.simulator.tree.ExecutorBasedTraceTreeNode;
import com.ericsson.ere.gui.simulator.tree.TraceNodeInterfaceBasedTraceTreeNode;
import com.ericsson.ere.gui.simulator.tree.TraceTreeGUI;
import com.ericsson.ere.gui.simulator.tree.TraceTreeNode;
import com.ericsson.ere.gui.util.ExceptionUtil;
import com.ericsson.ere.proxy.RatingPeriodProxy;
import com.ericsson.ere.selectiontree.NoModifierFoundException;
import com.ericsson.ere.selectiontree.interfaces.TariffStructure;
import com.ericsson.ere.simulation.TreeDefinedFieldValidator;
import com.ericsson.ere.swing.EDT;
import com.ericsson.ere.trace.GuiTraceTreeExecutor;
import com.ericsson.ere.trace.TraceNodeTariffStructure;
import ericsson.ere.datatype.Time;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.ratingrules.RatingRuleFrameJumper;
import ericsson.ere.gui.util.DialogFactory;
import ericsson.ere.gui.util.ProgressDialog;
import ericsson.ere.gui.util.RmaAction;
import ericsson.ere.interfaces.AbstractDAGNode;
import ericsson.ere.management.ContextAwareServiceContainer;
import ericsson.ere.management.DateUtil;
import ericsson.vareditor.variable.GroupedArrayVariable;
import ericsson.vareditor.variable.Variable;
import ericsson.vareditor.variable.treedefinedfields.TreeDefinedFieldPanelSupport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.Callable;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;

public class SimulationSet
implements ChangeListener,
SimulationDataPanelChangeListener,
ListSelectionListener,
FunctionController {
    private SimulationDataTable mySimulationTable;
    private SimulationDataTableModel mySimulationTableModel;
    private String myName;
    private List<ChangeListener> myNameChangeListeners = new ArrayList<ChangeListener>();
    private List<SimulationExecutionListener> mySimulationExecutionListeners = new ArrayList<SimulationExecutionListener>();
    private SimulatorPanel mySimulatorPanel;
    private ContextAwareServiceContainer myServiceContainer;
    private SimulatorTreeOwner myTreeOwner;
    private TraceTreeGUI myTraceTreeGUI;
    private JTextArea myTraceDestination;
    private RmaAction myAddNewCallCaseAction;
    private RmaAction myCloneCallCaseAction;
    private RmaAction myDeleteCallCaseAction;
    private RmaAction myExecuteCallCasesAction;
    private RmaAction mySwitchFailedFilterAction;
    private RmaAction mySwitchViewAction;
    private RmaAction myCreateSetAction;
    private RmaAction myCloseSetAction;
    private RmaAction mySwitchSourceAction;
    private RmaAction myChooseColumnsAction;
    private RmaAction mySearchCallCasesAction;
    private JPopupMenu mySimulationSetPopupMenu;
    private SimulationDataSource myDataSource;
    private JToolBar mySimulationSetToolbar = new JToolBar();
    private JToolBar myCallCaseToolBar = new JToolBar();
    private JToolBar myMainToolBar = new JToolBar();
    private boolean isShowingAllCases = true;
    private boolean isDataValid = true;

    public SimulationSet(String name, SimulatorPanel simulatorPanel, boolean createInitialPanel) {
        this.mySimulatorPanel = simulatorPanel;
        SimulationFactory factory = simulatorPanel.getSimulationFactory();
        this.myServiceContainer = simulatorPanel.getServiceAndContext();
        this.myTreeOwner = simulatorPanel.getTreeOwner();
        this.myTraceTreeGUI = simulatorPanel.getTraceTreeGUI();
        this.myTraceDestination = simulatorPanel.getTraceDestination();
        this.addNameChangeListener(simulatorPanel);
        this.myName = name;
        this.mySimulatorPanel = simulatorPanel;
        this.mySimulationTableModel = new SimulationDataTableModel(factory, this.myServiceContainer, this);
        if (createInitialPanel) {
            this.mySimulationTableModel.createNewSimulationDataPanel();
        }
        this.mySimulationTable = new SimulationDataTable(this.mySimulationTableModel);
        this.myDataSource = new FileSimulationSource(this.mySimulatorPanel, this);
        this.mySimulationTable.getSelectionModel().addListSelectionListener(this);
        this.mySimulationTable.getSelectionModel().addListSelectionListener(this.mySimulatorPanel);
        this.mySimulationTable.addMouseListener(new PopupAdapter());
        this.mySimulationTable.setName("SimulationSet.JTable.SimulationDataTable");
        this.initMenuAndToolbar();
    }

    public void setModel(SimulationDataTableModel model) {
        this.mySimulationTableModel = model;
        this.mySimulationTable.setModel(model);
    }

    public int[] convertSortedRows(int[] rows) {
        if (this.mySimulationTable.getRowCount() > 0) {
            for (int i = 0; i < rows.length; ++i) {
                int tableRow = rows[i];
                if (tableRow == -1) continue;
                rows[i] = this.mySimulationTable.convertRowIndexToModel(tableRow);
            }
        }
        return rows;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        try {
            int[] rows = this.mySimulationTable.getSelectedRows();
            rows = this.convertSortedRows(rows);
            if (e.getSource() instanceof Variable) {
                Variable var = (Variable)e.getSource();
                this.mySimulationTableModel.updateFieldSelection(rows, var.getLabel(), var.isSelected());
            } else if (e.getSource() instanceof SimulationField) {
                SimulationField field = (SimulationField)e.getSource();
                this.mySimulationTableModel.updateFieldSelection(rows, field.getName(), field.getSelected());
            }
        }
        catch (IndexOutOfBoundsException exc) {
            this.mySimulatorPanel.updateSimulationSets(true);
        }
    }

    @Override
    public void simulationDataPanelChanged(SimulationDataPanel panel, String fieldName, Object value) {
        boolean allCasesValid = true;
        try {
            if (this.mySimulationTable != null) {
                if (value != null) {
                    int[] rows = this.mySimulationTable.getSelectedRows();
                    rows = this.convertSortedRows(rows);
                    this.mySimulationTableModel.update(rows, fieldName, value);
                }
                for (int i = 0; i < this.mySimulationTable.getRowCount(); ++i) {
                    boolean valid = this.mySimulationTableModel.getSimulationDataPanel(i).isSimulationDataValid();
                    this.mySimulationTableModel.setDataValidity(i, valid);
                    this.mySimulationTable.repaint();
                    if (valid) continue;
                    allCasesValid = false;
                }
                this.mySimulatorPanel.stateChanged(new ChangeEvent(this));
                this.isDataValid = allCasesValid;
            }
        }
        catch (Exception x) {
            ExceptionUtil.handleException(x, "simulation", 1, "RMA failed to update the simulation field '" + fieldName + "' (value: " + value + ")", true);
        }
    }

    boolean isSetDataValid() {
        for (int i = 0; i < this.mySimulationTableModel.getDataModelSize(); ++i) {
            this.isDataValid = this.mySimulationTableModel.getSimulationDataPanel(i).isSimulationDataValid();
            if (!this.isDataValid) break;
        }
        return this.isDataValid;
    }

    public boolean canSave() {
        if (!this.isSetDataValid()) {
            DialogFactory.getErrorDialog("Invalid data...", "The simulation set contains invalid data. Please correct the errors and try again.");
            return false;
        }
        return true;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.mySimulationTable.getSelectedRowCount() == 0) {
            this.myCloneCallCaseAction.setEnabled(false);
            this.myDeleteCallCaseAction.setEnabled(false);
            this.myExecuteCallCasesAction.setEnabled(false);
        } else {
            this.myCloneCallCaseAction.setEnabled(true);
            this.myDeleteCallCaseAction.setEnabled(true);
            this.myExecuteCallCasesAction.setEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JPanel loadSelectedSimulationCase() {
        JPanel casePanel = null;
        try {
            if (this.mySimulationTable.getSelectedRowCount() == 1) {
                int row = this.mySimulationTable.getSelectedRow();
                row = this.mySimulationTable.convertRowIndexToModel(row);
                SimulationDataPanel panel = this.mySimulationTableModel.getSimulationDataPanel(row);
                casePanel = panel;
            } else if (this.mySimulationTable.getSelectedRowCount() > 1) {
                casePanel = new JPanel(new GridBagLayout());
                JLabel multiEditLabel = new JLabel("<html>You have selected more than one simulation case.<p>Note that any change you make will affect all selected cases.</html>");
                SimulationDataPanel multiEditDataPanel = this.mySimulationTableModel.getMultiSimulationDataPanel();
                casePanel.add((Component)multiEditLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
                casePanel.add((Component)multiEditDataPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            } else {
                JPanel emptyPanel = new JPanel(new BorderLayout());
                final JLabel infoLabel = new JLabel("Click to create a new case");
                infoLabel.setName("RatingRuleFrame.Simulation.JLabel.CreateNewCallCase");
                infoLabel.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseEntered(MouseEvent e) {
                        infoLabel.setText("<html><u>" + infoLabel.getText() + "</u></html>");
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                        String text = infoLabel.getText().replace("<html><u>", "");
                        text = text.replace("</u></html>", "");
                        infoLabel.setText(text);
                    }

                    @Override
                    public void mousePressed(MouseEvent e) {
                        SimulationSet.this.addNewCallCaseAction(null);
                    }
                });
                infoLabel.setHorizontalAlignment(0);
                emptyPanel.add((Component)infoLabel, "Center");
                casePanel = emptyPanel;
            }
        }
        finally {
            this.mySimulatorPanel.setCursor(new Cursor(0));
        }
        return casePanel;
    }

    void initMenuAndToolbar() {
        Action toggleDebugModeAction = this.mySimulatorPanel.getToggleDebugModeAction();
        this.myAddNewCallCaseAction = new RmaAction(this, "addNewCallCaseAction", "Add", "call_case_add24.png", "call_case_add16.png", "Adds a new case to the current set.", KeyStroke.getKeyStroke(78, 2));
        this.myCloneCallCaseAction = new RmaAction(this, "cloneCallCasesAction", "Clone", "call_case_clone24.png", "call_case_clone16.png", "Clones the selected cases and adds them to the current set.", KeyStroke.getKeyStroke(67, 3));
        this.myDeleteCallCaseAction = new RmaAction(this, "deleteCallCasesAction", "Delete", "call_case_delete24.png", "call_case_delete16.png", "Deletes the selected case from the set.", KeyStroke.getKeyStroke(127, 0));
        this.myExecuteCallCasesAction = new RmaAction(this, "executeCallCasesAction", "Execute", "call_case_run24.png", "call_case_run16.png", "Executes the selected cases.", KeyStroke.getKeyStroke(10, 2));
        this.mySwitchViewAction = new RmaAction(this.mySimulatorPanel, "switchViewAction", "Switch Simulator View", "table_view24.png", "table_view16.png", "Switches between showing a split and maximized simulator view.", KeyStroke.getKeyStroke(86, 8));
        this.myCreateSetAction = new RmaAction(this.mySimulatorPanel, "createSetAction", "Add Set...", "index_add24.png", "index_add16.png", "Creates a new simulation set.", KeyStroke.getKeyStroke(78, 3));
        this.myCloseSetAction = new RmaAction(this.mySimulatorPanel, "closeSetAction", "Close Set", "index_close24.png", "index_close16.png", "Closes the selected simulation set.", KeyStroke.getKeyStroke(81, 8));
        this.mySwitchSourceAction = new RmaAction(this, "switchDataSourceAction", "Switch Data Source", "cabinet24.png", "cabinet16.png", "Switches simulation data source between file and database.", KeyStroke.getKeyStroke(68, 8));
        this.myChooseColumnsAction = new RmaAction(this.mySimulationTable, "openSimulationColumnDialog", "Show/Hide table columns...", "column_preferences16.png", "column_preferences16.png", "Shows/Hides columns in the simulation table.", null);
        this.mySearchCallCasesAction = new RmaAction(this, "searchToolAction", "Search Tool...", "call_case_search24.png", "call_case_search16.png", "Opens the Simulation Search Tool.", KeyStroke.getKeyStroke(70, 2));
        this.mySwitchFailedFilterAction = new RmaAction(this, "switchFailedFilter", "Show all/failed", "call_case_warning24.png", "call_case_warning16.png", "Switches between showing all cases in the set and only showing the failed ones.", KeyStroke.getKeyStroke(70, 10));
        this.mySwitchFailedFilterAction.putValue("SwingSelectedKey", Boolean.FALSE);
        ActionMap am = this.mySimulationTable.getActionMap();
        am.put("myAddNewCallCaseAction", this.myAddNewCallCaseAction);
        am.put("myCloneCallCaseAction", this.myCloneCallCaseAction);
        am.put("myDeleteCallCaseAction", this.myDeleteCallCaseAction);
        am.put("myExecuteCallCasesAction", this.myExecuteCallCasesAction);
        am.put("mySwitchViewAction", this.mySwitchViewAction);
        am.put("myCreateSetAction", this.myCreateSetAction);
        am.put("myCloseSetAction", this.myCloseSetAction);
        am.put("mySwitchSourceAction", this.mySwitchSourceAction);
        am.put("myChooseColumnsAction", this.myChooseColumnsAction);
        am.put("mySwitchFailedFilterAction", this.mySwitchFailedFilterAction);
        am.put("mySearchCallCasesAction", this.mySearchCallCasesAction);
        InputMap im = this.mySimulationTable.getInputMap(2);
        im.put((KeyStroke)this.myAddNewCallCaseAction.getValue("AcceleratorKey"), "myAddNewCallCaseAction");
        im.put((KeyStroke)this.myCloneCallCaseAction.getValue("AcceleratorKey"), "myCloneCallCaseAction");
        im.put((KeyStroke)this.myDeleteCallCaseAction.getValue("AcceleratorKey"), "myDeleteCallCaseAction");
        im.put((KeyStroke)this.myExecuteCallCasesAction.getValue("AcceleratorKey"), "myExecuteCallCasesAction");
        im.put((KeyStroke)this.mySwitchViewAction.getValue("AcceleratorKey"), "mySwitchViewAction");
        im.put((KeyStroke)this.myCreateSetAction.getValue("AcceleratorKey"), "myCreateSetAction");
        im.put((KeyStroke)this.myCloseSetAction.getValue("AcceleratorKey"), "myCloseSetAction");
        im.put((KeyStroke)this.mySwitchSourceAction.getValue("AcceleratorKey"), "mySwitchSourceAction");
        im.put((KeyStroke)this.myChooseColumnsAction.getValue("AcceleratorKey"), "myChooseColumnsAction");
        im.put((KeyStroke)this.mySwitchFailedFilterAction.getValue("AcceleratorKey"), "mySwitchFailedFilterAction");
        im.put((KeyStroke)this.mySearchCallCasesAction.getValue("AcceleratorKey"), "mySearchCallCasesAction");
        List<Action> sourceActions = this.myDataSource.getActions();
        for (Action action : sourceActions) {
            am.put(action.getValue("Name"), action);
            im.put((KeyStroke)action.getValue("AcceleratorKey"), (String)action.getValue("Name"));
        }
        if (this.mySimulationTable.getSelectedRowCount() == 0) {
            this.myCloneCallCaseAction.setEnabled(false);
            this.myDeleteCallCaseAction.setEnabled(false);
            this.myExecuteCallCasesAction.setEnabled(false);
        }
        this.myCallCaseToolBar.removeAll();
        this.mySimulationSetToolbar.removeAll();
        this.myMainToolBar.removeAll();
        this.mySimulationSetToolbar.setName("SimulationSet.JToolbar.SimulationSetToolbar");
        this.myCallCaseToolBar.add(this.myAddNewCallCaseAction).setName("SimulationSet.JButton.AddCallCaseButton");
        this.myCallCaseToolBar.add(this.myCloneCallCaseAction).setName("SimulationSet.JButton.CloneCallCaseButton");
        this.myCallCaseToolBar.add(this.myDeleteCallCaseAction).setName("SimulationSet.JButton.DeleteCallCaseButton");
        this.myCallCaseToolBar.addSeparator();
        this.myCallCaseToolBar.add(this.myExecuteCallCasesAction).setName("SimulationSet.JButton.ExecuteCallCaseButton");
        this.myCallCaseToolBar.add(this.createActionToggleButton(this.mySwitchFailedFilterAction));
        this.myCallCaseToolBar.addSeparator();
        this.mySimulationSetToolbar.add(this.mySwitchViewAction);
        if (toggleDebugModeAction != null) {
            this.mySimulationSetToolbar.add(this.createActionToggleButton(toggleDebugModeAction));
        }
        this.mySimulationSetToolbar.addSeparator();
        this.mySimulationSetToolbar.add(this.mySwitchSourceAction);
        this.mySimulationSetToolbar.addSeparator();
        this.mySimulationSetToolbar.add(this.myCreateSetAction).setName("SimulationSet.JButton.CreateSimulationSetButton");
        this.mySimulationSetToolbar.add(this.myCloseSetAction).setName("SimulationSet.JButton.CloseSimulationSetButton");
        this.myMainToolBar.add(this.mySwitchViewAction);
        if (toggleDebugModeAction != null) {
            this.myMainToolBar.add(this.createActionToggleButton(toggleDebugModeAction));
        }
        this.myMainToolBar.addSeparator();
        this.myMainToolBar.add(this.myAddNewCallCaseAction).setName("SimulationSet.JButton.AddCallCaseButton");
        this.myMainToolBar.add(this.myCloneCallCaseAction).setName("SimulationSet.JButton.CloneCallCaseButton");
        this.myMainToolBar.add(this.myDeleteCallCaseAction).setName("SimulationSet.JButton.DeleteCallCaseButton");
        this.myMainToolBar.add(this.myExecuteCallCasesAction).setName("SimulationSet.JButton.ExecuteCallCaseButton");
        this.myMainToolBar.add(this.createActionToggleButton(this.mySwitchFailedFilterAction));
        this.myMainToolBar.addSeparator();
        this.myMainToolBar.add(this.mySwitchSourceAction);
        this.myMainToolBar.addSeparator();
        this.myMainToolBar.add(this.myCreateSetAction);
        this.myMainToolBar.add(this.myCloseSetAction);
        this.myCallCaseToolBar.setMinimumSize(new Dimension(0, 0));
        this.mySimulationSetToolbar.setMinimumSize(new Dimension(0, 0));
        for (Action action : sourceActions) {
            JButton btn1 = this.mySimulationSetToolbar.add(action);
            JButton btn2 = this.myMainToolBar.add(action);
            Object name = action.getValue("Name");
            if (name == null) continue;
            String strName = this.convertActionNameToComponentNamePart(name);
            btn1.setName("SimulationSetTB.JButton." + strName);
            btn2.setName("SimulationSetMain.JButton." + strName);
        }
        this.myCallCaseToolBar.validate();
        this.mySimulationSetToolbar.validate();
        this.myMainToolBar.validate();
        this.myCallCaseToolBar.repaint();
        this.mySimulationSetToolbar.repaint();
        this.myMainToolBar.repaint();
        this.myCallCaseToolBar.setOrientation(0);
        this.mySimulationSetToolbar.setOrientation(0);
        this.myMainToolBar.setOrientation(1);
        this.myCallCaseToolBar.setFloatable(false);
        this.mySimulationSetToolbar.setFloatable(false);
        this.myMainToolBar.setFloatable(false);
    }

    private String convertActionNameToComponentNamePart(Object name) {
        String strName = String.valueOf(name);
        String[] parts = strName.replace("...", "").split("\\s+");
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < parts.length; ++i) {
            b.append(parts[i].substring(0, 1).toUpperCase());
            b.append(parts[i].substring(1));
        }
        return b.toString();
    }

    private JPopupMenu createPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        menu.add(this.mySwitchViewAction);
        menu.addSeparator();
        menu.add(this.myAddNewCallCaseAction);
        menu.add(this.myCloneCallCaseAction);
        menu.add(this.myDeleteCallCaseAction);
        menu.add(this.myExecuteCallCasesAction);
        menu.add(new JCheckBoxMenuItem(this.mySwitchFailedFilterAction));
        menu.addSeparator();
        menu.add(this.mySwitchSourceAction);
        menu.addSeparator();
        menu.add(this.myCreateSetAction);
        menu.add(this.myCloseSetAction);
        menu.addSeparator();
        menu.add(this.myChooseColumnsAction);
        for (Action action : this.myDataSource.getActions()) {
            menu.add(action);
        }
        return menu;
    }

    public JToolBar[] getToolBars(SimulatorPanel.SimulationView view) {
        JToolBar[] toolbars = null;
        toolbars = view == SimulatorPanel.SimulationView.VIEW_SPLIT ? new JToolBar[]{this.myCallCaseToolBar, this.mySimulationSetToolbar} : new JToolBar[]{this.myMainToolBar};
        return toolbars;
    }

    public void cloneCallCasesAction(ActionEvent e) {
        try {
            this.mySimulatorPanel.setCursor(new Cursor(3));
            int[] rows = this.mySimulationTable.getSelectedRows();
            rows = this.convertSortedRows(rows);
            this.mySimulatorPanel.updateSimulationSets(true);
            this.mySimulationTableModel.cloneSimulationCase(rows);
            this.mySimulationTable.getSelectionModel().setSelectionInterval(this.mySimulationTable.getRowCount() - rows.length, this.mySimulationTable.getRowCount() - 1);
        }
        catch (Exception x) {
            DialogFactory.getErrorDialog("Error creating simulator data", "Could not create simulator data for " + this.myServiceContainer.getService().getId() + " due to :\n" + x.getMessage());
        }
        finally {
            this.mySimulatorPanel.setCursor(new Cursor(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeWithSimulationSet(SimulationSet otherSet, boolean onlyMergeSelected) {
        try {
            this.mySimulatorPanel.setCursor(new Cursor(3));
            HashMap<String, Boolean> dataMap = new HashMap<String, Boolean>();
            Vector<Vector> data = this.mySimulationTableModel.getDataVector();
            for (int i = 0; i < data.size(); ++i) {
                dataMap.put((String)data.get(i).get(SimulationDataTableModel.INDEX_OF_ROW_ID), true);
            }
            int[] selectedRows = otherSet.getSimulationDataTable().getSelectedRows();
            selectedRows = otherSet.convertSortedRows(selectedRows);
            HashMap<String, Boolean> selectedRowsMap = new HashMap<String, Boolean>();
            for (int row : selectedRows) {
                selectedRowsMap.put(otherSet.getSimulationModel().getIdForRow(row), new Boolean(true));
            }
            Vector<Vector> otherData = otherSet.getSimulationModel().getDataVector();
            for (int row = 0; row < otherData.size(); ++row) {
                Vector rowData = otherData.get(row);
                String rowId = (String)rowData.get(SimulationDataTableModel.INDEX_OF_ROW_ID);
                if (onlyMergeSelected && selectedRowsMap.get(rowId) == null || dataMap.get(rowId) != null) continue;
                this.mySimulationTableModel.addRow(rowData.toArray());
            }
        }
        finally {
            this.mySimulatorPanel.setCursor(new Cursor(0));
        }
    }

    public void addNewCallCaseAction(ActionEvent e) {
        try {
            this.mySimulatorPanel.setCursor(new Cursor(3));
            this.mySimulatorPanel.updateSimulationSets(true);
            this.mySimulationTableModel.createNewSimulationDataPanel();
            this.mySimulationTable.setSelectedRow(this.mySimulationTable.getRowCount() - 1);
        }
        catch (Exception x) {
            DialogFactory.getErrorDialog("Error creating simulator data", "Could not create simulator data for " + this.myServiceContainer.getService().getId() + " due to :\n" + x.getMessage());
        }
        finally {
            this.mySimulatorPanel.setCursor(new Cursor(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteCallCasesAction(ActionEvent e) {
        try {
            this.mySimulatorPanel.setCursor(new Cursor(3));
            int selected = 0;
            int[] selectedRows = this.mySimulationTable.getSelectedRows();
            selectedRows = this.convertSortedRows(selectedRows);
            if (DialogFactory.getQuestionDialog(this.mySimulatorPanel, "RMA Simulation", "Are you sure you would like to delete the selected rows?")) {
                for (int i = 0; i < selectedRows.length; ++i) {
                    selected = selectedRows[i] - i;
                    this.mySimulationTableModel.removeRow(selected);
                }
                this.mySimulationTable.setSelectedRow(Math.min(selected, this.mySimulationTable.getRowCount() - 1));
            }
        }
        finally {
            this.mySimulatorPanel.setCursor(new Cursor(0));
        }
    }

    public void switchFailedFilter(ActionEvent e) {
        this.mySimulatorPanel.updateSimulationSets(true);
        try {
            this.mySimulatorPanel.setCursor(new Cursor(3));
            if (this.isShowingAllCases) {
                this.mySimulationTableModel.setFailedFilterActive(true);
                this.isShowingAllCases = false;
            } else {
                this.mySimulationTableModel.setFailedFilterActive(false);
                this.isShowingAllCases = true;
            }
        }
        finally {
            this.mySimulatorPanel.setCursor(new Cursor(0));
        }
    }

    public void executeCallCasesAction(ActionEvent e) {
        SimulationExecutor executor;
        SimulationExecutionEvent.SimulationStartingEvent sse = new SimulationExecutionEvent.SimulationStartingEvent(this, this.mySimulationTable.getSelectedRowCount());
        this.fireSimulationStartingEvent(sse);
        if (sse.isCanceled()) {
            return;
        }
        JumperSupport jumper = this.myServiceContainer.getClassRepository().getJumperSupport();
        if (jumper instanceof RatingRuleFrameJumper) {
            ((RatingRuleFrameJumper)jumper).emptyRatingPlanCache();
        }
        this.mySimulatorPanel.updateSimulationSets(true);
        int num = 0;
        if ((e.getModifiers() & 2) != 0) {
            num = 50000;
        }
        final int numOfTests = num;
        assert (this.mySimulationTable.getSelectedRowCount() > 0) : "Should've been caught by a listener.";
        this.myTraceDestination.setText("");
        final ProgressDialog dialog = new ProgressDialog("Simulation", "Simulating selection tree...", true);
        dialog.setIndeterminate(true);
        dialog.setStringPainted(false);
        dialog.setName("Simulation.ProgressDialog.progress");
        if (this.mySimulationTable.getSelectedRowCount() == 1) {
            int row = this.mySimulationTable.getSelectedRow();
            final int selectedRow = this.mySimulationTable.convertRowIndexToModel(row);
            final SimulationDataPanel panel = this.mySimulationTableModel.getSimulationDataPanel(selectedRow);
            if (!panel.isSimulationDataValid()) {
                SimulationExecutionEvent.SimulationFailedEvent sfe = new SimulationExecutionEvent.SimulationFailedEvent(this, new SimulationErrorException("RMA cannot simulate the case until all data is valid!"));
                this.fireSimulationFailedEvent(sfe);
                return;
            }
            executor = new SimulationExecutor(dialog){

                @Override
                protected SimulationExecutionEvent doInBackground() throws Exception {
                    SimulationExecutionEvent sfe;
                    try {
                        TariffStructure rStructure = SimulationSet.this.myTreeOwner.getCurrentSelectionTree();
                        SimulationDataTableModel.SimulationStatus[] statuses = new SimulationDataTableModel.SimulationStatus[SimulationSet.this.mySimulationTable.getSelectedRowCount()];
                        SimulationDataTableModel.SimulationStatus status = SimulationSet.this.executePanel(rStructure, panel, numOfTests, true, this);
                        SimulationSet.this.mySimulationTableModel.setSimulationStatus(selectedRow, status);
                        statuses[0] = status;
                        sfe = new SimulationExecutionEvent.SimulationFinishedEvent(this, statuses);
                    }
                    catch (Exception x) {
                        sfe = new SimulationExecutionEvent.SimulationFailedEvent(this, x);
                    }
                    return sfe;
                }
            };
        } else if (this.mySimulationTable.getSelectedRowCount() > 1) {
            executor = new SimulationExecutor(dialog){

                @Override
                protected SimulationExecutionEvent doInBackground() throws Exception {
                    SimulationExecutionEvent sfe;
                    try {
                        int failedTests = 0;
                        boolean allValid = true;
                        Vector<Vector> data = SimulationSet.this.mySimulationTableModel.getDataVector();
                        SimulationDataTableModel.SimulationStatus[] statuses = new SimulationDataTableModel.SimulationStatus[SimulationSet.this.mySimulationTable.getSelectedRowCount()];
                        int[] selectedRows = SimulationSet.this.mySimulationTable.getSelectedRows();
                        selectedRows = SimulationSet.this.convertSortedRows(selectedRows);
                        TariffStructure rStructure = SimulationSet.this.myTreeOwner.getCurrentSelectionTree();
                        SimulationDataPanel panel = SimulationSet.this.mySimulationTableModel.getTemporarySimulationDataPanel();
                        Object[] columnNames = SimulationSet.this.mySimulationTableModel.getColumnNames(false).toArray();
                        for (int idx = 0; idx < selectedRows.length; ++idx) {
                            SimulationDataTableModel.SimulationStatus status;
                            int row = selectedRows[idx];
                            Vector rowData = (Vector)data.elementAt(row).clone();
                            for (int i = 0; i < SimulationDataTableModel.SPECIAL_FIELDS.length; ++i) {
                                rowData.remove(0);
                            }
                            SimulationCaseSelectedFields selectedFields = new SimulationCaseSelectedFields((String)SimulationSet.this.mySimulationTableModel.getValueAt(row, SimulationDataTableModel.INDEX_OF_SELECTED));
                            panel.init(columnNames, rowData.toArray(), selectedFields.getFields());
                            if (!panel.isSimulationDataValid()) {
                                statuses[idx] = SimulationDataTableModel.SimulationStatus.STATUS_ERRONEOUS;
                                allValid = false;
                                continue;
                            }
                            statuses[idx] = status = SimulationSet.this.executePanel(rStructure, panel, numOfTests, false, this);
                            SimulationSet.this.mySimulationTableModel.setSimulationStatus(row, status);
                            if (status != SimulationDataTableModel.SimulationStatus.STATUS_FAILED && status != SimulationDataTableModel.SimulationStatus.STATUS_ERRONEOUS) continue;
                            ++failedTests;
                        }
                        int total = SimulationSet.this.mySimulationTable.getSelectedRowCount();
                        this.trace(total - failedTests + " of " + total + " simulation cases succeded.");
                        this.trace(" \nExecute them one at a time to generate trace output.");
                        if (failedTests > 0) {
                            this.trace(" \nYou can choose to show only the failed cases from the toolbar/popup menu.");
                        }
                        if (!allValid) {
                            this.trace(" \n\nAll cases couldn't be executed since they have invalid simulation data.");
                        }
                        sfe = new SimulationExecutionEvent.SimulationFinishedEvent(this, statuses);
                    }
                    catch (Exception x) {
                        sfe = new SimulationExecutionEvent.SimulationFailedEvent(this, x);
                    }
                    return sfe;
                }
            };
        } else {
            throw new AssertionError((Object)"Trying to simulate when no simulation case is selected.");
        }
        dialog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.setInfoText("Canceled, please wait...");
                executor.cancel(false);
            }
        });
        executor.execute();
        dialog.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SimulationDataTableModel.SimulationStatus executePanel(TariffStructure rStructure, SimulationDataPanel panel, int numberOfTests, boolean withTrace, SimulationExecutor executor) {
        String errorTrace = "";
        boolean hasModifierBeenExecuted = false;
        SimulationDataTableModel.SimulationStatus simulationStatus = SimulationDataTableModel.SimulationStatus.STATUS_SUCCESS;
        long duration = 0L;
        ArrayList<String> validInfoList = new ArrayList<String>();
        GuiTraceTreeExecutor traceExec = null;
        TraceNodeTariffStructure traceTariffStructure = null;
        DataSet originalDataSet = null;
        DataSet dataSet = null;
        TraceTreeNode wrappedRoot = null;
        this.cleanStepTraceGui();
        ClassRepository classRepository = this.myServiceContainer.getClassRepository();
        JumperSupport originalJumperSupport = classRepository.getJumperSupport();
        try {
            block42: {
                if (panel instanceof AbstractGroupedSimulationDataPanel) {
                    this.searchForGroupedArrayPanels((AbstractGroupedSimulationDataPanel)panel);
                }
                dataSet = panel.createDataSet();
                panel.preProcessDataSet(dataSet);
                long start = System.nanoTime();
                int len = numberOfTests;
                for (int i = 0; i < len; ++i) {
                    rStructure.execute((DataSet)dataSet.clone());
                }
                long stop = System.nanoTime();
                duration = (stop - start) / 1000000L;
                panel.postExecutionProcessDataSet(dataSet);
                panel.postProcessDataSet(dataSet);
                originalDataSet = panel.createDataSet();
                dataSet = panel.createDataSet();
                panel.preProcessDataSet(dataSet);
                if (withTrace) {
                    TreeExecutor oldExec = dataSet.getTreeExecutor();
                    if (oldExec.getClass() != DefaultTreeExecutor.class) {
                        traceExec = new GuiTraceTreeExecutor(dataSet.getTreeExecutor());
                        dataSet.setTreeExecutor(traceExec);
                        try {
                            TreeExecutorHelper.executeTariffStructure(rStructure, dataSet);
                            panel.postExecutionProcessDataSet(dataSet);
                        }
                        catch (Exception exception) {
                        }
                        finally {
                            dataSet.setTreeExecutor(oldExec);
                        }
                    } else {
                        traceTariffStructure = (TraceNodeTariffStructure)rStructure.createTraceNode(0, null);
                        dataSet.executeWithTrace(traceTariffStructure);
                        panel.postExecutionProcessDataSet(dataSet);
                    }
                } else {
                    try {
                        rStructure.execute(dataSet);
                    }
                    catch (NoModifierFoundException oldExec) {
                        // empty catch block
                    }
                    panel.postExecutionProcessDataSet(dataSet);
                }
                panel.postProcessDataSet(dataSet);
                classRepository.setJumperSupport(originalJumperSupport);
                try {
                    boolean isValid = panel.validate(dataSet, validInfoList);
                    if (panel instanceof TreeDefinedFieldPanelSupport) {
                        HashMap<String, Object> outMap = new HashMap<String, Object>();
                        List<SimulationField> fields = panel.getSimulationDataVariables();
                        ClassRepository repository = this.myServiceContainer.getClassRepository();
                        Map<String, FieldDefinition> outputFields = repository.getOutputFieldDefinitionMap();
                        for (SimulationField field : fields) {
                            if (outputFields.get(field.getName()) == null || !field.getSelected()) continue;
                            outMap.put(field.getName(), field.getValueObject());
                        }
                        TreeDefinedFieldValidator validator = new TreeDefinedFieldValidator(repository);
                        if (!validator.validate(dataSet, outMap, validInfoList)) {
                            isValid = false;
                        }
                    }
                    simulationStatus = isValid ? SimulationDataTableModel.SimulationStatus.STATUS_SUCCESS : SimulationDataTableModel.SimulationStatus.STATUS_FAILED;
                }
                catch (DataSetValueNotFoundException x) {
                    simulationStatus = SimulationDataTableModel.SimulationStatus.STATUS_FAILED;
                    if (!withTrace) break block42;
                    validInfoList = new ArrayList();
                    validInfoList.add("Field '" + x.getFieldName() + "' was not found in the data set!\n No further comparison will be made.");
                }
            }
            if (dataSet.hasModifierBeenExecuted()) {
                hasModifierBeenExecuted = true;
            } else {
                simulationStatus = SimulationDataTableModel.SimulationStatus.STATUS_FAILED;
            }
            if (withTrace) {
                if (traceExec != null) {
                    boolean useOptimizedStepTrace = RmaDefs.getInstance().getUseOptimizedStepTrace();
                    ExecutorBasedTraceTreeNode.ExecutorBasedTraceTreeBuilder traceTreeBuilder = ExecutorBasedTraceTreeNode.createBuilder((GuiTraceTreeExecutor.GuiTraceData)traceExec.getTraceData(), executor, useOptimizedStepTrace);
                    wrappedRoot = traceTreeBuilder.buildTraceTreeForNode((AbstractDAGNode)((Object)rStructure));
                } else {
                    wrappedRoot = new TraceNodeInterfaceBasedTraceTreeNode(traceTariffStructure);
                }
                if (wrappedRoot != null) {
                    final DataSet pre = originalDataSet;
                    final DataSet post = dataSet;
                    final TraceTreeNode finalNode = wrappedRoot;
                    EDT.runAndWait(new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            SimulationSet.this.myTraceTreeGUI.setTree(finalNode, pre, post);
                            SimulationSet.this.myTraceTreeGUI.repaint();
                            return null;
                        }
                    });
                }
            }
        }
        catch (Throwable x) {
            if (x instanceof NoModifierFoundException || x.getCause() instanceof NoModifierFoundException) {
                simulationStatus = SimulationDataTableModel.SimulationStatus.STATUS_FAILED;
            } else {
                simulationStatus = SimulationDataTableModel.SimulationStatus.STATUS_ERRONEOUS;
                StringBuffer buf = new StringBuffer(x.getClass().getName());
                if (x.getMessage() != null) {
                    buf.append(" : ").append(x.getMessage());
                } else if (x.getCause() != null && x.getCause().getMessage() != null) {
                    buf.append(" : ").append(x.getCause().getMessage());
                }
                errorTrace = buf.toString();
            }
            ExceptionUtil.handleException(x, "simulation", 1, "Simulation failed!", false);
        }
        try {
            if (simulationStatus == SimulationDataTableModel.SimulationStatus.STATUS_ERRONEOUS) {
                if (withTrace) {
                    executor.trace("There was an error during simulation!:\n" + errorTrace + "\n");
                }
                return simulationStatus;
            }
            if (withTrace) {
                executor.trace("=================== [" + panel.getTitle() + "] ===================\n");
                if (numberOfTests > 0) {
                    executor.trace(numberOfTests + " rates took: " + duration + "ms - " + (long)(numberOfTests * 1000) / duration + " req/s\n");
                }
                this.printSimulationData(executor);
                if (wrappedRoot != null) {
                    executor.trace(wrappedRoot.getFullTrace(originalDataSet, dataSet));
                }
            }
            if (withTrace && simulationStatus == SimulationDataTableModel.SimulationStatus.STATUS_FAILED) {
                if (validInfoList.size() > 0) {
                    executor.trace("Differences found:\n");
                    for (String current : validInfoList) {
                        executor.trace(current + "\n");
                    }
                }
                if (!hasModifierBeenExecuted) {
                    executor.trace("No modifier was reached during the execution!");
                }
            }
        }
        catch (Exception x) {
            ExceptionUtil.handleException(x, "simulation", 1, "Error while printing trace!", true, new Object[]{String.valueOf(x.getMessage())});
        }
        return simulationStatus;
    }

    private void cleanStepTraceGui() {
        EDT.runAndWait(new Runnable(){

            @Override
            public void run() {
                SimulationSet.this.myTraceTreeGUI.clearTreePanel();
                SimulationSet.this.myTraceTreeGUI.repaint();
            }
        });
    }

    private void searchForGroupedArrayPanels(AbstractGroupedSimulationDataPanel aPanel) {
        List<Variable> commonVars = aPanel.getCommonParameters();
        for (Variable variable : commonVars) {
            if (!(variable instanceof GroupedArrayVariable)) continue;
            this.closeCellEditor((GroupedArrayVariable)variable);
        }
        List<Variable> inVars = aPanel.getInputParametersForSimulation();
        for (Variable iVar : inVars) {
            if (!(iVar instanceof GroupedArrayVariable)) continue;
            this.closeCellEditor((GroupedArrayVariable)iVar);
        }
        List<Variable> list = aPanel.getOutputParametersForSimulation();
        for (Variable oVar : list) {
            if (!(oVar instanceof GroupedArrayVariable)) continue;
            this.closeCellEditor((GroupedArrayVariable)oVar);
        }
    }

    private void closeCellEditor(GroupedArrayVariable gVar) {
        JTable table = gVar.getGroupedArrayPanel().getTable();
        TableCellEditor editor = table.getCellEditor();
        table.getModel();
        if (editor != null) {
            editor.stopCellEditing();
        }
        gVar.getGroupedArrayPanel().cleanupModel();
    }

    public void searchToolAction(ActionEvent e) {
        SQLSimulationTool sqlTool = new SQLSimulationTool(this.getSimulationModel(), this.mySimulatorPanel);
        sqlTool.setVisible(true);
    }

    public SimulationDataSource getDataSource() {
        return this.myDataSource;
    }

    public void switchDataSourceAction(ActionEvent e) {
        this.myDataSource = this.myDataSource instanceof FileSimulationSource ? new DatabaseSimulationSource(this.mySimulatorPanel, this) : new FileSimulationSource(this.mySimulatorPanel, this);
        this.initMenuAndToolbar();
    }

    public boolean save() {
        return this.myDataSource.save();
    }

    public void printSimulationData(PrintWriter out) {
        this.mySimulationTableModel.printData(out);
    }

    protected void printSimulationData(SimulationExecutor executor) {
        RatingPeriodProxy proxy = this.myTreeOwner.getRatingPeriodProxy();
        executor.trace("Service:            " + proxy.getServiceName() + "\n");
        executor.trace("Service provider:   " + proxy.getServiceProviderName() + "\n");
        executor.trace("Rating plan:        " + proxy.getRatingPlanName() + "\n");
        executor.trace("Rating period:      " + proxy.getName() + "\n");
        executor.trace("Rating period file: " + proxy.getRatingStructureFileRef() + "\n");
        Time startTime = proxy.getRatingPeriodTime();
        String timeString = "no time set";
        if (startTime != null) {
            SimpleDateFormat formatter = new SimpleDateFormat(DateUtil.DATETIME_TEXT_FORMAT[0]);
            timeString = formatter.format(startTime.getCalendar().getTime());
        }
        executor.trace("Period start time:  " + timeString + "\n");
    }

    public SimulationDataTable getSimulationDataTable() {
        return this.mySimulationTable;
    }

    public SimulationDataTableModel getSimulationModel() {
        return this.mySimulationTableModel;
    }

    public String getName() {
        return this.myName;
    }

    public void addNameChangeListener(ChangeListener listener) {
        if (!this.myNameChangeListeners.contains(listener)) {
            this.myNameChangeListeners.add(listener);
        }
    }

    public void removeNameChangeListener(ChangeListener listener) {
        this.myNameChangeListeners.remove(listener);
    }

    public void addSimulationExecutionListener(SimulationExecutionListener listener) {
        if (!this.mySimulationExecutionListeners.contains(listener)) {
            this.mySimulationExecutionListeners.add(listener);
        }
    }

    public void removeSimulationExecutionListener(SimulationExecutionListener listener) {
        this.mySimulationExecutionListeners.remove(listener);
    }

    private void fireSimulationStartingEvent(SimulationExecutionEvent.SimulationStartingEvent e) {
        for (SimulationExecutionListener listener : this.mySimulationExecutionListeners) {
            listener.simulationStarting(e);
        }
    }

    private void fireSimulationFinishedEvent(SimulationExecutionEvent.SimulationFinishedEvent e) {
        for (SimulationExecutionListener listener : this.mySimulationExecutionListeners) {
            listener.simulationFinished(e);
        }
    }

    private void fireSimulationFailedEvent(SimulationExecutionEvent.SimulationFailedEvent e) {
        for (SimulationExecutionListener listener : this.mySimulationExecutionListeners) {
            listener.simulationFailed(e);
        }
    }

    public void setName(String name) {
        this.myName = name;
        for (ChangeListener listener : this.myNameChangeListeners) {
            listener.stateChanged(new ChangeEvent(this));
        }
    }

    public boolean updateTreeDefinedFields() {
        return this.mySimulationTableModel.updateTreeDefinedFields();
    }

    public boolean isEmptySet() {
        return this.mySimulationTableModel.getRowCount() == 0;
    }

    public boolean isModified() {
        return this.mySimulationTableModel.isModified();
    }

    public void resetModified() {
        this.mySimulationTableModel.resetModified();
    }

    public void updateSessionName() {
        this.myDataSource.getSessionName();
    }

    public String toString() {
        return this.myName;
    }

    protected JToggleButton createActionToggleButton(Action a) {
        JToggleButton b = new JToggleButton(a);
        if (a != null && (a.getValue("SmallIcon") != null || a.getValue("SwingLargeIconKey") != null)) {
            b.setHideActionText(true);
        }
        b.setHorizontalTextPosition(0);
        b.setVerticalTextPosition(3);
        return b;
    }

    @Override
    public FunctionState getStateForFunction(FunctionToken token, FunctionContext ctx) {
        if (ctx != null) {
            throw new IllegalArgumentException("The context input should be null since a new context is built.");
        }
        RatingPeriodProxy proxy = this.myTreeOwner.getRatingPeriodProxy();
        if (proxy == null) {
            return FunctionState.createFunctionState(FunctionState.State.OFF);
        }
        FunctionManager mgr = FunctionManagerImpl.getInstance();
        FunctionState state = mgr.getStateForFunction(token, FunctionContext.build().withProxy(proxy).get());
        return state;
    }

    private abstract class SimulationExecutor
    extends SwingWorker<SimulationExecutionEvent, String> {
        private JDialog myProgressDialog;

        SimulationExecutor(JDialog progressDialog) {
            this.myProgressDialog = progressDialog;
        }

        @Override
        protected void process(List<String> chunks) {
            for (String str : chunks) {
                SimulationSet.this.myTraceDestination.append(str);
            }
        }

        public void trace(String trace) {
            super.publish(trace);
        }

        @Override
        public void done() {
            try {
                if (!this.isCancelled()) {
                    SimulationExecutionEvent sfe = (SimulationExecutionEvent)this.get();
                    if (sfe instanceof SimulationExecutionEvent.SimulationFinishedEvent) {
                        SimulationSet.this.fireSimulationFinishedEvent((SimulationExecutionEvent.SimulationFinishedEvent)sfe);
                    } else if (sfe instanceof SimulationExecutionEvent.SimulationFailedEvent) {
                        SimulationSet.this.fireSimulationFailedEvent((SimulationExecutionEvent.SimulationFailedEvent)sfe);
                    }
                }
            }
            catch (Exception ex) {
                ExceptionUtil.handleException(ex, "simulation", 1, "An error occurred while simulating.", true);
            }
            this.myProgressDialog.setVisible(false);
            this.myProgressDialog.dispose();
            SimulationSet.this.mySimulationTable.repaint();
        }
    }

    class PopupAdapter
    extends MouseAdapter {
        PopupAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                if (SimulationSet.this.mySimulationSetPopupMenu == null) {
                    SimulationSet.this.mySimulationSetPopupMenu = SimulationSet.this.createPopupMenu();
                }
                SimulationSet.this.mySimulationSetPopupMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

