/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.simulator.input;

import com.ericsson.ere.gui.simulator.SimulationCaseSelectedFields;
import com.ericsson.ere.gui.simulator.SimulationDataDiff;
import com.ericsson.ere.gui.simulator.SimulationDataPanel;
import com.ericsson.ere.gui.simulator.SimulationDataTableModel;
import com.ericsson.ere.gui.simulator.SimulationSet;
import com.ericsson.ere.gui.simulator.SimulatorPanel;
import com.ericsson.ere.gui.simulator.input.SimulationDataSource;
import com.ericsson.ere.gui.util.ExceptionUtil;
import com.ericsson.ere.gui.util.FileUtil;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.util.DialogFactory;
import ericsson.ere.gui.util.RmaAction;
import ericsson.ere.xml.XMLUtil;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FileSimulationSource
extends SimulationDataSource {
    private JFileChooser myFileChooser = GuiServiceCenter.getInstance().getSimFileChooser();
    private String myFilePath;
    public static final String SIM_FILE_ROOT_NODE_NAME = "SimulationSuite";

    public FileSimulationSource(SimulatorPanel simulatorPanel, SimulationSet simulationSet) {
        super(simulatorPanel, simulationSet);
    }

    @Override
    public List<Action> getActions() {
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add(new RmaAction(this, "loadAction", "Open simulation set...", "folder24.png", "folder16.png", "Opens a simulation set.", KeyStroke.getKeyStroke(79, 2)));
        actions.add(new RmaAction(this, "saveAction", "Save simulation set", "disk_blue24.png", "disk_blue16.png", "Saves the current simulation set.", KeyStroke.getKeyStroke(83, 2)));
        actions.add(new RmaAction(this, "saveAsAction", "Save simulation set as...", "save_as24.png", "save_as16.png", "Saves the current set as another file.", KeyStroke.getKeyStroke(83, 3)));
        return actions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAction(ActionEvent e) {
        File file = this.getFileChooser().getSelectedFile();
        if (this.myFilePath != null) {
            file = new File(this.myFilePath);
            this.getFileChooser().setSelectedFile(new File(this.myFilePath));
        }
        if (this.mySimulationSet.isModified()) {
            int overwriteOption = DialogFactory.showOptionDialog(this.mySimulatorPanel, "You have unsaved changes in the open set.\nWould you like to save them before loading another set?", "RMA", 0, 3, null, null);
            if (overwriteOption == 0) {
                this.saveAction(null);
            } else if (overwriteOption != 1) {
                return;
            }
        }
        this.mySimulatorPanel.updateSimulationSets(true);
        try {
            this.mySimulatorPanel.setCursor(new Cursor(3));
            int retVal = this.getFileChooser().showOpenDialog(this.mySimulatorPanel);
            if (retVal != 0) {
                return;
            }
            file = this.getFileChooser().getSelectedFile();
            this.myFilePath = this.getFileChooser().getSelectedFile().getPath();
            Document doc = null;
            try {
                doc = XMLUtil.buildDocumentFromFile(file);
            }
            catch (Exception x) {
                DialogFactory.getErrorDialog("RMA", "The selected simulation file is not valid!");
                ExceptionUtil.handleException(x, "simulation", 1, "Error while loading simulation data from " + this.myFilePath, false);
                this.mySimulatorPanel.setCursor(new Cursor(0));
                return;
            }
            this.loadDocument(doc);
            String fileName = FileUtil.getFileName(file);
            this.mySimulationSet.setName(fileName);
            if (this.mySimulationModel.getRowCount() > 0) {
                this.mySimulationSet.getSimulationDataTable().setSelectedRow(0);
            }
        }
        catch (Exception x) {
            ExceptionUtil.handleException(x, "simulation", 1, "Error while loading simulation data from " + this.myFilePath, true);
        }
        finally {
            this.mySimulatorPanel.setCursor(new Cursor(0));
        }
    }

    public void setFilePath(File file) {
        this.myFilePath = file != null ? file.getPath() : null;
    }

    public void loadDocument(Document doc) {
        ArrayList<Object[]> set = new ArrayList<Object[]>();
        SimulationDataPanel panel = this.mySimulationModel.getTemporarySimulationDataPanel();
        if (doc.getDocumentElement().getNodeName().equals(SIM_FILE_ROOT_NODE_NAME)) {
            List<SimulationDataDiff> simulationDataDifference = null;
            List<Element> cases = XMLUtil.getElementNodesNamed("ERESimulationDataPanel", doc.getDocumentElement().getChildNodes());
            cases.addAll(XMLUtil.getElementNodesNamed("RatingDataPanel", doc.getDocumentElement().getChildNodes()));
            for (int i = 0; i < cases.size(); ++i) {
                simulationDataDifference = panel.init(cases.get(i));
                Object[] data = SimulationDataTableModel.getPanelData(panel);
                SimulationCaseSelectedFields selectedFields = new SimulationCaseSelectedFields(panel);
                data = this.mySimulationModel.addSpecialFields(data, selectedFields);
                set.add(data);
            }
            String message = SimulationDataDiff.getDiffMessage(simulationDataDifference, false, true, false);
            if (!"".equals(message)) {
                if (message.length() > 3000) {
                    JTextArea textArea = new JTextArea();
                    textArea.setEditable(false);
                    textArea.setText(message);
                    textArea.setBackground(null);
                    JScrollPane scrollPane = new JScrollPane(textArea);
                    scrollPane.setPreferredSize(new Dimension(500, 500));
                    JOptionPane.showMessageDialog(GuiServiceCenter.getInstance().getMainWindow(), scrollPane, "Simulator data changed", 1);
                } else {
                    DialogFactory.getInformationDialog(GuiServiceCenter.getInstance().getMainWindow(), "Simulator data changed", message);
                }
            }
            this.mySimulationModel.init(set);
        } else if (doc.getDocumentElement().getNodeName().equals("")) {
            panel.init(doc.getDocumentElement());
            this.mySimulationModel.init(panel);
        }
    }

    @Override
    public boolean save() {
        if (this.myFilePath == null) {
            return this.doSaveAs();
        }
        return this.doSave();
    }

    @Override
    public boolean saveAs() {
        return this.doSaveAs();
    }

    public void saveAction(ActionEvent e) {
        this.mySimulatorPanel.updateSimulationSets(true);
        if (!super.checkValidity()) {
            return;
        }
        if (this.myFilePath == null) {
            this.doSaveAs();
        } else {
            this.doSave();
        }
    }

    public void saveAsAction(ActionEvent e) {
        this.mySimulatorPanel.updateSimulationSets(true);
        if (!super.checkValidity()) {
            return;
        }
        this.doSaveAs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doSave() {
        File file = null;
        try {
            this.mySimulatorPanel.setCursor(new Cursor(3));
            file = this.getFileChooser().getSelectedFile();
            file = new File(this.myFilePath);
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
            try (PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)out, "UTF-8"));){
                writer.print("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                this.mySimulationSet.printSimulationData(writer);
                writer.flush();
            }
            DialogFactory.getInformationDialog(this.mySimulatorPanel, "RMA", "The simulation case(s) was succesfully saved.");
            String fileName = this.myFilePath;
            int lastSeperator = this.myFilePath.lastIndexOf(File.separator);
            if (lastSeperator != -1) {
                fileName = this.myFilePath.substring(lastSeperator + 1);
            }
            this.mySimulationSet.resetModified();
            this.mySimulationSet.setName(fileName);
            boolean bl = true;
            return bl;
        }
        catch (Exception x) {
            ExceptionUtil.handleException(x, "simulation", 1, "Could not save simulation set to " + file.getPath(), true);
            boolean bl = false;
            return bl;
        }
        finally {
            this.mySimulatorPanel.setCursor(new Cursor(0));
        }
    }

    private boolean doSaveAs() {
        int retVal;
        int replaceFileOption = -1;
        if (this.myFilePath != null) {
            this.getFileChooser().setSelectedFile(new File(this.myFilePath));
        }
        if ((retVal = this.getFileChooser().showSaveDialog(this.mySimulatorPanel)) == 0) {
            File dest = this.getFileChooser().getSelectedFile();
            boolean destinationExists = dest.exists();
            if (!destinationExists && dest.getName().indexOf(46) == -1) {
                String extension = ".sim";
                if (this.getFileChooser().getFileFilter().getDescription().indexOf("xml") >= 0) {
                    extension = ".xml";
                }
                this.getFileChooser().setSelectedFile(new File(dest.getPath() + extension));
                dest = this.getFileChooser().getSelectedFile();
            }
            if (destinationExists) {
                replaceFileOption = DialogFactory.showOptionDialog(this.mySimulatorPanel, "The file '" + dest.getPath() + "' exists, overwrite existing file?", "File exists", 0, 1, null, null);
            }
            if (replaceFileOption == 0 || !destinationExists) {
                try {
                    this.myFilePath = this.getFileChooser().getSelectedFile().getPath();
                    boolean validFileName = GuiServiceCenter.getInstance().isFileNameValid(dest, dest.getName());
                    if (!validFileName) {
                        DialogFactory.getErrorDialog("Invalid file name", "The selected file name " + dest.getName() + "\n contains invalid characters.\nPlease select another name.");
                        return this.doSaveAs();
                    }
                    return this.doSave();
                }
                catch (Exception excep) {
                    DialogFactory.getErrorDialog("Error saving file ", "Could not save " + dest.getPath() + " due to :\n" + excep.getMessage());
                    RmaDefs.loggerRatingManager.warning("Error when exporting Simulator settings " + excep.getMessage());
                    return false;
                }
            }
            return false;
        }
        return false;
    }

    @Override
    public void setDefaultLocation(String name) {
        File defaultFile = new File(System.getProperty("user.home") + File.separator + name);
        this.myFileChooser.setSelectedFile(defaultFile);
    }

    private JFileChooser getFileChooser() {
        GuiServiceCenter.getInstance().setFileFilter("sim");
        return this.myFileChooser;
    }

    @Override
    public String getSessionName() {
        return "(File:" + this.myFilePath + ")";
    }
}

