/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.simulator.input.db;

import com.ericsson.ere.gui.simulator.SimulationDataTableModel;
import com.ericsson.ere.gui.simulator.SimulationField;
import com.ericsson.ere.gui.simulator.input.db.DatabaseAccess;
import com.ericsson.ere.gui.simulator.input.db.DatabaseColumnNameLimitationException;
import com.ericsson.ere.gui.simulator.input.db.DatabaseConfig;
import com.ericsson.ere.gui.simulator.input.db.DatabaseSimulationSource;
import com.ericsson.ere.gui.simulator.input.db.DatabaseUtil;
import com.ericsson.ere.gui.simulator.input.db.PasswordDialog;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.util.DialogFactory;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;

public class JDBCConnectDialog
extends JDialog
implements TableModelListener {
    public static final int SELECT_ACTION = 0;
    public static final int SAVE_ACTION = 1;
    public static final int OPEN_ACTION = 2;
    private static final String NEW_TABLE_NAME = "NewSet";
    private static final String CONFIG_EMPTY = "No database has been configured.";
    private static final String PASSWORD_DIALOG_TITLE = "Database Connection Password";
    private int myAction;
    private JFrame myOwner;
    private JComboBox dbUrlDropDown = new JComboBox();
    List<DatabaseConfig> myConnections;
    private JTable myTables;
    private JButton myTableAddButton;
    private TitledBorder mySetsTitle;
    private DatabaseSimulationSource mySimulationDataSource;
    private SimulationDataTableModel mySimulationDataTableModel;
    private DatabaseConfig mySelectedConnection;
    private DatabaseConfig myTempConnection;
    private List<String> myTableNames;
    private JDBCConnectDialogResponse myDialogResponse;

    public JDBCConnectDialog(DatabaseSimulationSource simulationDataSource, SimulationDataTableModel simulationDataTableModel, JFrame owner, int action) {
        super(owner, "Simulation Database Connection", true);
        this.mySimulationDataTableModel = simulationDataTableModel;
        this.myOwner = owner;
        this.myConnections = DatabaseAccess.loadDatabaseConfig();
        this.mySimulationDataSource = simulationDataSource;
        this.myAction = action;
        this.initComponents();
        this.setSize(400, 300);
        this.setLocationRelativeTo(this.myOwner);
    }

    private void initComponents() {
        String iconFileName;
        String actionButtonName;
        if (this.myAction == 1) {
            actionButtonName = "Save";
            iconFileName = "disk_blue16.png";
        } else if (this.myAction == 2) {
            actionButtonName = "Open";
            iconFileName = "folder16.png";
        } else {
            actionButtonName = "Select";
            iconFileName = "table_view16.png";
        }
        JButton btnCancel = new JButton("Close", RmaDefs.getImageIcon("door2_16.png"));
        JLabel lblDBUrl = new JLabel("Connection:");
        JButton dbConnectButton = new JButton("Connect", RmaDefs.getImageIcon("data_connection16.png"));
        final JButton tableSelectButton = new JButton(actionButtonName, RmaDefs.getImageIcon(iconFileName));
        final JButton tableDeleteButton = new JButton("Delete", RmaDefs.getImageIcon("table_delete16.png"));
        this.myTableAddButton = new JButton("Add", RmaDefs.getImageIcon("table_add16.png"));
        JPanel panelDatabase = new JPanel(new GridBagLayout());
        JPanel panelTables = new JPanel(new GridBagLayout());
        JPanel panelButtons = new JPanel(new GridBagLayout());
        this.setIconImage(RmaDefs.getImageIcon("data_connection16.png").getImage());
        this.fillBoxDbNames();
        if (this.dbUrlDropDown.getSelectedItem() == CONFIG_EMPTY) {
            dbConnectButton.setEnabled(false);
        }
        panelDatabase.add((Component)lblDBUrl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(8, 8, 0, 0), 0, 0));
        panelDatabase.add((Component)this.dbUrlDropDown, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(8, 5, 0, 8), 0, 0));
        panelDatabase.add((Component)dbConnectButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(8, 5, 0, 8), 0, 0));
        dbConnectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDBCConnectDialog.this.connect();
            }
        });
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JDBCConnectDialog.this.mySelectedConnection = null;
                JDBCConnectDialog.this.myDialogResponse = JDBCConnectDialogResponse.RESPONSE_CLOSE;
                JDBCConnectDialog.this.setVisible(false);
            }
        });
        tableSelectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JDBCConnectDialog.this.selectTable();
                JDBCConnectDialog.this.myDialogResponse = JDBCConnectDialogResponse.RESPONSE_SELECT;
                JDBCConnectDialog.this.setVisible(false);
            }
        });
        this.myTableAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JDBCConnectDialog.this.addTable(null);
            }
        });
        tableDeleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JDBCConnectDialog.this.deleteTable();
            }
        });
        this.mySetsTitle = new TitledBorder(new EtchedBorder(), "Simulation Sets");
        panelTables.setBorder(this.mySetsTitle);
        this.myTables = new JTable(new DefaultTableModel()){

            @Override
            public boolean isCellEditable(int i, int j) {
                return j == 0;
            }
        };
        ((DefaultTableModel)this.myTables.getModel()).addColumn("Set Name");
        ((DefaultTableModel)this.myTables.getModel()).addColumn("Data Fields");
        ((DefaultTableModel)this.myTables.getModel()).addColumn("Simulation Cases");
        this.myTables.getModel().addTableModelListener(this);
        this.myTableAddButton.setEnabled(false);
        tableDeleteButton.setEnabled(false);
        tableSelectButton.setEnabled(false);
        this.myTables.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (JDBCConnectDialog.this.myTables.getSelectionModel().isSelectionEmpty() || JDBCConnectDialog.this.myTables.getSelectionModel().getMinSelectionIndex() != JDBCConnectDialog.this.myTables.getSelectionModel().getMaxSelectionIndex()) {
                    tableDeleteButton.setEnabled(false);
                    tableSelectButton.setEnabled(false);
                } else {
                    tableSelectButton.setEnabled(true);
                    tableDeleteButton.setEnabled(true);
                }
            }
        });
        JScrollPane tablesScroll = new JScrollPane(this.myTables);
        tablesScroll.setPreferredSize(new Dimension(50, 80));
        if (this.mySimulationDataSource.getCurrentDatabaseConfig() != null) {
            this.dbUrlDropDown.setSelectedItem(this.mySimulationDataSource.getCurrentDatabaseConfig());
            this.connect();
        } else {
            this.dbUrlDropDown.setSelectedItem(0);
        }
        panelTables.add((Component)tablesScroll, new GridBagConstraints(0, 0, 3, 1, 1.0, 1.0, 10, 1, new Insets(8, 8, 0, 8), 0, 0));
        panelTables.add((Component)tableDeleteButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(8, 8, 8, 0), 0, 0));
        panelTables.add((Component)this.myTableAddButton, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(8, 8, 8, 0), 0, 0));
        panelTables.add((Component)tableSelectButton, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(8, 8, 8, 8), 0, 0));
        panelButtons.add((Component)btnCancel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(8, 8, 8, 8), 0, 0));
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)panelDatabase, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(8, 8, 8, 8), 0, 0));
        this.getContentPane().add((Component)panelTables, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(8, 8, 8, 8), 0, 0));
        this.getContentPane().add((Component)panelButtons, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.pack();
    }

    private void fillBoxDbNames() {
        this.dbUrlDropDown.removeAllItems();
        for (DatabaseConfig connection : this.myConnections) {
            this.dbUrlDropDown.addItem(connection);
        }
        if (this.dbUrlDropDown.getItemCount() == 0) {
            this.dbUrlDropDown.addItem(CONFIG_EMPTY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect() {
        this.myTempConnection = (DatabaseConfig)this.dbUrlDropDown.getSelectedItem();
        try {
            if (this.myTempConnection.get("Password") == null || this.myTempConnection.get("Password").isEmpty()) {
                String password = PasswordDialog.getPasswordFromDialog(PASSWORD_DIALOG_TITLE);
                if (password == null) {
                    return;
                }
                this.myTempConnection.set("Password", password);
            }
            this.setCursor(new Cursor(3));
            DatabaseAccess.connect(this.myTempConnection);
            this.myTableNames = DatabaseAccess.getTableNames(this.myTempConnection);
            if (this.myTableNames.size() == 0) {
                DialogFactory.getInformationDialog(this.myOwner, "Simulation database", "No sets have been created for this database");
            }
            DefaultTableModel tableModel = (DefaultTableModel)this.myTables.getModel();
            while (tableModel.getRowCount() > 0) {
                tableModel.removeRow(0);
            }
            for (int i = 0; i < this.myTableNames.size(); ++i) {
                int columnCount = DatabaseAccess.getTableColumnsCount(this.myTempConnection, this.myTableNames.get(i));
                int rowCount = DatabaseAccess.getTableRowCount(this.myTempConnection, this.myTableNames.get(i));
                tableModel.addRow(new String[]{this.myTableNames.get(i), columnCount + "", rowCount + ""});
            }
            this.myTableAddButton.setEnabled(true);
            this.mySetsTitle.setTitle("Simulation Sets at " + this.myTempConnection.get("Name"));
            this.getContentPane().repaint();
        }
        catch (Exception e) {
            DialogFactory.getErrorDialog(this.myOwner, "Database connection failed", e.getMessage());
            this.myTempConnection.set("Password", null);
        }
        finally {
            this.setCursor(new Cursor(0));
        }
    }

    private void deleteTable() {
        try {
            DefaultTableModel tableModel = (DefaultTableModel)this.myTables.getModel();
            int row = this.myTables.getSelectedRow();
            String tableName = (String)tableModel.getValueAt(row, 0);
            if (DialogFactory.getQuestionDialog(this, "Simulation set Deletion", "Are you sure you wan't to delete '" + tableName + "'?\nAll cases within it will be lost!")) {
                DatabaseAccess.removeTable(this.myTempConnection, tableName);
                tableModel.removeRow(row);
            }
        }
        catch (Exception e) {
            DialogFactory.getErrorDialog(this.myOwner, "Simulation set selection", e.getMessage());
        }
    }

    private void addTable(String tableName) {
        try {
            DefaultTableModel tableModel = (DefaultTableModel)this.myTables.getModel();
            boolean hasFoundFreeIndex = false;
            int index = 0;
            do {
                ++index;
                hasFoundFreeIndex = true;
                for (int i = 0; i < tableModel.getRowCount(); ++i) {
                    if (!((String)tableModel.getValueAt(i, 0)).equalsIgnoreCase(NEW_TABLE_NAME + index)) continue;
                    hasFoundFreeIndex = false;
                }
            } while (!hasFoundFreeIndex);
            List<SimulationField> variables = this.mySimulationDataTableModel.getSimulationData(false, true);
            List<SimulationField> arrangedFields = DatabaseUtil.arrangeFieldsForTable(variables);
            if (tableName == null) {
                tableName = NEW_TABLE_NAME + index;
            }
            DatabaseAccess.addTable(this.myTempConnection, tableName, arrangedFields);
            this.myTableNames.add(tableName);
            int columnCount = DatabaseAccess.getTableColumnsCount(this.myTempConnection, tableName);
            int rowCount = DatabaseAccess.getTableRowCount(this.myTempConnection, tableName);
            tableModel.addRow(new String[]{tableName, columnCount + "", rowCount + ""});
        }
        catch (DatabaseColumnNameLimitationException dle) {
            DialogFactory.getErrorDialog(this.myOwner, "Unable to save simulation", dle.getMessage());
        }
        catch (Exception ex) {
            DialogFactory.getErrorDialog(this.myOwner, "Simulation set selection", ex.getMessage());
        }
    }

    private void selectTable() {
        try {
            String tableName = (String)this.myTables.getValueAt(this.myTables.getSelectedRow(), 0);
            DatabaseAccess.selectTable(this.myTempConnection, tableName);
            this.mySelectedConnection = this.myTempConnection;
        }
        catch (Exception ex) {
            DialogFactory.getErrorDialog(this.myOwner, "Simulation set selection", ex.getMessage());
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        try {
            if (e.getType() == 0) {
                DefaultTableModel tableModel = (DefaultTableModel)this.myTables.getModel();
                int row = this.myTables.getSelectedRow();
                String tableName = (String)tableModel.getValueAt(row, 0);
                if (!this.myTableNames.get(row).equals(tableName)) {
                    DatabaseAccess.renameTable(this.myTempConnection, this.myTableNames.get(row), tableName);
                    this.myTableNames.set(row, tableName);
                }
            }
        }
        catch (Exception ex) {
            DialogFactory.getErrorDialog(this.myOwner, "Simulation set selection", ex.getMessage());
            int row = this.myTables.getSelectedRow();
            this.myTables.getModel().setValueAt(this.myTableNames.get(row), row, 0);
        }
    }

    public static DatabaseConfig showDialog(SimulationDataTableModel simulationDataTableModel, DatabaseSimulationSource simulationDataSource, JFrame frame, int action) {
        JDBCConnectDialog dialog = new JDBCConnectDialog(simulationDataSource, simulationDataTableModel, frame, action);
        dialog.setVisible(true);
        if (dialog.myDialogResponse == JDBCConnectDialogResponse.RESPONSE_SELECT) {
            return dialog.mySelectedConnection;
        }
        return null;
    }

    private static enum JDBCConnectDialogResponse {
        RESPONSE_SELECT,
        RESPONSE_CLOSE;

    }
}

