/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.simulator.tree;

import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.gui.simulator.tree.TraceTreeNode;
import com.ericsson.ere.util.IterableEnumeration;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class TraceTreeModel
extends DefaultTreeModel {
    private String myFullTrace;
    private List<TraceTreeNode> myExecutionOrder = new ArrayList<TraceTreeNode>();
    private TraceTreeNode myExceptionNode;

    public TraceTreeModel(TraceTreeNode root, DataSet preDataSet, DataSet postDataSet) {
        super(root);
        this.myFullTrace = root.getFullTrace(preDataSet, postDataSet);
        this.findLastException(root);
        this.generateExecutionList(root);
    }

    private void generateExecutionList(TraceTreeNode node) {
        IterableEnumeration<TreeNode> iterable = new IterableEnumeration<TreeNode>(node.children());
        for (TraceTreeNode traceTreeNode : iterable) {
            if (traceTreeNode.getType() == TraceTreeNode.TraceNodeType.MODIFIER && traceTreeNode.isExecuted()) {
                this.myExecutionOrder.add(traceTreeNode);
            }
            this.generateExecutionList(traceTreeNode);
        }
    }

    private void findLastException(TraceTreeNode node) {
        IterableEnumeration<TreeNode> iterable = new IterableEnumeration<TreeNode>(node.children());
        for (TraceTreeNode traceTreeNode : iterable) {
            if (traceTreeNode.hasException()) {
                this.myExceptionNode = traceTreeNode;
            }
            this.findLastException(traceTreeNode);
        }
    }

    public TraceTreeNode getLastException() {
        return this.myExceptionNode;
    }

    public String getTrace() {
        return this.myFullTrace;
    }

    public List<TraceTreeNode> getExecutionTrace() {
        return this.myExecutionOrder;
    }
}

