/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.undoredo;

import com.ericsson.ere.gui.undoredo.UndoableTree;
import com.ericsson.ere.gui.util.ExceptionUtil;
import ericsson.ere.gui.ratingrules.nodes.TSElement;
import ericsson.ere.util.StringUtil;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.util.List;
import javax.swing.tree.TreePath;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public class EditNodeEdit
extends AbstractUndoableEdit {
    public static final long MAX_TIME_DISTANCE_BETWEEN_EDITS = 3000L;
    private UndoableTree myTree;
    private TreePath myTreePath;
    private Object myOldValue;
    private Object myNewValue;
    private String myVariableKey;
    private long myCreateTime;

    public EditNodeEdit(UndoableTree tree, TreePath pathToRoot, String key, Object oldValue, Object newValue) {
        Object o = pathToRoot.getLastPathComponent();
        if (!(o instanceof TSElement)) {
            throw new IllegalArgumentException("Last path component must be a TSElement.");
        }
        this.myTree = tree;
        this.myTreePath = pathToRoot;
        this.myVariableKey = key;
        this.myOldValue = oldValue;
        this.myNewValue = newValue;
        this.myCreateTime = System.currentTimeMillis();
    }

    @Override
    public String toString() {
        return String.format("EditNodeEdit [time=%d; path=%s; key=%s; old=%s; new=%s]", this.myCreateTime, this.myTreePath, this.myVariableKey, this.myOldValue, this.myNewValue);
    }

    @Override
    public synchronized boolean addEdit(UndoableEdit anEdit) {
        boolean add;
        boolean bl = add = this.hasCompatibleType(anEdit) && this.shouldAssimilate((EditNodeEdit)anEdit);
        if (add) {
            this.myNewValue = ((EditNodeEdit)anEdit).myNewValue;
        }
        return add;
    }

    private boolean hasCompatibleType(UndoableEdit anEdit) {
        return anEdit != null && anEdit instanceof EditNodeEdit;
    }

    private boolean shouldAssimilate(EditNodeEdit newEdit) {
        return this.closeInTime(newEdit) && this.sameTreePath(newEdit) && this.sameVariable(newEdit) && this.isDirectSuccessor(newEdit) && this.followsTextTypingRules(newEdit);
    }

    private boolean followsTextTypingRules(EditNodeEdit newEdit) {
        String strReplacement;
        String strThis;
        boolean result = true;
        if (this.bothAreStrings(this.myNewValue, newEdit.myNewValue) && (this.oneStringIsEmpty(strThis = (String)this.myNewValue, strReplacement = (String)newEdit.myNewValue) || this.differByNewLine(strThis, strReplacement))) {
            result = false;
        }
        return result;
    }

    private boolean differByNewLine(String old, String replacement) {
        String addedOrSubstituted;
        int firstDiff;
        boolean result = false;
        int lengthDiff = replacement.length() - old.length();
        if (this.lengthDifferenceIsAtMostNewLine(lengthDiff) && (firstDiff = StringUtil.indexOfFirstDifference(old, replacement)) >= 0 && firstDiff < replacement.length() && this.isNewLine(addedOrSubstituted = replacement.substring(firstDiff, firstDiff + (lengthDiff > 0 ? lengthDiff : 1)))) {
            result = true;
        }
        return result;
    }

    private boolean isNewLine(String str) {
        return "\n".equals(str) || "\r\n".equals(str);
    }

    private boolean lengthDifferenceIsAtMostNewLine(int diff) {
        return diff >= 0 && diff <= 2;
    }

    private boolean isDirectSuccessor(EditNodeEdit next) {
        return EditNodeEdit.eq(this.myNewValue, next.myOldValue);
    }

    private boolean sameVariable(EditNodeEdit e2) {
        return this.myVariableKey.equals(e2.myVariableKey);
    }

    private boolean sameTreePath(EditNodeEdit e2) {
        return this.myTreePath.equals(e2.myTreePath);
    }

    private boolean closeInTime(EditNodeEdit e2) {
        return Math.abs(this.myCreateTime - e2.myCreateTime) <= 3000L;
    }

    private boolean oneStringIsEmpty(String s1, String s2) {
        return s1.isEmpty() != s2.isEmpty();
    }

    private boolean bothAreStrings(Object o1, Object o2) {
        return o1 instanceof String && o2 instanceof String;
    }

    private static boolean eq(Object first, Object second) {
        if (first == second) {
            return true;
        }
        if (first == null || second == null) {
            return false;
        }
        return first.equals(second);
    }

    @Override
    public void redo() throws CannotRedoException {
        this.myTree.setOngoingUndo(true);
        super.redo();
        try {
            if (!this.updateValue(this.myNewValue)) {
                throw new CannotRedoException();
            }
        }
        finally {
            this.myTree.setOngoingUndo(false);
        }
    }

    @Override
    public void undo() throws CannotUndoException {
        this.myTree.setOngoingUndo(true);
        super.undo();
        try {
            if (!this.updateValue(this.myOldValue)) {
                throw new CannotUndoException();
            }
        }
        finally {
            this.myTree.setOngoingUndo(false);
        }
    }

    protected boolean updateValue(Object value) {
        TSElement ts = (TSElement)this.myTreePath.getLastPathComponent();
        List<Variable> variables = ts.getVariablesForEditing(null);
        Variable var = VarListUtil.getVariableForKey(variables, this.myVariableKey);
        boolean result = false;
        if (var != null) {
            try {
                if (value instanceof Variable && ((Variable)value).getKey().equals(var.getKey())) {
                    variables.set(variables.indexOf(var), (Variable)value);
                    ts.updateGui();
                    var = (Variable)value;
                } else {
                    var.setValue(value);
                }
                var.getEditor().requestFocusInWindow();
                this.myTree.setSelectionPath(this.myTreePath);
                this.myTree.scrollPathToVisible(this.myTreePath);
                result = true;
            }
            catch (RuntimeException e) {
                if (value == null) {
                    ExceptionUtil.handleException(e, "ratingperiod", 1, "Variable.setValue(null) failed for " + var.getClass().getName(), false);
                    result = false;
                }
                throw e;
            }
        }
        return result;
    }

    @Override
    public String getPresentationName() {
        return String.format("%s: %s => %s", this.myVariableKey, this.myOldValue, this.myNewValue);
    }
}

