/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.undoredo;

import com.ericsson.ere.gui.undoredo.UndoableTree;
import javax.swing.tree.TreePath;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

public class MoveNodeDownEdit
extends AbstractUndoableEdit {
    private TreePath path;
    private UndoableTree myTree;

    public MoveNodeDownEdit(UndoableTree tree, Object[] path) {
        this.path = new TreePath(path);
        this.myTree = tree;
    }

    @Override
    public void undo() throws CannotUndoException {
        this.myTree.setOngoingUndo(true);
        try {
            super.undo();
            this.myTree.getTreeModel().moveUp(this.path.getPath());
            this.myTree.setSelectionPath(this.path);
            this.myTree.scrollPathToVisible(this.path);
        }
        finally {
            this.myTree.setOngoingUndo(false);
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        this.myTree.setOngoingUndo(true);
        try {
            super.redo();
            this.myTree.getTreeModel().moveDown(this.path.getPath());
            this.myTree.setSelectionPath(this.path);
            this.myTree.scrollPathToVisible(this.path);
        }
        finally {
            this.myTree.setOngoingUndo(false);
        }
    }
}

