/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.util;

import com.ericsson.ere.datatype.ValueResolver;
import com.ericsson.ere.datatype.ValueResolverAdapter;
import com.ericsson.ere.gui.util.ArrayEditPanel;
import com.ericsson.ere.variable.VariableProducer;
import ericsson.vareditor.variable.ArrayModel;
import ericsson.vareditor.variable.ArrayVariable;

public class ArrayEditPanelBuilder {
    private ArrayModel myModel;
    private ValueResolver myValueResolver;
    private VariableProducer myProducer;
    private boolean myForceArrayEdit;
    private ArrayVariable.EditMode myEditMode;
    private ArrayVariable.ObjectLabeler myObjectLabeler;
    private boolean myActAsSetEditor;

    private ArrayEditPanelBuilder(ArrayModel model) {
        this.myModel = model;
    }

    public static ArrayEditPanelBuilder useValues(Object[] values, String[] columnNames) {
        return ArrayEditPanelBuilder.useModel(new ArrayModel(values, columnNames));
    }

    public static ArrayEditPanelBuilder useModel(ArrayModel model) {
        return new ArrayEditPanelBuilder(model);
    }

    public ArrayEditPanelBuilder withValueResolver(ValueResolver resolver) {
        this.myValueResolver = resolver;
        return this;
    }

    public ArrayEditPanelBuilder withVariableProducer(VariableProducer producer) {
        this.myProducer = producer;
        return this;
    }

    public ArrayEditPanelBuilder forceArrayEdit(boolean force) {
        this.myForceArrayEdit = force;
        return this;
    }

    public ArrayEditPanelBuilder withEditMode(ArrayVariable.EditMode mode) {
        this.myEditMode = mode;
        return this;
    }

    public ArrayEditPanelBuilder withObjectLabeler(ArrayVariable.ObjectLabeler objectLabeler) {
        this.myObjectLabeler = objectLabeler;
        return this;
    }

    public ArrayEditPanelBuilder actingAsSetEditor(boolean actAsSetEditor) {
        this.myActAsSetEditor = actAsSetEditor;
        return this;
    }

    public ArrayEditPanel createPanel() {
        ArrayEditPanel panel = new ArrayEditPanel(this);
        if (this.myEditMode != null) {
            panel.setEditMode(this.myEditMode);
        }
        panel.setName("ArrayEditPanel.JPanel.EditPanel");
        return panel;
    }

    VariableProducer getVariableProducer() {
        return this.myProducer;
    }

    ValueResolver getValueResolver() {
        return ArrayEditPanelBuilder.combineValueResolverWithObjectLabeler(this.myValueResolver, this.myObjectLabeler);
    }

    ArrayModel getModel() {
        return this.myModel;
    }

    boolean getForceEditArray() {
        return this.myForceArrayEdit;
    }

    boolean getActAsSetEditor() {
        return this.myActAsSetEditor;
    }

    private static ValueResolver combineValueResolverWithObjectLabeler(ValueResolver resolver, final ArrayVariable.ObjectLabeler labeler) {
        ValueResolver ret = resolver;
        if (ret != null && labeler != null) {
            ret = new ValueResolverAdapter(resolver){

                @Override
                public String makeDisplayString(Object anObject) {
                    return labeler.getDisplayStringForObject(anObject);
                }
            };
        }
        return ret;
    }
}

