/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.gui.util;

import com.ericsson.ere.gui.util.CustomArrayBorder;
import com.ericsson.ere.gui.util.UnderlineLabelUI;
import com.ericsson.ere.swing.EDT;
import com.ericsson.ere.util.ValidItemList;
import com.ericsson.ere.variable.VariableList;
import com.ericsson.vareditor.TitleRenderer;
import ericsson.vareditor.VarTable2;
import ericsson.vareditor.VarTableModel;
import ericsson.vareditor.variable.Variable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.MouseInputAdapter;

public class ClosableVarPanel
extends JPanel {
    private static final String PANEL_VALID_PROP = "_panelValid";
    private static final long serialVersionUID = 1L;
    private static final Border EMPTY_BORDER = BorderFactory.createEmptyBorder();
    private boolean myIsFoldedState = false;
    private boolean myIsVarArray = false;
    protected List<? extends JComponent> myComponents;
    protected JPanel myBorderPanel;
    private Border myArrayBorder;
    private GridBagConstraints c = new GridBagConstraints();
    private boolean myValidStatus = true;
    protected TitleRenderer myTitleRenderer;

    protected ClosableVarPanel(String groupName, boolean folded) {
        super(new GridBagLayout());
        this.myTitleRenderer = new DefaultTitleRenderer(groupName);
        this.myIsFoldedState = !folded;
    }

    public ClosableVarPanel(String groupName, boolean folded, List<? extends JComponent> componentList) {
        this(new DefaultTitleRenderer(groupName), folded, componentList, false);
    }

    public ClosableVarPanel(TitleRenderer rend, boolean folded, List<? extends JComponent> componentList, boolean array) {
        super(new GridBagLayout());
        this.myComponents = componentList;
        this.myTitleRenderer = rend;
        this.myIsVarArray = array;
        this.myIsFoldedState = !folded;
        this.init();
        this.updateFoldedState();
        this.addListeners();
    }

    protected void addListeners() {
        List<VarTable2> varTables = this.findComponents(VarTable2.class);
        List<ClosableVarPanel> nestedPanels = this.findComponents(ClosableVarPanel.class);
        new ChildChangeHandler(varTables, nestedPanels);
    }

    protected void init() {
        this.myTitleRenderer.getLabel().setUI(new UnderlineLabelUI(true));
        if (this.myTitleRenderer instanceof DefaultTitleRenderer) {
            for (JComponent jComponent : this.getAdditionalTitleComponents()) {
                this.myTitleRenderer.getComponent().add(jComponent);
            }
        }
        this.updateLabelText();
        this.setupContentPanel();
    }

    protected List<? extends JComponent> getAdditionalTitleComponents() {
        return Collections.emptyList();
    }

    protected void setupContentPanel() {
        Border arrayEdge = BorderFactory.createEmptyBorder(2, 1, 5, 1);
        this.setBorder(arrayEdge);
        this.setOpaque(false);
        JComponent renderer = this.myTitleRenderer.getComponent();
        int rendererHeight = (int)((Component)renderer).getPreferredSize().getHeight();
        CustomArrayBorder border = new CustomArrayBorder((int)this.myTitleRenderer.getComponent().getPreferredSize().getWidth());
        this.myArrayBorder = BorderFactory.createCompoundBorder(border, BorderFactory.createEmptyBorder(rendererHeight, 0, 0, 0));
        this.myBorderPanel = new JPanel(new GridBagLayout());
        this.myBorderPanel.setBorder(this.myArrayBorder);
        this.myBorderPanel.setOpaque(false);
        final JLabel label = this.myTitleRenderer.getLabel();
        if (label.getName() == null) {
            label.setName("ClosableVarPanel.JLabel.TitleLabel");
        }
        label.addMouseListener(new MouseInputAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Point p = e.getPoint();
                if (label != null && !label.contains(p)) {
                    return;
                }
                ClosableVarPanel.this.onTitleClicked(e);
            }
        });
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.c.fill = 1;
        this.c.anchor = 18;
        this.c.weightx = 1.0;
        this.c.weighty = 1.0;
        this.addComponentsToPanel(this.myBorderPanel);
        this.add((Component)this.myBorderPanel, this.c);
        this.c.gridy = 0;
        this.c.insets = new Insets(2, 0, 0, 0);
        this.c.anchor = 18;
        this.c.weighty = 0.0;
        this.add((Component)renderer, this.c);
    }

    protected void addComponentsToPanel(JPanel panel) {
        GridBagConstraints con = new GridBagConstraints();
        con.gridx = 0;
        con.gridy = -1;
        con.gridwidth = 1;
        con.fill = 1;
        con.anchor = 12;
        con.weightx = 1.0;
        con.weighty = 0.0;
        con.insets = new Insets(0, 10, 3, 0);
        int len = this.myComponents.size();
        for (int i = 0; i < len; ++i) {
            JComponent component = this.myComponents.get(i);
            ++con.gridy;
            if (i == len - 1) {
                con.weighty = 1.0;
            }
            panel.add((Component)component, con);
        }
    }

    protected void onTitleClicked(MouseEvent e) {
        this.updateFoldedState();
    }

    protected void updateFoldedState() {
        this.setFoldedState(!this.myIsFoldedState);
    }

    public void setFoldedState(boolean folded) {
        this.myIsFoldedState = folded;
        this.updateLabelText();
        this.c.insets = new Insets(0, this.myIsFoldedState ? 0 : 10, 0, 0);
        this.add((Component)this.myTitleRenderer.getComponent(), this.c);
        this.myBorderPanel.setBorder(this.myIsFoldedState ? EMPTY_BORDER : this.myArrayBorder);
        for (JComponent jComponent : this.myComponents) {
            jComponent.setVisible(!this.myIsFoldedState);
        }
    }

    public boolean isFolded() {
        return this.myIsFoldedState;
    }

    protected void updateLabelText() {
        String text = (this.myIsFoldedState ? "+ " : "- ") + this.myTitleRenderer.getTitle();
        this.myTitleRenderer.setLabelText(text + (this.myIsFoldedState && this.myIsVarArray ? "..." : ""));
    }

    public String getGroupName() {
        return this.myTitleRenderer.getTitle();
    }

    @Deprecated
    public VarTableModel getVarTableModel() {
        if (this.myComponents.size() > 0) {
            JComponent first = this.myComponents.get(0);
            for (int ii = 0; ii < first.getComponentCount(); ++ii) {
                Component c = first.getComponent(ii);
                if (!(c instanceof VarTable2)) continue;
                return ((VarTable2)c).getTableModel();
            }
        }
        return null;
    }

    private <T extends Component> List<T> findComponents(Class<T> typeClass) {
        ArrayList list = new ArrayList();
        for (JComponent jComponent : this.myComponents) {
            this.findComponents(jComponent, typeClass, list);
        }
        return list;
    }

    private <T extends Component> void findComponents(Component c, Class<T> typeClass, List<T> list) {
        if (typeClass.isInstance(c)) {
            list.add(c);
        } else if (!(c instanceof ClosableVarPanel) && c instanceof Container) {
            Container cont = (Container)c;
            int cc = cont.getComponentCount();
            for (int i = 0; i < cc; ++i) {
                this.findComponents(cont.getComponent(i), typeClass, list);
            }
        }
    }

    public void setGroupColorValid() {
        EDT.runAndWait(new Runnable(){

            @Override
            public void run() {
                ClosableVarPanel.this.myTitleRenderer.getLabel().setForeground(Color.BLACK);
            }
        });
    }

    public void setGroupColorInvalid() {
        EDT.runAndWait(new Runnable(){

            @Override
            public void run() {
                ClosableVarPanel.this.myTitleRenderer.getLabel().setForeground(Color.RED);
                ClosableVarPanel.this.myTitleRenderer.getLabel().setBackground(Color.RED);
            }
        });
    }

    public void setGroupValid(boolean valid) {
        if (this.myValidStatus != valid) {
            boolean old = this.myValidStatus;
            this.myValidStatus = valid;
            this.firePropertyChange(PANEL_VALID_PROP, old, valid);
            if (valid) {
                this.setGroupColorValid();
            } else {
                this.setGroupColorInvalid();
            }
        }
    }

    public boolean getGroupValid() {
        return this.myValidStatus;
    }

    public List<JComponent> getClosableComponents() {
        return this.myComponents;
    }

    private static class ClosableVarPanelList
    extends ValidItemList<ClosableVarPanel>
    implements PropertyChangeListener {
        private ClosableVarPanelList() {
        }

        @Override
        protected boolean isValid(ClosableVarPanel item) {
            return item.getGroupValid();
        }

        @Override
        protected void registerValidStateChangeListener(ClosableVarPanel item) {
            item.addPropertyChangeListener(ClosableVarPanel.PANEL_VALID_PROP, this);
        }

        @Override
        protected void unregisterValidStateChangeListener(ClosableVarPanel item) {
            item.removePropertyChangeListener(ClosableVarPanel.PANEL_VALID_PROP, this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            assert (ClosableVarPanel.PANEL_VALID_PROP.equals(evt.getPropertyName())) : "Wrong property name!";
            ClosableVarPanel panel = (ClosableVarPanel)evt.getSource();
            boolean isValid = (Boolean)evt.getNewValue();
            this.validStateChanged(panel, isValid);
        }
    }

    private class ChildChangeHandler
    implements PropertyChangeListener {
        private VariableList myVarList = new VariableList();
        private ClosableVarPanelList myPanelList = new ClosableVarPanelList();

        ChildChangeHandler(List<VarTable2> varTables, List<ClosableVarPanel> nestedPanels) {
            for (VarTable2 vt2 : varTables) {
                for (Variable v : vt2.getTableModel().getData()) {
                    this.myVarList.add(v);
                }
            }
            this.myVarList.addPropertyChangeListener("valid", this);
            this.myPanelList.addAll(nestedPanels);
            this.myPanelList.addPropertyChangeListener("valid", this);
            this.updateValidState();
        }

        private void updateValidState() {
            boolean isValid = this.myVarList.isValid() && this.myPanelList.isValid();
            ClosableVarPanel.this.setGroupValid(isValid);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            assert ("valid".equals(evt.getPropertyName())) : "Wrong property name!";
            this.updateValidState();
        }
    }

    public static class DefaultTitleRenderer
    extends JPanel
    implements TitleRenderer {
        private static final long serialVersionUID = 1L;
        private JLabel myLabel;
        private String myTitle;

        public DefaultTitleRenderer(String title) {
            super(new FlowLayout(0, 5, 0));
            this.myTitle = title;
            this.myLabel = new JLabel(title);
            this.add(this.myLabel);
        }

        @Override
        public JComponent getComponent() {
            return this;
        }

        @Override
        public JLabel getLabel() {
            return this.myLabel;
        }

        @Override
        public String getLabelText() {
            return this.myLabel.getText();
        }

        @Override
        public String getTitle() {
            return this.myTitle;
        }

        @Override
        public void setLabelText(String text) {
            this.myLabel.setText(text);
        }
    }
}

