/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.io;

import ericsson.ere.integration.util.FileHandling;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;

public final class IOUtil {
    private IOUtil() {
    }

    public static String readAll(Reader r) throws IOException {
        StringBuilder builder = new StringBuilder();
        IOUtil.readAll(r, builder);
        return builder.toString();
    }

    public static String readAllAndClose(Reader r) throws IOException {
        StringBuilder builder = new StringBuilder();
        IOUtil.readAllAndClose(r, builder);
        return builder.toString();
    }

    public static void readAll(Reader r, Appendable appendable) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(r);
        while ((line = reader.readLine()) != null) {
            appendable.append(line).append('\n');
        }
    }

    public static void readAllAndClose(Reader r, Appendable appendable) throws IOException {
        try {
            IOUtil.readAll(r, appendable);
        }
        finally {
            r.close();
        }
    }

    public static File makeTemporaryCopy(File fileToCopy, String prefix) throws IOException {
        File tmp = File.createTempFile(prefix, ".tmp");
        FileHandling.copyFile(fileToCopy, tmp);
        return tmp;
    }

    public static boolean canCreateFile(File file) {
        boolean canCreate;
        boolean bl = canCreate = file != null;
        if (file != null && !file.exists()) {
            try {
                boolean created = file.createNewFile();
                if (created) {
                    file.delete();
                }
            }
            catch (IOException ex) {
                canCreate = false;
            }
        }
        return canCreate;
    }
}

