/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.naming;

import com.ericsson.ere.naming.NamingStrategy;
import java.awt.Component;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class DefaultSwingNamingStrategy
implements NamingStrategy {
    @Override
    public String createComponentName(Component comp, int index) {
        String name = null;
        if (comp instanceof AbstractButton) {
            name = this.getButtonName((AbstractButton)comp);
        }
        if (name == null || "".equals(name)) {
            if (comp.getClass().isAnonymousClass()) {
                Class<?> clazz = this.getBaseClassFor(comp);
                name = clazz.getSimpleName() + "-";
                String suffix = comp.getClass().getName();
                suffix = suffix.substring(suffix.lastIndexOf(46) + 1);
                suffix = suffix.substring(0, suffix.indexOf(36));
                name = name + suffix;
            } else {
                name = comp.getClass().getSimpleName();
            }
        }
        return name + "_" + index;
    }

    @Override
    public String normalizeName(String name) {
        String newName = name;
        if ((newName = newName.replaceAll("[/\\. -]", "_")).length() >= 2 && newName.charAt(0) == 'J' && Character.isUpperCase(newName.charAt(1))) {
            newName = newName.substring(1);
        }
        return newName;
    }

    private Class<?> getBaseClassFor(Component comp) {
        Class<?> clazz = comp.getClass();
        Class<?> base = clazz.getSuperclass();
        if (base == Object.class && clazz.getInterfaces().length > 0) {
            base = clazz.getInterfaces()[0];
        }
        return base;
    }

    private String getButtonName(AbstractButton button) {
        String iconDesc;
        Icon icon;
        String name = button.getText();
        if ((name == null || "".equals(name)) && (icon = button.getIcon()) != null && icon instanceof ImageIcon && this.looksLikeAFileName(iconDesc = ((ImageIcon)icon).getDescription())) {
            name = iconDesc;
            name = name.substring(name.lastIndexOf(47) + 1);
            name = name.substring(0, name.lastIndexOf(46));
        }
        return name;
    }

    private boolean looksLikeAFileName(String str) {
        String regex = ".*/[^/]+\\.[a-zA-Z]+";
        return str != null && str.matches(regex);
    }
}

