/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.proxy;

import ericsson.ere.defs.RmaDefs;
import ericsson.ere.integration.log.EreIntegrationLogInterface;
import ericsson.ere.integration.log.LogLevels;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class InternalEreProxyLogReceiver
implements EreIntegrationLogInterface {
    @Override
    public int getLevel() {
        return LogLevels.toLogLevel(RmaDefs.loggerRatingManager.getLevel());
    }

    @Override
    public boolean isLevel(int logLevel) {
        Level level = LogLevels.toLevel(logLevel);
        return level != null ? RmaDefs.loggerRatingManager.isLoggable(level) : false;
    }

    @Override
    public void print(int level, String msg) {
        LogRecord record = this.createLogRecord(level, msg);
        if (record != null) {
            RmaDefs.loggerRatingManager.log(record);
        }
    }

    private LogRecord createLogRecord(int logLevel, String msg) {
        Level level = LogLevels.toLevel(logLevel);
        LogRecord record = null;
        if (level != null) {
            record = new LogRecord(level, msg);
            this.inferCaller(record);
        }
        return record;
    }

    private void inferCaller(LogRecord record) {
        StackTraceElement frame;
        String cname;
        int ix;
        String thisClassName = this.getClass().getName();
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        for (ix = 0; ix < stack.length && !(cname = (frame = stack[ix]).getClassName()).equals(thisClassName); ++ix) {
        }
        while (ix < stack.length && (cname = (frame = stack[ix]).getClassName()).equals(thisClassName)) {
            ++ix;
        }
        while (ix < stack.length) {
            frame = stack[ix];
            String mname = frame.getMethodName();
            if (!mname.startsWith("print")) {
                record.setSourceClassName(frame.getClassName());
                record.setSourceMethodName(mname);
                break;
            }
            ++ix;
        }
    }

    @Override
    public void setLevel(int logLevel) {
    }
}

