/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.proxy;

import com.ericsson.ere.proxy.AbstractEreProxy;
import com.ericsson.ere.proxy.EreProxy;
import com.ericsson.ere.proxy.EreProxyManager;
import com.ericsson.ere.proxy.InternalEreProxy;
import com.ericsson.ere.proxy.ProgressWrapper;
import com.ericsson.ere.proxy.ServiceListProxy;
import com.ericsson.ere.proxy.ServiceProviderListProxy;
import ericsson.ere.integration.connector.AbstractConnector;
import ericsson.ere.integration.connector.EreCommunicationException;
import ericsson.ere.integration.settingsmap.SettingsMap;

public class RatingManagerProxy
extends AbstractEreProxy {
    private static final String UNKNOWN = "unknown";
    private transient ServiceListProxy myServiceListProxy = null;
    private transient ServiceProviderListProxy myServiceProviderListProxy = null;
    private transient EreProxy parentProxy = null;

    public RatingManagerProxy(AbstractConnector connector, EreProxy parentProxy) {
        ProgressWrapper[] progressArray = EreProxyManager.getInstance().getProgressWrapper().splitProgress(new int[]{1, 10, 1});
        progressArray[0].setInfo("Building RatingManagerProxy");
        this.connector = connector;
        this.parentProxy = parentProxy;
        if (connector != null) {
            this.setName(connector.getRatingManagerName());
        }
        this.myURI = this.buildURI(AbstractEreProxy.URIScheme.MANAGER);
        if (this.getAbortRefresh()) {
            return;
        }
        this.refresh();
        EreProxyManager.getInstance().setProgressWrapper(progressArray[0]);
        this.myServiceListProxy = connector.getProxyFactory().createServiceListProxy(connector, this);
        progressArray[0].progressFinished();
        EreProxyManager.getInstance().setProgressWrapper(progressArray[1]);
        this.myServiceProviderListProxy = connector.getProxyFactory().createServiceProviderListProxy(connector, this);
        progressArray[1].progressFinished();
    }

    public RatingManagerProxy(AbstractConnector connector, InternalEreProxy parentProxy) {
        ProgressWrapper progress = EreProxyManager.getInstance().getProgressWrapper();
        this.connector = connector;
        this.parentProxy = parentProxy;
        progress.progressIncrement();
        this.setName(connector.getRatingManagerName());
        this.myURI = this.buildURI(AbstractEreProxy.URIScheme.MANAGER);
        if (this.getAbortRefresh()) {
            return;
        }
        this.refresh();
        progress.progressIncrement();
        this.myServiceListProxy = connector.getProxyFactory().createServiceListProxy(connector, this);
        this.myServiceProviderListProxy = connector.getProxyFactory().createServiceProviderListProxy(connector, this);
        progress.progressIncrement();
    }

    @Override
    public void refresh() {
        this.myEreSettings.clear();
        String name = this.connector.getRatingManagerName();
        this.setName(name);
    }

    public void updateRatingManager(SettingsMap model) throws EreCommunicationException {
        this.connector.updateRatingManager(this, model);
    }

    public ServiceListProxy getServiceListProxy() {
        return this.myServiceListProxy;
    }

    @Deprecated
    public String getRatingManagerName() {
        return this.getName();
    }

    public String getProperty(String key) {
        return this.connector.getProperty(key);
    }

    public ServiceProviderListProxy getServiceProviderListProxy() {
        return this.myServiceProviderListProxy;
    }

    @Override
    public RatingManagerProxy getRatingManagerProxy() {
        return this;
    }

    @Override
    protected AbstractEreProxy getAbstractParentProxy() {
        return this.parentProxy;
    }

    @Override
    public boolean isImportableUnder(AbstractEreProxy destination) {
        return destination instanceof RatingManagerProxy;
    }

    @Override
    protected String getURIPath() {
        String path = UNKNOWN;
        if (this.parentProxy != null) {
            path = this.parentProxy.getURIPath();
        }
        return path;
    }
}

