/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.proxy;

import com.ericsson.ere.dataset.DefaultDataSetFactory;
import com.ericsson.ere.defs.GuiService;
import com.ericsson.ere.gui.simulator.GroupedDataSetSimulationFactory;
import com.ericsson.ere.proxy.AbstractEreProxy;
import com.ericsson.ere.proxy.EreProxyManager;
import com.ericsson.ere.proxy.ProgressWrapper;
import com.ericsson.ere.proxy.RatingManagerProxy;
import com.ericsson.ere.proxy.RatingPlanProxy;
import com.ericsson.ere.proxy.ServiceListProxy;
import com.ericsson.ere.proxy.ServiceProviderProxy;
import com.ericsson.ere.proxy.event.ProxyPropertyEvent;
import com.ericsson.ere.proxy.exception.ServiceValidationException;
import com.ericsson.ere.util.RemotePropertyDefinitions;
import ericsson.ere.datatype.Time;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.gui.Config;
import ericsson.ere.integration.connector.AbstractConnector;
import ericsson.ere.integration.connector.EreCommunicationException;
import ericsson.ere.integration.connector.EreConnector;
import ericsson.ere.integration.connector.ServiceConnector;
import ericsson.ere.integration.connector.http.RemotePropertyHandler;
import ericsson.ere.integration.settingsmap.Parameter;
import ericsson.ere.integration.settingsmap.SettingsMap;
import ericsson.ere.management.Service;
import ericsson.ere.util.StringUtil;
import ericsson.ere.xml.XMLUtil;
import java.io.File;
import java.util.Vector;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ServiceProxy
extends AbstractEreProxy {
    private transient ServiceListProxy parentProxy = null;
    public static final String TAG_SERVICEDEFINITION = "ServiceDefinition";
    public static final String TAG_SETTING = "Settings";

    public ServiceProxy(AbstractConnector anyConnector, ServiceListProxy parentProx, String serviceName) throws EreCommunicationException {
        this.connector = anyConnector;
        this.parentProxy = parentProx;
        this.setName(serviceName);
        this.myURI = this.buildURI(AbstractEreProxy.URIScheme.SERVICE);
        this.refresh();
    }

    @Override
    public void refresh() throws EreCommunicationException {
        ProgressWrapper progress = EreProxyManager.getInstance().getProgressWrapper();
        progress.setInfo("Building ServiceProxy");
        String serviceName = this.getName();
        this.myEreSettings = new SettingsMap();
        this.setName(serviceName);
        Element serviceListElement = this.connector.getServiceListElement();
        Element serviceElement = null;
        try {
            XPath xPath = XPathFactory.newInstance().newXPath();
            String pattern = "Service[@Name='" + serviceName + "']";
            serviceElement = (Element)xPath.evaluate(pattern, serviceListElement, XPathConstants.NODE);
        }
        catch (Exception e) {
            throw new EreCommunicationException((EreConnector)this.connector, e.getMessage(), e);
        }
        String definitionFile = serviceElement.getAttribute("DefinitionFile");
        String conditionFile = serviceElement.getAttribute("ConditionFile");
        try {
            this.myEreSettings.setParameter("Service definition file", StringUtil.convertFilePathString(definitionFile), 1, true);
            this.myEreSettings.setParameter("Service condition file", StringUtil.convertFilePathString(conditionFile), 1, true);
            progress.progressIncrement();
        }
        catch (Exception e) {
            throw new EreCommunicationException((EreConnector)this.connector, e.getMessage(), e);
        }
    }

    public Element getServiceXML() throws EreCommunicationException {
        return this.connector.getServiceElement(this.getName());
    }

    public String getId() {
        return this.getName();
    }

    public Service instantiateServiceObject() throws Exception {
        GuiService serviceObject = new GuiService(this.getName(), this);
        serviceObject.startService(this.getServiceDefinition());
        return serviceObject;
    }

    public static void prepareXMLForServiceCreation(Element configurationXML) throws ServiceValidationException {
        try {
            String serviceName = configurationXML.getAttribute("Name");
            Element structureElement = XMLUtil.getFirstElementNamed(TAG_SERVICEDEFINITION, configurationXML);
            Element conditionElement = XMLUtil.getFirstElementNamed(TAG_SETTING, configurationXML);
            if (conditionElement == null) {
                throw new ServiceValidationException("Could not find a Settings element in the service XML.");
            }
            if (conditionElement.getParentNode() != structureElement) {
                structureElement.appendChild(conditionElement);
            }
            Service tService = new Service(serviceName);
            tService.startService(structureElement, conditionElement);
        }
        catch (ServiceValidationException svex) {
            throw svex;
        }
        catch (Exception e) {
            throw new ServiceValidationException("The service XML is not valid (" + e.getMessage() + ").", e);
        }
    }

    @Deprecated
    public static boolean xmlIsValidForService(Element configurationXML) {
        try {
            String serviceName = configurationXML.getAttribute("Name");
            Element structureElement = XMLUtil.getNamedElement(TAG_SERVICEDEFINITION, configurationXML.getChildNodes());
            Element conditionElement = XMLUtil.getNamedElement(TAG_SETTING, configurationXML.getChildNodes());
            if (conditionElement == null) {
                conditionElement = XMLUtil.getNamedElement(TAG_SETTING, structureElement.getChildNodes());
            }
            Service tService = new Service(serviceName);
            tService.startService(structureElement, conditionElement);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public Element getServiceDefinition() throws EreCommunicationException {
        Element elementToReturn = null;
        Element serviceElement = null;
        serviceElement = this.getServiceXML();
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            elementToReturn = (Element)xpath.evaluate("//Service/ServiceDefinition", serviceElement, XPathConstants.NODE);
            Element settingsElement = (Element)xpath.evaluate("//Service/Settings", serviceElement, XPathConstants.NODE);
            if (settingsElement != null) {
                elementToReturn.appendChild(settingsElement);
            }
        }
        catch (Exception e) {
            throw new EreCommunicationException((EreConnector)this.connector, "Could not understand the service definition XML: " + e.getMessage(), e);
        }
        if (elementToReturn == null) {
            throw new EreCommunicationException(this.connector, "Could not understand the service definition XML: NO ServiceDefinition tag found.");
        }
        return elementToReturn;
    }

    public Element getServiceCondition() throws EreCommunicationException {
        Element elementToReturn = null;
        Element serviceElement = null;
        serviceElement = this.getServiceXML();
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            elementToReturn = (Element)xpath.evaluate("//Service/ServiceDefinition/Settings", serviceElement, XPathConstants.NODE);
            if (elementToReturn == null) {
                elementToReturn = (Element)xpath.evaluate("//Service/Settings", serviceElement, XPathConstants.NODE);
            }
        }
        catch (Exception e) {
            throw new EreCommunicationException((EreConnector)this.connector, "Could not understand the service definition XML: " + e.getMessage(), e);
        }
        if (elementToReturn == null) {
            throw new EreCommunicationException(this.connector, "Could not understand the service definition XML: NO Settings tag found.");
        }
        return elementToReturn;
    }

    public String getServiceDefinitionFileName() {
        return this.myEreSettings.getParameterAsString("Service definition file");
    }

    public ServiceConnector getServiceConnector() throws EreCommunicationException {
        return this.connector.getServiceConnector(this);
    }

    public String getServiceConditionFileName() {
        return this.myEreSettings.getParameterAsString("Service condition file");
    }

    public String getConnectorId() {
        return this.connector.getId();
    }

    public boolean isServiceUsed() {
        Vector<ServiceProviderProxy> serviceProviders = this.getRatingManagerProxy().getServiceProviderListProxy().getServiceProviderList();
        for (ServiceProviderProxy serviceProvider : serviceProviders) {
            Vector<RatingPlanProxy> ratingPlans = serviceProvider.getRatingPlanList();
            for (RatingPlanProxy ratingPlan : ratingPlans) {
                if (!ratingPlan.getServiceName().equals(this.getName())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public RatingManagerProxy getRatingManagerProxy() {
        return this.parentProxy.getRatingManagerProxy();
    }

    @Override
    protected AbstractEreProxy getAbstractParentProxy() {
        return this.parentProxy;
    }

    @Deprecated
    public ClassRepository getClassRepository() {
        return null;
    }

    public void updateService(SettingsMap model) throws EreCommunicationException {
        if (!this.isServiceUsed()) {
            boolean updated = false;
            ServiceConnector serviceConnector = this.connector.getServiceConnector(this);
            if (serviceConnector instanceof RemotePropertyHandler) {
                String newName = model.getParameter("Name").getValue();
                try {
                    ((RemotePropertyHandler)((Object)serviceConnector)).setRemoteProperty(RemotePropertyDefinitions.SERVICE_NAME_KEY, newName);
                    updated = true;
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
            }
            if (!updated) {
                this.connector.updateService(this, model);
            }
            this.myEreSettings.updateParametersFrom(model);
            this.triggerRefresh();
            this.getEreProxy().fireProxyPropertyEvent(new ProxyPropertyEvent(this));
        }
    }

    public void updateService(Element structureElement, Element conditionElement, boolean forceUpdate) throws EreCommunicationException {
        this.connector.getServiceConnector(this).updateService(structureElement, conditionElement, forceUpdate);
        this.triggerRefresh();
    }

    public void updateService(Element structureElement, Element conditionElement, SettingsMap settings, boolean forceUpdate) throws EreCommunicationException {
        Parameter definitionParameter = settings.getParameter("Service definition file");
        String file = definitionParameter.getValue();
        if (file.contains(File.separator)) {
            file = file.substring(file.lastIndexOf(File.separator) + 1, file.length());
        }
        definitionParameter.setLocked(false);
        definitionParameter.setValue(file);
        definitionParameter.setLocked(true);
        this.connector.getServiceConnector(this).updateService(structureElement, conditionElement, settings, forceUpdate);
        this.triggerRefresh();
    }

    private void triggerRefresh() throws EreCommunicationException {
        this.getEreProxy().refreshRatingManagerDocument();
        this.refresh();
    }

    public static Element createDefaultServiceDefinitionXML(String serviceName) throws Exception {
        try {
            Time date = new Time();
            Document newSD = XMLUtil.getEmptyDocument();
            Element sdElement = newSD.createElement(TAG_SERVICEDEFINITION);
            sdElement.setAttribute("Service", serviceName.trim());
            Element createDateElement = newSD.createElement("CreatedDate");
            createDateElement.setAttribute("date", date.toString());
            Element savedDateElement = newSD.createElement("SavedDate");
            savedDateElement.setAttribute("date", date.toString());
            Element descriptionElement = newSD.createElement("Description");
            Element dataSetFactoryElement = newSD.createElement("DataSetFactory");
            dataSetFactoryElement.setAttribute("class", DefaultDataSetFactory.class.getName());
            Element simulationFactoryElement = newSD.createElement("SimulationFactory");
            simulationFactoryElement.setAttribute("class", GroupedDataSetSimulationFactory.class.getName());
            Element fieldsElement = newSD.createElement("Fields");
            sdElement.appendChild(createDateElement);
            sdElement.appendChild(savedDateElement);
            sdElement.appendChild(descriptionElement);
            sdElement.appendChild(dataSetFactoryElement);
            sdElement.appendChild(simulationFactoryElement);
            sdElement.appendChild(simulationFactoryElement);
            sdElement.appendChild(fieldsElement);
            return sdElement;
        }
        catch (Exception e) {
            throw new Exception("Failed to create new ServiceDefinition XML", e);
        }
    }

    public static Element createDefaultServiceConditionXML() throws Exception {
        try {
            Vector<Node> vector = Config.getInstance().getConfigFor("DefaultServiceCondition");
            if (vector == null || vector.size() == 0) {
                Document newDS = XMLUtil.getEmptyDocument();
                Element settingsElement = newDS.createElement(TAG_SETTING);
                Element structuresElement = newDS.createElement("TariffStructures");
                Element structureElement = newDS.createElement("TariffStructure");
                structureElement.setAttribute("name", "TariffStructure");
                structureElement.setAttribute("class", "ericsson.ere.RatingStructure");
                structureElement.setAttribute("profile", "ericsson.ere.RatingStructureProfile");
                Element nodesElement = newDS.createElement("Nodes");
                Element nodeDefsElement = newDS.createElement("Node");
                nodeDefsElement.setAttribute("name", "Defs");
                nodeDefsElement.setAttribute("class", "ericsson.ere.statement.DefsStatement");
                nodeDefsElement.setAttribute("profile", "ericsson.ere.statement.DefsStatementProfile");
                Element nodeNodeElement = newDS.createElement("Node");
                nodeDefsElement.setAttribute("name", "Defs");
                nodeDefsElement.setAttribute("class", "ericsson.ere.statement.NodeStatement");
                nodeDefsElement.setAttribute("profile", "ericsson.ere.statement.NodeStatementProfile");
                Element genericElement = newDS.createElement("GenericConditions");
                Element modifiersElement = newDS.createElement("Modifiers");
                settingsElement.appendChild(structuresElement);
                structuresElement.appendChild(structureElement);
                nodesElement.appendChild(nodeDefsElement);
                nodesElement.appendChild(nodeNodeElement);
                settingsElement.appendChild(nodesElement);
                settingsElement.appendChild(genericElement);
                settingsElement.appendChild(modifiersElement);
                return settingsElement;
            }
            return (Element)vector.get(0);
        }
        catch (Exception e) {
            throw new Exception("Failed to create new Plug-in tree", e);
        }
    }

    public static void createFileRef(SettingsMap settings) {
        String serviceName = settings.getParameterAsString("Name");
        String definitionRef = ServiceProxy.fixFileName(serviceName) + "_Definition";
        String conditionRef = ServiceProxy.fixFileName(serviceName) + "_Condition";
        settings.setParameter("Service definition file", definitionRef);
        settings.setParameter("Service condition file", conditionRef);
    }

    private static String fixFileName(String str) {
        return str.replace(' ', '_');
    }

    @Override
    public boolean isImportableUnder(AbstractEreProxy destination) {
        return destination instanceof ServiceProxy || destination instanceof ServiceListProxy || destination instanceof RatingManagerProxy;
    }

    @Override
    public String getDefaultWindowTitle() {
        return "Service - " + this.getId() + "[" + this.getConnectorId() + "]";
    }
}

