/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree;

import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.TariffStructureNodeCache;
import com.ericsson.ere.selectiontree.conditions.AbstractCondition;
import com.ericsson.ere.selectiontree.conditions.ConditionLink;
import com.ericsson.ere.selectiontree.interfaces.ExecutableNode;
import com.ericsson.ere.selectiontree.interfaces.MutableCondition;
import com.ericsson.ere.selectiontree.interfaces.MutableModifier;
import com.ericsson.ere.selectiontree.interfaces.MutableStatement;
import com.ericsson.ere.selectiontree.interfaces.MutableTariffStructure;
import com.ericsson.ere.selectiontree.interfaces.SelectionTreeNodeFactory;
import com.ericsson.ere.selectiontree.interfaces.SelectionTreeNodeMigrator;
import com.ericsson.ere.selectiontree.modifiers.AbstractModifier;
import com.ericsson.ere.selectiontree.modifiers.ModifierLink;
import com.ericsson.ere.selectiontree.statements.AbstractNodeStatement;
import com.ericsson.ere.selectiontree.statements.DefsStatement;
import com.ericsson.ere.selectiontree.statements.ImmutableNodeStatement;
import com.ericsson.ere.selectiontree.statements.Statement;
import com.ericsson.ere.selectiontree.statements.StatementLink;
import com.ericsson.ere.selectiontree.structures.AbstractTariffStructure;
import com.ericsson.ere.selectiontree.structures.ChainMigrator;
import com.ericsson.ere.selectiontree.structures.DefaultMigrator;
import com.ericsson.ere.selectiontree.structures.ImmutableDefaultTreeStructure;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.EreClassLoader;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.interfaces.Condition;
import ericsson.ere.interfaces.TariffStructure;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.interfaces.XMLInitializable;
import ericsson.ere.statement.NodeStatement;
import ericsson.ere.util.NodeListIterable;
import ericsson.ere.xml.XMLUtil;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SelectionTreeNodeFactoryImpl
implements SelectionTreeNodeFactory {
    private static final TariffStructureNode[] NO_CHILDREN = new TariffStructureNode[0];
    public static final String USE_CLASS_INFO_CACHE = "ERE.STFUseClassInfoCache";
    public final ClassRepository myClassRepository;
    private final String myRatingPlanName;
    private final TariffStructureNodeCache myNodeCache;
    private final MyParseContext myParseContext = new MyParseContext();
    private static Map<String, ClassInfo> myClassInfo;
    private final SelectionTreeNodeMigrator myMigrator;

    public SelectionTreeNodeFactoryImpl(ClassRepository rep) {
        this(rep, null);
    }

    public SelectionTreeNodeFactoryImpl(ClassRepository rep, String ratingPlan) {
        this.myClassRepository = rep;
        this.myRatingPlanName = ratingPlan;
        this.myNodeCache = SelectionTreeNodeFactoryImpl.createCache(rep);
        this.myMigrator = new ChainMigrator(new DefaultMigrator(), this.myClassRepository.getMigrator());
    }

    static TariffStructureNodeCache createCache(ClassRepository rep) {
        TariffStructureNodeCache cache = null;
        try {
            cache = (TariffStructureNodeCache)((Object)rep.createUtil("NodeCache", "NodeCache"));
            if (cache != null) {
                cache.setClassRepository(rep);
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        return cache;
    }

    private void connect(TariffStructureNode parent, TariffStructureNode child) throws Exception {
        if (parent instanceof AbstractTariffStructure) {
            AbstractTariffStructure structure = (AbstractTariffStructure)parent;
            structure.add((ExecutableNode)((Object)child));
        } else if (parent instanceof MutableTariffStructure) {
            MutableTariffStructure structure = (MutableTariffStructure)((Object)parent);
            structure.add((Statement)child);
        } else if (parent instanceof TariffStructure) {
            TariffStructure structure = (TariffStructure)parent;
            structure.add((ericsson.ere.statement.Statement)child);
        } else if (parent instanceof DefsStatement) {
            parent.insertChildAt(parent.getChildCount(), child);
        } else if (parent instanceof AbstractNodeStatement) {
            AbstractNodeStatement nodeStatement = (AbstractNodeStatement)parent;
            nodeStatement.add(child);
        } else if (parent instanceof ericsson.ere.statement.Statement) {
            ericsson.ere.statement.Statement statement = (ericsson.ere.statement.Statement)parent;
            statement.add((XMLInitializable)((Object)child));
        } else if (parent instanceof Condition) {
            Condition cond = (Condition)((Object)parent);
            cond.add((Condition)((Object)child));
        } else if (parent instanceof ericsson.ere.interfaces.Modifier) {
            ericsson.ere.interfaces.Modifier mod = (ericsson.ere.interfaces.Modifier)((Object)parent);
            mod.add((ericsson.ere.interfaces.Modifier)((Object)child));
        } else {
            throw new IllegalArgumentException("Unknown parent node class: " + parent.getClass());
        }
    }

    protected boolean isLink(Node config) {
        return "link".equals(this.getNodeType(config));
    }

    private String getNodeType(Node iterator) {
        Node typeAttr;
        NamedNodeMap attr = null;
        if (iterator.hasAttributes()) {
            attr = iterator.getAttributes();
        }
        if (attr != null && (typeAttr = attr.getNamedItem("type")) != null) {
            return typeAttr.getNodeValue();
        }
        return null;
    }

    @Override
    public TariffStructureNode createCondition(Node iterator, TariffStructureNode[] children) throws InstantiationException, IllegalAccessException, ClassNotFoundException, Exception {
        this.myMigrator.migrateCondition(iterator);
        if ("link".equals(this.getNodeType(iterator))) {
            return this.createConditionLink(iterator);
        }
        String name = XMLUtil.getFirstTextContent(iterator);
        String classname = this.getConditionClassName(this.myClassRepository, name);
        if (classname == null) {
            throw new InstantiationException("Condition " + name + " not found in repository");
        }
        ClassInfo ci = this.getClassInfo(classname);
        Class<?> conditionClass = ci.cls;
        Method creator = ci.createMethod;
        TariffStructureNode condition = null;
        if (creator != null) {
            condition = (TariffStructureNode)creator.invoke(null, this.createParseContext(iterator), children);
        } else {
            XMLInitializable xi = (XMLInitializable)conditionClass.newInstance();
            if (xi instanceof MutableCondition) {
                this.initMutableCondition(name, (MutableCondition)((Object)xi));
            }
            XMLInitializable cond = xi.init(iterator);
            condition = (TariffStructureNode)((Object)cond);
        }
        if (creator == null) {
            for (TariffStructureNode c : children) {
                this.connect(condition, c);
            }
        }
        return condition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassInfo getClassInfo(String className) throws ClassNotFoundException {
        ClassInfo ci;
        if (!SelectionTreeNodeFactoryImpl.isClassInfoCacheEnabled()) {
            ci = this.createClassInfo(className);
        } else {
            Map<String, ClassInfo> map = myClassInfo;
            synchronized (map) {
                ci = myClassInfo.get(className);
                if (ci == null) {
                    ci = this.createClassInfo(className);
                    myClassInfo.put(className, ci);
                }
            }
        }
        return ci;
    }

    private ClassInfo createClassInfo(String className) throws ClassNotFoundException {
        Class<?> cls = EreClassLoader.getClass(className);
        Method creator = SelectionTreeNodeFactoryImpl.getCreateMethod(cls);
        return new ClassInfo(cls, creator);
    }

    public static boolean isClassInfoCacheEnabled() {
        String value = System.getProperty(USE_CLASS_INFO_CACHE, "true");
        return Boolean.parseBoolean(value);
    }

    private TariffStructureNode createConditionLink(Node iterator) throws Exception {
        if (this.myClassRepository.isUsingDataSet()) {
            return (TariffStructureNode)((Object)new ConditionLink().init(iterator));
        }
        return (TariffStructureNode)((Object)new ericsson.ere.condition.ConditionLink().init(iterator));
    }

    protected void initMutableCondition(String name, MutableCondition mc) {
        mc.setTypename(name);
        if (mc instanceof AbstractCondition) {
            ((AbstractCondition)mc).setAlias(this.myClassRepository.getAliasForCondition(name));
        }
        if (mc.needsFieldToBeSet()) {
            String fieldName = this.getConditionFieldName(this.myClassRepository, name);
            mc.setFieldName(fieldName);
            FieldDefinition fd = this.myClassRepository.getFieldDefinitionByName(fieldName);
            if (fd != null && fd.usesTagNumber()) {
                mc.setTag(fd.getTagNumber());
            }
        }
        if (mc.needsClassRepository()) {
            mc.setClassRepository(this.myClassRepository);
        }
    }

    protected String getConditionClassName(ClassRepository repository, String name) {
        return repository.getConditionClassName(name);
    }

    protected String getConditionFieldName(ClassRepository repository, String name) {
        return repository.getConditionFieldName(name);
    }

    protected void initMutableModifier(String name, MutableModifier mm) {
        mm.setTypename(name);
        if (mm instanceof AbstractModifier) {
            ((AbstractModifier)mm).setAlias(this.myClassRepository.getAliasForCondition(name));
        }
        if (mm.needsClassRepository()) {
            mm.setClassRepository(this.myClassRepository);
        }
        mm.setRatingPlan(this.myRatingPlanName);
    }

    @Override
    public TariffStructureNode createModifier(Node iterator, TariffStructureNode[] children) throws InstantiationException, IllegalAccessException, ClassNotFoundException, Exception {
        TariffStructureNode modifier;
        this.myMigrator.migrateModifier(iterator);
        if ("link".equals(this.getNodeType(iterator))) {
            return this.createModifierLink(iterator);
        }
        String name = XMLUtil.getFirstTextContent(iterator);
        String classname = this.myClassRepository.getModifierClassName(name);
        if (classname == null) {
            throw new InstantiationException("Modifier " + name + " not found in repository");
        }
        ClassInfo ci = this.getClassInfo(classname);
        Class<?> modifierClass = ci.cls;
        Method creator = ci.createMethod;
        if (creator != null) {
            modifier = (TariffStructureNode)creator.invoke(null, this.createParseContext(iterator), children);
        } else {
            XMLInitializable xi = (XMLInitializable)modifierClass.newInstance();
            if (xi instanceof MutableModifier) {
                this.initMutableModifier(name, (MutableModifier)((Object)xi));
            }
            XMLInitializable mod = xi.init(iterator);
            modifier = (TariffStructureNode)((Object)mod);
        }
        if (creator == null) {
            for (TariffStructureNode c : children) {
                this.connect(modifier, c);
            }
        }
        return modifier;
    }

    private TariffStructureNode createModifierLink(Node iterator) throws Exception {
        if (this.myClassRepository.isUsingDataSet()) {
            return (TariffStructureNode)((Object)new ModifierLink().init(iterator));
        }
        return (TariffStructureNode)((Object)new ericsson.ere.leaf.ModifierLink().init(iterator));
    }

    @Override
    public TariffStructureNode createNode(Node iterator, TariffStructureNode[] children) throws InstantiationException, IllegalAccessException, ClassNotFoundException, Exception {
        String type;
        this.myMigrator.migrateNode(iterator);
        String classname = this.myClassRepository.getNodeTypeClassName("Node");
        if (classname == null) {
            classname = this.myClassRepository.isUsingDataSet() ? ImmutableNodeStatement.class.getName() : NodeStatement.class.getName();
        }
        if ("link".equals(type = this.getNodeType(iterator))) {
            return this.createStatementLink(iterator);
        }
        if (type != null && (classname = this.myClassRepository.getNodeTypeClassName(type)) == null) {
            throw new InstantiationException("Node type " + type + " not found in repository.");
        }
        ClassInfo ci = this.getClassInfo(classname);
        Class<?> statementClass = ci.cls;
        Method creator = ci.createMethod;
        TariffStructureNode stmt = null;
        if (creator != null) {
            stmt = (TariffStructureNode)creator.invoke(null, this.createParseContext(iterator), children);
        } else {
            XMLInitializable xi = (XMLInitializable)statementClass.newInstance();
            XMLInitializable mod = xi.init(iterator);
            stmt = (TariffStructureNode)((Object)mod);
        }
        if (stmt instanceof MutableStatement) {
            String name = XMLUtil.getFirstTextContent(iterator);
            ((MutableStatement)((Object)stmt)).setName(name);
        }
        if (creator == null) {
            for (TariffStructureNode c : children) {
                this.connect(stmt, c);
            }
        }
        return stmt;
    }

    private TariffStructureNode createStatementLink(Node iterator) throws Exception {
        if (this.myClassRepository.isUsingDataSet()) {
            return (TariffStructureNode)((Object)new StatementLink().init(iterator));
        }
        return (TariffStructureNode)((Object)new ericsson.ere.statement.StatementLink().init(iterator));
    }

    @Override
    public TariffStructureNode createTariffStructure(Node iterator, TariffStructureNode[] children) throws InstantiationException, IllegalAccessException, ClassNotFoundException, Exception {
        String type;
        this.myMigrator.migrateTariffStructure(iterator);
        String classname = this.myClassRepository.getTariffStructureClassName("TariffStructure");
        if (classname == null) {
            classname = ImmutableDefaultTreeStructure.class.getName();
        }
        if ("link".equals(type = this.getNodeType(iterator))) {
            throw new IllegalArgumentException("Linked RatingStructures not implemented");
        }
        if (type != null && (classname = this.myClassRepository.getTariffStructureClassName(type)) == null) {
            throw new InstantiationException("RatingStructure type " + type + " not found in repository.");
        }
        ClassInfo ci = this.getClassInfo(classname);
        Class<?> structureClass = ci.cls;
        Method creator = ci.createMethod;
        TariffStructureNode ts = null;
        if (creator != null) {
            ts = (TariffStructureNode)creator.invoke(null, this.createParseContext(iterator), children);
        } else {
            TariffStructure struct = (TariffStructure)structureClass.newInstance();
            struct.setClassRepository(this.myClassRepository);
            XMLInitializable mod = struct.init(iterator);
            ts = (TariffStructureNode)((Object)mod);
        }
        if (ts instanceof MutableTariffStructure) {
            ((MutableTariffStructure)((Object)ts)).setClassRepository(this.myClassRepository);
        }
        if (creator == null) {
            for (TariffStructureNode c : children) {
                this.connect(ts, c);
            }
        }
        return ts;
    }

    public static Method getCreateMethod(Class<?> c) {
        Method creator = null;
        try {
            creator = c.getDeclaredMethod("create", ParseContext.class, TariffStructureNode[].class);
            int flags = creator.getModifiers();
            if (!Modifier.isPublic(flags) || !Modifier.isStatic(flags)) {
                throw new IllegalArgumentException("Class " + c.getName() + " declares a non-public and/or non-static create(ParseContext, TariffStructureNode[]) method");
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return creator;
    }

    @Override
    public TariffStructureNode finish(TariffStructureNode structure) {
        if (this.myNodeCache != null) {
            return this.myNodeCache.optimize(structure);
        }
        return structure;
    }

    @Override
    public void prepare(Node structureConfig) {
        block3: {
            try {
                this.createTariffStructure(structureConfig, NO_CHILDREN);
            }
            catch (Exception ex) {
                Element fieldsElement = XMLUtil.getNamedElement("Fields", structureConfig.getChildNodes());
                if (fieldsElement == null) break block3;
                NodeList fieldsList = fieldsElement.getChildNodes();
                for (Node node : new NodeListIterable(fieldsList, 1)) {
                    String fieldName;
                    Element field = (Element)node;
                    if (!"INTERNAL".equals(XMLUtil.getAttributeFromElement(field, "ParameterType", null)) || this.myClassRepository.getFieldDefinitionByName(fieldName = XMLUtil.getAttributeFromElement(field, "Name", null)) != null) continue;
                    this.myClassRepository.addField(field);
                }
            }
        }
    }

    protected final ParseContext createParseContext(Node config) {
        return this.createParseContext(this.myClassRepository, this.myRatingPlanName, config);
    }

    protected ParseContext createParseContext(ClassRepository repository, String ratingPlan, Node config) {
        this.myParseContext.setCurrentNode(config);
        return this.myParseContext;
    }

    static {
        if (SelectionTreeNodeFactoryImpl.isClassInfoCacheEnabled()) {
            myClassInfo = new HashMap<String, ClassInfo>();
        }
    }

    private static class ClassInfo {
        Class<?> cls;
        Method createMethod;

        ClassInfo(Class<?> cls, Method meth) {
            this.cls = cls;
            this.createMethod = meth;
        }
    }

    private final class MyParseContext
    implements ParseContext {
        private Node current;

        private MyParseContext() {
        }

        @Override
        public ClassRepository getClassRepository() {
            return SelectionTreeNodeFactoryImpl.this.myClassRepository;
        }

        @Override
        public Node getXMLNode() {
            return this.current;
        }

        void setCurrentNode(Node iterator) {
            this.current = iterator;
        }

        @Override
        public String getRatingPlanName() {
            return SelectionTreeNodeFactoryImpl.this.myRatingPlanName;
        }
    }
}

