/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.bit;

import com.ericsson.ere.selectiontree.conditions.bit.BitPatternMatcher;
import ericsson.ere.util.StringUtil;

public abstract class AbstractBitPatternMatcher
implements BitPatternMatcher {
    private static final String ALL_ZEROS = "0000000000000000000000000000000000000000000000000000000000000000";

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    @Override
    public abstract boolean match(Number var1);

    @Override
    public abstract boolean matchWithTrace(Number var1, StringBuilder var2);

    public static String getBinaryRepresentation(Number aValue) {
        if (aValue instanceof Short) {
            String binaryString = Integer.toBinaryString(aValue.intValue());
            if (binaryString.length() > 16) {
                return AbstractBitPatternMatcher.insertDots(binaryString.substring(16));
            }
            return AbstractBitPatternMatcher.insertDots(ALL_ZEROS.substring(binaryString.length() + 48) + binaryString);
        }
        if (aValue instanceof Integer) {
            String binaryString = Integer.toBinaryString(aValue.intValue());
            if (binaryString.length() == 32) {
                return AbstractBitPatternMatcher.insertDots(binaryString);
            }
            return AbstractBitPatternMatcher.insertDots(ALL_ZEROS.substring(binaryString.length() + 32) + binaryString);
        }
        String binaryString = Long.toBinaryString(aValue.longValue());
        if (binaryString.length() == 64) {
            return AbstractBitPatternMatcher.insertDots(binaryString);
        }
        return AbstractBitPatternMatcher.insertDots(ALL_ZEROS.substring(binaryString.length()) + binaryString);
    }

    public static String getHexadecimalRepresentation(Number aValue) {
        StringBuilder hexStringBuilder = new StringBuilder();
        if (aValue instanceof Short) {
            String hexString = Integer.toHexString(aValue.intValue()).toUpperCase();
            StringUtil.repeat("0", 8 - hexString.length(), hexStringBuilder);
            hexStringBuilder.append(hexString);
            hexStringBuilder.delete(0, 4);
        } else if (aValue instanceof Integer) {
            String hexString = Integer.toHexString(aValue.intValue()).toUpperCase();
            StringUtil.repeat("0", 8 - hexString.length(), hexStringBuilder);
            hexStringBuilder.append(hexString);
        } else {
            String hexString = Long.toHexString(aValue.longValue()).toUpperCase();
            StringUtil.repeat("0", 16 - hexString.length(), hexStringBuilder);
            hexStringBuilder.append(hexString);
        }
        return hexStringBuilder.toString();
    }

    private static String insertDots(String theString) {
        StringBuilder newString = new StringBuilder(theString);
        for (int i = 8; i < newString.length(); i += 8) {
            newString.insert(i++, '.');
        }
        return newString.toString();
    }
}

