/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.date;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.DataSetField;
import com.ericsson.ere.dataset.DataSetValueNotFoundException;
import com.ericsson.ere.datatype.EREDate;
import com.ericsson.ere.datatype.EREDateUtil;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.conditions.ImmutableCondition;
import com.ericsson.ere.selectiontree.conditions.ImmutableFieldMappableCondition;
import com.ericsson.ere.selectiontree.conditions.logic.ImmutableCompoundBoolean;
import com.ericsson.ere.selectiontree.interfaces.FieldKeyIndexUser;
import com.ericsson.ere.selectiontree.interfaces.MillisecondDurationSupport;
import com.ericsson.ere.trace.PluginTraceHelper;
import com.ericsson.ere.trace.TraceDataSet;
import com.ericsson.ere.trace.TracePoint;
import com.ericsson.ere.trace.TraceableV2;
import ericsson.ere.datatype.DataType;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.util.StringUtil;
import ericsson.ere.xml.XMLUtil;
import java.util.Calendar;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Immutable
public final class DayOfWeek
extends ImmutableFieldMappableCondition
implements FieldKeyIndexUser,
TraceableV2,
MillisecondDurationSupport {
    private static final int ONE_DAY_IN_SECONDS = 86400;
    private static final int ONE_DAY_IN_MILLISECONDS = 86400000;
    public static final String[] myPrintableDays = new String[]{"MON", "TUE", "WED", "THU", "FRI", "SAT", "SUN"};
    public static final String[] myOldPrintableDays = new String[]{"0", "1", "2", "3", "4", "5", "6"};
    public static final String TAG_FROM = "From";
    public static final String TAG_TO = "To";
    public static final String[] weekdays = new String[]{"Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"};
    private final int myStartDay;
    private final int myStopDay;

    private DayOfWeek(int startDay, int stopDay, ParseContext ctx) {
        super(ctx);
        this.myStartDay = startDay;
        this.myStopDay = stopDay;
    }

    @Override
    protected DataSetField createDataSetField(ParseContext ctx) {
        return this.createDataSetField(ctx, DataType.DATE);
    }

    public static ImmutableCondition create(ParseContext ctx, TariffStructureNode[] childs) {
        Element toDayNode;
        String toStr;
        byte stopDay;
        Node config = ctx.getXMLNode();
        NodeList children = config.getChildNodes();
        Element fromDayNode = XMLUtil.getNamedElement(TAG_FROM, children);
        String fromStr = XMLUtil.getFirstTextContent(fromDayNode);
        byte startDay = DayOfWeek.getDayOfWeekFromPrintable(fromStr);
        if (startDay > (stopDay = DayOfWeek.getDayOfWeekFromPrintable(toStr = XMLUtil.getFirstTextContent(toDayNode = XMLUtil.getNamedElement(TAG_TO, children))))) {
            TariffStructureNode[] conds = new TariffStructureNode[]{new DayOfWeek(startDay, 6, ctx), new DayOfWeek(0, stopDay, ctx)};
            return ImmutableCompoundBoolean.create(ImmutableCompoundBoolean.OperationType.OR, ctx, conds);
        }
        return new DayOfWeek(startDay, stopDay, ctx);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + this.myStartDay;
        result = 31 * result + this.myStopDay;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass() || !super.equalsImpl(obj)) {
            return false;
        }
        DayOfWeek other = (DayOfWeek)obj;
        if (this.myStartDay != other.myStartDay) {
            return false;
        }
        return this.myStopDay == other.myStopDay;
    }

    private static byte getDayOfWeekFromPrintable(String aDayOfWeekStr) {
        byte ret = 0;
        for (int i = 0; i <= 6; ++i) {
            if (!aDayOfWeekStr.equals(myPrintableDays[i]) && !aDayOfWeekStr.equals(myOldPrintableDays[i])) continue;
            ret = (byte)i;
            break;
        }
        return ret;
    }

    @Override
    public boolean test(DataSet theData) {
        int dayOfWeek;
        try {
            dayOfWeek = this.useCurrentTime() ? this.getDayOfWeek(theData.getCurrentTime()) : this.getDayOfWeek(EREDateUtil.convertToEREDate(this.extractFieldValueFromDataSet(theData, this.myField)));
        }
        catch (DataSetValueNotFoundException ex) {
            return false;
        }
        return dayOfWeek >= this.myStartDay && dayOfWeek <= this.myStopDay;
    }

    private boolean useCurrentTime() {
        return StringUtil.isEmptyString(this.key) || this.key.equals("DayOfWeek");
    }

    private int getDayOfWeek(Calendar cal) {
        int dayOfWeek = cal.get(7) - 2;
        return dayOfWeek < 0 ? 6 : dayOfWeek;
    }

    private int getDayOfWeek(EREDate date) {
        int dayOfWeek = date.getDayOfWeek().ordinal() - 1;
        return dayOfWeek < 0 ? 6 : dayOfWeek;
    }

    @Override
    public long getConditionSatisfiedDuration(DataSet theData) {
        return this.calculateConditionDurationInSeconds(theData, this.myStopDay);
    }

    @Override
    public long getConditionSatisfiedDurationInMilliseconds(DataSet theData) {
        return this.calculateConditionDurationInMilliseconds(theData, this.myStopDay);
    }

    @Override
    public long getConditionUnsatisfiedDuration(DataSet theData) {
        return this.calculateConditionDurationInSeconds(theData, this.myStartDay - 1);
    }

    @Override
    public long getConditionUnsatisfiedDurationInMilliseconds(DataSet theData) {
        return this.calculateConditionDurationInMilliseconds(theData, this.myStartDay - 1);
    }

    private long getSecondsOfDay(Calendar cal) {
        return cal.get(11) * 3600 + cal.get(12) * 60 + cal.get(13);
    }

    private long getMillisecondsOfDay(Calendar cal) {
        return this.getSecondsOfDay(cal) * 1000L + (long)cal.get(14);
    }

    private long calculateConditionDurationInSeconds(DataSet theData, long initialDays) {
        Calendar currentTime = theData.getCurrentTime();
        long days = this.calculateDays(initialDays, currentTime);
        long seconds = this.getSecondsOfDay(currentTime);
        return days * 86400L + 86400L - seconds;
    }

    private long calculateConditionDurationInMilliseconds(DataSet theData, long initialDays) {
        Calendar currentTime = theData.getCurrentTime();
        long days = this.calculateDays(initialDays, currentTime);
        long milliseconds = this.getMillisecondsOfDay(currentTime);
        return days * 86400000L + 86400000L - milliseconds;
    }

    private long calculateDays(long initialDays, Calendar currentTime) {
        int dayOfWeek = this.getDayOfWeek(currentTime);
        long days = initialDays - (long)dayOfWeek;
        if (days < 0L) {
            days += 7L;
        }
        return days;
    }

    @Override
    public String describeTrace(TracePoint tp) {
        TraceDataSet dataSet = TraceDataSet.createPreDataSet(tp);
        String fieldString = null;
        String weekDayString = null;
        try {
            int dayOfWeek;
            if (this.useCurrentTime()) {
                fieldString = "<Current Day>";
                dayOfWeek = this.getDayOfWeek(dataSet.getCurrentTime());
            } else {
                fieldString = this.describeFieldName(dataSet);
                dayOfWeek = this.getDayOfWeek((EREDate)this.extractFieldValueFromDataSet(dataSet, this.myField));
            }
            weekDayString = weekdays[dayOfWeek];
        }
        catch (DataSetValueNotFoundException dataSetValueNotFoundException) {
            // empty catch block
        }
        return this.createTraceDescriptionText("DayOfWeek", fieldString, weekDayString, "is between", weekdays[this.myStartDay] + " and " + weekdays[this.myStopDay]);
    }

    @Override
    public void setPreTracePointInfo(TracePoint tp) {
        if (this.useCurrentTime()) {
            PluginTraceHelper.storeCurrentTimeAsPreDataInTracePoint(tp);
        } else {
            PluginTraceHelper.addFieldValueAsPreDataInTracePoint(this.myField, this.myKeyIndex, tp);
        }
    }

    @Override
    public void setTracePointInfo(TracePoint tp) {
    }

    @Override
    public Set<String> getUsedFields() {
        Set<String> set = super.getUsedFields();
        set.remove("DayOfWeek");
        return set;
    }
}

