/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.field;

import com.ericsson.ere.exception.PluginCreationException;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.interfaces.ConfigurationParameter;
import com.ericsson.ere.selectiontree.interfaces.PluginConfiguration;
import com.ericsson.ere.selectiontree.util.FieldIndexKeyContainer;
import com.ericsson.ere.selectiontree.util.FieldOrientedPluginUtil;
import com.ericsson.ere.selectiontree.util.PluginConfigurationHelper;
import com.ericsson.ere.selectiontree.util.ValueFieldCompositeObject;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.EreClassLoader;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.xml.ElementIterator;
import ericsson.ere.xml.XMLUtil;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FieldSelectionConditionConfiguration
implements PluginConfiguration {
    private static final String ATTR_MISSING_ERROR_FMT = "Attribute '%s' is missing on the Field tag.";
    public static final String ATTR_CONTEXT = "Context";
    public static final String TAG_FIELD = "Field";
    public static final String TAG_INDEX = "Index";
    public static final String ATTR_FIELD = "field";
    public static final String ATTR_CONDITION = "condition";
    public static final String ATTR_CLASS = "class";
    public static final String ATTR_INDEX = "index";
    private final String myContextName;
    private final String myFieldName;
    private final String myBaseConditionName;
    private final FieldIndexKeyContainer myKeyIndex;
    private final ValueFieldCompositeObject myIndexObject;
    private PluginConfiguration myInnerConfig;
    private Node mySavedXMLNode;

    public FieldSelectionConditionConfiguration(ParseContext context) {
        NodeList children = context.getXMLNode().getChildNodes();
        ClassRepository repository = context.getClassRepository();
        Element fieldElement = XMLUtil.getNamedElement(TAG_FIELD, children);
        this.myFieldName = this.getAttributeOrNull(fieldElement, ATTR_FIELD);
        this.myBaseConditionName = this.getAttributeOrNull(fieldElement, ATTR_CONDITION);
        this.myContextName = this.getAttributeOrNull(fieldElement, ATTR_CONTEXT);
        String oldIndex = this.getAttributeOrNull(fieldElement, ATTR_INDEX);
        Element newIndex = XMLUtil.getNamedElement(TAG_INDEX, fieldElement.getChildNodes());
        if (newIndex != null) {
            FieldDefinition field = repository.getFieldDefinitionByName(this.myFieldName);
            this.myIndexObject = FieldOrientedPluginUtil.createValueFieldCompositeObjectFromIndexElement(newIndex);
            this.myKeyIndex = FieldOrientedPluginUtil.extractIndexKeyObjectFromIndexElement(this.myIndexObject, repository, field);
        } else if (oldIndex != null) {
            String indexAttribute = fieldElement.getAttribute(ATTR_INDEX);
            ValueFieldCompositeObject vfco = new ValueFieldCompositeObject(ValueFieldCompositeObject.Mode.Value, indexAttribute);
            this.myKeyIndex = new FieldIndexKeyContainer(vfco, FieldIndexKeyContainer.KeyType.VALUE_LIST, repository);
            this.myIndexObject = new ValueFieldCompositeObject(ValueFieldCompositeObject.Mode.Value, oldIndex);
        } else {
            this.myIndexObject = null;
            this.myKeyIndex = null;
        }
    }

    public FieldSelectionConditionConfiguration(String contextName, String fieldName, String baseCondition, ValueFieldCompositeObject indexObject) {
        this.myContextName = contextName;
        this.myFieldName = fieldName;
        this.myBaseConditionName = baseCondition;
        this.myIndexObject = indexObject;
        this.myKeyIndex = null;
    }

    private FieldSelectionConditionConfiguration(ParseContext context, PluginConfiguration innerConfigInstance) {
        this(context);
        this.myInnerConfig = innerConfigInstance;
        if (innerConfigInstance == null) {
            this.mySavedXMLNode = context.getXMLNode();
        }
    }

    public static PluginConfiguration create(ParseContext context) throws ClassNotFoundException {
        FieldSelectionConditionConfiguration conf;
        FieldSelectionConditionConfiguration temp = new FieldSelectionConditionConfiguration(context);
        String trafficClassName = context.getClassRepository().getBaseConditionClass(temp.getBaseConditionName());
        Class<?> trafficClass = EreClassLoader.getClass(trafficClassName);
        try {
            PluginConfiguration innerConfigInstance = PluginConfigurationHelper.createConfigurationInstance(trafficClass, context);
            conf = new FieldSelectionConditionConfiguration(context, innerConfigInstance);
        }
        catch (IllegalStateException ex) {
            conf = new FieldSelectionConditionConfiguration(context, null);
        }
        catch (InvocationTargetException ex) {
            throw new PluginCreationException("Failed to create a configuration instance for the base condition.", ex, context.getXMLNode());
        }
        return conf;
    }

    @Override
    public void appendXML(Node parent) {
        Document doc = parent.getOwnerDocument();
        Element fieldElement = doc.createElement(TAG_FIELD);
        parent.appendChild(fieldElement);
        fieldElement.setAttribute(ATTR_CONDITION, this.myBaseConditionName);
        if (this.myContextName != null) {
            fieldElement.setAttribute(ATTR_CONTEXT, this.myContextName);
        }
        fieldElement.setAttribute(ATTR_FIELD, this.myFieldName);
        if (this.myIndexObject != null) {
            Element indexElement = parent.getOwnerDocument().createElement(TAG_INDEX);
            fieldElement.appendChild(indexElement);
            this.myIndexObject.appendXML(indexElement);
        }
        if (this.myInnerConfig != null) {
            this.myInnerConfig.appendXML(parent);
        } else if (this.mySavedXMLNode != null) {
            Node copy = doc.importNode(this.mySavedXMLNode, true);
            for (Node child : new ElementIterator(copy.getChildNodes())) {
                if (TAG_FIELD.equals(child.getNodeName())) continue;
                parent.appendChild(child);
            }
        }
    }

    private String getAttributeOrNull(Element e, String attribute) {
        return e.hasAttribute(attribute) ? e.getAttribute(attribute) : null;
    }

    public String getContextName() {
        return this.myContextName;
    }

    public String getFieldName() {
        return this.myFieldName;
    }

    public String getBaseConditionName() {
        return this.myBaseConditionName;
    }

    public FieldIndexKeyContainer getKeyIndex() {
        return this.myKeyIndex;
    }

    public ValueFieldCompositeObject getIndexObject() {
        return this.myIndexObject;
    }

    void requireMandatoryParameters() {
        if (this.myBaseConditionName == null) {
            throw new PluginCreationException(String.format(ATTR_MISSING_ERROR_FMT, ATTR_CONDITION));
        }
        if (this.myFieldName == null) {
            throw new PluginCreationException(String.format(ATTR_MISSING_ERROR_FMT, ATTR_FIELD));
        }
    }

    @Override
    public Object getParameterValue(String name) {
        if (this.myInnerConfig == null) {
            throw new IllegalArgumentException("Unknown parameter: " + name);
        }
        return this.myInnerConfig.getParameterValue(name);
    }

    @Override
    public Collection<ConfigurationParameter> getParameters() {
        return this.myInnerConfig != null ? this.myInnerConfig.getParameters() : Collections.emptyList();
    }

    @Override
    public void setParameterValue(String name, Object value) {
        if (this.myInnerConfig == null) {
            throw new IllegalArgumentException("Unknown parameter: " + name);
        }
        this.myInnerConfig.setParameterValue(name, value);
    }

    @Override
    public String getTypeName() {
        String tn;
        String string = tn = this.myInnerConfig != null ? this.myInnerConfig.getTypeName() : "FieldSelection";
        if (!this.myBaseConditionName.equals(tn)) {
            tn = tn + " (" + this.myBaseConditionName + ")";
        }
        return tn;
    }
}

