/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.field;

import com.ericsson.ere.constraint.contract.AbstractConstrainableProfileContract;
import com.ericsson.ere.constraint.contract.ConstrainableProfileContract;
import com.ericsson.ere.constraint.contract.ConstraintSpecification;
import com.ericsson.ere.constraint.entity.Constraint;
import com.ericsson.ere.constraint.entity.ConstraintContext;
import com.ericsson.ere.constraint.entity.ConstraintContextItem;
import com.ericsson.ere.constraint.entity.ConstraintContextItemType;
import com.ericsson.ere.constraint.entity.ConstraintTarget;
import com.ericsson.ere.constraint.entity.ConstraintTargetType;
import com.ericsson.ere.selectiontree.HierarchicalFieldFilter;
import com.ericsson.ere.selectiontree.conditions.field.FieldSelectionConditionProfile;
import com.ericsson.ere.selectiontree.util.AvailableFieldListBuilder;
import com.ericsson.ere.selectiontree.util.ClassRepositoryHelper;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.interfaces.FieldHierarchyNode;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FieldSelectionConditionProfileContract
extends AbstractConstrainableProfileContract {
    private FieldSelectionConditionProfileContract(ClassRepository repository) {
        super(repository);
    }

    public static ConstrainableProfileContract create(ClassRepository repository) {
        return new FieldSelectionConditionProfileContract(repository);
    }

    @Override
    public Set<ConstraintSpecification> supportedConstraintSpecifications() {
        ConstraintSpecification t1 = ConstraintSpecification.of(ConstraintTargetType.FIELD, new ConstraintContextItemType[0]);
        ConstraintSpecification t2 = ConstraintSpecification.buildSpecificationWithTarget(ConstraintTargetType.CONDITION).withContext(ConstraintContextItemType.FIELD).andAdditionalActions(Constraint.Action.SELECT).build();
        ConstraintSpecification t3 = ConstraintSpecification.of(ConstraintTargetType.FEATURE, new ConstraintContextItemType[0]);
        HashSet<ConstraintSpecification> set = new HashSet<ConstraintSpecification>();
        set.add(t1);
        set.add(t2);
        set.add(t3);
        return set;
    }

    @Override
    protected Collection<ConstraintTarget> getConstraintTargetsImpl(ConstraintTargetType type, ConstraintContext context) {
        List<String> names = null;
        ClassRepositoryHelper classRepositoryHelper = new ClassRepositoryHelper(this.classRepository());
        switch (type) {
            case FIELD: {
                AvailableFieldListBuilder builder = AvailableFieldListBuilder.createAvailableFieldListBuilder(classRepositoryHelper.getClassRepository());
                builder.withHierarchicalFields().withFilter(new HierarchicalFieldFilter(){

                    @Override
                    public boolean isAllowed(FieldHierarchyNode field) {
                        boolean allowed;
                        boolean bl = allowed = field.getParent() == null;
                        if (allowed && field.isLeaf()) {
                            allowed = ((FieldDefinition)field).isFieldOriented();
                        }
                        return allowed;
                    }
                });
                names = builder.buildFieldNameList();
                break;
            }
            case CONDITION: {
                ConstraintContextItem fieldName = context.itemForType(ConstraintContextItemType.FIELD);
                if (fieldName.isAny()) {
                    names = FieldSelectionConditionProfile.getSupportedConditionList(classRepositoryHelper, null);
                    break;
                }
                names = FieldSelectionConditionProfile.getSupportedConditionList(classRepositoryHelper, fieldName.getValue());
                break;
            }
            case FEATURE: {
                names = FieldSelectionConditionProfile.getSupportedFeatures();
                break;
            }
            default: {
                throw new AssertionError((Object)("Wrong type: " + (Object)((Object)type)));
            }
        }
        return this.namesToTargets(names, type);
    }
}

