/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.logic;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.DataSetField;
import com.ericsson.ere.dataset.DataSetValueNotFoundException;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.conditions.ImmutableFieldMappableCondition;
import com.ericsson.ere.selectiontree.interfaces.ContextCondition;
import com.ericsson.ere.selectiontree.interfaces.ExecutionContext;
import com.ericsson.ere.selectiontree.interfaces.FieldKeyIndexUser;
import com.ericsson.ere.selectiontree.interfaces.TraceContext;
import com.ericsson.ere.trace.PluginTraceHelper;
import com.ericsson.ere.trace.TraceDataSet;
import com.ericsson.ere.trace.TracePoint;
import com.ericsson.ere.trace.TraceableV2;
import ericsson.ere.datatype.DataType;
import ericsson.ere.interfaces.TariffStructureNode;

@Immutable
public final class BooleanFieldCondition
extends ImmutableFieldMappableCondition
implements FieldKeyIndexUser,
TraceableV2,
ContextCondition {
    private BooleanFieldCondition(ParseContext ctx) {
        super(ctx);
    }

    public static BooleanFieldCondition create(ParseContext ctx, TariffStructureNode[] notUsed) {
        return new BooleanFieldCondition(ctx);
    }

    @Override
    protected DataSetField createDataSetField(ParseContext ctx) {
        return this.createDataSetField(ctx, DataType.BOOLEAN);
    }

    @Override
    public boolean test(DataSet theData) {
        Boolean boolValue = null;
        try {
            boolValue = (Boolean)this.extractFieldValueFromDataSet(theData, this.myField);
        }
        catch (DataSetValueNotFoundException dataSetValueNotFoundException) {
            // empty catch block
        }
        return boolValue != null ? boolValue : false;
    }

    @Override
    public boolean test(ExecutionContext exeCtx) {
        Boolean boolValue = (Boolean)exeCtx.getValue(DataType.BOOLEAN);
        return boolValue != null && boolValue != false;
    }

    @Override
    public String describeTrace(TracePoint tp) {
        TraceDataSet dataSet = TraceDataSet.createPreDataSet(tp);
        String describedFieldValue = null;
        try {
            Object dataSetFieldValue = this.extractFieldValueFromDataSet(dataSet, this.myField);
            describedFieldValue = dataSetFieldValue != null ? this.describeValue(dataSetFieldValue, dataSet) : null;
        }
        catch (DataSetValueNotFoundException dataSetValueNotFoundException) {
            // empty catch block
        }
        return this.doDescribeTrace(this.describeFieldName(dataSet), describedFieldValue);
    }

    @Override
    public String describeTrace(TraceContext traceCtx) {
        return this.doDescribeTrace(traceCtx.getFieldDescription(), traceCtx.getTraceValue());
    }

    private String doDescribeTrace(String selectedFieldName, String testedFieldValue) {
        return this.createTraceDescriptionText("Boolean", selectedFieldName, testedFieldValue, "is", "true");
    }

    @Override
    public void setPreTracePointInfo(TracePoint tp) {
        PluginTraceHelper.addFieldValueAsPreDataInTracePoint(this.myField, this.myKeyIndex, tp);
    }

    @Override
    public void setTracePointInfo(TracePoint tp) {
    }

    public int hashCode() {
        int prime = 23;
        int result = super.hashCodeImpl();
        result = 23 * result;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass() && super.equalsImpl(obj);
    }
}

