/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.logic;

import com.ericsson.ere.constraint.contract.AbstractConstrainableProfileContract;
import com.ericsson.ere.constraint.contract.ConstrainableProfileContract;
import com.ericsson.ere.constraint.contract.ConstrainableProfileContractContext;
import com.ericsson.ere.constraint.contract.ConstraintSpecification;
import com.ericsson.ere.constraint.entity.ConstraintContext;
import com.ericsson.ere.constraint.entity.ConstraintContextItem;
import com.ericsson.ere.constraint.entity.ConstraintContextItemType;
import com.ericsson.ere.constraint.entity.ConstraintTarget;
import com.ericsson.ere.constraint.entity.ConstraintTargetType;
import com.ericsson.ere.selectiontree.conditions.logic.CompareFieldProfile;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.defs.FieldDefinitionHelper;
import ericsson.ere.interfaces.ClassProfile;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CompareFieldProfileContract
extends AbstractConstrainableProfileContract {
    private Class<? extends CompareFieldProfile> myProfileClass;
    private String myProfileName;

    private CompareFieldProfileContract(ClassRepository repository, Class<? extends CompareFieldProfile> profileClass, String name) {
        super(repository);
        this.myProfileClass = profileClass;
        this.myProfileName = name;
    }

    public static ConstrainableProfileContract create(ConstrainableProfileContractContext context) {
        Class<? extends ClassProfile> pc = context.getProfileClass();
        if (!CompareFieldProfile.class.isAssignableFrom(pc)) {
            throw new IllegalArgumentException("This contract class require the profile class to extend " + CompareFieldProfile.class.getSimpleName());
        }
        Class<? extends ClassProfile> pclass = pc;
        return new CompareFieldProfileContract(context.getClassRepository(), pclass, context.getProfileName());
    }

    private CompareFieldProfile createProfileInstance() {
        try {
            CompareFieldProfile profile = this.myProfileClass.newInstance();
            profile.setName(this.myProfileName);
            profile.setClassRepository(this.classRepository());
            return profile;
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to create instance of " + this.myProfileClass, ex);
        }
    }

    @Override
    public Set<ConstraintSpecification> supportedConstraintSpecifications() {
        ConstraintSpecification t1 = ConstraintSpecification.of(ConstraintTargetType.FIELD, new ConstraintContextItemType[0]);
        ConstraintSpecification t2 = ConstraintSpecification.of(ConstraintTargetType.OPERATION, ConstraintContextItemType.FIELD);
        ConstraintSpecification t3 = ConstraintSpecification.of(ConstraintTargetType.FIELD, ConstraintContextItemType.OPERATION, ConstraintContextItemType.FIELD);
        ConstraintSpecification t4 = ConstraintSpecification.of(ConstraintTargetType.FEATURE, new ConstraintContextItemType[0]);
        HashSet<ConstraintSpecification> set = new HashSet<ConstraintSpecification>();
        set.add(t1);
        set.add(t2);
        set.add(t3);
        set.add(t4);
        return set;
    }

    @Override
    protected Collection<ConstraintTarget> getConstraintTargetsImpl(ConstraintTargetType type, ConstraintContext context) {
        List<String> names = null;
        CompareFieldProfile profile = this.createProfileInstance();
        switch (type) {
            case FIELD: {
                ConstraintContextItem firstOperandField;
                List<FieldDefinition> fields = context.itemForType(ConstraintContextItemType.OPERATION) == null ? profile.getSupportedFirstOperandFieldList(this.classRepository()) : ((firstOperandField = context.itemForType(ConstraintContextItemType.FIELD)).isAny() ? profile.getSupportedSecondOperandFieldList(this.classRepository(), null) : profile.getSupportedSecondOperandFieldList(this.classRepository(), firstOperandField.getValue()));
                names = FieldDefinitionHelper.extractFieldNameList(fields);
                break;
            }
            case OPERATION: {
                ConstraintContextItem firstOperandField = context.itemForType(ConstraintContextItemType.FIELD);
                if (firstOperandField.isAny()) {
                    names = profile.getSupportedOperationList(this.classRepository(), null);
                    break;
                }
                names = profile.getSupportedOperationList(this.classRepository(), firstOperandField.getValue());
                break;
            }
            case FEATURE: {
                names = CompareFieldProfile.getSupportedFeatures();
                break;
            }
            default: {
                throw new AssertionError((Object)("Unsupported type: " + (Object)((Object)type)));
            }
        }
        return this.namesToTargets(names, type);
    }
}

