/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.number;

import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.DataSetValueNotFoundException;
import com.ericsson.ere.dataset.Key;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.TreeExecutionException;
import com.ericsson.ere.selectiontree.conditions.ImmutableFieldMappableCondition;
import com.ericsson.ere.selectiontree.interfaces.FieldKeyIndexUser;
import com.ericsson.ere.selectiontree.interfaces.TraceContext;
import com.ericsson.ere.selectiontree.util.FieldOrientedPluginUtil;
import com.ericsson.ere.trace.TraceDataSet;
import com.ericsson.ere.trace.TracePoint;
import com.ericsson.ere.trace.TraceableV2;
import ericsson.ere.datatype.DataType;
import ericsson.ere.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractImmutableNumberCondition<T>
extends ImmutableFieldMappableCondition
implements FieldKeyIndexUser,
TraceableV2 {
    protected static final String TESTED_VALUE = "Tested_Value";
    protected final Operator myOperator;
    protected final T myValue;
    protected final String myTypeName;
    protected final DataType myDataType;

    protected AbstractImmutableNumberCondition(ParseContext context, String typeText) {
        this(context, typeText, null);
    }

    protected AbstractImmutableNumberCondition(ParseContext context, String typeText, DataType dataType) {
        super(context);
        Node config = context.getXMLNode();
        String operator = null;
        Element e = XMLUtil.getNamedElement("Operator", config.getChildNodes());
        if (e != null) {
            operator = XMLUtil.getFirstTextContent(e);
        }
        this.myTypeName = typeText;
        this.myValue = this.parseValue(this.getValueString(config));
        this.myOperator = this.getOperator(operator);
        this.myDataType = dataType;
    }

    protected abstract T parseValue(String var1);

    protected abstract String getValueString(Node var1);

    protected abstract String getValueAsString(T var1);

    protected abstract T getValueFromDataSet(DataSet var1);

    protected abstract boolean evaluate(T var1, T var2) throws Exception;

    private Operator getOperator(String operator) {
        Operator o = Operator.lookup(operator);
        return o != null ? o : Operator.EQ;
    }

    protected boolean compareUnsignedNumbers(long longToTest, long numberToCheck) {
        switch (this.myOperator) {
            case EQ: {
                return numberToCheck == longToTest;
            }
            case GT: {
                return this.compareUnsignedGT(longToTest, numberToCheck);
            }
            case LT: {
                return this.compareUnsignedLT(longToTest, numberToCheck);
            }
            case GTE: {
                return numberToCheck == longToTest || this.compareUnsignedGT(longToTest, numberToCheck);
            }
            case LTE: {
                return numberToCheck == longToTest || this.compareUnsignedLT(longToTest, numberToCheck);
            }
        }
        return false;
    }

    private boolean compareUnsignedGT(long longToTest, long numberToCheck) {
        if (longToTest >= 0L && numberToCheck >= 0L || longToTest < 0L && numberToCheck < 0L) {
            return numberToCheck > longToTest;
        }
        return numberToCheck <= longToTest;
    }

    private boolean compareUnsignedLT(long longToTest, long numberToCheck) {
        if (longToTest >= 0L && numberToCheck >= 0L || longToTest < 0L && numberToCheck < 0L) {
            return numberToCheck < longToTest;
        }
        return numberToCheck >= longToTest;
    }

    protected boolean compareSignedNumbers(long longToTest, long numberToCheck) {
        switch (this.myOperator) {
            case EQ: {
                return numberToCheck == longToTest;
            }
            case GT: {
                return numberToCheck > longToTest;
            }
            case LT: {
                return numberToCheck < longToTest;
            }
            case GTE: {
                return numberToCheck >= longToTest;
            }
            case LTE: {
                return numberToCheck <= longToTest;
            }
        }
        return false;
    }

    @Override
    public boolean test(DataSet dataset) {
        T value = null;
        try {
            value = this.getValueFromDataSet(dataset);
        }
        catch (DataSetValueNotFoundException dataSetValueNotFoundException) {
            // empty catch block
        }
        return value != null && this.doTest(value);
    }

    protected boolean doTest(T dataSetValue) {
        try {
            return dataSetValue != null && this.evaluate(this.myValue, dataSetValue);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TreeExecutionException(e);
        }
    }

    protected Operator operator() {
        return this.myOperator;
    }

    protected Number fetchNumberFromDataSet(DataSet theData) {
        Number resultingNumber;
        if (this.myKeyIndex == null) {
            resultingNumber = (Number)this.myField.getValueFromDataSet(theData);
        } else {
            Key firstKey = FieldOrientedPluginUtil.extractFirstKeyFromSet(this.myKeyIndex.getKeySet(theData));
            resultingNumber = (Number)this.myField.getValueFromDataSet(theData, firstKey);
        }
        return resultingNumber;
    }

    @Override
    public String describeTrace(TracePoint tp) {
        TraceDataSet dataSet = TraceDataSet.createPreDataSet(tp);
        Object testedValue = tp.getInfo(TESTED_VALUE);
        String testedFieldValue = testedValue == null ? null : this.describeValue(testedValue, dataSet);
        return this.doDescribeTrace(dataSet, this.describeFieldName(dataSet), testedFieldValue);
    }

    public String describeTrace(TraceContext traceCtx) {
        return this.doDescribeTrace(TraceDataSet.createPreDataSet(traceCtx.getTracePoint()), traceCtx.getFieldDescription(), traceCtx.getTraceValue());
    }

    private String doDescribeTrace(DataSet dataSet, String fieldNameString, String testedFieldValue) {
        return this.createTraceDescriptionText(this.myTypeName, fieldNameString, testedFieldValue, this.myOperator.getDescription(), this.describeValue(this.myValue, dataSet));
    }

    @Override
    public void setPreTracePointInfo(TracePoint tp) {
        try {
            T num = this.getValueFromDataSet(tp.getPreDataSet());
            tp.addInfo(TESTED_VALUE, num);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setTracePointInfo(TracePoint tp) {
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + (this.myOperator == null ? 0 : this.myOperator.hashCode());
        result = 31 * result + (this.myTypeName == null ? 0 : this.myTypeName.hashCode());
        result = 31 * result + (this.myValue == null ? 0 : this.myValue.hashCode());
        result = 31 * result + (this.myDataType == null ? 0 : this.myDataType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass() || !super.equalsImpl(obj)) {
            return false;
        }
        AbstractImmutableNumberCondition other = (AbstractImmutableNumberCondition)obj;
        if (this.myOperator == null ? other.myOperator != null : !this.myOperator.equals((Object)other.myOperator)) {
            return false;
        }
        if (this.myTypeName == null ? other.myTypeName != null : !this.myTypeName.equals(other.myTypeName)) {
            return false;
        }
        if (this.myValue == null ? other.myValue != null : !this.myValue.equals(other.myValue)) {
            return false;
        }
        return !(this.myDataType == null ? other.myDataType != null : !this.myDataType.equals(other.myDataType));
    }

    protected static enum Operator {
        EQ("=", "="),
        GT(">"),
        LT("<"),
        GTE(">="),
        LTE("<=");

        private String myXMLRepresentation;
        private String myDescription;

        private Operator(String desc) {
            this.myDescription = desc;
        }

        private Operator(String rep, String desc) {
            this(desc);
            this.myXMLRepresentation = rep;
        }

        String getXMLRepresentation() {
            return this.myXMLRepresentation == null ? this.name() : this.myXMLRepresentation;
        }

        String getDescription() {
            return this.myDescription;
        }

        static Operator lookup(String operator) {
            Operator found = null;
            for (Operator op : Operator.values()) {
                if (!op.getXMLRepresentation().equals(operator)) continue;
                found = op;
                break;
            }
            return found;
        }
    }
}

