/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.number;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.conditions.number.AbstractImmutableNumberCondition;
import com.ericsson.ere.selectiontree.interfaces.ContextCondition;
import com.ericsson.ere.selectiontree.interfaces.ExecutionContext;
import com.ericsson.ere.selectiontree.util.TreeParseUtil;
import ericsson.ere.datatype.DataType;
import ericsson.ere.datatype.interfaces.UnsignedInt;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.util.NodeListIterable;
import ericsson.ere.xml.XMLUtil;
import org.w3c.dom.Node;

@Immutable
public final class UnsignedIntCondition
extends AbstractImmutableNumberCondition<Long>
implements ContextCondition {
    public static final String TAG_OPERATOR = "Operator";
    public static final String[] numericOperatorArr = new String[]{AbstractImmutableNumberCondition.Operator.EQ.getXMLRepresentation(), AbstractImmutableNumberCondition.Operator.GT.getXMLRepresentation(), AbstractImmutableNumberCondition.Operator.LT.getXMLRepresentation(), AbstractImmutableNumberCondition.Operator.GTE.getXMLRepresentation(), AbstractImmutableNumberCondition.Operator.LTE.getXMLRepresentation()};

    private UnsignedIntCondition(ParseContext context) {
        super(context, "UnsignedInteger");
    }

    public static UnsignedIntCondition create(ParseContext context, TariffStructureNode[] children) {
        return new UnsignedIntCondition(context);
    }

    @Override
    protected boolean evaluate(Long value, Long dataSetValue) throws Exception {
        assert (value >= 0L && dataSetValue >= 0L);
        return this.compareSignedNumbers(value, dataSetValue);
    }

    @Override
    protected String getValueAsString(Long value) {
        return Long.toString(value);
    }

    @Override
    protected Long getValueFromDataSet(DataSet ds) {
        return this.getLongFromDataSet(ds);
    }

    @Override
    protected String getValueString(Node config) {
        String TAG = "LongValue".toLowerCase();
        String value = "";
        for (Node n : new NodeListIterable(config.getChildNodes(), 1)) {
            if (!n.getNodeName().toLowerCase().equals(TAG)) continue;
            value = XMLUtil.getFirstTextContent(n);
        }
        return value;
    }

    @Override
    protected Long parseValue(String value) {
        return TreeParseUtil.parseLong(value);
    }

    @Override
    public boolean test(ExecutionContext exeCtx) {
        return this.doTest((Long)exeCtx.getValue(DataType.LONG));
    }

    private long getLongFromDataSet(DataSet dataset) {
        UnsignedInt ui = (UnsignedInt)((Object)this.fetchNumberFromDataSet(dataset));
        return ui.longValue();
    }
}

