/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.string;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.DataSetField;
import com.ericsson.ere.dataset.DataSetValueNotFoundException;
import com.ericsson.ere.exception.PluginCreationException;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.conditions.ImmutableFieldMappableCondition;
import com.ericsson.ere.selectiontree.interfaces.FieldKeyIndexUser;
import com.ericsson.ere.selectiontree.util.TreeParseUtil;
import com.ericsson.ere.trace.PluginTraceHelper;
import com.ericsson.ere.trace.TraceDataSet;
import com.ericsson.ere.trace.TracePoint;
import com.ericsson.ere.trace.TraceableV2;
import ericsson.ere.datatype.DataType;
import ericsson.ere.datatype.OctetString;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.xml.XMLUtil;
import java.util.Arrays;
import java.util.StringTokenizer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Immutable
public final class IpAddress
extends ImmutableFieldMappableCondition
implements FieldKeyIndexUser,
TraceableV2 {
    public static final String TAG_MASK = "Mask";
    final String myMaskString;
    final short[] myIpBytes = new short[4];
    final short myNumberOfSignificantBits;
    final long myIp;
    final long myMask;
    private final int myFieldsDataType;

    private IpAddress(ParseContext ctx) {
        super(ctx);
        Node nodeConfig = ctx.getXMLNode();
        String theMask = "";
        if (nodeConfig.hasChildNodes()) {
            for (Node el : XMLUtil.getElementChildren(nodeConfig)) {
                if (!el.getNodeName().toLowerCase().equals(TAG_MASK.toLowerCase())) continue;
                theMask = XMLUtil.getFirstTextContent(el);
                break;
            }
        }
        if (theMask.length() > 0) {
            short bits = theMask.indexOf("/") >= 0 ? this.readCIDRString(theMask) : (theMask.indexOf("*") >= 0 ? this.readWildCardString(theMask) : this.readIp(theMask));
            this.myNumberOfSignificantBits = bits;
            this.myMask = this.createMask(this.myNumberOfSignificantBits);
            this.myIp = this.ipAddressToLong(this.myIpBytes) & this.myMask;
        } else {
            this.myNumberOfSignificantBits = 0;
            this.myIp = 0L;
            this.myMask = 0L;
        }
        this.myMaskString = theMask;
        Element fieldElement = XMLUtil.getFirstElementNamed("Field", (Element)nodeConfig);
        if (fieldElement != null) {
            String mappedFieldName = fieldElement.getAttribute("field");
            FieldDefinition ipAddressField = ctx.getClassRepository().getFieldDefinitionByName(mappedFieldName);
            this.myFieldsDataType = ipAddressField.getTypedDataType().getTypeIdentifier();
        } else {
            this.myFieldsDataType = 6;
        }
    }

    public static IpAddress create(ParseContext ctx, TariffStructureNode[] notUsed) {
        return new IpAddress(ctx);
    }

    private long ipAddressToLong(short[] ipAddressBytes) {
        long ipLongValue = 0L;
        ipLongValue += (long)ipAddressBytes[0] * 256L * 256L * 256L;
        ipLongValue += (long)ipAddressBytes[1] * 256L * 256L;
        ipLongValue += (long)ipAddressBytes[2] * 256L;
        return ipLongValue += (long)ipAddressBytes[3];
    }

    private long createMask(int numberOfSignificantBits) {
        int aa;
        long val = 1L;
        if (numberOfSignificantBits == 0) {
            return 0L;
        }
        for (aa = 1; aa < numberOfSignificantBits; ++aa) {
            val <<= 1;
            ++val;
        }
        while (aa < 32) {
            val <<= 1;
            ++aa;
        }
        return val;
    }

    private long ipStringToLong(String ipAddress) {
        if (!ipAddress.contains(".")) {
            try {
                return Long.parseLong(ipAddress);
            }
            catch (NumberFormatException nfe) {
                return 0L;
            }
        }
        short[] addressArray = new short[4];
        StringTokenizer token = new StringTokenizer(ipAddress, ".");
        for (int index = 0; token.hasMoreTokens() && index < addressArray.length; ++index) {
            try {
                addressArray[index] = TreeParseUtil.parseShort(token.nextToken());
                continue;
            }
            catch (NumberFormatException e) {
                break;
            }
        }
        return this.ipAddressToLong(addressArray);
    }

    private short readWildCardString(String ipMask) {
        int counter = 0;
        for (int ii = 0; ii < this.myIpBytes.length; ++ii) {
            this.myIpBytes[ii] = 0;
        }
        short numberOfSignificantBits = 32;
        StringTokenizer token = new StringTokenizer(ipMask, ".");
        while (token.hasMoreTokens()) {
            short aShort;
            String tmpStr = token.nextToken();
            if (tmpStr.equals("*")) {
                numberOfSignificantBits = (short)(counter * 8);
                break;
            }
            if (counter < 3) {
                try {
                    aShort = TreeParseUtil.parseShort(tmpStr);
                }
                catch (NumberFormatException e) {
                    String errMsg = "'" + ipMask + "' is NOT a valid ipAddress Wild card mask, only '0-9', '.' and '*' allowed";
                    throw new PluginCreationException(errMsg);
                }
                if (aShort < 0 || aShort > 255) {
                    String errMsg = "'" + ipMask + "' contains an invalid value '" + aShort + "' (range: 0-255)";
                    throw new PluginCreationException(errMsg);
                }
            } else {
                String errMsg = "'" + ipMask + "' to many  '.''s ";
                throw new PluginCreationException(errMsg);
            }
            this.myIpBytes[counter] = aShort;
            ++counter;
        }
        return numberOfSignificantBits;
    }

    private short readIp(String ipMask) {
        int counter = 0;
        for (int ii = 0; ii < this.myIpBytes.length; ++ii) {
            this.myIpBytes[ii] = 0;
        }
        short numberOfSignificantBits = 32;
        StringTokenizer token = new StringTokenizer(ipMask, ".");
        if (token.countTokens() < 4) {
            String errMsg = "'" + ipMask + "' is malformed, NOT a valid ip address";
            throw new PluginCreationException(errMsg);
        }
        while (token.hasMoreTokens()) {
            short aShort;
            String tmpStr = token.nextToken();
            if (counter < 4) {
                try {
                    aShort = TreeParseUtil.parseShort(tmpStr);
                }
                catch (NumberFormatException e) {
                    String errMsg = "'" + ipMask + "' is NOT a valid ipAddress, only '0-9' and '.' allowed";
                    throw new PluginCreationException(errMsg);
                }
                if (aShort < 0 || aShort > 255) {
                    String errMsg = "'" + ipMask + "' contains an invalid value '" + aShort + "' (range: 0-255)";
                    throw new PluginCreationException(errMsg);
                }
            } else {
                String errMsg = "'" + this.myMaskString + "' have to many address parts '";
                throw new PluginCreationException(errMsg);
            }
            this.myIpBytes[counter] = aShort;
            ++counter;
        }
        return numberOfSignificantBits;
    }

    private short readCIDRString(String ipMask) {
        int counter = 0;
        short numberOfSignificantBits = 32;
        for (int ii = 0; ii < this.myIpBytes.length; ++ii) {
            this.myIpBytes[ii] = 0;
        }
        int pos = ipMask.indexOf(47);
        if (pos < ipMask.length() - 1) {
            String numberOfSignString = ipMask.substring(pos + 1, ipMask.length());
            try {
                numberOfSignificantBits = TreeParseUtil.parseShort(numberOfSignString);
            }
            catch (NumberFormatException e) {
                String errMsg = "'" + ipMask + "' Significant bits part NOT a number (1-32)";
                throw new PluginCreationException(errMsg);
            }
            if (numberOfSignificantBits < 1 || numberOfSignificantBits > 32) {
                String errMsg = "'" + ipMask + "' Significant bits part NOT a in valid range (1-32)";
                throw new PluginCreationException(errMsg);
            }
        } else {
            String errMsg = "'" + ipMask + "' Significant bits part is NOT valid (range 1-32)";
            throw new PluginCreationException(errMsg);
        }
        StringTokenizer token = new StringTokenizer(ipMask.substring(0, pos), ".");
        if (token.countTokens() < 4) {
            String errMsg = "'" + ipMask + "' is malformed, NOT a valid ip address";
            throw new PluginCreationException(errMsg);
        }
        while (token.hasMoreTokens()) {
            short aShort;
            String numberStr = token.nextToken();
            try {
                aShort = TreeParseUtil.parseShort(numberStr);
                if (counter >= 4) {
                    String errMsg = ipMask + "' have to many address parts '";
                    throw new PluginCreationException(errMsg);
                }
                this.myIpBytes[counter] = aShort;
            }
            catch (NumberFormatException e) {
                String errMsg = "'" + ipMask + "' is NOT in a valid CIDR Notation , only '0-9', '.' and '/' allowed";
                throw new PluginCreationException(errMsg);
            }
            if (aShort < 0 || aShort > 255) {
                String errMsg = "'" + ipMask + "' contains an invalid value '" + aShort + "' (range: 0-255)";
                throw new PluginCreationException(errMsg);
            }
            ++counter;
        }
        return numberOfSignificantBits;
    }

    private boolean validate(Object ipAddress) {
        boolean retBoolean = true;
        long theIp = 0L;
        if (this.myMaskString.trim().length() == 0) {
            retBoolean = false;
        } else {
            String strIpAddress = "";
            if (ipAddress instanceof OctetString) {
                theIp = Long.parseLong(((OctetString)ipAddress).toString(), 16);
            } else {
                strIpAddress = (String)ipAddress;
                if (strIpAddress.trim().length() == 0) {
                    retBoolean = false;
                } else {
                    theIp = this.ipStringToLong(strIpAddress);
                }
            }
            if (retBoolean) {
                retBoolean = (theIp & this.myMask) == this.myIp;
            }
        }
        return retBoolean;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + this.myFieldsDataType;
        result = 31 * result + (int)(this.myIp ^ this.myIp >>> 32);
        result = 31 * result + Arrays.hashCode(this.myIpBytes);
        result = 31 * result + (int)(this.myMask ^ this.myMask >>> 32);
        result = 31 * result + (this.myMaskString == null ? 0 : this.myMaskString.hashCode());
        result = 31 * result + this.myNumberOfSignificantBits;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equalsImpl(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IpAddress other = (IpAddress)obj;
        if (this.myFieldsDataType != other.myFieldsDataType) {
            return false;
        }
        if (this.myIp != other.myIp) {
            return false;
        }
        if (!Arrays.equals(this.myIpBytes, other.myIpBytes)) {
            return false;
        }
        if (this.myMask != other.myMask) {
            return false;
        }
        if (this.myMaskString == null ? other.myMaskString != null : !this.myMaskString.equals(other.myMaskString)) {
            return false;
        }
        return this.myNumberOfSignificantBits == other.myNumberOfSignificantBits;
    }

    @Override
    public boolean test(DataSet theData) {
        Object ipAddress = null;
        try {
            ipAddress = this.extractFieldValueFromDataSet(theData, this.myField);
        }
        catch (DataSetValueNotFoundException dataSetValueNotFoundException) {
            // empty catch block
        }
        return ipAddress != null && this.validate(ipAddress);
    }

    @Override
    public String describeTrace(TracePoint tp) {
        TraceDataSet dataSet = TraceDataSet.createPreDataSet(tp);
        String describedConditionValue = this.describeValue(this.myMaskString, dataSet);
        String conditionConfigValue = describedConditionValue == this.myMaskString ? "\"" + describedConditionValue + "\"" : describedConditionValue;
        String testedFieldValue = null;
        try {
            Object dataSetFieldValue = this.extractFieldValueFromDataSet(dataSet, this.myField);
            if (dataSetFieldValue != null) {
                String describedFieldValue = this.describeValue(dataSetFieldValue, dataSet);
                testedFieldValue = describedFieldValue.equals(dataSetFieldValue.toString()) ? "\"" + describedFieldValue + "\"" : describedFieldValue;
            }
        }
        catch (DataSetValueNotFoundException dataSetValueNotFoundException) {
            // empty catch block
        }
        return this.createTraceDescriptionText("IpAddress", this.describeFieldName(dataSet), testedFieldValue, "matches", conditionConfigValue);
    }

    @Override
    public void setPreTracePointInfo(TracePoint tp) {
        PluginTraceHelper.addFieldValueAsPreDataInTracePoint(this.myField, this.myKeyIndex, tp);
    }

    @Override
    public void setTracePointInfo(TracePoint tp) {
    }

    @Override
    protected DataSetField createDataSetField(ParseContext ctx) {
        DataType type;
        FieldDefinition def = this.key == null ? null : ctx.getClassRepository().getFieldDefinitionByName(this.key);
        DataType dataType = type = def != null && def.getTypedDataType() == DataType.OCTETSTRING ? DataType.OCTETSTRING : DataType.STRING;
        DataSetField field = def == null ? new DataSetField(this.key, this.tag, this.tagIsSet, type, this.myKeyIndex != null) : new DataSetField(def, type);
        return field;
    }
}

