/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.string;

import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.dataset.DataSet;
import com.ericsson.ere.dataset.DataSetValueNotFoundException;
import com.ericsson.ere.selectiontree.ParseContext;
import com.ericsson.ere.selectiontree.conditions.string.AbstractImmutableStringCondition;
import com.ericsson.ere.selectiontree.interfaces.ContextCondition;
import com.ericsson.ere.selectiontree.interfaces.ExecutionContext;
import com.ericsson.ere.selectiontree.interfaces.TraceContext;
import com.ericsson.ere.trace.PluginTraceHelper;
import com.ericsson.ere.trace.TraceDataSet;
import com.ericsson.ere.trace.TracePoint;
import com.ericsson.ere.trace.TraceableV2;
import ericsson.ere.datatype.DataType;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Immutable
public final class StringCondition
extends AbstractImmutableStringCondition
implements TraceableV2,
ContextCondition {
    private final String myString;
    private final int myComparation;
    private final boolean myMatchCase;
    static final String TAG_TYPE = "Type";
    public static final String TAG_COMPARATION = "Comparation";
    public static final String TAG_TEXT = "Text";
    public static final String TAG_CASE = "MatchCase";
    static final int TAG_COMPARE_BEGINS_WITH = 0;
    static final int TAG_COMPARE_ENDS_WITH = 1;
    static final int TAG_COMPARE_CONTAINS = 2;
    static final int TAG_COMPARE_EXACT_MATCH = 3;

    public static StringCondition create(ParseContext ctx, TariffStructureNode[] children) {
        return new StringCondition(ctx);
    }

    private StringCondition(ParseContext ctx) {
        super(ctx);
        String theText = "";
        int theComparation = 0;
        boolean theMatchCase = true;
        Node config = ctx.getXMLNode();
        Element comparisonType = XMLUtil.getNamedElement(TAG_COMPARATION, config.getChildNodes());
        if (comparisonType != null) {
            theComparation = Integer.parseInt(XMLUtil.getFirstTextContent(comparisonType));
        }
        theText = XMLUtil.getFirstTextContent(XMLUtil.getNamedElement(TAG_TEXT, config.getChildNodes()));
        Element matchCaseTag = XMLUtil.getNamedElement(TAG_CASE, config.getChildNodes());
        if (matchCaseTag != null) {
            theMatchCase = Boolean.valueOf(XMLUtil.getFirstTextContent(matchCaseTag));
        }
        this.myComparation = theComparation;
        this.myString = theText;
        this.myMatchCase = theMatchCase;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + this.myComparation;
        result = 31 * result + (this.myMatchCase ? 1231 : 1237);
        result = 31 * result + (this.myString == null ? 0 : this.myString.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equalsImpl(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StringCondition other = (StringCondition)obj;
        if (this.myComparation != other.myComparation) {
            return false;
        }
        if (this.myMatchCase != other.myMatchCase) {
            return false;
        }
        return !(this.myString == null ? other.myString != null : !this.myString.equals(other.myString));
    }

    @Override
    public boolean test(DataSet theData) {
        String value = null;
        try {
            value = this.getStringValue(theData);
        }
        catch (DataSetValueNotFoundException dataSetValueNotFoundException) {
            // empty catch block
        }
        return this.doTest(value);
    }

    @Override
    public boolean test(ExecutionContext exeCtx) {
        String value = (String)exeCtx.getValue(DataType.STRING);
        return this.doTest(value);
    }

    private boolean doTest(String value) {
        boolean retVal = false;
        if (value != null) {
            if (this.myString.length() == 0) {
                retVal = value.length() == 0;
            } else {
                String valueString = this.myMatchCase ? value : value.toLowerCase();
                String compareString = this.myMatchCase ? this.myString : this.myString.toLowerCase();
                switch (this.myComparation) {
                    case 0: {
                        retVal = valueString.startsWith(compareString);
                        break;
                    }
                    case 1: {
                        retVal = valueString.endsWith(compareString);
                        break;
                    }
                    case 2: {
                        retVal = valueString.indexOf(compareString) > -1;
                        break;
                    }
                    case 3: {
                        retVal = valueString.equals(compareString);
                        break;
                    }
                }
            }
        }
        return retVal;
    }

    @Override
    public String describeTrace(TracePoint tp) {
        TraceDataSet dataSet = TraceDataSet.createPreDataSet(tp);
        String selectedFieldName = this.describeFieldName(dataSet);
        String dataSetFieldValue = null;
        try {
            dataSetFieldValue = this.getStringValue(dataSet);
        }
        catch (DataSetValueNotFoundException dataSetValueNotFoundException) {
            // empty catch block
        }
        return this.doDescribeTrace(dataSet, selectedFieldName, dataSetFieldValue);
    }

    @Override
    public String describeTrace(TraceContext traceCtx) {
        return this.doDescribeTrace(TraceDataSet.createPreDataSet(traceCtx.getTracePoint()), traceCtx.getFieldDescription(), traceCtx.getTraceValue());
    }

    private String doDescribeTrace(TraceDataSet dataSet, String selectedFieldName, String testedFieldValue) {
        String fieldValue = this.describeStringValue(testedFieldValue, dataSet);
        String conditionConfigValue = this.describeStringValue(this.myString, dataSet);
        return this.createTraceDescriptionText("String", selectedFieldName, fieldValue, this.describeComparation(), conditionConfigValue);
    }

    private String describeComparation() {
        String operationText = "";
        switch (this.myComparation) {
            case 0: {
                operationText = "begins with";
                break;
            }
            case 1: {
                operationText = "ends with";
                break;
            }
            case 2: {
                operationText = "contains";
                break;
            }
            case 3: {
                operationText = "equals";
            }
        }
        operationText = operationText + (this.myMatchCase ? " (case sensitive)" : " (case insensitive)");
        return operationText;
    }

    @Override
    public void setPreTracePointInfo(TracePoint tp) {
        PluginTraceHelper.addFieldValueAsPreDataInTracePoint(this.myField, this.myKeyIndex, tp);
    }

    @Override
    public void setTracePointInfo(TracePoint tp) {
    }
}

