/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.conditions.string;

import com.ericsson.ere.gui.editors.serviceeditor.fieldscontexts.nodes.RequiresNonMapField;
import com.ericsson.ere.gui.simulator.testgenerator.TestCaseGenerationConditionInterface;
import com.ericsson.ere.selectiontree.AbstractBaseConditionProfile;
import com.ericsson.ere.selectiontree.interfaces.FieldMappable;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.variable.BoolVariable;
import ericsson.vareditor.variable.DropDownVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@RequiresNonMapField
public class StringConditionProfile
extends AbstractBaseConditionProfile
implements FieldMappable,
TestCaseGenerationConditionInterface {
    private static String LABEL_COMPARISON = "Comparison";
    private static String LABEL_TEXT = "Text";
    private static String LABEL_MATCH_CASE = "Match case";
    private static final String[] myComparisonChoices = new String[]{"Begins with", "Ends with", "Contains", "Exact match"};
    private FieldDefinition myFieldDef;

    @Override
    public List<Variable> getVariables() {
        ArrayList<Variable> l = new ArrayList<Variable>();
        this.addInputVariables(l, "0", true, null);
        return l;
    }

    private void addInputVariables(List<Variable> l, String selection, boolean match, String value) {
        Variable inputVariable = this.createInputVariable(LABEL_TEXT, null, value, DataType.STRING);
        if (this.supportsInequalityOperators(inputVariable)) {
            l.add(new DropDownVariable(LABEL_COMPARISON, (Object)selection, 1, myComparisonChoices));
            l.add(inputVariable);
            l.add(new BoolVariable(LABEL_MATCH_CASE, match));
        } else {
            l.add(inputVariable);
        }
    }

    @Override
    public List<Variable> getVariables(Node iterator) {
        ArrayList<Variable> l = new ArrayList<Variable>();
        String comp = "0";
        String text = null;
        boolean match = true;
        NodeList children = iterator.getChildNodes();
        for (int aa = 0; aa < children.getLength(); ++aa) {
            NodeList value;
            int bb;
            if (children.item(aa).getNodeType() != 1) continue;
            String k = children.item(aa).getNodeName();
            if (k.equalsIgnoreCase("Comparation") && (bb = 0) < (value = children.item(aa).getChildNodes()).getLength()) {
                comp = value.item(bb).getNodeValue();
            }
            if (k.equalsIgnoreCase("Text") && (bb = 0) < (value = children.item(aa).getChildNodes()).getLength()) {
                text = value.item(bb).getNodeValue();
            }
            if (!k.equalsIgnoreCase("MatchCase") || (bb = 0) >= (value = children.item(aa).getChildNodes()).getLength()) continue;
            match = Boolean.valueOf(value.item(bb).getNodeValue());
        }
        this.addInputVariables(l, comp, match, text);
        return l;
    }

    @Override
    public void printParametersImpl(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        String comp;
        String text = VarListUtil.getValueStringForName(variables, LABEL_TEXT).toString();
        boolean supportsInequalityOperators = this.supportsInequalityOperators(VarListUtil.getVariableForName(variables, LABEL_TEXT));
        boolean match = false;
        if (supportsInequalityOperators) {
            comp = VarListUtil.getValueStringForName(variables, LABEL_COMPARISON);
            Boolean matchCase = VarListUtil.getBooleanValueForName(variables, LABEL_MATCH_CASE);
            if (matchCase != null) {
                match = matchCase;
            }
        } else {
            comp = "3";
            match = true;
        }
        out.println("<Text>" + XMLUtil.escape(text) + "</" + "Text" + ">");
        out.println("<Comparation>" + comp + "</" + "Comparation" + ">");
        out.println("<MatchCase>" + match + "</" + "MatchCase" + ">");
    }

    @Override
    public String getDescription(List<Variable> variables) {
        String name = VarListUtil.getValueStringForName(variables, "Name");
        String compToken = VarListUtil.getValueStringForName(variables, LABEL_COMPARISON);
        String comp = this.getDisplayableValueForComparison(compToken);
        String text = VarListUtil.getVariableForName(variables, LABEL_TEXT).toString();
        return name + " " + comp + " " + text;
    }

    @Override
    public String getAdditionalInfo(List<Variable> variables) {
        String comp = VarListUtil.getValueStringForName(variables, LABEL_COMPARISON);
        comp = this.getDisplayableValueForComparison(comp);
        String text = VarListUtil.getVariableForName(variables, LABEL_TEXT).toString();
        String info = "<b>" + super.getDescription(variables) + "</b> (" + comp + " " + XMLUtil.escape(text) + ")";
        info = info + "\n" + this.getComment(variables);
        return GuiUtil.multilineTooltipWrapper(info);
    }

    @Override
    public void setClassRepository(ClassRepository repository) {
        this.myRepository = repository;
    }

    @Override
    public Map<String, Object> getTestSimulationFieldValues(Node variableValueIterator, Node testSettingsIterator) throws Exception {
        Element textElement = XMLUtil.getFirstElementNamed("Text", (Element)variableValueIterator);
        HashMap<String, Object> fieldInformation = new HashMap<String, Object>();
        if (textElement != null) {
            String testValue = XMLUtil.getFirstTextContent(textElement);
            fieldInformation.put(this.myFieldDef.getFieldName(), testValue);
        }
        if (fieldInformation.size() == 0) {
            throw new Exception("Condition settings does not allow test case generation.");
        }
        return fieldInformation;
    }

    @Override
    public List<Variable> getTestVariables(Node variableValueIterator, Node testSettingsIterator) {
        return null;
    }

    @Override
    public void printTestVariables(PrintWriter out, List<Variable> vars) {
    }

    @Override
    public void setTestFieldDefinition(FieldDefinition fieldDefinition) {
        this.myFieldDef = fieldDefinition;
    }

    @Override
    public boolean testParameterChanged(String reference, Variable value, List<Variable> vars) {
        return false;
    }

    @Override
    public Map<String, Object> getDisplayValues(List<Variable> variables, Map<String, Object> prev) {
        HashMap<String, Object> displayValuesMap = prev == null ? new HashMap<String, Object>() : prev;
        this.storeComparationDataIfExistInVariables(displayValuesMap, variables);
        String value = VarListUtil.getVariableForName(variables, LABEL_TEXT).toString();
        displayValuesMap.put(LABEL_TEXT, value);
        return displayValuesMap;
    }

    @Override
    public Map<String, Object> getDisplayValues(Node data, Map<String, Object> prev) {
        HashMap<String, Object> displayValuesMap = prev == null ? new HashMap<String, Object>() : prev;
        this.storeComparationDataIfExistInNode(displayValuesMap, data);
        String value = this.getValueString(data);
        value = this.makeDisplayString(value, DataType.STRING);
        displayValuesMap.put(LABEL_TEXT, value);
        return displayValuesMap;
    }

    private String getValueString(Node data) {
        String text = XMLUtil.getNamedElement("Text", data.getChildNodes()).getTextContent();
        return this.makeDisplayString(text, DataType.STRING);
    }

    private String getDisplayableValueForComparison(String compToken) {
        String comparator = compToken == null ? myComparisonChoices[3].toLowerCase() : ("-1".equals(compToken) ? "Invalid" : myComparisonChoices[Integer.valueOf(compToken)].toLowerCase());
        return comparator;
    }

    private void storeComparationDataIfExistInNode(Map<String, Object> store, Node data) {
        Element compElement = XMLUtil.getNamedElement("Comparation", data.getChildNodes());
        Element matchElement = XMLUtil.getNamedElement("MatchCase", data.getChildNodes());
        if (compElement != null) {
            String comparation = compElement.getTextContent();
            store.put(LABEL_COMPARISON, this.getDisplayableValueForComparison(comparation));
        }
        if (matchElement != null) {
            String match = matchElement.getTextContent();
            store.put(LABEL_MATCH_CASE, match);
        }
    }

    private void storeComparationDataIfExistInVariables(Map<String, Object> store, List<Variable> variables) {
        String match;
        String comparison = VarListUtil.getValueStringForName(variables, LABEL_COMPARISON);
        if (comparison != null) {
            store.put(LABEL_COMPARISON, this.getDisplayableValueForComparison(comparison));
        }
        if ((match = VarListUtil.getValueStringForName(variables, LABEL_MATCH_CASE)) != null) {
            store.put(LABEL_MATCH_CASE, match);
        }
    }

    @Override
    public boolean handlesCachedPrint(Node xmlNode) {
        return false;
    }

    @Override
    public void cachedPrint(PrintWriter out, int indentLevel, String indent, TariffStructureNode tsNode, Node xmlNode) {
    }
}

