/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.mdu.model;

import com.ericsson.ere.exception.UncheckedInterruptedException;
import com.ericsson.ere.selectiontree.interfaces.ConfigurationParameter;
import com.ericsson.ere.selectiontree.mdu.filter.SelectionTreeElementFilter;
import com.ericsson.ere.selectiontree.mdu.model.MultiDataUpdateModel;
import com.ericsson.ere.selectiontree.mdu.model.SelectionTreeElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class MultiDataUpdateTableModel
extends AbstractTableModel {
    private boolean myAllowWrite;
    private List<ConfigurationParameter> myParams;
    private List<SelectionTreeElementFilter> myActualRowFilters;
    private MultiDataUpdateModel myMDUModel;
    private boolean myUseHeaderColumn = true;
    private boolean myUseCollectionValue = true;

    private MultiDataUpdateTableModel(MultiDataUpdateModel model, SelectionTreeElementType elementType, Comparator<? super ConfigurationParameter> parameterComparator, List<? extends SelectionTreeElementFilter> rowFilters, boolean allowWrite) {
        if (model == null || elementType == null || rowFilters == null) {
            throw new IllegalArgumentException("Model, element type and row filters must be non-null.");
        }
        this.myMDUModel = model;
        this.myAllowWrite = allowWrite;
        this.myParams = this.getSortedParameters(elementType, parameterComparator);
        assert (!this.myParams.isEmpty()) : "Should have parameters: the model should ignore parameter-less element types!";
        this.myActualRowFilters = this.getActualRowFilters(rowFilters, this.myParams.get(0));
    }

    public static MultiDataUpdateTableModel createReadOnlyTableModel(MultiDataUpdateModel model, SelectionTreeElementType elementType, Comparator<? super ConfigurationParameter> parameterComparator, List<? extends SelectionTreeElementFilter> rowFilters) {
        return new MultiDataUpdateTableModel(model, elementType, parameterComparator, rowFilters, false);
    }

    public static MultiDataUpdateTableModel createReadWriteTableModel(MultiDataUpdateModel model, SelectionTreeElementType elementType, Comparator<? super ConfigurationParameter> parameterComparator, List<? extends SelectionTreeElementFilter> rowFilters) {
        return new MultiDataUpdateTableModel(model, elementType, parameterComparator, rowFilters, true);
    }

    public void useHeaderColumn(boolean headerColumn) {
        this.myUseHeaderColumn = headerColumn;
    }

    public void useCollectionValues(boolean useCollectionValues) {
        this.myUseCollectionValue = useCollectionValues;
    }

    private List<SelectionTreeElementFilter> getActualRowFilters(List<? extends SelectionTreeElementFilter> rowFilters, ConfigurationParameter arbitraryParam) {
        ArrayList<SelectionTreeElementFilter> filters = new ArrayList<SelectionTreeElementFilter>();
        for (SelectionTreeElementFilter selectionTreeElementFilter : rowFilters) {
            if (Thread.interrupted()) {
                throw new UncheckedInterruptedException("Interrupted while detecting actual row filters.");
            }
            if (this.myMDUModel.getParameterValues(arbitraryParam, selectionTreeElementFilter).isEmpty()) continue;
            filters.add(selectionTreeElementFilter);
        }
        return filters;
    }

    private List<ConfigurationParameter> getSortedParameters(SelectionTreeElementType elementType, Comparator<? super ConfigurationParameter> parameterComparator) {
        ArrayList<ConfigurationParameter> params = new ArrayList<ConfigurationParameter>(elementType.getParameters());
        if (parameterComparator != null) {
            Collections.sort(params, parameterComparator);
        }
        return params;
    }

    @Override
    public int getColumnCount() {
        return this.myParams.size() + (this.myUseHeaderColumn ? 1 : 0);
    }

    @Override
    public int getRowCount() {
        return this.myActualRowFilters.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        SelectionTreeElementFilter filter = this.myActualRowFilters.get(rowIndex);
        if (columnIndex == 0 && this.myUseHeaderColumn) {
            return filter;
        }
        int coffset = this.myUseHeaderColumn ? -1 : 0;
        ConfigurationParameter parameter = this.myParams.get(columnIndex + coffset);
        Collection<Object> coll = this.myMDUModel.getParameterValues(parameter, filter);
        int size = coll.size();
        if (size == 0) {
            return this.myUseCollectionValue ? Collections.emptyList() : null;
        }
        if (size == 1 || !this.myUseCollectionValue) {
            return coll.iterator().next();
        }
        return coll;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex == 0 && this.myUseHeaderColumn) {
            return false;
        }
        return this.myAllowWrite;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (!this.myAllowWrite) {
            throw new IllegalStateException("Read-only model.");
        }
        if (columnIndex == 0 && this.myUseHeaderColumn) {
            throw new IllegalStateException("Cannot change header column.");
        }
        int coffset = this.myUseHeaderColumn ? -1 : 0;
        ConfigurationParameter parameter = this.myParams.get(columnIndex + coffset);
        SelectionTreeElementFilter filter = this.myActualRowFilters.get(rowIndex);
        this.myMDUModel.setParameterValue(parameter, filter, aValue);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0 && this.myUseHeaderColumn) {
            return SelectionTreeElementFilter.class;
        }
        int coffset = this.myUseHeaderColumn ? -1 : 0;
        return this.myParams.get(columnIndex + coffset).getType();
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0 && this.myUseHeaderColumn) {
            return "";
        }
        int coffset = this.myUseHeaderColumn ? -1 : 0;
        return this.myParams.get(column + coffset).getDisplayName();
    }

    public List<ConfigurationParameter> getParameters() {
        return Collections.unmodifiableList(this.myParams);
    }
}

