/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers;

import com.ericsson.ere.constraint.entity.ConstraintContext;
import com.ericsson.ere.constraint.entity.ConstraintContextItemType;
import com.ericsson.ere.expression.Expression;
import com.ericsson.ere.expression.ExpressionFormatter;
import com.ericsson.ere.expression.InfixExpressionFormatter;
import com.ericsson.ere.selectiontree.FieldFilter;
import com.ericsson.ere.selectiontree.modifiers.AbstractFieldOrientedModifierProfile;
import com.ericsson.ere.selectiontree.modifiers.mfo.ExpressionXMLFormatter;
import com.ericsson.ere.selectiontree.modifiers.mfo.ExpressionXMLReader;
import com.ericsson.ere.selectiontree.modifiers.mfo.FieldUseEvaluator;
import com.ericsson.ere.selectiontree.modifiers.mfo.MultiFieldOperationConfiguration;
import com.ericsson.ere.selectiontree.modifiers.mfo.ProfileExpressionXMLReader;
import com.ericsson.ere.selectiontree.modifiers.mfo.ValueFieldCompositeOperand;
import com.ericsson.ere.selectiontree.util.AvailableFieldListBuilder;
import com.ericsson.ere.selectiontree.util.ClassRepositoryHelper;
import com.ericsson.ere.selectiontree.util.FieldOrientedPluginProfileUtil;
import com.ericsson.ere.selectiontree.util.ValueFieldCompositeObject;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.defs.FieldDefinitionHelper;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.ere.gui.util.VariableFactory;
import ericsson.vareditor.variable.DropDownVariable;
import ericsson.vareditor.variable.InfoVariable;
import ericsson.vareditor.variable.LazyFieldDropDownVariable;
import ericsson.vareditor.variable.NotAllowedVariable;
import ericsson.vareditor.variable.TypedDropDownVariable;
import ericsson.vareditor.variable.ValueFieldVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import ericsson.vareditor.variable.VariableUtil;
import java.awt.Color;
import java.awt.Font;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;
import org.w3c.dom.Node;

public abstract class AbstractMultiFieldOperationProfile
extends AbstractFieldOrientedModifierProfile {
    private static final int MAX_RESULTING_EXPRESSION_LENGTH = 500;
    private static final int MAX_DESCRIPTION_LENGTH = 300;
    protected static final List<String> DEST_PARAM_TYPES;
    public static final String LBL_DEST_FIELD = "Destination field";
    public static final String LBL_RESULTING_EXPRESSION = "Resulting expression";
    private static final String MSG_NO_DEST_FIELDS = "No destination fields found";
    private static final String[] EMPTY_STRING_ARRAY;
    private String myCurrentDestinationField;
    private final ExpressionFormatter myExpressionFormatter = new InfixExpressionFormatter();
    private final String myDestinationIndexLabel;

    protected AbstractMultiFieldOperationProfile(String destIndexLabel) {
        this.myDestinationIndexLabel = destIndexLabel;
    }

    protected abstract FieldFilter getOrCreateDestinationFieldFilter();

    protected abstract FieldFilter getOrCreateOperandFieldFilter(String var1);

    protected abstract Expression getCurrentExpression(List<Variable> var1);

    protected abstract List<? extends Variable> createExpressionVariables(Expression var1);

    protected abstract VariableFactory.IndexType getIndexTypeForField(FieldDefinition var1, boolean var2);

    protected List<String> findUsedTDFs(List<Variable> vars) {
        ArrayList<String> result = new ArrayList<String>();
        Expression e = this.getCurrentExpression(vars);
        List<String> expressionFields = FieldUseEvaluator.getUsedFields(e);
        for (String s : expressionFields) {
            if (!this.isTDF(s)) continue;
            result.add(s);
        }
        return result;
    }

    protected static List<FieldDefinition> filterFieldMappableFields(ClassRepository repository, String destinationField, FieldFilter filter) {
        return AbstractMultiFieldOperationProfile.getSupportedFields(ClassRepositoryHelper.extractVisibleFieldsForField(destinationField, repository), filter);
    }

    List<FieldDefinition> getCandidateDestinationFields() {
        List<FieldDefinition> fieldMappableFields = AbstractMultiFieldOperationProfile.filterFieldMappableFields(this.myClassRepository, null, this.getOrCreateDestinationFieldFilter());
        return AbstractMultiFieldOperationProfile.getSupportedFields(fieldMappableFields, new NoSetFieldFilter());
    }

    List<FieldDefinition> getCandidateOperandFields(String destination) {
        List<FieldDefinition> fieldMappableFields = AbstractMultiFieldOperationProfile.filterFieldMappableFields(this.myClassRepository, this.myCurrentDestinationField, this.getOrCreateOperandFieldFilter(destination));
        return AbstractMultiFieldOperationProfile.getSupportedFields(fieldMappableFields, new NoSetFieldFilter());
    }

    @Override
    public List<Variable> getVariables() {
        List<String> destinationFields = this.getConstrainedDestinationFields();
        String selectedDestination = destinationFields.isEmpty() ? null : destinationFields.get(0);
        return this.createVariables(destinationFields, selectedDestination, null, null);
    }

    @Override
    public List<Variable> getVariables(Node config) {
        Variable destFieldVar;
        ExpressionXMLReader reader = this.createXMLReader(this.myClassRepository);
        MultiFieldOperationConfiguration mfoConfig = MultiFieldOperationConfiguration.readConfig(this.myClassRepository, config, reader);
        AvailableFieldListBuilder builder = this.createDestinationFieldListBuilder();
        String selectedDestination = mfoConfig.getDestinationField();
        String destField = selectedDestination == null ? "" : selectedDestination;
        ValueFieldCompositeObject keyObject = mfoConfig.getKey();
        Expression expr = mfoConfig.getExpression();
        ArrayList<Variable> vars = new ArrayList<Variable>();
        if (!builder.filtersAllow(this.myClassRepository.getFieldDefinitionByName(selectedDestination))) {
            List<FieldDefinition> availableFieldList = builder.buildFieldDefinitionList();
            if (availableFieldList.isEmpty()) {
                NotAllowedVariable var = new NotAllowedVariable(LBL_DEST_FIELD, MSG_NO_DEST_FIELDS);
                return Arrays.asList(var);
            }
            destFieldVar = this.createDestinationFieldVariable(builder.buildFieldNameList(), destField);
        } else {
            destFieldVar = new LazyFieldDropDownVariable(LBL_DEST_FIELD, builder, selectedDestination);
        }
        vars.add(destFieldVar);
        Variable indexVariable = this.createIndexVariableForFieldIfNecessary(destField, keyObject, this.myDestinationIndexLabel, true);
        if (indexVariable != null) {
            vars.add(indexVariable);
        }
        vars.add(this.createResultingExpressionVariable());
        this.updateCurrentDestinationField(destFieldVar);
        vars.addAll(this.createExpressionVariables(expr));
        this.updateResultingExpression(vars, this.getCurrentExpression(vars));
        return vars;
    }

    protected ExpressionXMLReader createXMLReader(ClassRepository repository) {
        return new ProfileExpressionXMLReader(repository);
    }

    @Override
    public String getDescription(List<Variable> variables) {
        String descriptionString;
        Variable destField = VarListUtil.getVariableForName(variables, LBL_DEST_FIELD);
        Variable index = VarListUtil.getVariableForName(variables, this.myDestinationIndexLabel);
        String resultingExpression = VarListUtil.getValueStringForName(variables, LBL_RESULTING_EXPRESSION);
        String fieldName = destField.getValueString();
        if (destField instanceof NotAllowedVariable) {
            return fieldName;
        }
        if (this.getField(fieldName) != null) {
            FieldDefinition field = this.myClassRepository.getFieldDefinitionByName(fieldName);
            ValueFieldCompositeOperand temp = new ValueFieldCompositeOperand(ValueFieldCompositeObject.createForField(fieldName), index == null ? null : (ValueFieldCompositeObject)index.getValueObject(), field.isMap());
            descriptionString = temp.toString() + " = " + resultingExpression;
        } else {
            descriptionString = fieldName + " = " + resultingExpression;
        }
        if (descriptionString.length() > 300) {
            descriptionString = descriptionString.substring(0, 297) + "...";
        }
        return descriptionString;
    }

    @Override
    public String getAdditionalInfo(List<Variable> variables) {
        String info = "<b>" + this.getName() + "</b> (" + this.getDescription(variables) + ")\n" + this.getComment(variables);
        return GuiUtil.multilineTooltipWrapper(info);
    }

    @Override
    public boolean parameterChanged(String reference, Variable value, List<Variable> vars) {
        boolean updated = false;
        if (LBL_DEST_FIELD.equals(reference)) {
            String oldField = this.myCurrentDestinationField;
            updated |= this.updateIndexVariableForFieldVariable(vars, value, this.myDestinationIndexLabel, true);
            this.updateCurrentDestinationField(value);
            if (this.needsExpressionRefreshForDestinationFieldChange(oldField, value.getValueString())) {
                this.recreateExpressionVariables(vars);
                this.updateResultingExpression(vars, this.getCurrentExpression(vars));
                updated = true;
            }
        }
        return updated;
    }

    private void recreateExpressionVariables(List<Variable> vars) {
        Expression e = this.getCurrentExpression(vars);
        Variable resVar = VarListUtil.getVariableForName(vars, LBL_RESULTING_EXPRESSION);
        if (resVar != null) {
            int index = vars.indexOf(resVar);
            while (vars.size() > index + 1) {
                vars.remove(index + 1);
            }
        }
        vars.addAll(this.createExpressionVariables(e));
    }

    protected boolean needsExpressionRefreshForDestinationFieldChange(String oldField, String newField) {
        List<String> newContexts;
        List<String> oldContexts;
        boolean needsRefresh = true;
        FieldDefinition fd = this.getField(oldField);
        if (fd != null && (oldContexts = this.myClassRepository.getFieldDefinitionByName(oldField).getContextNames()).containsAll(newContexts = this.myClassRepository.getFieldDefinitionByName(newField).getContextNames()) && oldContexts.size() == newContexts.size()) {
            needsRefresh = false;
        }
        return needsRefresh;
    }

    protected final FieldDefinition getField(String name) {
        return this.myClassRepository.getFieldDefinitionByName(name);
    }

    private void updateCurrentDestinationField(Variable var) {
        this.myCurrentDestinationField = var.getValueString();
    }

    protected boolean updateIndexVariableForFieldVariable(List<Variable> vars, Variable fieldVariable, String indexVariableLabel, boolean isDestination) {
        boolean updated = false;
        String selectedField = fieldVariable.getValueString();
        Variable indexVariable = this.createIndexVariableForFieldIfNecessary(selectedField, null, indexVariableLabel, isDestination);
        if (indexVariable == null) {
            updated |= VarListUtil.removeVariablesByKey(vars, indexVariableLabel);
        } else {
            if (!VarListUtil.replaceVariableByKey(vars, indexVariableLabel, indexVariable)) {
                VarListUtil.insertVariableAfterLabel(vars, fieldVariable.getLabel(), indexVariable);
            }
            updated = true;
        }
        return updated;
    }

    protected void updateResultingExpression(List<Variable> vars, Expression expression) {
        String desc;
        String string = desc = expression == null ? "" : expression.format(this.myExpressionFormatter);
        if (desc.length() > 500) {
            desc = desc.substring(0, 497) + "...";
        }
        Variable resultingExprVar = VarListUtil.getVariableForName(vars, LBL_RESULTING_EXPRESSION);
        resultingExprVar.setValue(desc);
    }

    @Override
    public void printParametersImpl(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        Variable destFieldVar = VarListUtil.getVariableForName(variables, LBL_DEST_FIELD);
        if (destFieldVar instanceof NotAllowedVariable || !destFieldVar.isValueValid()) {
            return;
        }
        String destField = destFieldVar.getValueString();
        Expression expr = this.getCurrentExpression(variables);
        ValueFieldCompositeObject keyObject = this.createObjectForIndexVariable(VarListUtil.getVariableForKey(variables, this.myDestinationIndexLabel));
        MultiFieldOperationConfiguration mfoConfig = MultiFieldOperationConfiguration.create(destField, keyObject, expr);
        ExpressionFormatter formatter = this.createExpressionFormatter();
        MultiFieldOperationConfiguration.write(out, mfoConfig, formatter);
    }

    protected ExpressionFormatter createExpressionFormatter() {
        return new ExpressionXMLFormatter(true);
    }

    private List<String> getConstrainedDestinationFields() {
        List<FieldDefinition> candidates = this.getCandidateDestinationFields();
        List<FieldDefinition> constrained = this.getConstrainedFields(candidates, null);
        return FieldDefinitionHelper.extractFieldNameList(constrained);
    }

    private AvailableFieldListBuilder createDestinationFieldListBuilder() {
        return AvailableFieldListBuilder.createAvailableFieldListBuilder(this.myClassRepository).withFilter(this.getOrCreateDestinationFieldFilter()).withFilter(new NoSetFieldFilter()).withConstraints(this, null);
    }

    protected AvailableFieldListBuilder createOperandFieldListBuilder() {
        String destField = this.getCurrentDestinationField();
        ConstraintContext context = new ConstraintContext.Builder().addContext(ConstraintContextItemType.FIELD, destField).build();
        return AvailableFieldListBuilder.createAvailableFieldListBuilder(this.myClassRepository).withFilter(this.getOrCreateOperandFieldFilter(destField)).withFilter(new ClassRepositoryHelper.VisibleFieldFilter(this.myClassRepository)).withFilter(new NoSetFieldFilter()).withConstraints(this, context);
    }

    protected List<String> getConstrainedOperandFieldsForDestinationField(String destination) {
        return FieldDefinitionHelper.extractFieldNameList(this.getConstrainedOperandFieldDefinitionsForDestinationField(destination));
    }

    protected List<FieldDefinition> getConstrainedOperandFieldDefinitionsForDestinationField(String destination) {
        List<FieldDefinition> candidates = this.getCandidateOperandFields(destination);
        ConstraintContext context = new ConstraintContext.Builder().addContext(ConstraintContextItemType.FIELD, destination).build();
        return this.getConstrainedFields(candidates, context);
    }

    protected List<Variable> createVariables(List<String> destinationFields, String selectedDestination, ValueFieldCompositeObject keyObject, Expression expression) {
        if (destinationFields.isEmpty()) {
            NotAllowedVariable var = new NotAllowedVariable(LBL_DEST_FIELD, MSG_NO_DEST_FIELDS);
            return Arrays.asList(var);
        }
        String destField = selectedDestination == null ? "" : selectedDestination;
        Variable destFieldVar = this.createDestinationFieldVariable(destinationFields, destField);
        Variable indexVariable = this.createIndexVariableForFieldIfNecessary(destField, keyObject, this.myDestinationIndexLabel, true);
        Variable resultingExprVar = this.createResultingExpressionVariable();
        ArrayList<Variable> vars = new ArrayList<Variable>();
        vars.add(destFieldVar);
        if (indexVariable != null) {
            vars.add(indexVariable);
        }
        vars.add(resultingExprVar);
        this.updateCurrentDestinationField(destFieldVar);
        vars.addAll(this.createExpressionVariables(expression));
        this.updateResultingExpression(vars, this.getCurrentExpression(vars));
        return vars;
    }

    protected Variable createDestinationFieldVariable(List<String> destinationFields, String defaultSelection) {
        return this.createVariableForFieldList(LBL_DEST_FIELD, null, destinationFields, defaultSelection);
    }

    protected Variable createResultingExpressionVariable() {
        InfoVariable var = new InfoVariable(LBL_RESULTING_EXPRESSION, "");
        JComponent editor = (JComponent)((Variable)var).getEditor();
        editor.setFont(new Font("Monospaced", 0, 12));
        Border margin = BorderFactory.createEmptyBorder(3, 3, 2, 3);
        MatteBorder bottomLine = BorderFactory.createMatteBorder(0, 0, 1, 0, Color.black);
        CompoundBorder border = BorderFactory.createCompoundBorder(bottomLine, margin);
        editor.setBorder(border);
        return var;
    }

    protected Variable createIndexVariableForFieldIfNecessary(String fieldName, ValueFieldCompositeObject keyObject, String indexLabel, boolean isDestination) {
        FieldDefinition field = this.myClassRepository.getFieldDefinitionByName(fieldName);
        Variable var = null;
        if (field != null) {
            VariableFactory.IndexType indexType = this.getIndexTypeForField(field, isDestination);
            var = FieldOrientedPluginProfileUtil.createIndexVariable(indexLabel, indexLabel, field, this.myClassRepository, keyObject, indexType == VariableFactory.IndexType.Numeric_Range);
        }
        return var;
    }

    protected final String getCurrentDestinationField() {
        return this.myCurrentDestinationField;
    }

    @Override
    public String[] getTreeDefinedFieldInUse(List<Variable> variables) {
        Collection<String> coll = this.getUsedTDFs(variables);
        if (coll.isEmpty()) {
            return EMPTY_STRING_ARRAY;
        }
        return coll.toArray(new String[coll.size()]);
    }

    protected Collection<String> getUsedTDFs(List<Variable> vars) {
        HashSet<String> tdfs = new HashSet<String>();
        tdfs.addAll(FieldOrientedPluginProfileUtil.extractReservedTreeDefinedFieldFromVariable(VarListUtil.getVariableForName(vars, LBL_DEST_FIELD), this.myClassRepository, true));
        tdfs.addAll(FieldOrientedPluginProfileUtil.extractReservedTreeDefinedFieldFromVariable(VarListUtil.getVariableForName(vars, this.myDestinationIndexLabel), this.myClassRepository, true));
        tdfs.addAll(this.findUsedTDFs(vars));
        return tdfs;
    }

    protected void addSelectedValueToCollectionIfTDF(Variable var, Collection<String> tdfs) {
        if (VariableUtil.currentValueIsTreeDefinedField(this.myClassRepository, var)) {
            tdfs.add(var.getValueString());
        }
    }

    protected final boolean isTDF(String field) {
        FieldDefinition fd = this.getField(field);
        return fd != null && "INTERNAL".equals(fd.getParameterType());
    }

    protected ValueFieldCompositeObject extractCompositeObjectFromVariable(Variable var) {
        ValueFieldCompositeObject ret;
        if (var == null) {
            ret = null;
        } else if (var instanceof ValueFieldVariable) {
            ret = (ValueFieldCompositeObject)var.getValueObject();
        } else {
            String str = var.getValueString();
            ret = var instanceof DropDownVariable || var instanceof TypedDropDownVariable ? ValueFieldCompositeObject.createForField(str) : ValueFieldCompositeObject.createForValue(str, null);
        }
        return ret;
    }

    protected boolean containsFieldOfMapType(ValueFieldCompositeObject value) {
        if (value.getMode() != ValueFieldCompositeObject.Mode.Field) {
            return false;
        }
        FieldDefinition field = this.getField(value.getFieldOrValueAsString());
        return field != null && field.isMap();
    }

    @Override
    public Map<String, Object> getDisplayValues(Node data, Map<String, Object> prev) {
        ExpressionXMLReader reader = this.createXMLReader(this.myClassRepository);
        MultiFieldOperationConfiguration mfoConfig = MultiFieldOperationConfiguration.readConfig(this.myClassRepository, data, reader);
        HashMap<String, Object> displayValues = new HashMap<String, Object>();
        displayValues.put(LBL_DEST_FIELD, mfoConfig.getDestinationField());
        displayValues.put(this.myDestinationIndexLabel, mfoConfig.getKey());
        return displayValues;
    }

    static {
        EMPTY_STRING_ARRAY = new String[0];
        DEST_PARAM_TYPES = new ArrayList<String>(Arrays.asList(ClassRepository.OUTPUT_TYPES));
        DEST_PARAM_TYPES.add("INTERNAL");
    }

    private static class NoSetFieldFilter
    implements FieldFilter {
        private NoSetFieldFilter() {
        }

        @Override
        public boolean isAllowed(FieldDefinition field) {
            return !field.isSet();
        }
    }

    protected static class DestinationFieldFilter
    extends ParameterTypeFieldFilter {
        protected DestinationFieldFilter() {
            super(DEST_PARAM_TYPES);
        }
    }

    protected static class ParameterTypeFieldFilter
    implements FieldFilter {
        private List<String> myParameterTypes;

        protected ParameterTypeFieldFilter(List<String> allowedTypes) {
            this.myParameterTypes = allowedTypes;
        }

        @Override
        public boolean isAllowed(FieldDefinition field) {
            String pt = field.getParameterType();
            return this.myParameterTypes.contains(pt);
        }
    }
}

