/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers;

import com.ericsson.ere.gui.simulator.testgenerator.TestCaseGenerationModifierInterface;
import com.ericsson.ere.selectiontree.modifiers.AbstractModifierProfile;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.variable.BoolVariable;
import ericsson.vareditor.variable.InfoVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BreakPointModifierProfile
extends AbstractModifierProfile
implements TestCaseGenerationModifierInterface {
    private static String LBL_BREAK = "Break";

    @Override
    public List<Variable> getVariables() {
        ArrayList<Variable> l = new ArrayList<Variable>(2);
        l.add(new BoolVariable(LBL_BREAK, true));
        return l;
    }

    @Override
    public List<Variable> getVariables(Node iterator) {
        NodeList children = iterator.getChildNodes();
        Element stopIndicatorNode = XMLUtil.getNamedElement("Break", children);
        String stopIndicatorStr = XMLUtil.getFirstTextContent(stopIndicatorNode);
        boolean stopIndicator = "true".equalsIgnoreCase(stopIndicatorStr);
        ArrayList<Variable> l = new ArrayList<Variable>(2);
        l.add(new BoolVariable(LBL_BREAK, stopIndicator));
        return l;
    }

    @Override
    public void printParametersImpl(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        boolean shallBreak = VarListUtil.getBooleanValueForName(variables, LBL_BREAK);
        for (int i = 0; i < indentLevel + 1; ++i) {
            out.print(indentMarker);
        }
        out.println("<Break>" + shallBreak + "</" + "Break" + ">");
    }

    @Override
    public String getDescription(List<Variable> variables) {
        boolean willBreak = VarListUtil.getBooleanValueForName(variables, LBL_BREAK);
        return "Break = " + willBreak;
    }

    @Override
    public String getAdditionalInfo(List<Variable> variables) {
        boolean willBreak = VarListUtil.getBooleanValueForName(variables, LBL_BREAK);
        String info = "<b>Break </b> (" + willBreak + ")\n" + this.getComment(variables);
        return GuiUtil.multilineTooltipWrapper(info);
    }

    @Override
    public List<Variable> getTestVariables(Node settingsIterator, Node testSettingsIterator) {
        ArrayList<Variable> testCaseVariables = new ArrayList<Variable>(2);
        testCaseVariables.add(new InfoVariable("Information", " No validation possible"));
        return testCaseVariables;
    }

    @Override
    public Map<String, Object> getTestSimulationFieldValues(Node variableValueIterator, Node testSettingsIterator) throws Exception {
        return new HashMap<String, Object>();
    }

    @Override
    public void printTestVariables(PrintWriter out, List<Variable> vars) {
        out.print("<TestSettings></TestSettings>");
    }

    @Override
    public boolean isManualValidationPossible(Node variableValueIterator) {
        return false;
    }

    @Override
    public boolean testParameterChanged(String reference, Variable value, List<Variable> vars) {
        return false;
    }
}

