/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ere.selectiontree.modifiers;

import com.ericsson.ere.constraint.ConstraintService;
import com.ericsson.ere.constraint.contract.Constrainable;
import com.ericsson.ere.expression.Operator;
import com.ericsson.ere.expression.Operators;
import com.ericsson.ere.selectiontree.FieldFilter;
import com.ericsson.ere.selectiontree.modifiers.AbstractBinaryDateOperationProfile;
import com.ericsson.ere.selectiontree.modifiers.AbstractMultiFieldOperationProfile;
import com.ericsson.ere.selectiontree.modifiers.DateDifferenceProfileContract;
import com.ericsson.ere.selectiontree.modifiers.mfo.ValueFieldCompositeOperand;
import com.ericsson.ere.selectiontree.util.ValueFieldCompositeObject;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.defs.FieldDefinitionHelper;
import ericsson.vareditor.variable.ValueFieldVariable;
import ericsson.vareditor.variable.Variable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

@Constrainable(contractClass=DateDifferenceProfileContract.class)
public class DateDifferenceProfile
extends AbstractBinaryDateOperationProfile {
    private static ArrayList<String> OPERAND_PARAM_TYPES = new ArrayList(DEST_PARAM_TYPES);
    public static final String LBL_FIRST_DATE = "Date";
    public static final String LBL_FIRST_DATE_INDEX = "Date index";
    public static final String LBL_OPERATION = "Operation";
    public static final String LBL_SECOND_DATE = "Date to subtract";
    public static final String LBL_SECOND_DATE_INDEX = "Date to subtract index";
    private FieldFilter myOperandFieldFilter = new OperandFieldFilter();
    private FieldFilter myDestinationFieldFilter = new NumericDestinationFieldFilter();
    private static final String DATE_TIME_INTEROPERABILITY_FEATURE = "Date_Time_Interoperability_Support";
    private boolean mySupportDateTimeInteroperability;

    public DateDifferenceProfile() {
        super(LBL_FIRST_DATE, LBL_FIRST_DATE_INDEX, LBL_OPERATION, LBL_SECOND_DATE, LBL_SECOND_DATE_INDEX);
    }

    @Override
    protected List<Variable> createFirstOperandVariables(ValueFieldCompositeOperand operand) {
        return this.createOperandVariables(operand, LBL_FIRST_DATE, LBL_FIRST_DATE_INDEX);
    }

    @Override
    protected List<Variable> createSecondOperandVariables(ValueFieldCompositeOperand operand) {
        return this.createOperandVariables(operand, LBL_SECOND_DATE, LBL_SECOND_DATE_INDEX);
    }

    private List<Variable> createOperandVariables(ValueFieldCompositeOperand operand, String valueLabel, String indexLabel) {
        String field;
        ValueFieldCompositeObject value;
        ArrayList<Variable> vars = new ArrayList<Variable>();
        ValueFieldCompositeObject index = null;
        if (operand != null) {
            value = operand.getValue();
            index = operand.getIndex();
        } else {
            String dateValue = DataType.DATE.makeParseableString(DataType.DATE.createDefaultInstance());
            value = ValueFieldCompositeObject.createForValue(dateValue, DataType.DATE);
        }
        Variable var = new ValueFieldVariable(valueLabel, value, this.getOperandFieldsAsMap(), null, DataType.DATE);
        vars.add(var);
        if (index != null && (var = this.createIndexVariableForFieldIfNecessary(field = value.getFieldOrValueAsString(), index, indexLabel, false)) != null) {
            vars.add(var);
        }
        return vars;
    }

    private Map<String, FieldDefinition> getOperandFieldsAsMap() {
        List<FieldDefinition> fieldList = this.getConstrainedOperandFieldDefinitionsForDestinationField(this.getCurrentDestinationField());
        return FieldDefinitionHelper.createNameToFieldMap(fieldList);
    }

    @Override
    protected Variable createOperationVariable(Operator oper) {
        assert (oper == null || oper.equals(Operators.SUBTRACT));
        return null;
    }

    @Override
    protected FieldFilter getOrCreateDestinationFieldFilter() {
        return this.myDestinationFieldFilter;
    }

    @Override
    protected FieldFilter getOrCreateOperandFieldFilter(String destination) {
        return this.myOperandFieldFilter;
    }

    @Override
    protected Operator operatorFromString(String str) {
        return Operators.SUBTRACT;
    }

    private void checkFeaturesViaClassRepository(ClassRepository repository) {
        List<String> enabledFeatures = ConstraintService.constrainFeatures(this, repository, this.getSupportedFeatures());
        this.mySupportDateTimeInteroperability = enabledFeatures.contains(DATE_TIME_INTEROPERABILITY_FEATURE);
    }

    List<String> getSupportedFeatures() {
        return Arrays.asList(DATE_TIME_INTEROPERABILITY_FEATURE);
    }

    @Override
    public void setClassRepository(ClassRepository repository) {
        super.setClassRepository(repository);
        this.checkFeaturesViaClassRepository(repository);
    }

    static {
        OPERAND_PARAM_TYPES.addAll(Arrays.asList(ClassRepository.INPUT_TYPES));
    }

    private class OperandFieldFilter
    extends AbstractMultiFieldOperationProfile.ParameterTypeFieldFilter {
        OperandFieldFilter() {
            super(OPERAND_PARAM_TYPES);
        }

        @Override
        public boolean isAllowed(FieldDefinition field) {
            DataType type = field.getTypedDataType();
            return super.isAllowed(field) && (type == DataType.DATE || DateDifferenceProfile.this.mySupportDateTimeInteroperability && type == DataType.TIME);
        }
    }

    private static class NumericDestinationFieldFilter
    extends AbstractMultiFieldOperationProfile.DestinationFieldFilter {
        private NumericDestinationFieldFilter() {
        }

        @Override
        public boolean isAllowed(FieldDefinition field) {
            DataType dt = field.getTypedDataType();
            return super.isAllowed(field) && dt.isNumeric();
        }
    }
}

